/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.client.result;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import okuyama.imdst.client.OkuyamaClient;
import okuyama.imdst.client.OkuyamaClientException;
import okuyama.imdst.client.OkuyamaResultSet;

public class OkuyamaMultiTagKeysResultSet
implements OkuyamaResultSet {
    protected int maxMultiGetSize = 100;
    protected OkuyamaClient client = null;
    protected String[] tagStrList = null;
    protected Map<String, String[]> tagIndexListMap = null;
    protected String encoding = null;
    protected boolean margeType = false;
    private static final int buketMaxLinkGroupSize = 500000;
    private int nowIndex = 0;
    private boolean closeFlg = true;
    private Map getIndexMap = null;
    private LinkedBlockingQueue indexQueue = null;
    private LinkedBlockingQueue keyQueue = null;
    private LinkedBlockingQueue keyValueQueue = null;
    private String nowKey = null;
    private String nowValue = null;
    private boolean dataNull = false;

    public OkuyamaMultiTagKeysResultSet() {
        this.dataNull = true;
    }

    public OkuyamaMultiTagKeysResultSet(OkuyamaClient client, String[] tagStrList, Map<String, String[]> tagIndexListMap, String encoding, boolean margeType) {
        this.client = client;
        this.tagStrList = tagStrList;
        this.tagIndexListMap = tagIndexListMap;
        this.encoding = encoding;
        this.margeType = margeType;
        this.indexQueue = new LinkedBlockingQueue();
        this.keyQueue = new LinkedBlockingQueue();
        this.keyValueQueue = new LinkedBlockingQueue();
        this.closeFlg = false;
        try {
            Map<String, String> equalTagGroupMap;
            this.getIndexMap = new HashMap(300);
            for (int idx = 0; idx < this.tagStrList.length; ++idx) {
                String[] tmpTagIndexList = this.tagIndexListMap.get(this.tagStrList[idx]);
                if (tmpTagIndexList == null) {
                    if (!this.margeType) continue;
                    this.getIndexMap.clear();
                    break;
                }
                for (int tmpIdx = 0; tmpIdx < tmpTagIndexList.length; ++tmpIdx) {
                    equalTagGroupMap = (Map)this.getIndexMap.get(new Integer(Integer.parseInt(tmpTagIndexList[tmpIdx]) / 500000));
                    if (equalTagGroupMap != null) {
                        equalTagGroupMap.put(this.tagStrList[idx], tmpTagIndexList[tmpIdx]);
                    } else {
                        equalTagGroupMap = new HashMap<String, String>(8);
                        equalTagGroupMap.put(this.tagStrList[idx], tmpTagIndexList[tmpIdx]);
                    }
                    this.getIndexMap.put(new Integer(Integer.parseInt(tmpTagIndexList[tmpIdx]) / 500000), equalTagGroupMap);
                }
            }
            Set entrySet = this.getIndexMap.entrySet();
            for (Map.Entry obj : entrySet) {
                equalTagGroupMap = (HashMap<String, String>)obj.getValue();
                this.indexQueue.put(equalTagGroupMap);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public boolean next() throws OkuyamaClientException {
        if (this.dataNull) {
            return false;
        }
        try {
            while (true) {
                Set entrySet;
                if (this.keyValueQueue.size() > 0) {
                    String[] keyValue = (String[])this.keyValueQueue.take();
                    this.nowKey = keyValue[0];
                    this.nowValue = keyValue[1];
                    return true;
                }
                while (this.keyQueue.size() > 0) {
                    String tmpKey;
                    ArrayList<String> keys = new ArrayList<String>(this.maxMultiGetSize);
                    for (int idx = 0; idx < this.maxMultiGetSize && (tmpKey = (String)this.keyQueue.poll()) != null; ++idx) {
                        keys.add(tmpKey);
                    }
                    if (keys.size() > 0) {
                        String[] getMultiKeys = new String[keys.size()];
                        for (int idx = 0; idx < keys.size(); ++idx) {
                            getMultiKeys[idx] = (String)keys.get(idx);
                        }
                        Map<String, String> keyValueRetMap = null;
                        if (getMultiKeys.length > 1) {
                            keyValueRetMap = this.client.getMultiValue(getMultiKeys, this.encoding);
                        } else {
                            keyValueRetMap = new HashMap();
                            String[] singleGetRet = this.client.getValue(getMultiKeys[0], this.encoding);
                            if (singleGetRet[0].equals("true")) {
                                keyValueRetMap.put(getMultiKeys[0], singleGetRet[1]);
                            }
                        }
                        if (keyValueRetMap != null && keyValueRetMap.size() > 0) {
                            entrySet = keyValueRetMap.entrySet();
                            for (Map.Entry obj : entrySet) {
                                String[] keyValueTmp = new String[]{(String)obj.getKey(), (String)obj.getValue()};
                                this.keyValueQueue.put(keyValueTmp);
                            }
                        }
                    }
                    if (this.keyValueQueue.size() <= 0) continue;
                    break;
                }
                if (this.keyValueQueue.size() > 0) continue;
                while (this.indexQueue.size() > 0) {
                    Map buketIdxStrMap = (Map)this.indexQueue.take();
                    if (this.margeType && buketIdxStrMap.size() != this.tagStrList.length) continue;
                    HashMap margeKeyMap = new HashMap(1000);
                    HashMap<String, Object> tmpMargeMap = null;
                    for (int idx = 0; idx < this.tagStrList.length; ++idx) {
                        int buketIdx;
                        String[] keysStrList;
                        Object[] bucketKeysRet;
                        if (this.margeType) {
                            tmpMargeMap = new HashMap<String, Object>(100);
                            bucketKeysRet = this.client.getTargetIndexTagKeys(this.tagStrList[idx], (String)buketIdxStrMap.get(this.tagStrList[idx]));
                            if (bucketKeysRet[0].equals("true")) {
                                keysStrList = (String[])bucketKeysRet[1];
                                for (buketIdx = 0; buketIdx < keysStrList.length; ++buketIdx) {
                                    if (idx == 0) {
                                        tmpMargeMap.put(keysStrList[buketIdx], null);
                                        continue;
                                    }
                                    if (!margeKeyMap.containsKey(keysStrList[buketIdx])) continue;
                                    tmpMargeMap.put(keysStrList[buketIdx], null);
                                }
                            }
                            margeKeyMap = tmpMargeMap;
                            continue;
                        }
                        if (!buketIdxStrMap.containsKey(this.tagStrList[idx]) || !(bucketKeysRet = this.client.getTargetIndexTagKeys(this.tagStrList[idx], (String)buketIdxStrMap.get(this.tagStrList[idx])))[0].equals("true")) continue;
                        keysStrList = (String[])bucketKeysRet[1];
                        for (buketIdx = 0; buketIdx < keysStrList.length; ++buketIdx) {
                            margeKeyMap.put(keysStrList[buketIdx], null);
                        }
                    }
                    entrySet = margeKeyMap.entrySet();
                    for (Map.Entry obj : entrySet) {
                        this.keyQueue.put((String)obj.getKey());
                    }
                    if (this.keyQueue.size() <= 0) continue;
                    break;
                }
                if (this.keyQueue.size() <= 0 && this.indexQueue.size() < 1) break;
            }
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
        return false;
    }

    @Override
    public Object getKey() throws OkuyamaClientException {
        return this.nowKey;
    }

    @Override
    public Object getValue() throws OkuyamaClientException {
        return this.nowValue;
    }

    @Override
    public void close() throws OkuyamaClientException {
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
                this.tagStrList = null;
                this.tagIndexListMap = null;
                this.nowIndex = -1;
                this.indexQueue = null;
                this.keyQueue = null;
                this.keyValueQueue = null;
                this.getIndexMap = null;
            }
            this.closeFlg = true;
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
    }

    @Override
    public boolean isClose() {
        return this.closeFlg;
    }
}

