/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached.test;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;

public class MemCachedBench {
    public static void main(String[] args) {
        int runs = Integer.parseInt(args[0]);
        int start = Integer.parseInt(args[1]);
        String[] serverlist = new String[]{"cache0.int.meetup.com:1624"};
        SockIOPool pool = SockIOPool.getInstance();
        pool.setServers(serverlist);
        pool.setInitConn(100);
        pool.setMinConn(100);
        pool.setMaxConn(500);
        pool.setMaintSleep(30L);
        pool.setNagle(false);
        pool.initialize();
        MemCachedClient mc = new MemCachedClient();
        mc.setCompressEnable(false);
        String keyBase = "testKey";
        String object = "This is a test of an object blah blah es, serialization does not seem to slow things down so much.  The gzip compression is horrible horrible performance, so we only use it for very large objects.  I have not done any heavy benchmarking recently";
        long begin = System.currentTimeMillis();
        for (int i = start; i < start + runs; ++i) {
            mc.set(keyBase + i, object);
        }
        long end = System.currentTimeMillis();
        long time = end - begin;
        System.out.println(runs + " gets: " + time + "ms");
        begin = System.currentTimeMillis();
        for (int i = start; i < start + runs; ++i) {
            String str = (String)mc.get(keyBase + i);
        }
        end = System.currentTimeMillis();
        time = end - begin;
        System.out.println(runs + " gets: " + time + "ms");
        SockIOPool.getInstance().shutDown();
    }
}

