/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import okuyama.base.JavaMain;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.helper.AbstractMasterManagerHelper;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.SystemUtil;
import okuyama.imdst.util.io.NodeDnsUtil;

public class ServerControllerHelper
extends AbstractMasterManagerHelper {
    private String statusCommandBindIp = null;
    private int statusCommandPortNo = 8881;
    private ServerSocket svSoc = null;
    private static ILogger logger = LoggerFactory.createLogger(ServerControllerHelper.class);

    @Override
    public void initHelper(String initValue) {
        if (initValue != null && !initValue.trim().equals("")) {
            if (initValue.indexOf(":") == -1) {
                this.statusCommandPortNo = Integer.parseInt(initValue);
            } else {
                String[] bindDt = initValue.split(":");
                this.statusCommandBindIp = bindDt[0];
                this.statusCommandPortNo = Integer.parseInt(bindDt[1]);
            }
        }
    }

    @Override
    public String executeHelper(String optionParam) throws BatchException {
        logger.debug("ServerControllerHelper - executeHelper - start");
        String ret = SUCCESS;
        try {
            InetSocketAddress bindAddress = null;
            bindAddress = this.statusCommandBindIp != null ? new InetSocketAddress(this.statusCommandBindIp, this.statusCommandPortNo) : new InetSocketAddress(this.statusCommandPortNo);
            this.svSoc = new ServerSocket();
            this.svSoc.bind(bindAddress);
            while (true) {
                Socket soc = this.svSoc.accept();
                try {
                    String name;
                    BufferedReader br = new BufferedReader(new InputStreamReader(soc.getInputStream(), "UTF-8"));
                    PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(soc.getOutputStream(), "UTF-8")));
                    String command = br.readLine();
                    if (command.equals("shutdown")) {
                        pw.println("Commond Success");
                        pw.flush();
                        pw.println("Shutdown ...");
                        pw.flush();
                        Thread.sleep(500L);
                        soc.close();
                        JavaMain.shutdownMainProccess();
                        break;
                    }
                    if (command.equals("debug")) {
                        StatusUtil.setDebugOption(true);
                        pw.println(command + " Success");
                        pw.flush();
                        Thread.sleep(500L);
                        br.close();
                        pw.close();
                        soc.close();
                        continue;
                    }
                    if (command.equals("nodebug")) {
                        StatusUtil.setDebugOption(false);
                        pw.println(command + " Success");
                        pw.flush();
                        br.close();
                        pw.close();
                        Thread.sleep(500L);
                        soc.close();
                        continue;
                    }
                    if (command.equals("cname")) {
                        String nameLine = br.readLine();
                        String[] nameInfo = nameLine.split("=");
                        if (nameInfo.length != 2) {
                            pw.println(nameLine + " Error");
                        } else {
                            NodeDnsUtil.setNameMap(nameInfo[0], nameInfo[1]);
                            pw.println(command + " Success Setting.. [" + nameInfo[0] + "] to [" + nameInfo[1] + "]");
                        }
                        pw.flush();
                        br.close();
                        pw.close();
                        Thread.sleep(500L);
                        soc.close();
                        continue;
                    }
                    if (command.equals("rname")) {
                        name = br.readLine();
                        NodeDnsUtil.removeNameMap(name);
                        pw.println(command + " Success Remove Setting.. [" + name + "]");
                        pw.flush();
                        br.close();
                        pw.close();
                        Thread.sleep(500L);
                        soc.close();
                        continue;
                    }
                    if (command.equals("jobs")) {
                        pw.println(command + " Success");
                        pw.println(StatusUtil.getMethodExecuteCount());
                        pw.flush();
                        br.close();
                        pw.close();
                        Thread.sleep(500L);
                        soc.close();
                        continue;
                    }
                    if (command.equals("allsize")) {
                        pw.println(command + " Success");
                        pw.println(StatusUtil.getNodeDataSize().toString());
                        pw.flush();
                        br.close();
                        pw.close();
                        Thread.sleep(500L);
                        soc.close();
                        continue;
                    }
                    if (command.equals("size")) {
                        name = br.readLine();
                        pw.println(command + " Success");
                        Map sizeMap = StatusUtil.getNodeDataSize();
                        String size = "";
                        size = sizeMap != null && sizeMap.containsKey(name) ? ((Long)sizeMap.get(name)).toString() : name + " NOT_FOUND";
                        pw.println(size);
                        pw.flush();
                        br.close();
                        pw.close();
                        Thread.sleep(500L);
                        soc.close();
                        continue;
                    }
                    if (command.equals("fullgc")) {
                        pw.println(command + " Success");
                        JavaSystemApi.manualGc();
                        pw.println("Execute GC");
                        pw.flush();
                        br.close();
                        pw.close();
                        Thread.sleep(500L);
                        soc.close();
                        continue;
                    }
                    if (command.equals("netdebug")) {
                        pw.println(command + " Success");
                        pw.println("");
                        pw.println("Please transmit changing line to end debugging");
                        pw.println("Net Debug Start ...");
                        pw.flush();
                        Thread.sleep(3000L);
                        SystemUtil.netDebugPrinter = pw;
                        StatusUtil.setDebugOption(true);
                        try {
                            br.readLine();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        StatusUtil.setDebugOption(false);
                        SystemUtil.netDebugPrinter = null;
                        br.close();
                        pw.close();
                        soc.close();
                        soc.close();
                        continue;
                    }
                    if (command.equals("maptime")) {
                        ImdstDefine.fileBaseMapTimeDebug = !ImdstDefine.fileBaseMapTimeDebug;
                        pw.println(command + " Success");
                        pw.println("MapTime = " + ImdstDefine.fileBaseMapTimeDebug);
                        pw.flush();
                        br.close();
                        pw.close();
                        Thread.sleep(500L);
                        soc.close();
                        continue;
                    }
                    if (command.equals("-help")) {
                        pw.println(command + " Success");
                        pw.println("");
                        pw.println("shutdown");
                        pw.println("debug");
                        pw.println("nodebug");
                        pw.println("jobs");
                        pw.println("size");
                        pw.println("allsize");
                        pw.println("cname");
                        pw.println("rname");
                        pw.println("fullgc");
                        pw.println("netdebug");
                        pw.println("");
                        pw.flush();
                        br.close();
                        pw.close();
                        soc.close();
                        continue;
                    }
                    pw.println(command + " Command Not Found");
                    pw.flush();
                    br.close();
                    pw.close();
                    Thread.sleep(500L);
                    soc.close();
                }
                catch (Exception innerE) {
                    logger.info("ServerControllerHelper - executeHelper - Inner-Error", innerE);
                    innerE.printStackTrace();
                    try {
                        if (soc == null) continue;
                        soc.close();
                    }
                    catch (Exception e2) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("ServerControllerHelper - executeHelper - Error", e);
            throw new BatchException(e);
        }
        finally {
            try {
                if (this.svSoc != null) {
                    this.svSoc.close();
                }
            }
            catch (Exception e) {}
        }
        logger.debug("ServerControllerHelper - executeHelper - end");
        return ret;
    }

    @Override
    public void endHelper() {
    }
}

