/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.client;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okuyama.imdst.client.ClientRedirector;
import okuyama.imdst.client.OkuyamaClient;
import okuyama.imdst.client.OkuyamaClientException;

public class OkuyamaClientFactory {
    private String[] masterNodeInfos = null;
    private String singleMasterNodeAddr = null;
    private int singleMasterNodePort = -1;
    private int maxClients = 100;
    private int maxUseCount = 10000;
    boolean shutdownFlg = false;
    private ArrayBlockingQueue clientQueue = null;
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    public static Object lock = new Object();
    public static ConcurrentHashMap factoryMap = new ConcurrentHashMap(32, 32.0f, 64);

    private OkuyamaClientFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OkuyamaClientFactory getFactory(String[] masterNodeInfos, int maxClients) throws OkuyamaClientException {
        if (masterNodeInfos == null || masterNodeInfos.length < 1) {
            throw new OkuyamaClientException("The connection information on MasterNode is not set up");
        }
        OkuyamaClientFactory me = null;
        me = OkuyamaClientFactory.getExistingFactory(masterNodeInfos);
        if (me != null) {
            return me;
        }
        Object object = lock;
        synchronized (object) {
            me = OkuyamaClientFactory.getExistingFactory(masterNodeInfos);
            if (me != null) {
                return me;
            }
            me = new OkuyamaClientFactory();
            if (masterNodeInfos.length > 1) {
                me.masterNodeInfos = masterNodeInfos;
            } else {
                try {
                    String[] info = masterNodeInfos[0].split(":");
                    me.singleMasterNodeAddr = info[0];
                    me.singleMasterNodePort = Integer.parseInt(info[1]);
                }
                catch (Exception e) {
                    throw new OkuyamaClientException(e);
                }
            }
            me.clientQueue = new ArrayBlockingQueue(maxClients);
            StringBuilder buf = new StringBuilder();
            String poolKey = null;
            for (int i = 0; i < masterNodeInfos.length; ++i) {
                buf.append(masterNodeInfos[i]);
                buf.append(",");
            }
            poolKey = buf.toString();
            factoryMap.put(poolKey, me);
        }
        return me;
    }

    public static OkuyamaClientFactory getNewFactory(String[] masterNodeInfos, int maxClients) throws OkuyamaClientException {
        OkuyamaClientFactory me = new OkuyamaClientFactory();
        if (masterNodeInfos.length > 1) {
            me.masterNodeInfos = masterNodeInfos;
        } else {
            try {
                String[] info = masterNodeInfos[0].split(":");
                me.singleMasterNodeAddr = info[0];
                me.singleMasterNodePort = Integer.parseInt(info[1]);
            }
            catch (Exception e) {
                throw new OkuyamaClientException(e);
            }
        }
        me.clientQueue = new ArrayBlockingQueue(maxClients);
        return me;
    }

    private static OkuyamaClientFactory getExistingFactory(String[] masterNodeInfos) {
        OkuyamaClientFactory me = null;
        StringBuilder chkBuf = new StringBuilder();
        String chkStr = null;
        for (int i = 0; i < masterNodeInfos.length; ++i) {
            chkBuf.append(masterNodeInfos[i]);
            chkBuf.append(",");
        }
        chkStr = chkBuf.toString();
        if (factoryMap.containsKey(chkStr)) {
            me = (OkuyamaClientFactory)factoryMap.get(chkStr);
        }
        if (me != null && me.shutdownFlg) {
            me = null;
        }
        return me;
    }

    public OkuyamaClient getClient() throws OkuyamaClientException {
        OkuyamaClient client = null;
        try {
            this.rwLock.readLock().lock();
            if (this.shutdownFlg) {
                throw new OkuyamaClientException("Since shutdown is already called, it cannot use");
            }
            client = (OkuyamaClient)this.clientQueue.poll();
            if (client != null) {
                if (((ClientRedirector)client).useCount > (long)this.maxUseCount) {
                    try {
                        ((ClientRedirector)client).clientClose();
                    }
                    catch (Exception innerE) {
                        // empty catch block
                    }
                    client = null;
                } else {
                    try {
                        client.getOkuyamaVersion();
                    }
                    catch (Exception innerE) {
                        client = null;
                    }
                }
            }
            if (client == null) {
                client = new ClientRedirector(this);
                ((ClientRedirector)client).createTime = System.currentTimeMillis();
                if (this.singleMasterNodeAddr != null) {
                    client.connect(this.singleMasterNodeAddr, this.singleMasterNodePort);
                } else {
                    client.setConnectionInfos(this.masterNodeInfos);
                    client.autoConnect();
                }
            }
            ((ClientRedirector)client).incrUseCount();
            ((ClientRedirector)client).lastUseTime = System.currentTimeMillis();
            ((ClientRedirector)client).returnFlg = false;
        }
        catch (Exception e) {
            throw new OkuyamaClientException(e);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnConnect(ClientRedirector client) {
        try {
            this.rwLock.readLock().lock();
            if (this.shutdownFlg) {
                client.clientClose();
                return;
            }
            boolean closeFlg = false;
            if (!this.clientQueue.offer(client)) {
                closeFlg = true;
            }
            if (closeFlg) {
                try {
                    client.clientClose();
                }
                catch (Exception inner) {
                    client = null;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.rwLock.writeLock().lock();
            this.shutdownFlg = true;
            OkuyamaClient client = null;
            while ((client = (OkuyamaClient)this.clientQueue.poll()) != null) {
                try {
                    ((ClientRedirector)client).clientClose();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

