/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okuyama.imdst.util.JavaSystemApi;

public class ValueCacheMap
extends LinkedHashMap {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private static int upperCacheMemSize = 60;
    private int maxCacheSize = 8192;
    protected Map copyMap = null;

    public ValueCacheMap() {
        super(1024, 0.75f, true);
    }

    public ValueCacheMap(int maxCacheCapacity) {
        super(maxCacheCapacity, 0.75f, true);
        this.maxCacheSize = maxCacheCapacity;
    }

    public ValueCacheMap(int maxCacheCapacity, Map copyMap) {
        super(maxCacheCapacity, 0.75f, true);
        this.maxCacheSize = maxCacheCapacity;
        this.copyMap = copyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        this.w.lock();
        try {
            if (this.copyMap != null) {
                this.copyMap.put(key, "");
            }
            Object object = super.put(key, value);
            return object;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.r.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        this.r.lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        this.w.lock();
        try {
            if (this.copyMap != null) {
                this.copyMap.remove(key);
            }
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransfer() {
        this.w.lock();
        try {
            int nowJvmUseMem = JavaSystemApi.getUseMemoryPercentCache();
            if (nowJvmUseMem > upperCacheMemSize) {
                super.put(null, null);
                super.remove(null);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintenanceRemoveTransfer() {
        boolean execFlg = true;
        int counter = 0;
        while (execFlg) {
            this.w.lock();
            try {
                if (counter != 1000) {
                    int nowJvmUseMem = JavaSystemApi.getUseMemoryPercentCache();
                    if (nowJvmUseMem > upperCacheMemSize) {
                        super.put(null, null);
                        super.remove(null);
                    } else {
                        execFlg = false;
                    }
                } else {
                    execFlg = false;
                }
                ++counter;
            }
            finally {
                this.w.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.w.lock();
        try {
            super.clear();
            if (this.copyMap != null) {
                this.copyMap.clear();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        if (this.maxCacheSize < super.size()) {
            if (this.copyMap != null) {
                this.copyMap.remove(eldest.getKey());
            }
            return true;
        }
        int nowJvmUseMem = JavaSystemApi.getUseMemoryPercentCache();
        return nowJvmUseMem > upperCacheMemSize;
    }
}

