/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.io.AbstractDataRandomAccess;

public class SortedSchedulingRandomAccess
extends AbstractDataRandomAccess {
    protected Map dataPointMap = null;
    public ArrayBlockingQueue readRequestSeekPointQueue = new ArrayBlockingQueue(65534);
    private int maxSeqSize = 65534;
    private long[] seekPointList = null;
    private ConcurrentHashMap responseDataMap = new ConcurrentHashMap(180);
    private ConcurrentHashMap responseDataSizeMap = new ConcurrentHashMap(180);
    private long nowSeekPoint = 0L;
    private long clearCount = 300000L;
    private long executeCount = 0L;
    private Object sync = new Object();
    private boolean sortAccessFlg = ImdstDefine.dataFileSequentialSchedulingFlg;

    public SortedSchedulingRandomAccess(File target, String type) throws FileNotFoundException {
        super(target, type);
    }

    @Override
    public void setDataPointMap(Map dataPointMap) {
        this.dataPointMap = dataPointMap;
    }

    @Override
    public void requestSeekPoint(long seekPoint, int start, int size) {
        if (this.sortAccessFlg) {
            try {
                HashMap<Integer, Number> requestParams = new HashMap<Integer, Number>(4);
                requestParams.put(2, start);
                requestParams.put(3, size);
                requestParams.put(4, seekPoint);
                this.readRequestSeekPointQueue.put(requestParams);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void seek(long seekPoint) throws IOException {
        if (this.sortAccessFlg) {
            this.nowSeekPoint = seekPoint;
        }
        super.seek(seekPoint);
    }

    @Override
    public void write(byte[] data, int start, int size) throws IOException {
        if (this.sortAccessFlg) {
            this.responseDataSizeMap.remove(this.nowSeekPoint);
            this.responseDataMap.remove(this.nowSeekPoint);
        }
        super.write(data, start, size);
    }

    @Override
    public int seekAndRead(long seekPoint, byte[] data, int start, int size, Object key) throws IOException {
        int ret;
        block22: {
            ret = -1;
            boolean waitMode = false;
            try {
                if (this.sortAccessFlg) {
                    Integer readDataSize;
                    ++this.executeCount;
                    if (this.clearCount < this.executeCount) {
                        this.responseDataSizeMap.clear();
                        this.responseDataMap.clear();
                        this.readRequestSeekPointQueue.clear();
                        this.executeCount = 0L;
                    }
                    if ((readDataSize = (Integer)this.responseDataSizeMap.remove(seekPoint)) != null) {
                        Map response = (Map)this.responseDataMap.remove(seekPoint);
                        byte[] responseBytes = (byte[])response.get(1);
                        for (int idx = 0; idx < responseBytes.length; ++idx) {
                            data[idx] = responseBytes[idx];
                        }
                        return readDataSize;
                    }
                    if (this.readRequestSeekPointQueue.size() > 1) {
                        int count = this.maxSeqSize;
                        if (count > this.readRequestSeekPointQueue.size()) {
                            count = this.readRequestSeekPointQueue.size();
                        }
                        Map requestParams = null;
                        if (waitMode) {
                            ArrayList<Map> tmpList = new ArrayList<Map>();
                            int maxPool = 30;
                            int execPool = 0;
                            while ((requestParams = (Map)this.readRequestSeekPointQueue.poll(10L, TimeUnit.MILLISECONDS)) != null) {
                                tmpList.add(requestParams);
                                if (maxPool > ++execPool) continue;
                            }
                            count = tmpList.size();
                            this.seekPointList = new long[count];
                            for (int i = 0; i < count; ++i) {
                                requestParams = (Map)tmpList.get(i);
                                this.seekPointList[i] = (Long)requestParams.get(4);
                                this.responseDataMap.put(this.seekPointList[i], requestParams);
                            }
                        } else {
                            this.seekPointList = new long[count];
                            for (int i = 0; i < count; ++i) {
                                requestParams = (Map)this.readRequestSeekPointQueue.take();
                                this.seekPointList[i] = (Long)requestParams.get(4);
                                this.responseDataMap.put(this.seekPointList[i], requestParams);
                            }
                        }
                        Arrays.sort(this.seekPointList);
                        for (int i = 0; i < this.seekPointList.length; ++i) {
                            requestParams = (Map)this.responseDataMap.remove(this.seekPointList[i]);
                            int reqStart = (Integer)requestParams.get(2);
                            int reqSize = (Integer)requestParams.get(3);
                            byte[] reqData = new byte[reqSize];
                            super.seek(this.seekPointList[i]);
                            Integer readDataLen = new Integer(super.read(reqData, reqStart, reqSize));
                            requestParams.put(1, reqData);
                            this.responseDataMap.put(this.seekPointList[i], requestParams);
                            this.responseDataSizeMap.put(this.seekPointList[i], readDataLen);
                        }
                        readDataSize = (Integer)this.responseDataSizeMap.remove(seekPoint);
                        Map response = (Map)this.responseDataMap.remove(seekPoint);
                        if (readDataSize == null || response == null) {
                            super.seek(seekPoint);
                            ret = super.read(data, start, size);
                        } else {
                            byte[] responseBytes = (byte[])response.get(1);
                            for (int idx = 0; idx < responseBytes.length; ++idx) {
                                data[idx] = responseBytes[idx];
                            }
                            ret = readDataSize;
                        }
                        break block22;
                    }
                    if (this.readRequestSeekPointQueue.size() == 1) {
                        Map requestParams = (Map)this.readRequestSeekPointQueue.take();
                        long requestSeekPoint = (Long)requestParams.get(4);
                        if (requestSeekPoint == seekPoint) {
                            super.seek(requestSeekPoint);
                            ret = super.read(data, start, size);
                        } else {
                            super.seek(seekPoint);
                            ret = super.read(data, start, size);
                            this.readRequestSeekPointQueue.put(requestParams);
                        }
                    } else {
                        super.seek(seekPoint);
                        ret = super.read(data, start, size);
                    }
                    break block22;
                }
                super.seek(seekPoint);
                ret = super.read(data, start, size);
            }
            catch (IOException ie) {
                throw ie;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }
}

