/*
 * Decompiled with CFR 0.152.
 */
package fuse.okuyamafs;

import fuse.okuyamafs.LRUCacheMap;
import fuse.okuyamafs.OkuyamaClientWrapper;
import fuse.okuyamafs.OkuyamaFilesystem;
import fuse.okuyamafs.OkuyamaFsMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class CacheStoreDaemon
extends Thread {
    private ArrayBlockingQueue storeQueue = null;
    private Map tmpDataMap = null;
    public OkuyamaFsMap okuyamaFs = null;
    int maxParallel = 64;
    public Object[] parallelAccessSync = new Object[this.maxParallel];

    public CacheStoreDaemon(int cacheSize, OkuyamaFsMap okuyamaFs) {
        this.storeQueue = new ArrayBlockingQueue(cacheSize);
        this.okuyamaFs = okuyamaFs;
        this.tmpDataMap = new LRUCacheMap(cacheSize);
        for (int i = 0; i < this.maxParallel; ++i) {
            this.parallelAccessSync[i] = new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println("CacheStoreDaemon-start");
        block8: while (true) {
            try {
                while (true) {
                    Object object;
                    Object[] requestData = null;
                    while ((requestData = (Object[])this.storeQueue.poll(1000L, TimeUnit.MILLISECONDS)) == null && !OkuyamaFilesystem.jvmShutdownStatus) {
                    }
                    if (OkuyamaFilesystem.jvmShutdownStatus) break block8;
                    if (!this.tmpDataMap.containsKey(requestData[1])) continue;
                    Object registData = requestData[2];
                    Object tmpDataObj = this.tmpDataMap.get(requestData[1]);
                    if (requestData[0].equals("String")) {
                        object = this.parallelAccessSync[(requestData[1].hashCode() << 1 >>> 1) % this.maxParallel];
                        synchronized (object) {
                            if (!((String)registData).equals((String)tmpDataObj)) {
                                continue;
                            }
                            this.okuyamaFs.putString(requestData[1], (String)requestData[2]);
                            continue block8;
                        }
                    }
                    if (requestData[0].equals("Map")) {
                        object = this.parallelAccessSync[(requestData[1].hashCode() << 1 >>> 1) % this.maxParallel];
                        synchronized (object) {
                            if (!((Object)((Map)registData)).equals((Map)tmpDataObj)) {
                                continue;
                            }
                            this.okuyamaFs.putMap(requestData[1], (Map)requestData[2]);
                            continue block8;
                        }
                    }
                    if (!requestData[0].equals("bytes") || !Arrays.equals((byte[])registData, (byte[])tmpDataObj)) continue;
                    this.okuyamaFs.putBytes(requestData[1], (byte[])requestData[2]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        System.out.println("CacheStoreDaemon-end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Object object = this.parallelAccessSync[(key.hashCode() << 1 >>> 1) % this.maxParallel];
        synchronized (object) {
            if (this.tmpDataMap.containsKey(key)) {
                return true;
            }
            return this.okuyamaFs.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putString(Object key, String value) {
        Object object = this.parallelAccessSync[(key.hashCode() << 1 >>> 1) % this.maxParallel];
        synchronized (object) {
            return this.putStoreRequest("String", key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putMap(Object key, Map value) {
        Object object = this.parallelAccessSync[(key.hashCode() << 1 >>> 1) % this.maxParallel];
        synchronized (object) {
            return this.putStoreRequest("Map", key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putBytes(Object key, byte[] value) {
        Object object = this.parallelAccessSync[(key.hashCode() << 1 >>> 1) % this.maxParallel];
        synchronized (object) {
            return this.putStoreRequest("bytes", key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object putStoreRequest(String type, Object key, Object value) {
        Object[] storeRequest = new Object[]{type, key, value};
        try {
            Object object = this.parallelAccessSync[(key.hashCode() << 1 >>> 1) % this.maxParallel];
            synchronized (object) {
                this.tmpDataMap.put(key, value);
                this.storeQueue.put(storeRequest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(Object key) {
        Object object = this.parallelAccessSync[(key.hashCode() << 1 >>> 1) % this.maxParallel];
        synchronized (object) {
            if (this.tmpDataMap.containsKey(key)) {
                String value = (String)this.tmpDataMap.get(key);
                if (value == null) {
                    value = this.okuyamaFs.getString(key);
                }
                return value;
            }
            String val = this.okuyamaFs.getString(key);
            if (OkuyamaClientWrapper.singleMode && val != null) {
                this.tmpDataMap.put(key, val);
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMap(Object key) {
        Object object = this.parallelAccessSync[(key.hashCode() << 1 >>> 1) % this.maxParallel];
        synchronized (object) {
            if (this.tmpDataMap.containsKey(key)) {
                Map value = (Map)this.tmpDataMap.get(key);
                if (value == null) {
                    value = this.okuyamaFs.getMap(key);
                }
                return value;
            }
            Map val = this.okuyamaFs.getMap(key);
            if (OkuyamaClientWrapper.singleMode && val != null) {
                this.tmpDataMap.put(key, val);
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(Object key) {
        Object object = this.parallelAccessSync[(key.hashCode() << 1 >>> 1) % this.maxParallel];
        synchronized (object) {
            if (this.tmpDataMap.containsKey(key)) {
                byte[] value = (byte[])this.tmpDataMap.get(key);
                if (value == null) {
                    value = this.okuyamaFs.getBytes(key);
                }
                return value;
            }
            byte[] val = this.okuyamaFs.getBytes(key);
            if (OkuyamaClientWrapper.singleMode && val != null) {
                this.tmpDataMap.put(key, val);
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object object = this.parallelAccessSync[(key.hashCode() << 1 >>> 1) % this.maxParallel];
        synchronized (object) {
            this.tmpDataMap.remove(key);
            return this.okuyamaFs.remove(key);
        }
    }
}

