/*
 * Decompiled with CFR 0.152.
 */
package fuse.okuyamafs;

import fuse.okuyamafs.CoreMapFactory;
import fuse.okuyamafs.ExpireCacheMap;
import fuse.okuyamafs.IFsMap;
import fuse.okuyamafs.OkuyamaFilesystem;
import fuse.okuyamafs.OkuyamaFsMap;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class OkuyamaClientWrapper {
    static IFsMap dataMap = CoreMapFactory.createDataMap();
    static IFsMap infoMap = CoreMapFactory.createInfoMap();
    static IFsMap dirMap = CoreMapFactory.createDirMap();
    static byte[] dummyBuf = new byte[OkuyamaFilesystem.blockSize];
    static volatile boolean singleMode = false;
    static Map infoCache = new ExpireCacheMap(50000, 60000L);

    public OkuyamaClientWrapper(boolean singleMode) throws Exception {
        this.addDir("/", false);
        OkuyamaClientWrapper.singleMode = singleMode;
    }

    public boolean addDir(String path) throws Exception {
        return this.addDir(path, true);
    }

    public boolean addDir(String path, boolean checkExist) throws Exception {
        if (!checkExist) {
            dirMap.putNewMap(path, new LinkedHashMap());
            return true;
        }
        return dirMap.putNewMap(path, new LinkedHashMap());
    }

    public boolean setDirAttribute(String attributeName, String type) throws Exception {
        String dirName = "";
        String[] attributeNameCnv = attributeName.trim().split("/");
        if (attributeNameCnv.length == 1) {
            dirName = "/";
        } else {
            String sep = "/";
            int cnt = 0;
            for (int i = 0; i < attributeNameCnv.length - 1; ++i) {
                if (attributeNameCnv[i].trim().equals("")) continue;
                dirName = dirName + sep + attributeNameCnv[i];
                ++cnt;
            }
            if (cnt == 0) {
                dirName = "/";
            }
        }
        if (!dirMap.containsKey(dirName)) {
            return false;
        }
        Map dirDt = dirMap.getMap(dirName);
        dirDt.put(attributeName, type);
        dirMap.putMap(dirName, dirDt);
        return true;
    }

    public boolean removeDir(String path) throws Exception {
        if (!dirMap.containsKey(path)) {
            return false;
        }
        Map dirDt = dirMap.getMap(path);
        if (dirDt != null && dirDt.size() > 0) {
            return false;
        }
        String[] parentDirList = path.split("/");
        if (parentDirList.length > 0) {
            int dirCnt = 0;
            String parentDirStr = "/";
            String sep = "";
            for (int idx = 0; idx < parentDirList.length - 1; ++idx) {
                if (parentDirList[idx].trim().equals("")) continue;
                parentDirStr = parentDirStr + sep + parentDirList[idx].trim();
                ++dirCnt;
                sep = "/";
            }
            Map parentDirDt = dirMap.getMap(parentDirStr);
            parentDirDt.remove(path);
            dirMap.putMap(parentDirStr, parentDirDt);
        }
        dirMap.remove(path);
        return true;
    }

    public boolean removeAttribute(String attributeName) throws Exception {
        String dirName = "";
        String[] attributeNameCnv = attributeName.trim().split("/");
        if (attributeNameCnv.length == 1) {
            dirName = "/";
        } else {
            String sep = "/";
            for (int i = 0; i < attributeNameCnv.length - 1; ++i) {
                if (attributeNameCnv[i].trim().equals("")) continue;
                dirName = dirName + sep + attributeNameCnv[i];
            }
            if (attributeName.indexOf("/") == 0 && dirName.trim().equals("")) {
                dirName = "/";
            }
        }
        if (!dirMap.containsKey(dirName)) {
            return false;
        }
        Map dirDt = dirMap.getMap(dirName);
        dirDt.remove(attributeName);
        dirMap.putMap(dirName, dirDt);
        return true;
    }

    public Map getDirChild(String path) throws Exception {
        Map dirDt = dirMap.getMap(path);
        return dirDt;
    }

    public String getPathDetail(String key) throws Exception {
        String retStr = null;
        if (singleMode) {
            retStr = (String)infoCache.get(key);
        }
        if (retStr != null) {
            return retStr;
        }
        retStr = infoMap.getString(key);
        if (retStr != null) {
            infoCache.put(key, retStr);
        }
        return retStr;
    }

    public byte[] readValue(String key, long start, int offset, String realKeyNodeNo) throws Exception {
        Object[] dataReadKeyList = null;
        boolean allDataNull = true;
        long readStartPoint = start / (long)OkuyamaFilesystem.blockSize;
        long assistPoint = 0L;
        if ((start + (long)offset) % (long)OkuyamaFilesystem.blockSize > 0L) {
            assistPoint = 1L;
        }
        long readEndPoint = (start + (long)offset) / (long)OkuyamaFilesystem.blockSize;
        byte[] replaceDataBuf = null;
        int bufReadPoint = new Long(start - start / (long)OkuyamaFilesystem.blockSize * (long)OkuyamaFilesystem.blockSize).intValue();
        if (readStartPoint == (readEndPoint += assistPoint)) {
            dataReadKeyList = new String[]{realKeyNodeNo + "\t" + readStartPoint};
        } else {
            dataReadKeyList = new String[(int)(readEndPoint - readStartPoint)];
            int idx = 0;
            for (long i = readStartPoint; i < readEndPoint; ++i) {
                dataReadKeyList[idx] = realKeyNodeNo + "\t" + i;
                ++idx;
            }
        }
        int t = 0;
        int dataReadKeyListSize = dataReadKeyList.length;
        replaceDataBuf = new byte[OkuyamaFilesystem.blockSize * dataReadKeyListSize];
        if (CoreMapFactory.factoryType == 2) {
            Map multiReadRet;
            if (dataReadKeyListSize > 0 && (multiReadRet = this.getMultiValue(dataReadKeyList)) != null) {
                byte[] readData;
                for (int i = 0; i < dataReadKeyListSize && (readData = (byte[])multiReadRet.get(dataReadKeyList[i])) != null; ++i) {
                    allDataNull = false;
                    System.arraycopy(readData, 0, replaceDataBuf, t, readData.length);
                    t += readData.length;
                }
            }
        } else {
            byte[] readData;
            for (int i = 0; i < dataReadKeyListSize && (readData = this.getValue((String)dataReadKeyList[i])) != null; ++i) {
                allDataNull = false;
                System.arraycopy(readData, 0, replaceDataBuf, t, readData.length);
                t += readData.length;
            }
        }
        if (allDataNull) {
            for (int i = 0; i < dataReadKeyListSize; ++i) {
            }
            return null;
        }
        int readDataSize = replaceDataBuf.length;
        byte[] retData = null;
        int realWritePoint = 0;
        for (int startPoint = bufReadPoint; startPoint < bufReadPoint + offset && replaceDataBuf.length > startPoint; ++startPoint) {
            ++realWritePoint;
        }
        if (replaceDataBuf.length <= bufReadPoint + offset) {
            retData = new byte[realWritePoint];
            System.arraycopy(replaceDataBuf, bufReadPoint, retData, 0, realWritePoint);
        } else if (replaceDataBuf.length > bufReadPoint + offset) {
            retData = new byte[realWritePoint];
            System.arraycopy(replaceDataBuf, bufReadPoint, retData, 0, realWritePoint);
        }
        return retData;
    }

    private byte[] getValue(String key) throws Exception {
        byte[] retData = dataMap.getBytes(key);
        return retData;
    }

    private Map getMultiValue(Object[] keyList) throws Exception {
        Map retData = ((OkuyamaFsMap)dataMap).getMultiBytes(keyList);
        return retData;
    }

    public long writeValue(String key, long start, byte[] writeData, int limit, String realKeyNodeNo, long lastBlockIdx) throws Exception {
        byte[] blockDataBuf;
        long retBlockIdx = 0L;
        int realStartPoint = new Long(start % (long)OkuyamaFilesystem.blockSize).intValue();
        int len = writeData.length;
        String[] dataReadKeyList = null;
        long writeStartPoint = start / (long)OkuyamaFilesystem.blockSize;
        int assistPoint = 0;
        if ((start + (long)len) % (long)OkuyamaFilesystem.blockSize > 0L) {
            assistPoint = 1;
        }
        long writeEndPoint = (start + (long)len) / (long)OkuyamaFilesystem.blockSize;
        writeEndPoint += (long)assistPoint;
        boolean fullFirtstBlock = false;
        if (lastBlockIdx < writeStartPoint) {
            fullFirtstBlock = true;
        }
        if (writeStartPoint == writeEndPoint) {
            dataReadKeyList = new String[]{realKeyNodeNo + "\t" + writeStartPoint};
        } else {
            dataReadKeyList = new String[(int)(writeEndPoint - writeStartPoint)];
            int assistIdx = 0;
            for (long i = writeStartPoint; i < writeEndPoint; ++i) {
                dataReadKeyList[assistIdx] = realKeyNodeNo + "\t" + i;
                ++assistIdx;
            }
        }
        int dataReadKeyListSize = dataReadKeyList.length;
        byte[] replaceDataBuf = new byte[OkuyamaFilesystem.blockSize * dataReadKeyListSize];
        int copyStart = 0;
        if (lastBlockIdx == -1L || fullFirtstBlock) {
            for (int idx = 0; idx < dataReadKeyListSize; ++idx) {
                System.arraycopy(dummyBuf, 0, replaceDataBuf, copyStart, dummyBuf.length);
                copyStart += dummyBuf.length;
            }
        } else {
            boolean firstDataExists = false;
            for (int idx = 0; idx < dataReadKeyListSize; ++idx) {
                byte[] replaceData = null;
                if (CoreMapFactory.factoryType == 1 || CoreMapFactory.factoryType == 2) {
                    if (idx == 0) {
                        replaceData = this.getValue(dataReadKeyList[idx]);
                        if (replaceData != null) {
                            firstDataExists = true;
                        }
                    } else if (idx + 1 == dataReadKeyListSize && firstDataExists) {
                        replaceData = this.getValue(dataReadKeyList[idx]);
                    }
                }
                if (replaceData != null) {
                    System.arraycopy(replaceData, 0, replaceDataBuf, copyStart, replaceData.length);
                    copyStart += replaceData.length;
                    continue;
                }
                System.arraycopy(dummyBuf, 0, replaceDataBuf, copyStart, dummyBuf.length);
                copyStart += dummyBuf.length;
            }
        }
        byte[] replaceAllData = replaceDataBuf;
        replaceDataBuf = null;
        if (copyStart == 0) {
            replaceAllData = new byte[len];
        }
        System.arraycopy(writeData, 0, replaceAllData, realStartPoint, len);
        String lastSetKey = null;
        if (CoreMapFactory.factoryType == 1) {
            blockDataBuf = new byte[OkuyamaFilesystem.blockSize];
            for (int idx = 0; idx < dataReadKeyListSize; ++idx) {
                int stopPointIdx = 0;
                for (int t = idx * OkuyamaFilesystem.blockSize; t < replaceAllData.length; ++t) {
                    blockDataBuf[stopPointIdx] = replaceAllData[t];
                    if (OkuyamaFilesystem.blockSize <= ++stopPointIdx) break;
                }
                byte[] setBytes = Arrays.copyOf(blockDataBuf, stopPointIdx);
                this.setValue(dataReadKeyList[idx], setBytes);
                lastSetKey = dataReadKeyList[idx];
            }
        } else {
            blockDataBuf = new byte[OkuyamaFilesystem.blockSize];
            Object[] putDataList = new Object[dataReadKeyListSize];
            for (int idx = 0; idx < dataReadKeyListSize; ++idx) {
                int stopPointIdx = 0;
                for (int t = idx * OkuyamaFilesystem.blockSize; t < replaceAllData.length; ++t) {
                    blockDataBuf[stopPointIdx] = replaceAllData[t];
                    if (OkuyamaFilesystem.blockSize <= ++stopPointIdx) break;
                }
                byte[] setBytes = Arrays.copyOf(blockDataBuf, stopPointIdx);
                Object[] putDataReq = new Object[]{dataReadKeyList[idx], setBytes};
                putDataList[idx] = putDataReq;
                lastSetKey = dataReadKeyList[idx];
            }
            ((OkuyamaFsMap)dataMap).putMultiBytes(putDataList);
        }
        String retBlockIdxStr = lastSetKey.substring(lastSetKey.indexOf("\t") + 1);
        retBlockIdx = Long.parseLong(retBlockIdxStr);
        return retBlockIdx;
    }

    private boolean setValue(String key, byte[] value) throws Exception {
        dataMap.putBytes(key, value);
        return true;
    }

    public boolean removeValue(String key, long size, long removeSize, String realKeyNodeNo) throws Exception {
        if (size == 0L) {
            this.deleteValue(key, realKeyNodeNo);
            return true;
        }
        ArrayList<String> dataReadKeyList = new ArrayList<String>();
        LinkedHashMap dataBuf = new LinkedHashMap(8192);
        ArrayList dataList = new ArrayList(8192);
        int noRemoveStartPoint = new Long(size % (long)OkuyamaFilesystem.blockSize).intValue();
        long readStartPoint = size / (long)OkuyamaFilesystem.blockSize;
        long assistPoint = 0L;
        if ((size + removeSize) % (long)OkuyamaFilesystem.blockSize > 0L) {
            assistPoint = 1L;
        }
        long readEndPoint = (size + removeSize) / (long)OkuyamaFilesystem.blockSize;
        if (readStartPoint == (readEndPoint += assistPoint)) {
            dataReadKeyList.add(realKeyNodeNo + "\t" + readStartPoint);
        } else {
            for (long i = readStartPoint; i < readEndPoint; ++i) {
                dataReadKeyList.add(realKeyNodeNo + "\t" + i);
            }
        }
        int dataReadKeyListSize = dataReadKeyList.size();
        if (dataReadKeyListSize > 1) {
            for (int idx = 1; idx < dataReadKeyListSize && this.removeValue((String)dataReadKeyList.get(idx)); ++idx) {
            }
        } else if (dataReadKeyListSize == 0) {
            return true;
        }
        byte[] readData = this.getValue((String)dataReadKeyList.get(0));
        for (int i = noRemoveStartPoint; i < OkuyamaFilesystem.blockSize; ++i) {
            readData[i] = new Byte(0);
        }
        this.setValue((String)dataReadKeyList.get(0), readData);
        return true;
    }

    public boolean appendingNullData(String key, long size, String realKeyNodeNo) throws Exception {
        ArrayList<String> dataReadKeyList = new ArrayList<String>();
        LinkedHashMap dataBuf = new LinkedHashMap(8192);
        ArrayList dataList = new ArrayList(8192);
        long readStartPoint = 0L;
        long readEndPoint = size / (long)OkuyamaFilesystem.blockSize;
        long assistPoint = 0L;
        if (size % (long)OkuyamaFilesystem.blockSize > 0L) {
            ++readEndPoint;
        }
        if (readStartPoint == readEndPoint) {
            dataReadKeyList.add(realKeyNodeNo + "\t" + readStartPoint);
        } else {
            for (long i = readStartPoint; i < readEndPoint; ++i) {
                dataReadKeyList.add(realKeyNodeNo + "\t" + i);
            }
        }
        boolean t = false;
        int dataReadKeyListSize = dataReadKeyList.size();
        for (int i = 0; i < dataReadKeyListSize; ++i) {
            int dummyIdx;
            byte[] readData;
            ByteArrayOutputStream replaceDataBuf = new ByteArrayOutputStream(OkuyamaFilesystem.blockSize);
            byte[] setBytes = null;
            if (i == 0) {
                readData = this.getValue((String)dataReadKeyList.get(i));
                if (readData == null) {
                    for (dummyIdx = 0; dummyIdx < OkuyamaFilesystem.blockSize; ++dummyIdx) {
                        replaceDataBuf.write(0);
                    }
                    setBytes = replaceDataBuf.toByteArray();
                } else {
                    replaceDataBuf.write(readData);
                    for (dummyIdx = readData.length; dummyIdx < OkuyamaFilesystem.blockSize; ++dummyIdx) {
                        replaceDataBuf.write(0);
                    }
                    setBytes = replaceDataBuf.toByteArray();
                }
            } else if (i + 1 != dataReadKeyListSize) {
                for (int dummyIdx2 = 0; dummyIdx2 < OkuyamaFilesystem.blockSize; ++dummyIdx2) {
                    replaceDataBuf.write(0);
                }
                setBytes = replaceDataBuf.toByteArray();
            } else {
                readData = this.getValue((String)dataReadKeyList.get(i));
                if (readData == null) {
                    for (dummyIdx = 0; dummyIdx < OkuyamaFilesystem.blockSize; ++dummyIdx) {
                        replaceDataBuf.write(0);
                    }
                    setBytes = replaceDataBuf.toByteArray();
                } else {
                    replaceDataBuf.write(readData);
                    for (dummyIdx = readData.length; dummyIdx < OkuyamaFilesystem.blockSize; ++dummyIdx) {
                        replaceDataBuf.write(0);
                    }
                    setBytes = replaceDataBuf.toByteArray();
                }
            }
            this.setValue((String)dataReadKeyList.get(i), setBytes);
        }
        return true;
    }

    public boolean deleteValue(String key, String realKeyNodeNo) throws Exception {
        if (CoreMapFactory.factoryType != 2) {
            for (long idx = 0L; idx < Long.MAX_VALUE && this.removeValue(realKeyNodeNo + "\t" + idx); ++idx) {
            }
        } else {
            for (long idx = 0L; idx < Long.MAX_VALUE; ++idx) {
                String[] keys = new String[50];
                int i = 0;
                while (i < 50) {
                    keys[i] = realKeyNodeNo + "\t" + idx;
                    ++i;
                    ++idx;
                }
                if (this.multiRemoveValue(keys)) {
                    continue;
                }
                break;
            }
        }
        return true;
    }

    private boolean removeValue(String key) throws Exception {
        boolean ret = dataMap.containsKey(key);
        dataMap.remove(key);
        return ret;
    }

    private boolean multiRemoveValue(String[] keys) throws Exception {
        return ((OkuyamaFsMap)dataMap).removeMulti(keys);
    }

    public boolean setPathDetail(String key, String value) throws Exception {
        infoMap.putString(key, value);
        if (singleMode) {
            infoCache.put(key, value);
        }
        return true;
    }

    public boolean addPathDetail(String key, String value) throws Exception {
        if (infoMap.containsKey(key)) {
            return false;
        }
        infoMap.putString(key, value);
        if (singleMode) {
            infoCache.put(key, value);
        }
        return true;
    }

    public boolean removePathDetail(String key) throws Exception {
        if (singleMode) {
            infoCache.remove(key);
        }
        if (!infoMap.containsKey(key)) {
            return false;
        }
        infoMap.remove(key);
        return true;
    }

    static {
        for (int dummyIdx = 0; dummyIdx < OkuyamaFilesystem.blockSize; ++dummyIdx) {
            OkuyamaClientWrapper.dummyBuf[dummyIdx] = 0;
        }
    }
}

