/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okuyama.imdst.util.AllFileModeCoreValueCnv;
import okuyama.imdst.util.CoreStorageContainer;
import okuyama.imdst.util.CoreValueMapSet;
import okuyama.imdst.util.FileBaseDataMap;
import okuyama.imdst.util.ICoreStorage;
import okuyama.imdst.util.ICoreValueConverter;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.MemoryModeCoreValueCnv;
import okuyama.imdst.util.NativeConcurrentHashMap;
import okuyama.imdst.util.OriginalValueMemoryModeCoreValueCnv;
import okuyama.imdst.util.PartialConcurrentHashMap;
import okuyama.imdst.util.PartialFileModeCoreValueCnv;
import okuyama.imdst.util.PartialSerializeMap;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.serializemap.SerializeMap;

public class CoreValueMap
extends AbstractMap
implements Cloneable,
Serializable {
    private boolean fileWrite = false;
    private ICoreValueConverter converter = null;
    private AbstractMap mainMap = null;
    private boolean allDataMemory = false;
    public long useStorageObjectTime = 0L;
    protected Map dataSizeMap = new ConcurrentHashMap(20, 16.0f, 16);
    private boolean urgentSaveMode = false;
    private AbstractMap urgentSaveMap = null;
    private ICoreValueConverter urgentSaveMapConverter = null;
    private String[] virtualStoreDirs = null;
    private Object syncObj = new Object();

    public CoreValueMap(int size, int upper, int multi, boolean memoryMode, String[] virtualStoreDirs, boolean renewFlg, File bkupObjectDataFile) {
        System.out.println("Core Storage initialize start - " + new Date().toString());
        if (memoryMode) {
            if (!ImdstDefine.useSerializeMap) {
                if (ImdstDefine.saveValueCompress) {
                    System.out.println(" PartialConcurrentHashMap Use");
                    if (renewFlg) {
                        this.mainMap = new PartialConcurrentHashMap(size, upper, multi, virtualStoreDirs);
                    } else {
                        File file = bkupObjectDataFile;
                        if (file != null && file.exists()) {
                            try {
                                FileInputStream fis = new FileInputStream(file);
                                ObjectInputStream ois = new ObjectInputStream(fis);
                                CoreStorageContainer container = (CoreStorageContainer)ois.readObject();
                                this.useStorageObjectTime = container.storeTime;
                                this.mainMap = (PartialConcurrentHashMap)container.storeObject;
                                this.dataSizeMap = container.dataSizeMap;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.mainMap = new PartialConcurrentHashMap(size, upper, multi, virtualStoreDirs);
                            }
                        } else {
                            this.mainMap = new PartialConcurrentHashMap(size, upper, multi, virtualStoreDirs);
                        }
                    }
                } else {
                    System.out.println(" ConcurrentHashMap Use");
                    if (renewFlg) {
                        this.mainMap = new NativeConcurrentHashMap(size, upper, multi);
                    } else {
                        File file = bkupObjectDataFile;
                        if (file != null && file.exists()) {
                            try {
                                FileInputStream fis = new FileInputStream(file);
                                ObjectInputStream ois = new ObjectInputStream(fis);
                                CoreStorageContainer container = (CoreStorageContainer)ois.readObject();
                                this.useStorageObjectTime = container.storeTime;
                                this.mainMap = (NativeConcurrentHashMap)container.storeObject;
                                this.dataSizeMap = container.dataSizeMap;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.mainMap = new NativeConcurrentHashMap(size, upper, multi);
                            }
                        } else {
                            this.mainMap = new NativeConcurrentHashMap(size, upper, multi);
                        }
                    }
                    this.converter = new OriginalValueMemoryModeCoreValueCnv();
                }
            } else {
                long jvmMaxMemory = JavaSystemApi.getRuntimeMaxMem("M");
                long bucketSize = jvmMaxMemory * SerializeMap.bucketJvm1MBMemoryFactor;
                System.out.println(" PartialSerializeMap Use");
                MemoryModeCoreValueCnv.compressUnderLimitSize = 0x40000000;
                if (renewFlg) {
                    this.mainMap = new PartialSerializeMap(size, upper, new Long(bucketSize).intValue(), virtualStoreDirs);
                } else {
                    File file = bkupObjectDataFile;
                    if (file != null && file.exists()) {
                        try {
                            FileInputStream fis = new FileInputStream(file);
                            ObjectInputStream ois = new ObjectInputStream(fis);
                            CoreStorageContainer container = (CoreStorageContainer)ois.readObject();
                            this.useStorageObjectTime = container.storeTime;
                            this.mainMap = (PartialSerializeMap)container.storeObject;
                            this.dataSizeMap = container.dataSizeMap;
                        }
                        catch (Exception e) {
                            this.mainMap = new PartialSerializeMap(size, upper, new Long(bucketSize).intValue(), virtualStoreDirs);
                        }
                    } else {
                        this.mainMap = new PartialSerializeMap(size, upper, new Long(bucketSize).intValue(), virtualStoreDirs);
                    }
                }
            }
            if (this.converter == null) {
                this.converter = new MemoryModeCoreValueCnv();
            }
            this.allDataMemory = true;
        } else {
            if (!ImdstDefine.useSerializeMap) {
                System.out.println(" ConcurrentHashMap Use");
                if (renewFlg) {
                    this.mainMap = new NativeConcurrentHashMap(size, upper, multi);
                } else {
                    File file = bkupObjectDataFile;
                    if (file != null && file.exists()) {
                        try {
                            FileInputStream fis = new FileInputStream(file);
                            ObjectInputStream ois = new ObjectInputStream(fis);
                            CoreStorageContainer container = (CoreStorageContainer)ois.readObject();
                            this.useStorageObjectTime = container.storeTime;
                            this.mainMap = (NativeConcurrentHashMap)container.storeObject;
                            this.dataSizeMap = container.dataSizeMap;
                        }
                        catch (Exception e) {
                            this.mainMap = new NativeConcurrentHashMap(size, upper, multi);
                        }
                    } else {
                        this.mainMap = new NativeConcurrentHashMap(size, upper, multi);
                    }
                }
            } else {
                long jvmMaxMemory = JavaSystemApi.getRuntimeMaxMem("M");
                long bucketSize = jvmMaxMemory * SerializeMap.bucketJvm1MBMemoryFactor;
                System.out.println(" SerializeMap Use");
                if (renewFlg) {
                    this.mainMap = new SerializeMap(size, upper, new Long(bucketSize).intValue(), ImdstDefine.serializerClassName);
                } else {
                    File file = bkupObjectDataFile;
                    if (file != null && file.exists()) {
                        try {
                            FileInputStream fis = new FileInputStream(file);
                            ObjectInputStream ois = new ObjectInputStream(fis);
                            CoreStorageContainer container = (CoreStorageContainer)ois.readObject();
                            this.useStorageObjectTime = container.storeTime;
                            this.mainMap = (SerializeMap)container.storeObject;
                            this.dataSizeMap = container.dataSizeMap;
                        }
                        catch (Exception e) {
                            this.mainMap = new SerializeMap(size, upper, new Long(bucketSize).intValue(), ImdstDefine.serializerClassName);
                        }
                    } else {
                        this.mainMap = new SerializeMap(size, upper, new Long(bucketSize).intValue(), ImdstDefine.serializerClassName);
                    }
                }
            }
            this.converter = new PartialFileModeCoreValueCnv();
        }
        this.virtualStoreDirs = virtualStoreDirs;
        if (this.useStorageObjectTime != 0L) {
            System.out.println(" ->Storage data is restored from backup");
            System.out.println(" ->Backup data create time = " + new Date(this.useStorageObjectTime).toString());
        }
        System.out.println("Core Storage initialize end   - " + new Date().toString());
    }

    public CoreValueMap(String[] dirs, int numberOfDataSize, boolean renewFlg) {
        this.mainMap = new FileBaseDataMap(dirs, numberOfDataSize, 0.2, 15, renewFlg);
        this.converter = new AllFileModeCoreValueCnv();
    }

    @Override
    public Object put(Object key, Object value) {
        if (!this.isUrgentSaveMode()) {
            return this.mainMap.put(this.converter.convertEncodeKey(key), this.converter.convertEncodeValue(value));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return this.mainMap.put(this.converter.convertEncodeKey(key), this.converter.convertEncodeValue(value));
        }
        return this.urgentSaveMap.put(this.urgentSaveMapConverter.convertEncodeKey(key), this.urgentSaveMapConverter.convertEncodeValue(value));
    }

    @Override
    public Object get(Object key) {
        if (!this.isUrgentSaveMode()) {
            return this.converter.convertDecodeValue(this.mainMap.get(this.converter.convertEncodeKey(key)));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return this.converter.convertDecodeValue(this.mainMap.get(this.converter.convertEncodeKey(key)));
        }
        return this.urgentSaveMapConverter.convertDecodeValue(this.urgentSaveMap.get(this.urgentSaveMapConverter.convertEncodeKey(key)));
    }

    @Override
    public Object remove(Object key) {
        if (!this.isUrgentSaveMode()) {
            return this.converter.convertDecodeValue(this.mainMap.remove(this.converter.convertEncodeKey(key)));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return this.converter.convertDecodeValue(this.mainMap.remove(this.converter.convertEncodeKey(key)));
        }
        return this.urgentSaveMapConverter.convertDecodeValue(this.urgentSaveMap.remove(this.urgentSaveMapConverter.convertEncodeKey(key)));
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.isUrgentSaveMode()) {
            return this.mainMap.containsKey(this.converter.convertEncodeKey(key));
        }
        if (this.mainMap.containsKey(this.converter.convertEncodeKey(key))) {
            return true;
        }
        return this.urgentSaveMap.containsKey(this.urgentSaveMapConverter.convertEncodeKey(key));
    }

    @Override
    public void clear() {
        this.mainMap.clear();
        if (this.isUrgentSaveMode()) {
            this.urgentSaveMap.clear();
        }
    }

    @Override
    public int size() {
        if (!this.isUrgentSaveMode()) {
            return this.mainMap.size();
        }
        int retSize = this.mainMap.size();
        return retSize += this.urgentSaveMap.size();
    }

    @Override
    public Set entrySet() {
        if (!this.isUrgentSaveMode()) {
            return new CoreValueMapSet(this.mainMap.entrySet(), this.converter);
        }
        return new CoreValueMapSet(this.mainMap.entrySet(), this.urgentSaveMap.entrySet(), this.converter, this.urgentSaveMapConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUrgentSaveMode() {
        if (this.virtualStoreDirs == null) {
            return false;
        }
        if (this.urgentSaveMode) {
            return true;
        }
        if (!StatusUtil.isUseMemoryLimitOver()) {
            return false;
        }
        if (this.urgentSaveMap != null) {
            return true;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.urgentSaveMap != null) {
                return true;
            }
            this.urgentSaveMapConverter = new AllFileModeCoreValueCnv();
            this.urgentSaveMap = this.allDataMemory ? new FileBaseDataMap(this.virtualStoreDirs, 100000, 0.05, new Double((double)ImdstDefine.saveDataMaxSize * 1.4).intValue() + 1, 512, 126976) : new FileBaseDataMap(this.virtualStoreDirs, 10000000, 0.1, 15);
            this.urgentSaveMode = true;
        }
        return true;
    }

    public void fileStoreMapObject(File file, Map dataSizeMap) throws Exception {
        String fileName = file.getAbsolutePath();
        File createFile = new File(fileName + ".tmp");
        FileOutputStream fos = new FileOutputStream(createFile, false);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        CoreStorageContainer container = new CoreStorageContainer();
        container.storeTime = System.currentTimeMillis();
        container.storeObject = (ICoreStorage)((Object)this.mainMap);
        container.dataSizeMap = dataSizeMap;
        oos.writeObject(container);
        oos.close();
        if (file.exists()) {
            file.delete();
        }
        if (!createFile.renameTo(file = new File(fileName))) {
            throw new Exception("Obj file create error");
        }
    }
}

