/*
 * Decompiled with CFR 0.152.
 */
package fuse;

import fuse.Filesystem3;
import fuse.FuseDirFiller;
import fuse.FuseException;
import fuse.FuseGetattrSetter;
import fuse.FuseMount;
import fuse.FuseOpenSetter;
import fuse.FuseSizeSetter;
import fuse.FuseStatfsSetter;
import fuse.XattrLister;
import fuse.XattrSupport;
import java.io.File;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FakeFilesystem
implements Filesystem3,
XattrSupport {
    private static final Log log = LogFactory.getLog(FakeFilesystem.class);
    private static final int BLOCK_SIZE = 512;
    private static final int NAME_LENGTH = 1024;
    private D root = new D("", 493, "description", "ROOT directory");

    private N lookup(String path) {
        N node;
        if (path.equals("/")) {
            return this.root;
        }
        File f = new File(path);
        N parent = this.lookup(f.getParent());
        N n = node = parent instanceof D ? ((D)parent).files.get(f.getName()) : null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("  lookup(\"" + path + "\") returning: " + node));
        }
        return node;
    }

    public FakeFilesystem() {
        this.root.add(new F("README", 420, "Hou have read me\n", new String[]{"mimetype", "text/plain", "description", "a README file"}));
        this.root.add(new F("execute_me.sh", 493, "#!/bin/sh\n\necho \"You executed me\"\n", new String[]{"mimetype", "text/plain", "description", "a BASH script"}));
        D subdir = new D("subdir", 493, "description", "a subdirectory");
        this.root.add(subdir);
        subdir.add(new L("README.link", 438, "../README", new String[]{"description", "a symbolic link"}));
        subdir.add(new L("execute_me.link.sh", 438, "../execute_me.sh", new String[]{"description", "another symbolic link"}));
        log.info((Object)"created");
    }

    public int chmod(String path, int mode) throws FuseException {
        N n = this.lookup(path);
        if (n != null) {
            n.mode = n.mode & 0xF000 | mode & 0xFFF;
            return 0;
        }
        return 2;
    }

    public int chown(String path, int uid, int gid) throws FuseException {
        return 0;
    }

    public int getattr(String path, FuseGetattrSetter getattrSetter) throws FuseException {
        N n = this.lookup(path);
        int time = (int)(System.currentTimeMillis() / 1000L);
        if (n instanceof D) {
            D d = (D)n;
            getattrSetter.set(d.hashCode(), 0x4000 | d.mode, 1, 0, 0, 0, d.files.size() * 1024, (d.files.size() * 1024 + 512 - 1) / 512, time, time, time);
            return 0;
        }
        if (n instanceof F) {
            F f = (F)n;
            getattrSetter.set(f.hashCode(), 0x8000 | f.mode, 1, 0, 0, 0, f.content.length, (f.content.length + 512 - 1) / 512, time, time, time);
            return 0;
        }
        if (n instanceof L) {
            L l = (L)n;
            getattrSetter.set(l.hashCode(), 0xA000 | l.mode, 1, 0, 0, 0, l.link.length(), (l.link.length() + 512 - 1) / 512, time, time, time);
            return 0;
        }
        return 2;
    }

    public int getdir(String path, FuseDirFiller filler) throws FuseException {
        N n = this.lookup(path);
        if (n instanceof D) {
            for (N child : ((D)n).files.values()) {
                int ftype = child instanceof D ? 16384 : (child instanceof F ? 32768 : (child instanceof L ? 40960 : 0));
                if (ftype <= 0) continue;
                filler.add(child.name, child.hashCode(), ftype | child.mode);
            }
            return 0;
        }
        return 20;
    }

    public int link(String from, String to) throws FuseException {
        return 30;
    }

    public int mkdir(String path, int mode) throws FuseException {
        return 30;
    }

    public int mknod(String path, int mode, int rdev) throws FuseException {
        return 30;
    }

    public int rename(String from, String to) throws FuseException {
        return 30;
    }

    public int rmdir(String path) throws FuseException {
        return 30;
    }

    public int statfs(FuseStatfsSetter statfsSetter) throws FuseException {
        statfsSetter.set(512, 1000, 200, 180, N.nfiles, 0, 1024);
        return 0;
    }

    public int symlink(String from, String to) throws FuseException {
        return 30;
    }

    public int truncate(String path, long size) throws FuseException {
        return 30;
    }

    public int unlink(String path) throws FuseException {
        return 30;
    }

    public int utime(String path, int atime, int mtime) throws FuseException {
        return 0;
    }

    public int readlink(String path, CharBuffer link) throws FuseException {
        N n = this.lookup(path);
        if (n instanceof L) {
            link.append(((L)n).link);
            return 0;
        }
        return 2;
    }

    public int open(String path, int flags, FuseOpenSetter openSetter) throws FuseException {
        N n = this.lookup(path);
        if (n != null) {
            openSetter.setFh(new FH(n));
            return 0;
        }
        return 2;
    }

    public int write(String path, Object fh, boolean isWritepage, ByteBuffer buf, long offset) throws FuseException {
        return 30;
    }

    public int read(String path, Object fh, ByteBuffer buf, long offset) throws FuseException {
        if (fh instanceof FH) {
            F f = (F)((FH)fh).n;
            buf.put(f.content, (int)offset, Math.min(buf.remaining(), f.content.length - (int)offset));
            return 0;
        }
        return 9;
    }

    public int flush(String path, Object fh) throws FuseException {
        if (fh instanceof FH) {
            return 0;
        }
        return 9;
    }

    public int fsync(String path, Object fh, boolean isDatasync) throws FuseException {
        if (fh instanceof FH) {
            return 0;
        }
        return 9;
    }

    public int release(String path, Object fh, int flags) throws FuseException {
        if (fh instanceof FH) {
            ((FH)fh).release();
            System.runFinalization();
            return 0;
        }
        return 9;
    }

    public int getxattr(String path, String name, ByteBuffer dst) throws FuseException, BufferOverflowException {
        N n = this.lookup(path);
        if (n == null) {
            return 2;
        }
        byte[] value = n.xattrs.get(name);
        if (value == null) {
            return 61;
        }
        dst.put(value);
        return 0;
    }

    public int getxattrsize(String path, String name, FuseSizeSetter sizeSetter) throws FuseException {
        N n = this.lookup(path);
        if (n == null) {
            return 2;
        }
        byte[] value = n.xattrs.get(name);
        if (value == null) {
            return 61;
        }
        sizeSetter.setSize(value.length);
        return 0;
    }

    public int listxattr(String path, XattrLister lister) throws FuseException {
        N n = this.lookup(path);
        if (n == null) {
            return 2;
        }
        for (String xattrName : n.xattrs.keySet()) {
            lister.add(xattrName);
        }
        return 0;
    }

    public int removexattr(String path, String name) throws FuseException {
        return 30;
    }

    public int setxattr(String path, String name, ByteBuffer value, int flags) throws FuseException {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        log.info((Object)"entering");
        try {
            FuseMount.mount(args, new FakeFilesystem(), log);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            log.info((Object)"exiting");
        }
    }

    private static class FH {
        N n;

        FH(N n) {
            this.n = n;
            log.debug((Object)("  " + this + " created"));
        }

        void release() {
            log.debug((Object)("  " + this + " released"));
        }

        protected void finalize() {
            log.debug((Object)("  " + this + " finalized"));
        }

        public String toString() {
            return "FH[" + this.n + ", hashCode=" + this.hashCode() + "]";
        }
    }

    private static class L
    extends N {
        String link;

        L(String name, int mode, String link, String ... xattrs) {
            super(name, mode, xattrs);
            this.link = link;
        }
    }

    private static class F
    extends N {
        byte[] content;

        F(String name, int mode, String content, String ... xattrs) {
            super(name, mode, xattrs);
            this.content = content.getBytes();
        }
    }

    private static class D
    extends N {
        Map<String, N> files = new LinkedHashMap<String, N>();

        D(String name, int mode, String ... xattrs) {
            super(name, mode, xattrs);
        }

        void add(N n) {
            this.files.put(n.name, n);
        }

        public String toString() {
            return super.toString() + " with " + this.files.size() + " files";
        }
    }

    private static class N {
        static int nfiles = 0;
        String name;
        int mode;
        Map<String, byte[]> xattrs = new HashMap<String, byte[]>();

        N(String name, int mode, String ... xattrs) {
            this.name = name;
            this.mode = mode;
            for (int i = 0; i < xattrs.length - 1; i += 2) {
                this.xattrs.put(xattrs[i], xattrs[i + 1].getBytes());
            }
            ++nfiles;
        }

        public String toString() {
            String cn = this.getClass().getName();
            return cn.substring(cn.indexOf("$")) + "[ name=" + this.name + ", mode=" + Integer.toOctalString(this.mode) + "(OCT) ]";
        }
    }
}

