/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapreduce.util.MRAsyncDiskService;

@InterfaceAudience.Private
class UserLogCleaner
extends Thread {
    private static final Log LOG = LogFactory.getLog(UserLogCleaner.class);
    static final int DEFAULT_USER_LOG_RETAIN_HOURS = 24;
    static final long DEFAULT_THREAD_SLEEP_TIME = 3600000L;
    private Map<JobID, Long> completedJobs = Collections.synchronizedMap(new HashMap());
    private final long threadSleepTime;
    private MRAsyncDiskService logAsyncDisk;
    private Clock clock;

    UserLogCleaner(Configuration conf) throws IOException {
        this.threadSleepTime = conf.getLong("mapreduce.tasktracker.userlogcleanup.sleeptime", 3600000L);
        this.logAsyncDisk = new MRAsyncDiskService((FileSystem)FileSystem.getLocal((Configuration)conf), TaskLog.getUserLogDir().toString());
        this.setClock(new Clock());
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    Clock getClock() {
        return this.clock;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.threadSleepTime);
                    this.processCompletedJobs();
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)(this.getClass().getSimpleName() + " encountered an exception while monitoring :"), e);
                LOG.info((Object)"Ingoring the exception and continuing monitoring.");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCompletedJobs() throws IOException {
        long now = this.clock.getTime();
        Map<JobID, Long> map = this.completedJobs;
        synchronized (map) {
            Iterator<Map.Entry<JobID, Long>> completedJobIter = this.completedJobs.entrySet().iterator();
            while (completedJobIter.hasNext()) {
                Map.Entry<JobID, Long> entry = completedJobIter.next();
                if (entry.getValue() > now) continue;
                this.deleteLogPath(TaskLog.getJobDir(entry.getKey()).getAbsolutePath());
                completedJobIter.remove();
            }
        }
    }

    void clearOldUserLogs(Configuration conf) throws IOException {
        String[] logDirs;
        File userLogDir = TaskLog.getUserLogDir();
        if (userLogDir.exists() && (logDirs = userLogDir.list()).length > 0) {
            long now = this.clock.getTime();
            for (String logDir : logDirs) {
                if (logDir.equals("toBeDeleted")) continue;
                JobID jobid = null;
                try {
                    jobid = JobID.forName(logDir);
                }
                catch (IllegalArgumentException ie) {
                    this.deleteLogPath(new File(userLogDir, logDir).getAbsolutePath());
                    continue;
                }
                if (this.completedJobs.containsKey(jobid)) continue;
                this.markJobLogsForDeletion(now, conf, jobid);
            }
        }
    }

    private int getUserlogRetainMillis(Configuration conf) {
        return (conf == null ? 24 : conf.getInt("mapreduce.job.userlog.retain.hours", 24)) * 1000 * 60 * 60;
    }

    public void markJobLogsForDeletion(long jobCompletionTime, Configuration conf, JobID jobid) {
        long retainTimeStamp = jobCompletionTime + (long)this.getUserlogRetainMillis(conf);
        LOG.info((Object)("Adding " + jobid + " for user-log deletion with retainTimeStamp:" + retainTimeStamp));
        this.completedJobs.put(jobid, retainTimeStamp);
    }

    public void unmarkJobFromLogDeletion(JobID jobid) {
        if (this.completedJobs.remove(jobid) != null) {
            LOG.info((Object)("Removing " + jobid + " from user-log deletion"));
        }
    }

    private void deleteLogPath(String logPath) throws IOException {
        LOG.info((Object)("Deleting user log path " + logPath));
        this.logAsyncDisk.moveAndDeleteAbsolutePath(logPath);
    }
}

