/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.fs.FSInputStream;

class ByteRangeInputStream
extends FSInputStream {
    protected InputStream in;
    protected URLOpener originalURL;
    protected URLOpener resolvedURL;
    protected long startPos = 0L;
    protected long currentPos = 0L;
    protected int status = 1;
    protected static final int STATUS_NORMAL = 0;
    protected static final int STATUS_SEEK = 1;

    ByteRangeInputStream(URL url) {
        this(new URLOpener(url), new URLOpener(null));
    }

    ByteRangeInputStream(URLOpener o, URLOpener r) {
        this.originalURL = o;
        this.resolvedURL = r;
    }

    private InputStream getInputStream() throws IOException {
        if (this.status != 0) {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            System.out.println("url: " + this.resolvedURL.getURL());
            URLOpener o = this.resolvedURL.getURL() == null ? this.originalURL : this.resolvedURL;
            HttpURLConnection connection = o.openConnection();
            connection.setRequestMethod("GET");
            if (this.startPos != 0L) {
                connection.setRequestProperty("Range", "bytes=" + this.startPos + "-");
            }
            connection.connect();
            this.in = connection.getInputStream();
            if (this.startPos != 0L && connection.getResponseCode() != 206) {
                throw new IOException("206 expected, but received " + connection.getResponseCode());
            }
            if (this.startPos == 0L && connection.getResponseCode() != 200) {
                throw new IOException("200 expected, but received " + connection.getResponseCode());
            }
            this.resolvedURL.setURL(connection.getURL());
            this.status = 0;
        }
        return this.in;
    }

    public int read() throws IOException {
        int ret = this.getInputStream().read();
        if (ret != -1) {
            ++this.currentPos;
        }
        return ret;
    }

    public void seek(long pos) throws IOException {
        if (pos != this.currentPos) {
            this.startPos = pos;
            this.currentPos = pos;
            this.status = 1;
        }
    }

    public long getPos() throws IOException {
        return this.currentPos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    static class URLOpener {
        protected URL url;

        public URLOpener(URL u) {
            this.url = u;
        }

        public void setURL(URL u) {
            this.url = u;
        }

        public URL getURL() {
            return this.url;
        }

        public HttpURLConnection openConnection() throws IOException {
            return (HttpURLConnection)this.url.openConnection();
        }
    }
}

