/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.TokenStorage;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class DelegationTokenServlet
extends DfsServlet {
    private static final Log LOG = LogFactory.getLog(DelegationTokenServlet.class);
    public static final String PATH_SPEC = "/getDelegationToken";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(final HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserGroupInformation ugi;
        try {
            ugi = this.getUGI(req, new Configuration());
        }
        catch (IOException ioe) {
            LOG.info((Object)("Request for token received with no authentication from " + req.getRemoteAddr()), (Throwable)ioe);
            resp.sendError(403, "Unable to identify or authenticate user");
            return;
        }
        LOG.info((Object)("Sending token: {" + ugi.getUserName() + "," + req.getRemoteAddr() + "}"));
        ServletContext context = this.getServletContext();
        final NameNode nn = (NameNode)context.getAttribute("name.node");
        DataOutputStream dos = null;
        try {
            final DataOutputStream dosFinal = dos = new DataOutputStream((OutputStream)resp.getOutputStream());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Token<DelegationTokenIdentifier> token = nn.getDelegationToken(new Text(req.getUserPrincipal().getName()));
                    String s = nn.rpcAddress.getAddress().getHostAddress() + ":" + nn.rpcAddress.getPort();
                    token.setService(new Text(s));
                    TokenStorage ts = new TokenStorage();
                    ts.addToken(new Text(ugi.getShortUserName()), token);
                    ts.write((DataOutput)dosFinal);
                    dosFinal.close();
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.info((Object)"Exception while sending token. Re-throwing. ", (Throwable)e);
            resp.sendError(500);
        }
        finally {
            if (dos != null) {
                dos.close();
            }
        }
    }
}

