package okuyama.imdst.util.io;

import java.io.*;
import java.net.*;
import java.util.*;

import okuyama.imdst.util.*;

/**
 * IOのRead系のラッパー.<br>
 *
 * @author T.Okuyama
 * @license GPL(Lv3)
 */
public class CustomReader {

    private InputStream is = null;

    private BufferedInputStream bis = null;

    private ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
    private byte[] b = new byte[1];


    public CustomReader(InputStream is) {

        this.is = is;
        this.bis = new BufferedInputStream(this.is);
    }


    public String readLine() throws Exception {
        this.b[0] = (byte)0;

        int i = 0;
        while (bis.read(this.b, 0, 1) != -1) {

            if (this.b[0] != 13 && this.b[0] != 10) {
                this.bos.write(this.b, 0, 1);
            } else if (this.b[0] == 10) {
                break;
            }
        }

        String ret = this.bos.toString();
        this.bos.reset();
        return ret;
    }


    public boolean ready() throws Exception {
        if(this.bis.available() > 0) return true;
        return false;
    }


    public int read(byte[] buf) throws Exception {

        for (int i= 0; i < buf.length; i++) {
            bis.read(buf, i, 1);
        }

        return buf.length;

    }


    public void mark(int point) throws Exception {
        this.bis.mark(point);
    }


    public int read() throws Exception {
        return this.bis.read();
    }


    public void reset() throws Exception {
        this.bis.reset();
    }


    public void close() {

        try {
            if (this.bis != null) {
                this.bis.close();
                this.bis = null;
            }

            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
        } catch (Exception e) {
            // 無視
        }
    }
}

