/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.crypto.Mac;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class BlockAccessKey
implements Writable {
    private long keyID;
    private Text key;
    private long expiryDate;
    private transient Mac mac;

    public BlockAccessKey() {
        this(0L, new Text(), 0L);
    }

    public BlockAccessKey(long keyID, Text key, long expiryDate) {
        this.keyID = keyID;
        this.key = key;
        this.expiryDate = expiryDate;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public Text getKey() {
        return this.key;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public Mac getMac() {
        return this.mac;
    }

    public void setMac(Mac mac) {
        this.mac = mac;
    }

    static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockAccessKey) {
            BlockAccessKey that = (BlockAccessKey)obj;
            return this.keyID == that.keyID && BlockAccessKey.isEqual(this.key, that.key) && this.expiryDate == that.expiryDate;
        }
        return false;
    }

    public int hashCode() {
        return this.key == null ? 0 : this.key.hashCode();
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVLong((DataOutput)out, (long)this.keyID);
        this.key.write(out);
        WritableUtils.writeVLong((DataOutput)out, (long)this.expiryDate);
    }

    public void readFields(DataInput in) throws IOException {
        this.keyID = WritableUtils.readVLong((DataInput)in);
        this.key.readFields(in);
        this.expiryDate = WritableUtils.readVLong((DataInput)in);
    }
}

