/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.security.BlockAccessKey;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
public class ExportedAccessKeys
implements Writable {
    public static final ExportedAccessKeys DUMMY_KEYS = new ExportedAccessKeys();
    private boolean isAccessTokenEnabled;
    private long keyUpdateInterval;
    private long tokenLifetime;
    private BlockAccessKey currentKey;
    private BlockAccessKey[] allKeys;

    public ExportedAccessKeys() {
        this(false, 0L, 0L, new BlockAccessKey(), new BlockAccessKey[0]);
    }

    ExportedAccessKeys(boolean isAccessTokenEnabled, long keyUpdateInterval, long tokenLifetime, BlockAccessKey currentKey, BlockAccessKey[] allKeys) {
        this.isAccessTokenEnabled = isAccessTokenEnabled;
        this.keyUpdateInterval = keyUpdateInterval;
        this.tokenLifetime = tokenLifetime;
        this.currentKey = currentKey;
        this.allKeys = allKeys;
    }

    public boolean isAccessTokenEnabled() {
        return this.isAccessTokenEnabled;
    }

    public long getKeyUpdateInterval() {
        return this.keyUpdateInterval;
    }

    public long getTokenLifetime() {
        return this.tokenLifetime;
    }

    public BlockAccessKey getCurrentKey() {
        return this.currentKey;
    }

    public BlockAccessKey[] getAllKeys() {
        return this.allKeys;
    }

    static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExportedAccessKeys) {
            ExportedAccessKeys that = (ExportedAccessKeys)obj;
            return this.isAccessTokenEnabled == that.isAccessTokenEnabled && this.keyUpdateInterval == that.keyUpdateInterval && this.tokenLifetime == that.tokenLifetime && ExportedAccessKeys.isEqual(this.currentKey, that.currentKey) && Arrays.equals(this.allKeys, that.allKeys);
        }
        return false;
    }

    public int hashCode() {
        return this.currentKey == null ? 0 : this.currentKey.hashCode();
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isAccessTokenEnabled);
        out.writeLong(this.keyUpdateInterval);
        out.writeLong(this.tokenLifetime);
        this.currentKey.write(out);
        out.writeInt(this.allKeys.length);
        for (int i = 0; i < this.allKeys.length; ++i) {
            this.allKeys[i].write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.isAccessTokenEnabled = in.readBoolean();
        this.keyUpdateInterval = in.readLong();
        this.tokenLifetime = in.readLong();
        this.currentKey.readFields(in);
        this.allKeys = new BlockAccessKey[in.readInt()];
        for (int i = 0; i < this.allKeys.length; ++i) {
            this.allKeys[i] = new BlockAccessKey();
            this.allKeys[i].readFields(in);
        }
    }

    static {
        WritableFactories.setFactory(ExportedAccessKeys.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new ExportedAccessKeys();
            }
        });
    }
}

