/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public class StorageInfo
implements Writable {
    public int layoutVersion;
    public int namespaceID;
    public long cTime;

    public StorageInfo() {
        this(0, 0, 0L);
    }

    public StorageInfo(int layoutV, int nsID, long cT) {
        this.layoutVersion = layoutV;
        this.namespaceID = nsID;
        this.cTime = cT;
    }

    public StorageInfo(StorageInfo from) {
        this.setStorageInfo(from);
    }

    public int getLayoutVersion() {
        return this.layoutVersion;
    }

    public int getNamespaceID() {
        return this.namespaceID;
    }

    public long getCTime() {
        return this.cTime;
    }

    public void setStorageInfo(StorageInfo from) {
        this.layoutVersion = from.layoutVersion;
        this.namespaceID = from.namespaceID;
        this.cTime = from.cTime;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.getLayoutVersion());
        out.writeInt(this.getNamespaceID());
        out.writeLong(this.getCTime());
    }

    public void readFields(DataInput in) throws IOException {
        this.layoutVersion = in.readInt();
        this.namespaceID = in.readInt();
        this.cTime = in.readLong();
    }
}

