/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.security.AccessTokenHandler;
import org.apache.hadoop.hdfs.security.BlockAccessToken;
import org.apache.hadoop.hdfs.security.ExportedAccessKeys;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.BlockSender;
import org.apache.hadoop.hdfs.server.datanode.DataBlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.UpgradeManagerDatanode;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.FileChecksumServlets;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.StreamFile;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class DataNode
extends Configured
implements InterDatanodeProtocol,
ClientDatanodeProtocol,
FSConstants,
Runnable {
    public static final Log LOG = LogFactory.getLog(DataNode.class);
    public static final String DN_CLIENTTRACE_FORMAT = "src: %s, dest: %s, bytes: %s, op: %s, cliID: %s, offset: %s, srvID: %s, blockid: %s, duration: %s";
    static final Log ClientTraceLog;
    public DatanodeProtocol namenode = null;
    public FSDatasetInterface data = null;
    public DatanodeRegistration dnRegistration = null;
    volatile boolean shouldRun = true;
    private LinkedList<Block> receivedBlockList = new LinkedList();
    private LinkedList<String> delHints = new LinkedList();
    public static final String EMPTY_DEL_HINT = "";
    AtomicInteger xmitsInProgress = new AtomicInteger();
    Daemon dataXceiverServer = null;
    ThreadGroup threadGroup = null;
    long blockReportInterval;
    long lastBlockReport = 0L;
    boolean resetBlockReportTime = true;
    long initialBlockReportDelay = 0L;
    long lastHeartbeat = 0L;
    long heartBeatInterval;
    private DataStorage storage = null;
    private HttpServer infoServer = null;
    DataNodeMetrics myMetrics;
    private InetSocketAddress nameNodeAddr;
    private InetSocketAddress selfAddr;
    private static DataNode datanodeObject;
    private Thread dataNodeThread = null;
    String machineName;
    private static String dnThreadName;
    int socketTimeout;
    int socketWriteTimeout = 0;
    boolean transferToAllowed = true;
    int writePacketSize = 0;
    boolean isAccessTokenEnabled;
    AccessTokenHandler accessTokenHandler;
    boolean isAccessTokenInitialized = false;
    public DataBlockScanner blockScanner = null;
    public Daemon blockScannerThread = null;
    private List<ServicePlugin> plugins;
    private static final Random R;
    public Server ipcServer;
    UpgradeManagerDatanode upgradeManager = new UpgradeManagerDatanode(this);
    public static final int PKT_HEADER_LEN = 21;

    @Deprecated
    public static InetSocketAddress createSocketAddr(String target) throws IOException {
        return NetUtils.createSocketAddr((String)target);
    }

    static long now() {
        return System.currentTimeMillis();
    }

    DataNode(Configuration conf, AbstractList<File> dataDirs) throws IOException {
        this(conf, dataDirs, (DatanodeProtocol)RPC.waitForProxy(DatanodeProtocol.class, (long)24L, (InetSocketAddress)NameNode.getAddress(conf), (Configuration)conf));
    }

    DataNode(Configuration conf, AbstractList<File> dataDirs, DatanodeProtocol namenode) throws IOException {
        super(conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        DFSUtil.login(conf, "dfs.datanode.keytab.file", "dfs.datanode.user.name.key");
        DataNode.setDataNode(this);
        try {
            this.startDataNode(conf, dataDirs, namenode);
        }
        catch (IOException ie) {
            this.shutdown();
            throw ie;
        }
    }

    void startDataNode(Configuration conf, AbstractList<File> dataDirs, DatanodeProtocol namenode) throws IOException {
        if (conf.get("dfs.datanode.hostname") != null) {
            this.machineName = conf.get("dfs.datanode.hostname");
        }
        if (this.machineName == null) {
            this.machineName = DNS.getDefaultHost((String)conf.get("dfs.datanode.dns.interface", "default"), (String)conf.get("dfs.datanode.dns.nameserver", "default"));
        }
        this.nameNodeAddr = NameNode.getAddress(conf);
        this.socketTimeout = conf.getInt("dfs.client.socket-timeout", 60000);
        this.socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        this.transferToAllowed = conf.getBoolean("dfs.datanode.transferTo.allowed", true);
        this.writePacketSize = conf.getInt("dfs.client-write-packet-size", 65536);
        InetSocketAddress socAddr = NetUtils.createSocketAddr((String)conf.get("dfs.datanode.address", "0.0.0.0:50010"));
        int tmpPort = socAddr.getPort();
        this.storage = new DataStorage();
        this.dnRegistration = new DatanodeRegistration(this.machineName + ":" + tmpPort);
        this.namenode = namenode;
        NamespaceInfo nsInfo = this.handshake();
        HdfsConstants.StartupOption startOpt = DataNode.getStartupOption(conf);
        assert (startOpt != null) : "Startup option must be set.";
        boolean simulatedFSDataset = conf.getBoolean("dfs.datanode.simulateddatastorage", false);
        if (simulatedFSDataset) {
            DataNode.setNewStorageID(this.dnRegistration);
            this.dnRegistration.storageInfo.layoutVersion = -24;
            this.dnRegistration.storageInfo.namespaceID = nsInfo.namespaceID;
            conf.set("dfs.datanode.StorageId", this.dnRegistration.getStorageID());
            try {
                this.data = (FSDatasetInterface)ReflectionUtils.newInstance(Class.forName("org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset"), (Configuration)conf);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
        } else {
            this.storage.recoverTransitionRead(nsInfo, dataDirs, startOpt);
            this.dnRegistration.setStorageInfo(this.storage);
            this.data = new FSDataset(this.storage, conf);
        }
        ServerSocket ss = this.socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
        Server.bind((ServerSocket)ss, (InetSocketAddress)socAddr, (int)0);
        ss.setReceiveBufferSize(131072);
        tmpPort = ss.getLocalPort();
        this.selfAddr = new InetSocketAddress(ss.getInetAddress().getHostAddress(), tmpPort);
        this.dnRegistration.setName(this.machineName + ":" + tmpPort);
        LOG.info((Object)("Opened info server at " + tmpPort));
        this.threadGroup = new ThreadGroup("dataXceiverServer");
        this.dataXceiverServer = new Daemon(this.threadGroup, (Runnable)new DataXceiverServer(ss, conf, this));
        this.threadGroup.setDaemon(true);
        this.blockReportInterval = conf.getLong("dfs.blockreport.intervalMsec", 3600000L);
        this.initialBlockReportDelay = conf.getLong("dfs.blockreport.initialDelay", 0L) * 1000L;
        if (this.initialBlockReportDelay >= this.blockReportInterval) {
            this.initialBlockReportDelay = 0L;
            LOG.info((Object)"dfs.blockreport.initialDelay is greater than dfs.blockreport.intervalMsec. Setting initial delay to 0 msec:");
        }
        this.heartBeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        String reason = null;
        if (conf.getInt("dfs.datanode.scan.period.hours", 0) < 0) {
            reason = "verification is turned off by configuration";
        } else if (!(this.data instanceof FSDataset)) {
            reason = "verifcation is supported only with FSDataset";
        }
        if (reason == null) {
            this.blockScanner = new DataBlockScanner(this, (FSDataset)this.data, conf);
        } else {
            LOG.info((Object)("Periodic Block Verification is disabled because " + reason + "."));
        }
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr((String)conf.get("dfs.datanode.http.address", "0.0.0.0:50075"));
        String infoHost = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.infoServer = new HttpServer("datanode", infoHost, tmpInfoPort, tmpInfoPort == 0, conf);
        if (conf.getBoolean("dfs.https.enable", false)) {
            boolean needClientAuth = conf.getBoolean("dfs.client.https.need-auth", false);
            InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr((String)conf.get("dfs.datanode.https.address", infoHost + ":" + 0));
            HdfsConfiguration sslConf = new HdfsConfiguration(false);
            sslConf.addResource(conf.get("dfs.https.server.keystore.resource", "ssl-server.xml"));
            this.infoServer.addSslListener(secInfoSocAddr, (Configuration)sslConf, needClientAuth);
        }
        this.infoServer.addInternalServlet(null, "/streamFile/*", StreamFile.class);
        this.infoServer.addInternalServlet(null, "/getFileChecksum/*", FileChecksumServlets.GetServlet.class);
        this.infoServer.setAttribute("datanode.blockScanner", (Object)this.blockScanner);
        this.infoServer.setAttribute("datanode.conf", (Object)conf);
        this.infoServer.addServlet(null, "/blockScannerReport", DataBlockScanner.Servlet.class);
        this.infoServer.start();
        this.dnRegistration.setInfoPort(this.infoServer.getPort());
        this.myMetrics = new DataNodeMetrics(conf, this.dnRegistration.getName());
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            ServiceAuthorizationManager.refresh((Configuration)conf, (PolicyProvider)new HDFSPolicyProvider());
        }
        InetSocketAddress ipcAddr = NetUtils.createSocketAddr((String)conf.get("dfs.datanode.ipc.address"));
        this.ipcServer = RPC.getServer(DataNode.class, (Object)this, (String)ipcAddr.getHostName(), (int)ipcAddr.getPort(), (int)conf.getInt("dfs.datanode.handler.count", 3), (boolean)false, (Configuration)conf);
        this.ipcServer.start();
        this.dnRegistration.setIpcPort(this.ipcServer.getListenerAddress().getPort());
        LOG.info((Object)("dnRegistration = " + this.dnRegistration));
        this.plugins = conf.getInstances("dfs.datanode.plugins", ServicePlugin.class);
        for (ServicePlugin p : this.plugins) {
            try {
                p.start((Object)this);
                LOG.info((Object)("Started plug-in " + p));
            }
            catch (Throwable t) {
                LOG.warn((Object)("ServicePlugin " + p + " could not be started"), t);
            }
        }
    }

    protected Socket newSocket() throws IOException {
        return this.socketWriteTimeout > 0 ? SocketChannel.open().socket() : new Socket();
    }

    private NamespaceInfo handshake() throws IOException {
        NamespaceInfo nsInfo = new NamespaceInfo();
        while (this.shouldRun) {
            try {
                nsInfo = this.namenode.versionRequest();
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        String errorMsg = null;
        if (!nsInfo.getBuildVersion().equals(Storage.getBuildVersion())) {
            errorMsg = "Incompatible build versions: namenode BV = " + nsInfo.getBuildVersion() + "; datanode BV = " + Storage.getBuildVersion();
            LOG.fatal((Object)errorMsg);
            try {
                this.namenode.errorReport(this.dnRegistration, 0, errorMsg);
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
            }
            throw new IOException(errorMsg);
        }
        assert (-24 == nsInfo.getLayoutVersion()) : "Data-node and name-node layout versions must be the same.Expected: -24 actual " + nsInfo.getLayoutVersion();
        return nsInfo;
    }

    private static void setDataNode(DataNode node) {
        datanodeObject = node;
    }

    public static DataNode getDataNode() {
        return datanodeObject;
    }

    public static InterDatanodeProtocol createInterDataNodeProtocolProxy(DatanodeID datanodeid, Configuration conf) throws IOException {
        InetSocketAddress addr = NetUtils.createSocketAddr((String)(datanodeid.getHost() + ":" + datanodeid.getIpcPort()));
        if (InterDatanodeProtocol.LOG.isDebugEnabled()) {
            InterDatanodeProtocol.LOG.info((Object)("InterDatanodeProtocol addr=" + addr));
        }
        return (InterDatanodeProtocol)RPC.getProxy(InterDatanodeProtocol.class, (long)5L, (InetSocketAddress)addr, (Configuration)conf);
    }

    public InetSocketAddress getNameNodeAddr() {
        return this.nameNodeAddr;
    }

    public InetSocketAddress getSelfAddr() {
        return this.selfAddr;
    }

    DataNodeMetrics getMetrics() {
        return this.myMetrics;
    }

    public DatanodeRegistration getDatanodeRegistration() {
        return this.dnRegistration;
    }

    public String getNamenode() {
        return "<namenode>";
    }

    public static void setNewStorageID(DatanodeRegistration dnReg) {
        String ip = "unknownIP";
        try {
            ip = DNS.getDefaultIP((String)"default");
        }
        catch (UnknownHostException ignored) {
            LOG.warn((Object)"Could not find ip address of \"default\" inteface.");
        }
        int rand = 0;
        try {
            rand = SecureRandom.getInstance("SHA1PRNG").nextInt(Integer.MAX_VALUE);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn((Object)"Could not use SecureRandom");
            rand = R.nextInt(Integer.MAX_VALUE);
        }
        dnReg.storageID = "DS-" + rand + "-" + ip + "-" + dnReg.getPort() + "-" + System.currentTimeMillis();
    }

    private void register() throws IOException {
        if (this.dnRegistration.getStorageID().equals(EMPTY_DEL_HINT)) {
            DataNode.setNewStorageID(this.dnRegistration);
        }
        while (this.shouldRun) {
            try {
                this.dnRegistration.name = this.machineName + ":" + this.dnRegistration.getPort();
                this.dnRegistration = this.namenode.registerDatanode(this.dnRegistration);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        assert (EMPTY_DEL_HINT.equals(this.storage.getStorageID()) && !EMPTY_DEL_HINT.equals(this.dnRegistration.getStorageID()) || this.storage.getStorageID().equals(this.dnRegistration.getStorageID())) : "New storageID can be assigned only if data-node is not formatted";
        if (this.storage.getStorageID().equals(EMPTY_DEL_HINT)) {
            this.storage.setStorageID(this.dnRegistration.getStorageID());
            this.storage.writeAll();
            LOG.info((Object)("New storage id " + this.dnRegistration.getStorageID() + " is assigned to data-node " + this.dnRegistration.getName()));
        }
        if (!this.storage.getStorageID().equals(this.dnRegistration.getStorageID())) {
            throw new IOException("Inconsistent storage IDs. Name-node returned " + this.dnRegistration.getStorageID() + ". Expecting " + this.storage.getStorageID());
        }
        if (!this.isAccessTokenInitialized) {
            ExportedAccessKeys keys = this.dnRegistration.exportedKeys;
            this.isAccessTokenEnabled = keys.isAccessTokenEnabled();
            if (this.isAccessTokenEnabled) {
                long accessKeyUpdateInterval = keys.getKeyUpdateInterval();
                long accessTokenLifetime = keys.getTokenLifetime();
                LOG.info((Object)("Access token params received from NN: keyUpdateInterval=" + accessKeyUpdateInterval / 60000L + " min(s), tokenLifetime=" + accessTokenLifetime / 60000L + " min(s)"));
                this.accessTokenHandler = new AccessTokenHandler(false, accessKeyUpdateInterval, accessTokenLifetime);
            }
            this.isAccessTokenInitialized = true;
        }
        if (this.isAccessTokenEnabled) {
            this.accessTokenHandler.setKeys(this.dnRegistration.exportedKeys);
            this.dnRegistration.exportedKeys = ExportedAccessKeys.DUMMY_KEYS;
        }
        this.scheduleBlockReport(this.initialBlockReportDelay);
    }

    public void shutdown() {
        if (this.plugins != null) {
            for (ServicePlugin p : this.plugins) {
                try {
                    p.stop();
                    LOG.info((Object)("Stopped plug-in " + p));
                }
                catch (Throwable t) {
                    LOG.warn((Object)("ServicePlugin " + p + " could not be stopped"), t);
                }
            }
        }
        if (this.infoServer != null) {
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception shutting down DataNode", (Throwable)e);
            }
        }
        if (this.ipcServer != null) {
            this.ipcServer.stop();
        }
        this.shouldRun = false;
        if (this.dataXceiverServer != null) {
            ((DataXceiverServer)this.dataXceiverServer.getRunnable()).kill();
            this.dataXceiverServer.interrupt();
            if (this.threadGroup != null) {
                int sleepMs = 2;
                while (true) {
                    this.threadGroup.interrupt();
                    LOG.info((Object)("Waiting for threadgroup to exit, active threads is " + this.threadGroup.activeCount()));
                    if (this.threadGroup.activeCount() == 0) break;
                    try {
                        Thread.sleep(sleepMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((sleepMs = sleepMs * 3 / 2) <= 1000) continue;
                    sleepMs = 1000;
                }
            }
            try {
                this.dataXceiverServer.join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        RPC.stopProxy((Object)this.namenode);
        if (this.upgradeManager != null) {
            this.upgradeManager.shutdownUpgrade();
        }
        if (this.blockScannerThread != null) {
            this.blockScannerThread.interrupt();
            try {
                this.blockScannerThread.join(3600000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (this.storage != null) {
            try {
                this.storage.unlockAll();
            }
            catch (IOException ie) {
                LOG.warn((Object)("Exception when unlocking storage: " + ie), (Throwable)ie);
            }
        }
        if (this.dataNodeThread != null) {
            this.dataNodeThread.interrupt();
            try {
                this.dataNodeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.data != null) {
            this.data.shutdown();
        }
        if (this.myMetrics != null) {
            this.myMetrics.shutdown();
        }
    }

    protected void checkDiskError(Exception e) throws IOException {
        LOG.warn((Object)"checkDiskError: exception: ", (Throwable)e);
        if (e.getMessage() != null && e.getMessage().startsWith("No space left on device")) {
            throw new DiskChecker.DiskOutOfSpaceException("No space left on device");
        }
        this.checkDiskError();
    }

    protected void checkDiskError() {
        try {
            this.data.checkDataDir();
        }
        catch (DiskChecker.DiskErrorException de) {
            this.handleDiskError(de.getMessage());
        }
    }

    private void handleDiskError(String errMsgr) {
        boolean hasEnoughResource = this.data.hasEnoughResource();
        LOG.warn((Object)("DataNode.handleDiskError: Keep Running: " + hasEnoughResource));
        int dp_error = 1;
        if (!hasEnoughResource) {
            dp_error = 3;
        }
        try {
            this.namenode.errorReport(this.dnRegistration, dp_error, errMsgr);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (hasEnoughResource) {
            this.scheduleBlockReport(0L);
            return;
        }
        LOG.warn((Object)("DataNode is shutting down.\n" + errMsgr));
        this.shouldRun = false;
    }

    int getXceiverCount() {
        return this.threadGroup == null ? 0 : this.threadGroup.activeCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerService() throws Exception {
        LOG.info((Object)("using BLOCKREPORT_INTERVAL of " + this.blockReportInterval + "msec" + " Initial delay: " + this.initialBlockReportDelay + "msec"));
        while (this.shouldRun) {
            try {
                long startTime = DataNode.now();
                if (startTime - this.lastHeartbeat > this.heartBeatInterval) {
                    this.lastHeartbeat = startTime;
                    DatanodeCommand[] cmds = this.namenode.sendHeartbeat(this.dnRegistration, this.data.getCapacity(), this.data.getDfsUsed(), this.data.getRemaining(), this.xmitsInProgress.get(), this.getXceiverCount());
                    this.myMetrics.heartbeats.inc(DataNode.now() - startTime);
                    if (!this.processCommand(cmds)) continue;
                }
                this.reportReceivedBlocks();
                DatanodeCommand cmd = this.blockReport();
                this.processCommand(cmd);
                if (this.blockScanner != null && this.blockScannerThread == null && this.upgradeManager.isUpgradeCompleted()) {
                    LOG.info((Object)"Starting Periodic block scanner.");
                    this.blockScannerThread = new Daemon((Runnable)this.blockScanner);
                    this.blockScannerThread.start();
                }
                long waitTime = this.heartBeatInterval - (System.currentTimeMillis() - this.lastHeartbeat);
                LinkedList<Block> linkedList = this.receivedBlockList;
                synchronized (linkedList) {
                    if (waitTime > 0L && this.receivedBlockList.size() == 0) {
                        try {
                            this.receivedBlockList.wait(waitTime);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (UnregisteredNodeException.class.getName().equals(reClass) || DisallowedDatanodeException.class.getName().equals(reClass) || IncorrectVersionException.class.getName().equals(reClass)) {
                    LOG.warn((Object)("DataNode is shutting down: " + StringUtils.stringifyException((Throwable)re)));
                    this.shutdown();
                    return;
                }
                LOG.warn((Object)StringUtils.stringifyException((Throwable)re));
            }
            catch (IOException e) {
                LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    private boolean processCommand(DatanodeCommand[] cmds) {
        if (cmds != null) {
            for (DatanodeCommand cmd : cmds) {
                try {
                    if (!this.processCommand(cmd)) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Error processing datanode Command", (Throwable)ioe);
                }
            }
        }
        return true;
    }

    private boolean processCommand(DatanodeCommand cmd) throws IOException {
        if (cmd == null) {
            return true;
        }
        BlockCommand bcmd = cmd instanceof BlockCommand ? (BlockCommand)cmd : null;
        switch (cmd.getAction()) {
            case 1: {
                this.transferBlocks(bcmd.getBlocks(), bcmd.getTargets());
                this.myMetrics.blocksReplicated.inc(bcmd.getBlocks().length);
                break;
            }
            case 2: {
                Block[] toDelete = bcmd.getBlocks();
                try {
                    if (this.blockScanner != null) {
                        this.blockScanner.deleteBlocks(toDelete);
                    }
                    this.data.invalidate(toDelete);
                }
                catch (IOException e) {
                    this.checkDiskError();
                    throw e;
                }
                this.myMetrics.blocksRemoved.inc(toDelete.length);
                break;
            }
            case 3: {
                this.shutdown();
                return false;
            }
            case 4: {
                LOG.info((Object)"DatanodeCommand action: DNA_REGISTER");
                if (!this.shouldRun) break;
                this.register();
                break;
            }
            case 5: {
                this.storage.finalizeUpgrade();
                break;
            }
            case 101: {
                this.processDistributedUpgradeCommand((UpgradeCommand)cmd);
                break;
            }
            case 6: {
                this.recoverBlocks(((BlockRecoveryCommand)cmd).getRecoveringBlocks());
                break;
            }
            case 7: {
                LOG.info((Object)"DatanodeCommand action: DNA_ACCESSKEYUPDATE");
                if (!this.isAccessTokenEnabled) break;
                this.accessTokenHandler.setKeys(((KeyUpdateCommand)cmd).getExportedKeys());
                break;
            }
            default: {
                LOG.warn((Object)("Unknown DatanodeCommand action: " + cmd.getAction()));
            }
        }
        return true;
    }

    private void processDistributedUpgradeCommand(UpgradeCommand comm) throws IOException {
        assert (this.upgradeManager != null) : "DataNode.upgradeManager is null.";
        this.upgradeManager.processUpgradeCommand(comm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportReceivedBlocks() throws IOException {
        LinkedList<String> linkedList;
        Block[] blockArray = null;
        String[] delHintArray = null;
        LinkedList<Block> linkedList2 = this.receivedBlockList;
        synchronized (linkedList2) {
            linkedList = this.delHints;
            synchronized (linkedList) {
                int numBlocks = this.receivedBlockList.size();
                if (numBlocks > 0) {
                    if (numBlocks != this.delHints.size()) {
                        LOG.warn((Object)"Panic: receiveBlockList and delHints are not of the same length");
                    }
                    blockArray = this.receivedBlockList.toArray(new Block[numBlocks]);
                    delHintArray = this.delHints.toArray(new String[numBlocks]);
                }
            }
        }
        if (blockArray != null) {
            if (delHintArray == null || delHintArray.length != blockArray.length) {
                LOG.warn((Object)"Panic: block array & delHintArray are not the same");
            }
            this.namenode.blockReceived(this.dnRegistration, blockArray, delHintArray);
            linkedList2 = this.receivedBlockList;
            synchronized (linkedList2) {
                linkedList = this.delHints;
                synchronized (linkedList) {
                    for (int i = 0; i < blockArray.length; ++i) {
                        this.receivedBlockList.remove(blockArray[i]);
                        this.delHints.remove(delHintArray[i]);
                    }
                }
            }
        }
    }

    private DatanodeCommand blockReport() throws IOException {
        DatanodeCommand cmd = null;
        long startTime = DataNode.now();
        if (startTime - this.lastBlockReport > this.blockReportInterval) {
            long brStartTime = DataNode.now();
            BlockListAsLongs bReport = this.data.getBlockReport();
            cmd = this.namenode.blockReport(this.dnRegistration, bReport.getBlockListAsLongs());
            long brTime = DataNode.now() - brStartTime;
            this.myMetrics.blockReports.inc(brTime);
            LOG.info((Object)("BlockReport of " + bReport.getNumberOfBlocks() + " blocks got processed in " + brTime + " msecs"));
            if (this.resetBlockReportTime) {
                this.lastBlockReport = startTime - (long)R.nextInt((int)this.blockReportInterval);
                this.resetBlockReportTime = false;
            } else {
                this.lastBlockReport += (DataNode.now() - this.lastBlockReport) / this.blockReportInterval * this.blockReportInterval;
            }
        }
        return cmd;
    }

    private void startDistributedUpgradeIfNeeded() throws IOException {
        UpgradeManagerDatanode um = DataNode.getDataNode().upgradeManager;
        assert (um != null) : "DataNode.upgradeManager is null.";
        if (!um.getUpgradeState()) {
            return;
        }
        um.setUpgradeState(false, um.getUpgradeVersion());
        um.startUpgrade();
    }

    private void transferBlock(Block block, DatanodeInfo[] xferTargets) throws IOException {
        if (!this.data.isValidBlock(block)) {
            String errStr = "Can't send invalid block " + block;
            LOG.info((Object)errStr);
            this.namenode.errorReport(this.dnRegistration, 2, errStr);
            return;
        }
        long onDiskLength = this.data.getLength(block);
        if (block.getNumBytes() > onDiskLength) {
            this.namenode.reportBadBlocks(new LocatedBlock[]{new LocatedBlock(block, new DatanodeInfo[]{new DatanodeInfo(this.dnRegistration)})});
            LOG.info((Object)("Can't replicate block " + block + " because on-disk length " + onDiskLength + " is shorter than NameNode recorded length " + block.getNumBytes()));
            return;
        }
        int numTargets = xferTargets.length;
        if (numTargets > 0) {
            if (LOG.isInfoEnabled()) {
                StringBuilder xfersBuilder = new StringBuilder();
                for (int i = 0; i < numTargets; ++i) {
                    xfersBuilder.append(xferTargets[i].getName());
                    xfersBuilder.append(" ");
                }
                LOG.info((Object)(this.dnRegistration + " Starting thread to transfer block " + block + " to " + xfersBuilder));
            }
            new Daemon((Runnable)new DataTransfer(xferTargets, block, this)).start();
        }
    }

    private void transferBlocks(Block[] blocks, DatanodeInfo[][] xferTargets) {
        for (int i = 0; i < blocks.length; ++i) {
            try {
                this.transferBlock(blocks[i], xferTargets[i]);
                continue;
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failed to transfer block " + blocks[i]), (Throwable)ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyNamenodeReceivedBlock(Block block, String delHint) {
        if (block == null || delHint == null) {
            throw new IllegalArgumentException(block == null ? "Block is null" : "delHint is null");
        }
        LinkedList<Block> linkedList = this.receivedBlockList;
        synchronized (linkedList) {
            LinkedList<String> linkedList2 = this.delHints;
            synchronized (linkedList2) {
                this.receivedBlockList.add(block);
                this.delHints.add(delHint);
                this.receivedBlockList.notifyAll();
            }
        }
    }

    void closeBlock(Block block, String delHint) {
        this.myMetrics.blocksWritten.inc();
        this.notifyNamenodeReceivedBlock(block, delHint);
        if (this.blockScanner != null) {
            this.blockScanner.addBlock(block);
        }
    }

    @Override
    public void run() {
        LOG.info((Object)(this.dnRegistration + "In DataNode.run, data = " + this.data));
        this.dataXceiverServer.start();
        while (this.shouldRun) {
            try {
                this.startDistributedUpgradeIfNeeded();
                this.offerService();
            }
            catch (Exception ex) {
                LOG.error((Object)("Exception: " + StringUtils.stringifyException((Throwable)ex)));
                if (!this.shouldRun) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        LOG.info((Object)(this.dnRegistration + ":Finishing DataNode in: " + this.data));
        this.shutdown();
    }

    public static void runDatanodeDaemon(DataNode dn) throws IOException {
        if (dn != null) {
            dn.register();
            dn.dataNodeThread = new Thread((Runnable)dn, dnThreadName);
            dn.dataNodeThread.setDaemon(true);
            dn.dataNodeThread.start();
        }
    }

    static boolean isDatanodeUp(DataNode dn) {
        return dn.dataNodeThread != null && dn.dataNodeThread.isAlive();
    }

    public static DataNode instantiateDataNode(String[] args, Configuration conf) throws IOException {
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        if (args != null) {
            GenericOptionsParser hParser = new GenericOptionsParser(conf, args);
            args = hParser.getRemainingArgs();
        }
        if (!DataNode.parseArguments(args, conf)) {
            DataNode.printUsage();
            return null;
        }
        if (conf.get("dfs.network.script") != null) {
            LOG.error((Object)"This configuration for rack identification is not supported anymore. RackID resolution is handled by the NameNode.");
            System.exit(-1);
        }
        Collection<URI> dataDirs = DataNode.getStorageDirs(conf);
        dnThreadName = "DataNode: [" + StringUtils.uriToString((URI[])dataDirs.toArray(new URI[0])) + "]";
        return DataNode.makeInstance(dataDirs, conf);
    }

    static Collection<URI> getStorageDirs(Configuration conf) {
        Collection dirNames = conf.getStringCollection("dfs.datanode.data.dir");
        return Util.stringCollectionAsURIs(dirNames);
    }

    public static DataNode createDataNode(String[] args, Configuration conf) throws IOException {
        DataNode dn = DataNode.instantiateDataNode(args, conf);
        DataNode.runDatanodeDaemon(dn);
        return dn;
    }

    void join() {
        if (this.dataNodeThread != null) {
            try {
                this.dataNodeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static DataNode makeInstance(Collection<URI> dataDirs, Configuration conf) throws IOException {
        FsPermission permission;
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        ArrayList<File> dirs = DataNode.getDataDirsFromURIs(dataDirs, localFS, permission = new FsPermission(conf.get("dfs.datanode.data.dir.perm", "755")));
        if (dirs.size() > 0) {
            return new DataNode(conf, dirs);
        }
        LOG.error((Object)"All directories in dfs.datanode.data.dir are invalid.");
        return null;
    }

    static ArrayList<File> getDataDirsFromURIs(Collection<URI> dataDirs, LocalFileSystem localFS, FsPermission permission) {
        ArrayList<File> dirs = new ArrayList<File>();
        for (URI dirURI : dataDirs) {
            if (!"file".equalsIgnoreCase(dirURI.getScheme())) {
                LOG.warn((Object)("Unsupported URI schema in " + dirURI + ". Ignoring ..."));
                continue;
            }
            File data = new File(dirURI.getPath());
            try {
                DiskChecker.checkDir((LocalFileSystem)localFS, (Path)new Path(data.toURI()), (FsPermission)permission);
                dirs.add(data);
            }
            catch (IOException e) {
                LOG.warn((Object)("Invalid directory in: dfs.datanode.data.dir: " + e.getMessage()));
            }
        }
        return dirs;
    }

    public String toString() {
        return "DataNode{data=" + this.data + (this.dnRegistration != null ? ", localName='" + this.dnRegistration.getName() + "'" + ", storageID='" + this.dnRegistration.getStorageID() + "'" : EMPTY_DEL_HINT) + ", xmitsInProgress=" + this.xmitsInProgress.get() + "}";
    }

    private static void printUsage() {
        System.err.println("Usage: java DataNode");
        System.err.println("           [-rollback]");
    }

    private static boolean parseArguments(String[] args, Configuration conf) {
        int argsLen = args == null ? 0 : args.length;
        HdfsConstants.StartupOption startOpt = HdfsConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if ("-r".equalsIgnoreCase(cmd) || "--rack".equalsIgnoreCase(cmd)) {
                LOG.error((Object)"-r, --rack arguments are not supported anymore. RackID resolution is handled by the NameNode.");
                System.exit(-1);
                continue;
            }
            if ("-rollback".equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.ROLLBACK;
                continue;
            }
            if ("-regular".equalsIgnoreCase(cmd)) {
                startOpt = HdfsConstants.StartupOption.REGULAR;
                continue;
            }
            return false;
        }
        DataNode.setStartupOption(conf, startOpt);
        return true;
    }

    private static void setStartupOption(Configuration conf, HdfsConstants.StartupOption opt) {
        conf.set("dfs.datanode.startup", opt.toString());
    }

    static HdfsConstants.StartupOption getStartupOption(Configuration conf) {
        return HdfsConstants.StartupOption.valueOf(conf.get("dfs.datanode.startup", HdfsConstants.StartupOption.REGULAR.toString()));
    }

    public void scheduleBlockReport(long delay) {
        this.lastBlockReport = delay > 0L ? System.currentTimeMillis() - (this.blockReportInterval - (long)R.nextInt((int)delay)) : this.lastHeartbeat - this.blockReportInterval;
        this.resetBlockReportTime = true;
    }

    public FSDatasetInterface getFSDataset() {
        return this.data;
    }

    public static void main(String[] args) {
        try {
            StringUtils.startupShutdownMessage(DataNode.class, (String[])args, (Log)LOG);
            DataNode datanode = DataNode.createDataNode(args, null);
            if (datanode != null) {
                datanode.join();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            System.exit(-1);
        }
    }

    public Daemon recoverBlocks(final Collection<BlockRecoveryCommand.RecoveringBlock> blocks) {
        Daemon d = new Daemon(this.threadGroup, new Runnable(){

            @Override
            public void run() {
                for (BlockRecoveryCommand.RecoveringBlock b : blocks) {
                    try {
                        DataNode.logRecoverBlock("NameNode", b.getBlock(), b.getLocations());
                        DataNode.this.recoverBlock(b);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("recoverBlocks FAILED: " + b), (Throwable)e);
                    }
                }
            }
        });
        d.start();
        return d;
    }

    @Override
    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        return this.data.initReplicaRecovery(rBlock);
    }

    private static ReplicaRecoveryInfo callInitReplicaRecovery(InterDatanodeProtocol datanode, BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        try {
            return datanode.initReplicaRecovery(rBlock);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
    }

    @Override
    public Block updateReplicaUnderRecovery(Block oldBlock, long recoveryId, long newLength) throws IOException {
        ReplicaInfo r = this.data.updateReplicaUnderRecovery(oldBlock, recoveryId, newLength);
        return new Block(r);
    }

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(InterDatanodeProtocol.class.getName())) {
            return 5L;
        }
        if (protocol.equals(ClientDatanodeProtocol.class.getName())) {
            return 6L;
        }
        throw new IOException("Unknown protocol to " + this.getClass().getSimpleName() + ": " + protocol);
    }

    private void recoverBlock(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        Block block = rBlock.getBlock();
        DatanodeInfo[] targets = rBlock.getLocations();
        DatanodeID[] datanodeids = targets;
        ArrayList<BlockRecord> syncList = new ArrayList<BlockRecord>(datanodeids.length);
        int errorCount = 0;
        for (DatanodeID id : datanodeids) {
            try {
                DataNode datanode = this.dnRegistration.equals(id) ? this : DataNode.createInterDataNodeProtocolProxy(id, this.getConf());
                ReplicaRecoveryInfo info = DataNode.callInitReplicaRecovery(datanode, rBlock);
                if (info == null || info.getGenerationStamp() < block.getGenerationStamp() || info.getNumBytes() <= 0L) continue;
                syncList.add(new BlockRecord(id, datanode, info));
            }
            catch (RecoveryInProgressException ripE) {
                InterDatanodeProtocol.LOG.warn((Object)("Recovery for replica " + block + " on data-node " + id + " is already in progress. Recovery id = " + rBlock.getNewGenerationStamp() + " is aborted."), (Throwable)ripE);
                return;
            }
            catch (IOException e) {
                ++errorCount;
                InterDatanodeProtocol.LOG.warn((Object)("Failed to obtain replica info for block (=" + block + ") from datanode (=" + id + ")"), (Throwable)e);
            }
        }
        if (errorCount == datanodeids.length) {
            throw new IOException("All datanodes failed: block=" + block + ", datanodeids=" + Arrays.asList(datanodeids));
        }
        this.syncBlock(rBlock, syncList);
    }

    void syncBlock(BlockRecoveryCommand.RecoveringBlock rBlock, List<BlockRecord> syncList) throws IOException {
        Block block = rBlock.getBlock();
        long recoveryId = rBlock.getNewGenerationStamp();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("block=" + block + ", (length=" + block.getNumBytes() + "), syncList=" + syncList));
        }
        if (syncList.isEmpty()) {
            this.namenode.commitBlockSynchronization(block, recoveryId, 0L, true, true, DatanodeID.EMPTY_ARRAY);
            return;
        }
        HdfsConstants.ReplicaState bestState = HdfsConstants.ReplicaState.RWR;
        long finalizedLength = -1L;
        for (BlockRecord r : syncList) {
            assert (r.rInfo.getNumBytes() > 0L) : "zero length replica";
            HdfsConstants.ReplicaState rState = r.rInfo.getOriginalReplicaState();
            if (rState.getValue() < bestState.getValue()) {
                bestState = rState;
            }
            if (rState != HdfsConstants.ReplicaState.FINALIZED) continue;
            if (finalizedLength > 0L && finalizedLength != r.rInfo.getNumBytes()) {
                throw new IOException("Inconsistent size of finalized replicas. Replica " + r.rInfo + " expected size: " + finalizedLength);
            }
            finalizedLength = r.rInfo.getNumBytes();
        }
        ArrayList<BlockRecord> participatingList = new ArrayList<BlockRecord>();
        Block newBlock = new Block(block.getBlockId(), -1L, recoveryId);
        switch (bestState) {
            case FINALIZED: {
                assert (finalizedLength > 0L) : "finalizedLength is not positive";
                for (BlockRecord r : syncList) {
                    HdfsConstants.ReplicaState rState = r.rInfo.getOriginalReplicaState();
                    if (rState != HdfsConstants.ReplicaState.FINALIZED && (rState != HdfsConstants.ReplicaState.RBW || r.rInfo.getNumBytes() != finalizedLength)) continue;
                    participatingList.add(r);
                }
                newBlock.setNumBytes(finalizedLength);
                break;
            }
            case RBW: 
            case RWR: {
                long minLength = Long.MAX_VALUE;
                for (BlockRecord r : syncList) {
                    HdfsConstants.ReplicaState rState = r.rInfo.getOriginalReplicaState();
                    if (rState != bestState) continue;
                    minLength = Math.min(minLength, r.rInfo.getNumBytes());
                    participatingList.add(r);
                }
                newBlock.setNumBytes(minLength);
                break;
            }
            case RUR: 
            case TEMPORARY: {
                assert (false) : "bad replica state: " + (Object)((Object)bestState);
                break;
            }
        }
        ArrayList<DatanodeID> failedList = new ArrayList<DatanodeID>();
        ArrayList<DatanodeID> successList = new ArrayList<DatanodeID>();
        for (BlockRecord r : participatingList) {
            try {
                Block reply = r.datanode.updateReplicaUnderRecovery(r.rInfo, recoveryId, newBlock.getNumBytes());
                assert (reply.equals(newBlock) && reply.getNumBytes() == newBlock.getNumBytes()) : "Updated replica must be the same as the new block.";
                successList.add(r.id);
            }
            catch (IOException e) {
                InterDatanodeProtocol.LOG.warn((Object)("Failed to updateBlock (newblock=" + newBlock + ", datanode=" + r.id + ")"), (Throwable)e);
                failedList.add(r.id);
            }
        }
        if (!failedList.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (DatanodeID id : failedList) {
                b.append("\n  " + id);
            }
            throw new IOException("Cannot recover " + block + ", the following " + failedList.size() + " data-nodes failed {" + b + "\n}");
        }
        DatanodeID[] nlist = successList.toArray(new DatanodeID[successList.size()]);
        this.namenode.commitBlockSynchronization(block, newBlock.getGenerationStamp(), newBlock.getNumBytes(), true, false, nlist);
    }

    private static void logRecoverBlock(String who, Block block, DatanodeID[] targets) {
        StringBuilder msg = new StringBuilder(targets[0].getName());
        for (int i = 1; i < targets.length; ++i) {
            msg.append(", " + targets[i].getName());
        }
        LOG.info((Object)(who + " calls recoverBlock(block=" + block + ", targets=[" + msg + "])"));
    }

    @Override
    public long getReplicaVisibleLength(Block block) throws IOException {
        return this.data.getReplicaVisibleLength(block);
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        ClientTraceLog = LogFactory.getLog((String)(DataNode.class.getName() + ".clienttrace"));
        datanodeObject = null;
        R = new Random();
    }

    static class BlockRecord {
        final DatanodeID id;
        final InterDatanodeProtocol datanode;
        final ReplicaRecoveryInfo rInfo;

        BlockRecord(DatanodeID id, InterDatanodeProtocol datanode, ReplicaRecoveryInfo rInfo) {
            this.id = id;
            this.datanode = datanode;
            this.rInfo = rInfo;
        }

        public String toString() {
            return "block:" + this.rInfo + " node:" + this.id;
        }
    }

    class DataTransfer
    implements Runnable {
        DatanodeInfo[] targets;
        Block b;
        DataNode datanode;

        public DataTransfer(DatanodeInfo[] targets, Block b, DataNode datanode) throws IOException {
            this.targets = targets;
            this.b = b;
            this.datanode = datanode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                DataNode.this.xmitsInProgress.getAndIncrement();
                Socket sock = null;
                DataOutputStream out = null;
                BlockSender blockSender = null;
                try {
                    InetSocketAddress curTarget = NetUtils.createSocketAddr((String)this.targets[0].getName());
                    sock = DataNode.this.newSocket();
                    NetUtils.connect((Socket)sock, (SocketAddress)curTarget, (int)DataNode.this.socketTimeout);
                    sock.setSoTimeout(this.targets.length * DataNode.this.socketTimeout);
                    long writeTimeout = DataNode.this.socketWriteTimeout + 5000 * (this.targets.length - 1);
                    OutputStream baseStream = NetUtils.getOutputStream((Socket)sock, (long)writeTimeout);
                    out = new DataOutputStream(new BufferedOutputStream(baseStream, FSConstants.SMALL_BUFFER_SIZE));
                    blockSender = new BlockSender(this.b, 0L, this.b.getNumBytes(), false, false, false, this.datanode);
                    DatanodeInfo srcNode = new DatanodeInfo(DataNode.this.dnRegistration);
                    BlockAccessToken accessToken = BlockAccessToken.DUMMY_TOKEN;
                    if (DataNode.this.isAccessTokenEnabled) {
                        accessToken = DataNode.this.accessTokenHandler.generateToken(null, this.b.getBlockId(), EnumSet.of(AccessTokenHandler.AccessMode.WRITE));
                    }
                    DataTransferProtocol.Sender.opWriteBlock(out, this.b.getBlockId(), this.b.getGenerationStamp(), 0, DataTransferProtocol.BlockConstructionStage.PIPELINE_SETUP_CREATE, 0L, 0L, 0L, DataNode.EMPTY_DEL_HINT, srcNode, this.targets, accessToken);
                    blockSender.sendBlock(out, baseStream, null);
                    LOG.info((Object)(DataNode.this.dnRegistration + ":Transmitted block " + this.b + " to " + curTarget));
                    DataNode.this.xmitsInProgress.getAndDecrement();
                }
                catch (IOException ie) {
                    LOG.warn((Object)(DataNode.this.dnRegistration + ":Failed to transfer " + this.b + " to " + this.targets[0].getName() + " got " + StringUtils.stringifyException((Throwable)ie)));
                    this.datanode.checkDiskError();
                    break block6;
                }
                finally {
                    DataNode.this.xmitsInProgress.getAndDecrement();
                    IOUtils.closeStream(blockSender);
                    IOUtils.closeStream(out);
                    IOUtils.closeSocket((Socket)sock);
                }
                IOUtils.closeStream((Closeable)blockSender);
                IOUtils.closeStream((Closeable)out);
                IOUtils.closeSocket((Socket)sock);
            }
        }
    }
}

