/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;

class BlocksMap {
    private int capacity = 1;
    private final float loadFactor;
    private Map<BlockInfo, BlockInfo> map;

    BlocksMap(int initialCapacity, float loadFactor) {
        while (this.capacity < initialCapacity) {
            this.capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.map = new HashMap<BlockInfo, BlockInfo>(initialCapacity, loadFactor);
    }

    INodeFile getINode(Block b) {
        BlockInfo info = this.map.get(b);
        return info != null ? info.getINode() : null;
    }

    BlockInfo addINode(BlockInfo b, INodeFile iNode) {
        BlockInfo info = this.map.get(b);
        if (info != b) {
            info = b;
            this.map.put(info, info);
        }
        info.setINode(iNode);
        return info;
    }

    void removeBlock(Block block) {
        BlockInfo blockInfo = this.map.remove(block);
        if (blockInfo == null) {
            return;
        }
        blockInfo.setINode(null);
        for (int idx = blockInfo.numNodes() - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = blockInfo.getDatanode(idx);
            dn.removeBlock(blockInfo);
        }
    }

    BlockInfo getStoredBlock(Block b) {
        return this.map.get(b);
    }

    Iterator<DatanodeDescriptor> nodeIterator(Block b) {
        return this.nodeIterator(this.map.get(b));
    }

    Iterator<DatanodeDescriptor> nodeIterator(BlockInfo storedBlock) {
        return new NodeIterator(storedBlock);
    }

    int numNodes(Block b) {
        BlockInfo info = this.map.get(b);
        return info == null ? 0 : info.numNodes();
    }

    boolean removeNode(Block b, DatanodeDescriptor node) {
        BlockInfo info = this.map.get(b);
        if (info == null) {
            return false;
        }
        boolean removed = node.removeBlock(info);
        if (info.getDatanode(0) == null && info.getINode() == null) {
            this.map.remove(b);
        }
        return removed;
    }

    int size() {
        return this.map.size();
    }

    Collection<BlockInfo> getBlocks() {
        return this.map.values();
    }

    boolean contains(Block block) {
        return this.map.containsKey(block);
    }

    boolean contains(Block block, DatanodeDescriptor datanode) {
        BlockInfo info = this.map.get(block);
        if (info == null) {
            return false;
        }
        return -1 != info.findDatanode(datanode);
    }

    int getCapacity() {
        while (this.map.size() > (int)((float)this.capacity * this.loadFactor)) {
            this.capacity <<= 1;
        }
        return this.capacity;
    }

    float getLoadFactor() {
        return this.loadFactor;
    }

    BlockInfo replaceBlock(BlockInfo newBlock) {
        BlockInfo currentBlock = this.map.get(newBlock);
        assert (currentBlock != null) : "the block if not in blocksMap";
        for (int idx = currentBlock.numNodes() - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = currentBlock.getDatanode(idx);
            dn.replaceBlock(currentBlock, newBlock);
        }
        this.map.put(newBlock, newBlock);
        return newBlock;
    }

    private static class NodeIterator
    implements Iterator<DatanodeDescriptor> {
        private BlockInfo blockInfo;
        private int nextIdx = 0;

        NodeIterator(BlockInfo blkInfo) {
            this.blockInfo = blkInfo;
        }

        @Override
        public boolean hasNext() {
            return this.blockInfo != null && this.nextIdx < this.blockInfo.getCapacity() && this.blockInfo.getDatanode(this.nextIdx) != null;
        }

        @Override
        public DatanodeDescriptor next() {
            return this.blockInfo.getDatanode(this.nextIdx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }
}

