/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.util.DataDispatcher;
import okuyama.imdst.util.DataTransactionFileFlushDaemon;
import okuyama.imdst.util.FileBaseDataList;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.KeyManagerValueMap;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.SystemUtil;
import okuyama.imdst.util.io.CustomBufferedWriter;

public class KeyMapManager
extends Thread {
    private static ILogger logger = LoggerFactory.createLogger(KeyMapManager.class);
    private KeyManagerValueMap keyMapObj = null;
    private int mapSize = 0;
    private static final String tagStartStr = "{imdst_tag#9641";
    private static final String tagEndStr = "1469#tag_imdst}";
    private static final String tagKeySep = ":";
    private int putValueMaxSize = new Double((double)ImdstDefine.saveDataMaxSize * 1.38).intValue();
    public boolean outputDataStopSignal = false;
    private Object poolKeyLock = new Object();
    private Object setKeyLock = new Object();
    private Object lockKeyLock = new Object();
    private static final int parallelSize = 5000;
    private Integer[] parallelSyncObjs = new Integer[5000];
    private static final int tagSetParallelSize = 300;
    private Integer[] tagSetParallelSyncObjs = new Integer[300];
    private Object setTagLock = new Object();
    private String nodeKeyMapFilePath = null;
    private String workKeyFilePath = null;
    private String[] keyFileDirs = null;
    private BufferedWriter bw = null;
    private AtomicInteger tLogWriteCount = null;
    protected static int accessorTypeBw = 2;
    private boolean blocking = false;
    private boolean initFlg = false;
    private boolean writeMapFileFlg = false;
    private static int updateInterval = 1000;
    private static int intervalCount = 60;
    private static boolean workFileStartingReadFlg = ImdstDefine.workFileStartingReadFlg;
    private static String workFileSeq = ",";
    protected static String workMapFileEnc = "UTF-8";
    private static String workFileEndPoint = ";";
    private boolean workFileMemory = false;
    private Object lockWorkFileSync = new Object();
    private boolean workFileFlushTiming = ImdstDefine.dataTransactionFileFlushTiming;
    private DataTransactionFileFlushDaemon dataTransactionFileFlushDaemon = null;
    private static final long workFileChangeNewFileSize = 0x60000000L;
    private static final int workFileChangeCheckLimit = 2;
    private boolean dataMemory = true;
    private boolean allDataForFile = false;
    private String diskModeRestoreFile = null;
    private long lastAccess = 0L;
    private boolean vacuumExec = false;
    private int vacuumStartLimit = 100000;
    private int vacuumStartCompulsionLimit = 1000000;
    private int vacuumExecAfterAccessTime = 200;
    private boolean dataManege = true;
    private String lockKeyTimeSep = "_";
    private static String listStructStartPrefix = new String(BASE64EncoderStream.encode((byte[])"{imdst_list#1234".getBytes()));
    private static String listStructEndPrefix = new String(BASE64EncoderStream.encode((byte[])"{imdst_list#9876".getBytes()));
    private static String listStructPointerPrefix = new String(BASE64EncoderStream.encode((byte[])"{imdst_list_pointer#878685".getBytes()));
    private static String listStructSizePrefix = new String(BASE64EncoderStream.encode((byte[])"{imdst_list_size#848382".getBytes()));
    private static String listStructDataKeyPrefix = new String(BASE64EncoderStream.encode((byte[])"{imdst_list_data#567".getBytes()));
    private boolean diffDataPoolingFlg = false;
    private Object diffSync = new Object();
    private List diffDataPoolingListForFileBase = null;
    public int myOperationStatus = 1;
    public int myDiffModeOperationStatus = 1;
    private ConcurrentHashMap moveAdjustmentDataMap = null;
    private Object moveAdjustmentSync = new Object();
    private int memoryLimitSize = -1;
    private String[] virtualStorageDirs = null;
    protected boolean initDataFile = true;
    protected boolean keyObjBkupMode = false;
    protected String keyObjBkupFilePath = null;
    private Object keyObjectExportSync = new Object();
    private int keyObjectStoreTiming = 25;
    private String diskCacheFile = null;

    public KeyMapManager(String keyMapFilePath, String workKeyMapFilePath, boolean workFileMemory, int keySize, boolean dataMemory, boolean dataManage, String diskCacheFile) throws BatchException {
        if (ImdstDefine.recoverRequired) {
            this.myOperationStatus = 4;
        }
        this.keyObjBkupMode = true;
        this.diskCacheFile = diskCacheFile;
        this.bkupObjCheck(keyMapFilePath);
        this.init(keyMapFilePath, workKeyMapFilePath, workFileMemory, keySize, dataMemory, null);
        this.dataManege = dataManage;
    }

    public KeyMapManager(String keyMapFilePath, String workKeyMapFilePath, boolean workFileMemory, int keySize, boolean dataMemory, String diskCacheFile) throws BatchException {
        if (ImdstDefine.recoverRequired) {
            this.myOperationStatus = 4;
        }
        this.keyObjBkupMode = true;
        this.diskCacheFile = diskCacheFile;
        this.bkupObjCheck(keyMapFilePath);
        this.init(keyMapFilePath, workKeyMapFilePath, workFileMemory, keySize, dataMemory, null);
    }

    public KeyMapManager(String keyMapFilePath, String workKeyMapFilePath, boolean workFileMemory, int keySize, boolean dataMemory, int memoryLimitSize, String[] virtualStorageDirs, String diskCacheFile) throws BatchException {
        if (ImdstDefine.recoverRequired) {
            this.myOperationStatus = 4;
        }
        this.keyObjBkupMode = true;
        this.diskCacheFile = diskCacheFile;
        this.bkupObjCheck(keyMapFilePath);
        this.memoryLimitSize = memoryLimitSize;
        this.virtualStorageDirs = virtualStorageDirs;
        this.init(keyMapFilePath, workKeyMapFilePath, workFileMemory, keySize, dataMemory, null);
    }

    public KeyMapManager(String keyMapFilePath, String workKeyMapFilePath, boolean workFileMemory, int keySize, boolean dataMemory, String[] dirs, String diskCacheFile) throws BatchException {
        if (ImdstDefine.recoverRequired) {
            this.myOperationStatus = 4;
        }
        boolean renewFlg = false;
        this.diskCacheFile = diskCacheFile;
        for (int idx = 0; idx < dirs.length; ++idx) {
            File path = new File(dirs[idx]);
            if (path.exists()) continue;
            renewFlg = true;
        }
        this.initDataFile = renewFlg;
        if (!ImdstDefine.recycleExsistData) {
            this.initDataFile = true;
        }
        this.init(keyMapFilePath, workKeyMapFilePath, workFileMemory, keySize, dataMemory, dirs);
    }

    private void bkupObjCheck(String keyMapFilePath) {
        boolean renewFlg = false;
        this.keyObjBkupFilePath = keyMapFilePath + ".obj";
        File path = new File(this.keyObjBkupFilePath);
        if (!path.exists()) {
            renewFlg = true;
        }
        this.initDataFile = renewFlg;
        if (!ImdstDefine.recycleExsistData) {
            this.initDataFile = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String keyMapFilePath, String workKeyMapFilePath, boolean workFileMemory, int keySize, boolean dataMemory, String[] dirs) throws BatchException {
        logger.debug("init - start");
        if (!this.initFlg) {
            int i;
            this.initFlg = true;
            this.nodeKeyMapFilePath = keyMapFilePath;
            this.workFileMemory = workFileMemory;
            this.dataMemory = dataMemory;
            this.mapSize = keySize;
            this.workKeyFilePath = workKeyMapFilePath;
            if (ImdstDefine.bigValueFileStoreUse && ImdstDefine.tagValueAppendMaxSize > ImdstDefine.memoryStoreLimitSize) {
                ImdstDefine.tagValueAppendMaxSize = ImdstDefine.memoryStoreLimitSize - ImdstDefine.saveKeyMaxSize;
            }
            FileInputStream workKeyFilefis = null;
            InputStreamReader isr = null;
            Object fr = null;
            BufferedReader br = null;
            String line = null;
            String[] workSplitStrs = null;
            if (dirs != null) {
                this.dataMemory = false;
                this.allDataForFile = true;
                this.keyFileDirs = dirs;
            }
            if (!this.dataMemory) {
                this.diskModeRestoreFile = keyMapFilePath + ".data";
            }
            for (i = 0; i < 5000; ++i) {
                this.parallelSyncObjs[i] = new Integer(i);
            }
            for (i = 0; i < 300; ++i) {
                this.tagSetParallelSyncObjs[i] = new Integer(i + 300);
            }
            Object object = this.poolKeyLock;
            synchronized (object) {
                try {
                    boolean mapFileRead = true;
                    this.keyMapObj = !this.allDataForFile ? new KeyManagerValueMap(this.mapSize, this.dataMemory, this.virtualStorageDirs, this.initDataFile, new File(this.keyObjBkupFilePath), this.diskCacheFile) : new KeyManagerValueMap(this.keyFileDirs, this.mapSize, this.initDataFile, this.diskCacheFile);
                    if (!dataMemory) {
                        File beforeDtaFile = new File(this.diskModeRestoreFile);
                        if (this.initDataFile && beforeDtaFile.exists()) {
                            beforeDtaFile.delete();
                        }
                        this.keyMapObj.initNoMemoryModeSetting(this.diskModeRestoreFile, this.initDataFile);
                    }
                    if (workFileStartingReadFlg) {
                        System.out.println(" Data log file read start - " + new Date().toString());
                        int i2 = 0;
                        while (true) {
                            boolean endFlg = false;
                            File workKeyFile = new File(this.workKeyFilePath + i2);
                            if (!workKeyFile.exists()) {
                                workKeyFile = new File(this.workKeyFilePath);
                                endFlg = true;
                            }
                            if (workKeyFile.exists()) {
                                logger.info("workKeyMapFile - Read - start");
                                workKeyFilefis = new FileInputStream(workKeyFile);
                                isr = new InputStreamReader((InputStream)workKeyFilefis, workMapFileEnc);
                                br = new BufferedReader(isr);
                                int counter = 1;
                                while ((line = br.readLine()) != null) {
                                    if (counter % 100 == 0) {
                                        logger.info("workKeyMapFile - Read - Count =[" + counter + "]");
                                    }
                                    if (!line.equals("")) {
                                        workSplitStrs = line.split(workFileSeq);
                                        if (workSplitStrs.length == 5) {
                                            if (workSplitStrs[0].equals("+")) {
                                                if (this.keyMapObj.useStorageObjectTime < Long.parseLong(workSplitStrs[3])) {
                                                    this.keyMapObjPutSetTime(workSplitStrs[1], workSplitStrs[2], new Long(workSplitStrs[3]));
                                                }
                                            } else if (workSplitStrs[0].equals("-") && this.keyMapObj.useStorageObjectTime < Long.parseLong(workSplitStrs[3])) {
                                                this.keyMapObjRemoveSetTime(workSplitStrs[1], new Long(workSplitStrs[3]));
                                            }
                                        } else if (workSplitStrs.length == 6) {
                                            if (workSplitStrs[0].equals("+")) {
                                                if (this.keyMapObj.useStorageObjectTime < Long.parseLong(workSplitStrs[4])) {
                                                    this.keyMapObjPutSetTime(workSplitStrs[1], workSplitStrs[2] + workFileSeq + workSplitStrs[3], new Long(workSplitStrs[4]));
                                                }
                                            } else if (workSplitStrs[0].equals("-") && this.keyMapObj.useStorageObjectTime < Long.parseLong(workSplitStrs[3])) {
                                                this.keyMapObjRemoveSetTime(workSplitStrs[1], new Long(workSplitStrs[3]));
                                            }
                                        } else {
                                            logger.error("workKeyMapFile - Read - Error " + counter + "Line Data = [" + workSplitStrs + "]");
                                        }
                                    } else {
                                        logger.info("workKeyMapFile - Read - Info " + counter + "Line Blank");
                                    }
                                    ++counter;
                                }
                                br.close();
                                isr.close();
                                workKeyFilefis.close();
                                logger.info("workKeyMapFile - Read - end");
                            }
                            if (endFlg) break;
                            ++i2;
                        }
                        System.out.println(" Data log file read end - " + new Date().toString());
                    }
                    this.tLogWriteCount = new AtomicInteger(0);
                    FileOutputStream newFos = new FileOutputStream(new File(this.workKeyFilePath), true);
                    this.bw = new CustomBufferedWriter(new OutputStreamWriter((OutputStream)newFos, workMapFileEnc), 196608, newFos);
                    this.bw.newLine();
                    SystemUtil.diskAccessSync(this.bw);
                    if (!this.workFileMemory && !this.workFileFlushTiming) {
                        this.dataTransactionFileFlushDaemon = new DataTransactionFileFlushDaemon();
                        this.dataTransactionFileFlushDaemon.tFilePath = this.workKeyFilePath;
                        this.dataTransactionFileFlushDaemon.tBw = this.bw;
                        this.dataTransactionFileFlushDaemon.start();
                    }
                }
                catch (Exception e) {
                    logger.error("KeyMapManager - init - Error" + e);
                    this.blocking = true;
                    StatusUtil.setStatusAndMessage(1, "KeyMapManager - init - Error [" + e.getMessage() + "]");
                    throw new BatchException(e);
                }
            }
        }
        logger.debug("init - end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int sizeCheckCounter = 0;
        int vacuumInvalidDataCount = 0;
        int keyMapObjectStoreCheckCount = 0;
        while (true) {
            if (StatusUtil.getStatus() != 0) break;
            try {
                Object object;
                for (int count = 0; count < intervalCount; ++count) {
                    if (StatusUtil.getStatus() != 0) {
                        logger.info("KeyMapManager - run - System Shutdown 2");
                        break;
                    }
                    if (!this.dataManege) {
                        this.autoLockRelease(JavaSystemApi.currentTimeMillis);
                    }
                    Thread.sleep(updateInterval);
                    if (count % 4 != 0 || this.workFileMemory || this.workFileFlushTiming || !this.dataTransactionFileFlushDaemon.getExecuteEnd()) continue;
                    try {
                        Object object2 = this.poolKeyLock;
                        synchronized (object2) {
                            object = this.lockWorkFileSync;
                            synchronized (object) {
                                if (this.dataTransactionFileFlushDaemon != null && this.dataTransactionFileFlushDaemon.getExecuteEnd()) {
                                    DataTransactionFileFlushDaemon dataTransactionFileFlushDaemonRe = new DataTransactionFileFlushDaemon();
                                    this.dataTransactionFileFlushDaemon.tFilePath = this.workKeyFilePath;
                                    dataTransactionFileFlushDaemonRe.tBw = this.bw;
                                    dataTransactionFileFlushDaemonRe.setDataTransactionFileQueue(this.dataTransactionFileFlushDaemon.getDataTransactionFileQueue());
                                    dataTransactionFileFlushDaemonRe.start();
                                    this.dataTransactionFileFlushDaemon = dataTransactionFileFlushDaemonRe;
                                }
                            }
                        }
                    }
                    catch (Exception reE) {
                        reE.printStackTrace();
                    }
                }
                logger.debug("Transaction Log Size Check - Start");
                if (!this.workFileMemory && ++sizeCheckCounter > 2) {
                    File nowWorkFile = new File(this.workKeyFilePath);
                    if (nowWorkFile.length() > 0x60000000L) {
                        Object reE = this.poolKeyLock;
                        synchronized (reE) {
                            object = this.lockWorkFileSync;
                            synchronized (object) {
                                logger.debug("Transaction Log File Change - Start");
                                if (!this.workFileFlushTiming) {
                                    this.dataTransactionFileFlushDaemon.close();
                                } else {
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.bw.close();
                                    this.bw = null;
                                }
                                int nextWorkFileName = 0;
                                File checkWorkKeyFile = null;
                                nextWorkFileName = 0;
                                while ((checkWorkKeyFile = new File(this.workKeyFilePath + nextWorkFileName)).exists()) {
                                    ++nextWorkFileName;
                                }
                                if (!nowWorkFile.renameTo(checkWorkKeyFile)) {
                                    throw new Exception("Work File Name Change Error");
                                }
                                nowWorkFile = null;
                                checkWorkKeyFile = null;
                                this.tLogWriteCount = new AtomicInteger(0);
                                FileOutputStream newFos = new FileOutputStream(new File(this.workKeyFilePath), true);
                                this.bw = new CustomBufferedWriter(new OutputStreamWriter((OutputStream)newFos, workMapFileEnc), 196608, newFos);
                                this.bw.newLine();
                                SystemUtil.diskAccessSync(this.bw);
                                if (!this.workFileFlushTiming) {
                                    this.dataTransactionFileFlushDaemon.tFilePath = this.workKeyFilePath;
                                    this.dataTransactionFileFlushDaemon.tBw = this.bw;
                                }
                                logger.debug("Transaction Log File Change - End");
                            }
                        }
                    }
                    sizeCheckCounter = 0;
                }
                logger.debug("Transaction Log Size Check - End");
                logger.info("VacuumCheck - Start");
                if (!this.dataMemory && this.vacuumExec && !this.diffDataPoolingFlg) {
                    logger.debug("vacuumCheck - Start - 1");
                    Object nowWorkFile = this.poolKeyLock;
                    synchronized (nowWorkFile) {
                        logger.debug("VacuumCheck - DifferenceCount = [" + (this.keyMapObj.getAllDataCount() - this.keyMapObj.getKeySize()) + "]");
                        if (this.keyMapObj.getAllDataCount() - this.keyMapObj.getKeySize() > this.vacuumStartLimit) {
                            logger.debug("VacuumCheck - Start - 2");
                            if (JavaSystemApi.currentTimeMillis - this.lastAccess > (long)this.vacuumExecAfterAccessTime || this.keyMapObj.getAllDataCount() - this.keyMapObj.getKeySize() > this.vacuumStartCompulsionLimit) {
                                logger.info("Vacuum - Start Vacuum Data Count=[" + (this.keyMapObj.getAllDataCount() - this.keyMapObj.getKeySize()) + "]");
                                long vacuumStart = JavaSystemApi.currentTimeMillis;
                                this.keyMapObj.vacuumData();
                                this.keyObjectExport(null);
                                long vacuumEnd = JavaSystemApi.currentTimeMillis;
                                logger.info("Vacuum - End - VacuumTime [" + (vacuumEnd - vacuumStart) + "] Milli Second");
                            }
                        }
                    }
                }
                logger.info("VacuumCheck - End");
                if ((this.dataMemory || ImdstDefine.vacuumInvalidDataCompulsion) && ImdstDefine.vacuumInvalidDataFlg && vacuumInvalidDataCount > ImdstDefine.startVaccumInvalidCount && !this.diffDataPoolingFlg) {
                    logger.info("VacuumInvalidData - Start - 1");
                    Object nowWorkFile = this.poolKeyLock;
                    synchronized (nowWorkFile) {
                        Set entrySet = this.keyMapObj.entrySet();
                        Iterator entryIte = entrySet.iterator();
                        long removeTagetData = 0L;
                        long counter = 0L;
                        while (entryIte.hasNext()) {
                            String[] metaColumns;
                            String[] valStrSplit;
                            String[] checkValueSplit;
                            Map.Entry obj;
                            if (++counter % 2500L == 0L) {
                                logger.info("VacuumInvalidData - Exec Count[" + counter + "]");
                                Thread.sleep(100L);
                            }
                            if ((obj = (Map.Entry)entryIte.next()) == null) continue;
                            Object key = null;
                            key = obj.getKey();
                            String valStr = this.getKeyPair(key);
                            if (valStr == null || (checkValueSplit = (valStr = (valStrSplit = valStr.split("!"))[0]).split(",")).length <= 1 || SystemUtil.expireCheck((metaColumns = checkValueSplit[1].split("-"))[1], 6000L)) continue;
                            this.removeKeyPair(key, "0");
                            ++removeTagetData;
                        }
                        logger.info("RemoveInvalidData - Count [" + removeTagetData + "]");
                    }
                    logger.info("VacuumInvalidData - End - 1");
                    vacuumInvalidDataCount = 0;
                }
                ++vacuumInvalidDataCount;
                if (++keyMapObjectStoreCheckCount <= this.keyObjectStoreTiming) continue;
                this.keyObjectExport(null);
                keyMapObjectStoreCheckCount = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("KeyMapManager - run - Error" + e);
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "KeyMapManager - run - Error [" + e.getMessage() + "]");
                if (this.workFileMemory || this.workFileFlushTiming) continue;
                this.dataTransactionFileFlushDaemon.close();
            }
        }
        logger.info("KeyMapManager - run - System Shutdown [1] Msg=[" + StatusUtil.getStatusMessage() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long truncateData(String uniqueKey) {
        long truncateTagetData = 0L;
        try {
            String tagUniqueKey = tagStartStr + uniqueKey;
            logger.info("truncateData - Start");
            Object object = this.poolKeyLock;
            synchronized (object) {
                Set entrySet = this.keyMapObj.entrySet();
                Iterator entryIte = entrySet.iterator();
                long counter = 0L;
                while (entryIte.hasNext()) {
                    Map.Entry obj;
                    if (++counter % 5000L == 0L) {
                        logger.info("TruncateData - Exec Count[" + counter + "]");
                    }
                    if ((obj = (Map.Entry)entryIte.next()) == null) continue;
                    String key = null;
                    key = (String)obj.getKey();
                    if (!uniqueKey.equals("#all") && key.indexOf(uniqueKey) != 0 && key.indexOf(tagUniqueKey) != 0 || StatusUtil.configDataKeyMap.containsKey(key)) continue;
                    this.removeKeyPair(key, "0");
                    ++truncateTagetData;
                }
                logger.info("TruncateData - TotalTargetCount [" + counter + "]");
                logger.info("TruncateData - TotalRemoveCount [" + truncateTagetData + "]");
            }
            logger.info("truncateData - End");
        }
        catch (BatchException be) {
            logger.error("truncateData - InnerError", be);
            be.printStackTrace();
        }
        catch (Exception e) {
            logger.error("truncateData - Error" + e);
            e.printStackTrace();
        }
        return truncateTagetData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyPair(String key, String keyNode, String transactionCode) throws BatchException {
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(key.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    if (this.moveAdjustmentDataMap != null) {
                        Object object = this.moveAdjustmentSync;
                        synchronized (object) {
                            if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(key)) {
                                this.moveAdjustmentDataMap.remove(key);
                            }
                        }
                    }
                    String data = null;
                    int timeSepPoint = keyNode.indexOf("!");
                    if (timeSepPoint != -1) {
                        int lastTimeSepPoint = keyNode.lastIndexOf("!");
                        if (timeSepPoint == lastTimeSepPoint) {
                            data = keyNode;
                        } else {
                            String[] keyNoddes = keyNode.split("!");
                            data = keyNoddes[0] + "!" + keyNoddes[1];
                        }
                    } else {
                        data = keyNode + "!" + "0";
                    }
                    this.keyMapObjPut(key, data);
                    if (!this.workFileMemory) {
                        Object object = this.lockWorkFileSync;
                        synchronized (object) {
                            if (this.workFileFlushTiming) {
                                if (data.length() < 200) {
                                    this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                } else {
                                    this.bw.write("+");
                                    this.bw.write(workFileSeq);
                                    this.bw.write(key);
                                    this.bw.write(workFileSeq);
                                    this.bw.write(data);
                                    this.bw.write(workFileSeq);
                                    this.bw.write(new Long(JavaSystemApi.currentTimeMillis).toString());
                                    this.bw.write(workFileSeq);
                                    this.bw.write(workFileEndPoint);
                                    this.bw.write("\n");
                                }
                                SystemUtil.diskAccessSync(this.bw);
                                this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                            } else {
                                this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                            }
                        }
                    }
                    if (this.diffDataPoolingFlg) {
                        Object object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + data);
                            }
                        }
                    }
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("setKeyPair - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "setKeyPair - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
    }

    public boolean setKeyPairOnlyOnce(String key, String keyNode, String transactionCode) throws BatchException {
        return this.setKeyPairOnlyOnce(key, keyNode, transactionCode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setKeyPairOnlyOnce(String key, String keyNode, String transactionCode, boolean moveData) throws BatchException {
        boolean ret = false;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(key.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    Object object;
                    Object tmp;
                    if (this.containsKeyPair(key) && !KeyMapManager.isExpireData((String)(tmp = this.keyMapObjGet(key)))) {
                        return ret;
                    }
                    if (this.moveAdjustmentDataMap != null) {
                        tmp = this.moveAdjustmentSync;
                        synchronized (tmp) {
                            if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(key) && !moveData) {
                                this.moveAdjustmentDataMap.remove(key);
                            }
                        }
                    }
                    String data = null;
                    if (keyNode.indexOf("-1") == -1) {
                        data = keyNode;
                    } else {
                        String[] keyNoddes = keyNode.split("!");
                        data = keyNoddes[0] + "!" + "0";
                    }
                    this.keyMapObjPut(key, data);
                    ret = true;
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            if (this.workFileFlushTiming) {
                                this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                SystemUtil.diskAccessSync(this.bw);
                                this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                            } else {
                                this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                            }
                        }
                    }
                    if (this.diffDataPoolingFlg) {
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + data);
                            }
                        }
                    }
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("setKeyPairOnlyOnce - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "setKeyPairOnlyOnce - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setKeyPairVersionCheck(String key, String keyNode, String transactionCode, String updateVersionNo, boolean execCheck) throws BatchException {
        boolean ret = false;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(key.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    Object object;
                    Object checkValue;
                    if (execCheck && this.containsKeyPair(key) && !((String)(checkValue = this.getKeyPair(key))).split("!")[1].equals(updateVersionNo)) {
                        return ret;
                    }
                    if (this.moveAdjustmentDataMap != null) {
                        checkValue = this.moveAdjustmentSync;
                        synchronized (checkValue) {
                            if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(key)) {
                                this.moveAdjustmentDataMap.remove(key);
                            }
                        }
                    }
                    String data = null;
                    String[] keyNoddes = keyNode.split("!");
                    data = keyNoddes[0] + "!" + (new Long(updateVersionNo) + 1L);
                    this.keyMapObjPut(key, data);
                    ret = true;
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            if (this.workFileFlushTiming) {
                                this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                SystemUtil.diskAccessSync(this.bw);
                                this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                            } else {
                                this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                            }
                        }
                    }
                    if (this.diffDataPoolingFlg) {
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + data);
                            }
                        }
                    }
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("setKeyPairVersionCheck - Error", e);
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "setKeyPairVersionCheck - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    public String getKeyPair(String key) {
        String ret = null;
        if (!this.blocking) {
            try {
                ret = this.keyMapObjGet(key);
            }
            catch (BatchException be) {
                ret = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createListStruct(String listName, boolean compulsiveFlg, String transactionCode) throws BatchException {
        int ret = 1;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(listName.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    String pointerKey = listStructPointerPrefix + listName;
                    String sizeKey = listStructSizePrefix + listName;
                    String key = listStructStartPrefix + listName;
                    String[] keyList = new String[]{key, listStructEndPrefix + listName};
                    if (!compulsiveFlg && this.containsKeyPair(pointerKey)) {
                        ret = 2;
                        return ret;
                    }
                    if (this.moveAdjustmentDataMap != null) {
                        Object object = this.moveAdjustmentSync;
                        synchronized (object) {
                            if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(key)) {
                                this.moveAdjustmentDataMap.remove(key);
                            }
                            if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(keyList[1])) {
                                this.moveAdjustmentDataMap.remove(keyList[1]);
                            }
                            if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(pointerKey)) {
                                this.moveAdjustmentDataMap.remove(pointerKey);
                            }
                            if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(sizeKey)) {
                                this.moveAdjustmentDataMap.remove(sizeKey);
                            }
                        }
                    }
                    String data = "(B)!0";
                    for (int i = 0; i < 2; ++i) {
                        Object object;
                        this.keyMapObjPut(keyList[i], data);
                        if (!this.workFileMemory) {
                            object = this.lockWorkFileSync;
                            synchronized (object) {
                                if (this.workFileFlushTiming) {
                                    this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(keyList[i]).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                } else {
                                    this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(keyList[i]).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                }
                            }
                        }
                        if (!this.diffDataPoolingFlg) continue;
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + keyList[i] + workFileSeq + data);
                            }
                            continue;
                        }
                    }
                    data = "0!0";
                    this.keyMapObjPut(pointerKey, data);
                    if (!this.workFileMemory) {
                        Object object = this.lockWorkFileSync;
                        synchronized (object) {
                            if (this.workFileFlushTiming) {
                                this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(pointerKey).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                SystemUtil.diskAccessSync(this.bw);
                                this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                            } else {
                                this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(pointerKey).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                            }
                        }
                    }
                    if (this.diffDataPoolingFlg) {
                        Object object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + pointerKey + workFileSeq + data);
                            }
                        }
                    }
                    data = "0!0";
                    this.keyMapObjPut(sizeKey, data);
                    if (!this.workFileMemory) {
                        Object object = this.lockWorkFileSync;
                        synchronized (object) {
                            if (this.workFileFlushTiming) {
                                this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(sizeKey).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                SystemUtil.diskAccessSync(this.bw);
                                this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                            } else {
                                this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(sizeKey).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                            }
                        }
                    }
                    if (this.diffDataPoolingFlg) {
                        Object object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + sizeKey + workFileSeq + data);
                            }
                        }
                    }
                    ret = 0;
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("createListStruct - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "createListStruct - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int listLPush(String listName, String keyNode, String transactionCode) throws BatchException {
        int ret = 2;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(listName.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    String pointerKey = listStructPointerPrefix + listName;
                    String sizeKey = listStructSizePrefix + listName;
                    String key = listStructStartPrefix + listName;
                    String[] keyList = new String[3];
                    boolean allDataDeleted = false;
                    keyList[0] = key;
                    keyList[1] = listStructEndPrefix + listName;
                    keyList[2] = listStructDataKeyPrefix + listName;
                    if (!this.containsKeyPair(pointerKey)) {
                        ret = 1;
                        return ret;
                    }
                    String chkListStartStruct = this.getKeyPair(keyList[0]);
                    if (chkListStartStruct.indexOf("(B)") == 0) {
                        allDataDeleted = true;
                    }
                    ArrayList<String[]> saveDataList = new ArrayList<String[]>();
                    String listPointerStruct = this.getKeyPair(pointerKey);
                    if (listPointerStruct != null && listPointerStruct.indexOf("0") == 0 || allDataDeleted) {
                        String pointerLongStr = "1";
                        String listStartStruct = pointerLongStr + "!" + "0";
                        String listEndStruct = pointerLongStr + "!" + "0";
                        keyList[2] = keyList[2] + pointerLongStr;
                        this.keyMapObjPut(keyList[0], listStartStruct);
                        this.keyMapObjPut(keyList[1], listEndStruct);
                        String[] saveDataTmp = new String[]{keyList[0], listStartStruct};
                        saveDataList.add(saveDataTmp);
                        saveDataTmp = new String[]{keyList[1], listEndStruct};
                        saveDataList.add(saveDataTmp);
                        String dataValue = keyNode + "!" + "0";
                        this.keyMapObjPut(keyList[2], dataValue);
                        saveDataTmp = new String[]{keyList[2], dataValue};
                        saveDataList.add(saveDataTmp);
                        String leftPointerKey = keyList[2] + "_L";
                        String leftPointerValue = "(B)!0";
                        this.keyMapObjPut(leftPointerKey, leftPointerValue);
                        saveDataTmp = new String[]{leftPointerKey, leftPointerValue};
                        saveDataList.add(saveDataTmp);
                        String rightPointerKey = keyList[2] + "_R";
                        String rightPointerValue = "(B)!0";
                        this.keyMapObjPut(rightPointerKey, rightPointerValue);
                        saveDataTmp = new String[]{rightPointerKey, rightPointerValue};
                        saveDataList.add(saveDataTmp);
                        this.keyMapObjPut(pointerKey, listStartStruct);
                        saveDataTmp = new String[]{pointerKey, listStartStruct};
                        saveDataList.add(saveDataTmp);
                    } else {
                        long pointerLong = Long.parseLong(listPointerStruct.split("!")[0]);
                        String listStartStruct = this.getKeyPair(keyList[0]);
                        String nowStartDataPointer = listStartStruct.split("!")[0];
                        String nowStartDataKey = keyList[2] + nowStartDataPointer;
                        String newStartDataKey = keyList[2] + ++pointerLong;
                        String dataValue = keyNode + "!" + "0";
                        this.keyMapObjPut(newStartDataKey, dataValue);
                        String[] saveDataTmp = new String[]{newStartDataKey, dataValue};
                        saveDataList.add(saveDataTmp);
                        String leftPointerKey = newStartDataKey + "_L";
                        String leftPointerValue = "(B)!0";
                        this.keyMapObjPut(leftPointerKey, leftPointerValue);
                        saveDataTmp = new String[]{leftPointerKey, leftPointerValue};
                        saveDataList.add(saveDataTmp);
                        String rightPointerKey = newStartDataKey + "_R";
                        String rightPointerValue = nowStartDataPointer + "!" + "0";
                        this.keyMapObjPut(rightPointerKey, rightPointerValue);
                        saveDataTmp = new String[]{rightPointerKey, rightPointerValue};
                        saveDataList.add(saveDataTmp);
                        String startDataNewStructValue = pointerLong + "!" + "0";
                        this.keyMapObjPut(keyList[0], startDataNewStructValue);
                        saveDataTmp = new String[]{keyList[0], startDataNewStructValue};
                        saveDataList.add(saveDataTmp);
                        String beforStartDataLeftStructKey = nowStartDataKey + "_L";
                        String beforStartDataLeftStructValue = pointerLong + "!" + "0";
                        this.keyMapObjPut(beforStartDataLeftStructKey, beforStartDataLeftStructValue);
                        saveDataTmp = new String[]{beforStartDataLeftStructKey, beforStartDataLeftStructValue};
                        saveDataList.add(saveDataTmp);
                        this.keyMapObjPut(pointerKey, beforStartDataLeftStructValue);
                        saveDataTmp = new String[]{pointerKey, beforStartDataLeftStructValue};
                        saveDataList.add(saveDataTmp);
                    }
                    String nowSizeRet = this.keyMapObjGet(sizeKey);
                    if (nowSizeRet == null) {
                        throw new BatchException("List size not found error");
                    }
                    String[] nowSizeRetSplit = nowSizeRet.split("!");
                    long listSizeLong = new Long(nowSizeRetSplit[0]);
                    String nextSize = ++listSizeLong + "!" + "0";
                    this.keyMapObjPut(sizeKey, nextSize);
                    String[] saveSizeDataTmp = new String[]{sizeKey, nextSize};
                    saveDataList.add(saveSizeDataTmp);
                    for (int idx = 0; idx < saveDataList.size(); ++idx) {
                        Object object;
                        String[] saveData = (String[])saveDataList.get(idx);
                        if (this.moveAdjustmentDataMap != null) {
                            object = this.moveAdjustmentSync;
                            synchronized (object) {
                                if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(saveData[0])) {
                                    this.moveAdjustmentDataMap.remove(saveData[0]);
                                }
                            }
                        }
                        if (!this.workFileMemory) {
                            object = this.lockWorkFileSync;
                            synchronized (object) {
                                if (this.workFileFlushTiming) {
                                    this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(saveData[0]).append(workFileSeq).append(saveData[1]).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                } else {
                                    this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(saveData[0]).append(workFileSeq).append(saveData[1]).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                }
                            }
                        }
                        if (!this.diffDataPoolingFlg) continue;
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + saveData[0] + workFileSeq + saveData[1]);
                            }
                            continue;
                        }
                    }
                    ret = 0;
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("listRPush - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "listRPush - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int listRPush(String listName, String keyNode, String transactionCode) throws BatchException {
        int ret = 2;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(listName.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    String listEndStruct;
                    String pointerKey = listStructPointerPrefix + listName;
                    String sizeKey = listStructSizePrefix + listName;
                    String key = listStructStartPrefix + listName;
                    String[] keyList = new String[3];
                    boolean allDataDeleted = false;
                    keyList[0] = key;
                    keyList[1] = listStructEndPrefix + listName;
                    keyList[2] = listStructDataKeyPrefix + listName;
                    if (!this.containsKeyPair(pointerKey)) {
                        ret = 1;
                        return ret;
                    }
                    String chkListStartStruct = this.getKeyPair(keyList[0]);
                    if (chkListStartStruct.indexOf("(B)") == 0) {
                        allDataDeleted = true;
                    }
                    ArrayList<String[]> saveDataList = new ArrayList<String[]>();
                    String listPointerStruct = this.getKeyPair(pointerKey);
                    if (listPointerStruct != null && listPointerStruct.indexOf("0") == 0 || allDataDeleted) {
                        String pointerLongStr = "1";
                        String listStartStruct = pointerLongStr + "!" + "0";
                        listEndStruct = pointerLongStr + "!" + "0";
                        keyList[2] = keyList[2] + pointerLongStr;
                        this.keyMapObjPut(keyList[0], listStartStruct);
                        this.keyMapObjPut(keyList[1], listEndStruct);
                        String[] saveDataTmp = new String[]{keyList[0], listStartStruct};
                        saveDataList.add(saveDataTmp);
                        saveDataTmp = new String[]{keyList[1], listEndStruct};
                        saveDataList.add(saveDataTmp);
                        String dataValue = keyNode + "!" + "0";
                        this.keyMapObjPut(keyList[2], dataValue);
                        saveDataTmp = new String[]{keyList[2], dataValue};
                        saveDataList.add(saveDataTmp);
                        String leftPointerKey = keyList[2] + "_L";
                        String leftPointerValue = "(B)!0";
                        this.keyMapObjPut(leftPointerKey, leftPointerValue);
                        saveDataTmp = new String[]{leftPointerKey, leftPointerValue};
                        saveDataList.add(saveDataTmp);
                        String rightPointerKey = keyList[2] + "_R";
                        String rightPointerValue = "(B)!0";
                        this.keyMapObjPut(rightPointerKey, rightPointerValue);
                        saveDataTmp = new String[]{rightPointerKey, rightPointerValue};
                        saveDataList.add(saveDataTmp);
                        this.keyMapObjPut(pointerKey, listStartStruct);
                        saveDataTmp = new String[]{pointerKey, listStartStruct};
                        saveDataList.add(saveDataTmp);
                    } else {
                        long pointerLong = Long.parseLong(listPointerStruct.split("!")[0]);
                        listEndStruct = this.getKeyPair(keyList[1]);
                        String nowEndDataPointer = listEndStruct.split("!")[0];
                        String nowEndDataKey = keyList[2] + nowEndDataPointer;
                        String newEndDataKey = keyList[2] + ++pointerLong;
                        String dataValue = keyNode + "!" + "0";
                        this.keyMapObjPut(newEndDataKey, dataValue);
                        String[] saveDataTmp = new String[]{newEndDataKey, dataValue};
                        saveDataList.add(saveDataTmp);
                        String leftPointerKey = newEndDataKey + "_L";
                        String leftPointerValue = nowEndDataPointer + "!" + "0";
                        this.keyMapObjPut(leftPointerKey, leftPointerValue);
                        saveDataTmp = new String[]{leftPointerKey, leftPointerValue};
                        saveDataList.add(saveDataTmp);
                        String rightPointerKey = newEndDataKey + "_R";
                        String rightPointerValue = "(B)!0";
                        this.keyMapObjPut(rightPointerKey, rightPointerValue);
                        saveDataTmp = new String[]{rightPointerKey, rightPointerValue};
                        saveDataList.add(saveDataTmp);
                        String endDataNewStructValue = pointerLong + "!" + "0";
                        this.keyMapObjPut(keyList[1], endDataNewStructValue);
                        saveDataTmp = new String[]{keyList[1], endDataNewStructValue};
                        saveDataList.add(saveDataTmp);
                        String beforEndDataRightStructKey = nowEndDataKey + "_R";
                        String beforEndDataRightStructValue = pointerLong + "!" + "0";
                        this.keyMapObjPut(beforEndDataRightStructKey, beforEndDataRightStructValue);
                        saveDataTmp = new String[]{beforEndDataRightStructKey, beforEndDataRightStructValue};
                        saveDataList.add(saveDataTmp);
                        this.keyMapObjPut(pointerKey, beforEndDataRightStructValue);
                        saveDataTmp = new String[]{pointerKey, beforEndDataRightStructValue};
                        saveDataList.add(saveDataTmp);
                    }
                    String nowSizeRet = this.keyMapObjGet(sizeKey);
                    if (nowSizeRet == null) {
                        throw new BatchException("List size not found error");
                    }
                    String[] nowSizeRetSplit = nowSizeRet.split("!");
                    long listSizeLong = new Long(nowSizeRetSplit[0]);
                    String nextSize = ++listSizeLong + "!" + "0";
                    this.keyMapObjPut(sizeKey, nextSize);
                    String[] saveSizeDataTmp = new String[]{sizeKey, nextSize};
                    saveDataList.add(saveSizeDataTmp);
                    for (int idx = 0; idx < saveDataList.size(); ++idx) {
                        Object object;
                        String[] saveData = (String[])saveDataList.get(idx);
                        if (this.moveAdjustmentDataMap != null) {
                            object = this.moveAdjustmentSync;
                            synchronized (object) {
                                if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(saveData[0])) {
                                    this.moveAdjustmentDataMap.remove(saveData[0]);
                                }
                            }
                        }
                        if (!this.workFileMemory) {
                            object = this.lockWorkFileSync;
                            synchronized (object) {
                                if (this.workFileFlushTiming) {
                                    this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(saveData[0]).append(workFileSeq).append(saveData[1]).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                } else {
                                    this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(saveData[0]).append(workFileSeq).append(saveData[1]).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                }
                            }
                        }
                        if (!this.diffDataPoolingFlg) continue;
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + saveData[0] + workFileSeq + saveData[1]);
                            }
                            continue;
                        }
                    }
                    ret = 0;
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("listLPush - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "listLPush - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    public String listGetData(String listName, long index, String leftPointer, String transactionCode) throws BatchException {
        String ret = null;
        if (!this.blocking) {
            try {
                String pointerKey = listStructPointerPrefix + listName;
                if (!this.containsKeyPair(pointerKey)) {
                    return ret;
                }
                String listDataKey = null;
                if (leftPointer == null) {
                    String listStartStruct = this.getKeyPair(listStructStartPrefix + listName);
                    String keyPrefix = listStructDataKeyPrefix + listName;
                    listDataKey = keyPrefix + listStartStruct.split("!")[0];
                    int createKeyIdx = 1;
                    while ((long)createKeyIdx <= index) {
                        String rightDataPointer = this.getKeyPair(listDataKey + "_R");
                        if (rightDataPointer == null) {
                            return null;
                        }
                        listDataKey = keyPrefix + rightDataPointer.split("!")[0];
                        ++createKeyIdx;
                    }
                } else {
                    String keyPrefix = listStructDataKeyPrefix + listName;
                    String rightDataPointer = this.getKeyPair(keyPrefix + leftPointer + "_R");
                    if (rightDataPointer == null) {
                        String listStartStruct = this.getKeyPair(listStructStartPrefix + listName);
                        listDataKey = keyPrefix + listStartStruct.split("!")[0];
                        int createKeyIdx = 1;
                        while ((long)createKeyIdx <= index) {
                            rightDataPointer = this.getKeyPair(listDataKey + "_R");
                            if (rightDataPointer == null) {
                                return null;
                            }
                            listDataKey = keyPrefix + rightDataPointer.split("!")[0];
                            ++createKeyIdx;
                        }
                    } else {
                        listDataKey = keyPrefix + rightDataPointer.split("!")[0];
                    }
                }
                return this.getKeyPair(listDataKey);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("listGetData - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "listGetData - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listLPop(String listName, String transactionCode) throws BatchException {
        String ret = null;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(listName.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    String pointerKey = listStructPointerPrefix + listName;
                    String sizeKey = listStructSizePrefix + listName;
                    String key = listStructStartPrefix + listName;
                    String[] keyList = new String[]{key, listStructEndPrefix + listName, listStructDataKeyPrefix + listName};
                    if (!this.containsKeyPair(pointerKey)) {
                        ret = null;
                        return ret;
                    }
                    String listStartStruct = this.getKeyPair(keyList[0]);
                    if (listStartStruct.indexOf("(B)") == 0) {
                        return null;
                    }
                    String nowStartDataPointer = listStartStruct.split("!")[0];
                    String nowStartDataKey = keyList[2] + nowStartDataPointer;
                    ret = this.getKeyPair(nowStartDataKey);
                    if (ret == null) {
                        return null;
                    }
                    String nowStartDataRightPointerKey = nowStartDataKey + "_R";
                    String nowStartDataRightPointer = this.getKeyPair(nowStartDataRightPointerKey);
                    String[] saveDataTmp = null;
                    ArrayList<String[]> saveDataList = new ArrayList<String[]>();
                    if (nowStartDataRightPointer != null && nowStartDataRightPointer.indexOf("(B)") != 0) {
                        this.keyMapObjPut(keyList[0], nowStartDataRightPointer);
                        saveDataTmp = new String[]{keyList[0], nowStartDataRightPointer};
                        saveDataList.add(saveDataTmp);
                        String[] newStartDataPointer = nowStartDataRightPointer.split("!");
                        String newStartDataLeftPointerKey = keyList[2] + newStartDataPointer[0] + "_L";
                        String newStartDataLeftPointerValue = "(B)!0";
                        this.keyMapObjPut(newStartDataLeftPointerKey, newStartDataLeftPointerValue);
                        saveDataTmp = new String[]{newStartDataLeftPointerKey, newStartDataLeftPointerValue};
                        saveDataList.add(saveDataTmp);
                    } else {
                        String newStartStructValue = "(B)!0";
                        this.keyMapObjPut(keyList[0], newStartStructValue);
                        saveDataTmp = new String[]{keyList[0], newStartStructValue};
                        saveDataList.add(saveDataTmp);
                        String newEndStructValue = "(B)!0";
                        this.keyMapObjPut(keyList[1], newEndStructValue);
                        saveDataTmp = new String[]{keyList[1], newEndStructValue};
                        saveDataList.add(saveDataTmp);
                    }
                    String nowSizeRet = this.keyMapObjGet(sizeKey);
                    if (nowSizeRet == null) {
                        throw new BatchException("List size not found error");
                    }
                    String[] nowSizeRetSplit = nowSizeRet.split("!");
                    long listSizeLong = new Long(nowSizeRetSplit[0]);
                    String nextSize = --listSizeLong + "!" + "0";
                    this.keyMapObjPut(sizeKey, nextSize);
                    saveDataTmp = new String[]{sizeKey, nextSize};
                    saveDataList.add(saveDataTmp);
                    for (int idx = 0; idx < saveDataList.size(); ++idx) {
                        Object object;
                        String[] saveData = (String[])saveDataList.get(idx);
                        if (this.moveAdjustmentDataMap != null) {
                            object = this.moveAdjustmentSync;
                            synchronized (object) {
                                if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(saveData[0])) {
                                    this.moveAdjustmentDataMap.remove(saveData[0]);
                                }
                            }
                        }
                        if (!this.workFileMemory) {
                            object = this.lockWorkFileSync;
                            synchronized (object) {
                                if (this.workFileFlushTiming) {
                                    this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(saveData[0]).append(workFileSeq).append(saveData[1]).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                } else {
                                    this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(saveData[0]).append(workFileSeq).append(saveData[1]).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                }
                            }
                        }
                        if (!this.diffDataPoolingFlg) continue;
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + saveData[0] + workFileSeq + saveData[1]);
                            }
                            continue;
                        }
                    }
                    this.removeKeyPair(nowStartDataKey, transactionCode);
                    this.removeKeyPair(nowStartDataRightPointerKey, transactionCode);
                    this.removeKeyPair(nowStartDataKey + "_L", transactionCode);
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("listLPop - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "listLPop - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listRPop(String listName, String transactionCode) throws BatchException {
        String ret = null;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(listName.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    String pointerKey = listStructPointerPrefix + listName;
                    String sizeKey = listStructSizePrefix + listName;
                    String key = listStructStartPrefix + listName;
                    String[] keyList = new String[]{key, listStructEndPrefix + listName, listStructDataKeyPrefix + listName};
                    if (!this.containsKeyPair(pointerKey)) {
                        ret = null;
                        return ret;
                    }
                    String listStartStruct = this.getKeyPair(keyList[0]);
                    if (listStartStruct.indexOf("(B)") == 0) {
                        return null;
                    }
                    String listEndStruct = this.getKeyPair(keyList[1]);
                    String nowEndDataPointer = listEndStruct.split("!")[0];
                    String nowEndDataKey = keyList[2] + nowEndDataPointer;
                    ret = this.getKeyPair(nowEndDataKey);
                    if (ret == null) {
                        return null;
                    }
                    String nowEndDataLeftPointerKey = nowEndDataKey + "_L";
                    String nowEndDataLeftPointer = this.getKeyPair(nowEndDataLeftPointerKey);
                    String[] saveDataTmp = null;
                    ArrayList<String[]> saveDataList = new ArrayList<String[]>();
                    if (nowEndDataLeftPointer != null && nowEndDataLeftPointer.indexOf("(B)") != 0) {
                        this.keyMapObjPut(keyList[1], nowEndDataLeftPointer);
                        saveDataTmp = new String[]{keyList[1], nowEndDataLeftPointer};
                        saveDataList.add(saveDataTmp);
                        String[] newEndDataPointer = nowEndDataLeftPointer.split("!");
                        String newEndDataRightPointerKey = keyList[2] + newEndDataPointer[0] + "_R";
                        String newEndDataRightPointerValue = "(B)!0";
                        this.keyMapObjPut(newEndDataRightPointerKey, newEndDataRightPointerValue);
                        saveDataTmp = new String[]{newEndDataRightPointerKey, newEndDataRightPointerValue};
                        saveDataList.add(saveDataTmp);
                    } else {
                        String newStartStructValue = "(B)!0";
                        this.keyMapObjPut(keyList[0], newStartStructValue);
                        saveDataTmp = new String[]{keyList[0], newStartStructValue};
                        saveDataList.add(saveDataTmp);
                        String newEndStructValue = "(B)!0";
                        this.keyMapObjPut(keyList[1], newEndStructValue);
                        saveDataTmp = new String[]{keyList[1], newEndStructValue};
                        saveDataList.add(saveDataTmp);
                    }
                    String nowSizeRet = this.keyMapObjGet(sizeKey);
                    if (nowSizeRet == null) {
                        throw new BatchException("List size not found error");
                    }
                    String[] nowSizeRetSplit = nowSizeRet.split("!");
                    long listSizeLong = new Long(nowSizeRetSplit[0]);
                    String nextSize = --listSizeLong + "!" + "0";
                    this.keyMapObjPut(sizeKey, nextSize);
                    saveDataTmp = new String[]{sizeKey, nextSize};
                    saveDataList.add(saveDataTmp);
                    for (int idx = 0; idx < saveDataList.size(); ++idx) {
                        Object object;
                        String[] saveData = (String[])saveDataList.get(idx);
                        if (this.moveAdjustmentDataMap != null) {
                            object = this.moveAdjustmentSync;
                            synchronized (object) {
                                if (this.moveAdjustmentDataMap != null && this.moveAdjustmentDataMap.containsKey(saveData[0])) {
                                    this.moveAdjustmentDataMap.remove(saveData[0]);
                                }
                            }
                        }
                        if (!this.workFileMemory) {
                            object = this.lockWorkFileSync;
                            synchronized (object) {
                                if (this.workFileFlushTiming) {
                                    this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(saveData[0]).append(workFileSeq).append(saveData[1]).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                } else {
                                    this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(saveData[0]).append(workFileSeq).append(saveData[1]).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                }
                            }
                        }
                        if (!this.diffDataPoolingFlg) continue;
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("+" + workFileSeq + saveData[0] + workFileSeq + saveData[1]);
                            }
                            continue;
                        }
                    }
                    this.removeKeyPair(nowEndDataKey, transactionCode);
                    this.removeKeyPair(nowEndDataLeftPointerKey, transactionCode);
                    this.removeKeyPair(nowEndDataKey + "_R", transactionCode);
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("listRPop - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "listRPop - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listLen(String listName, String transactionCode) throws BatchException {
        String ret = null;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(listName.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    String pointerKey = listStructPointerPrefix + listName;
                    String sizeKey = listStructSizePrefix + listName;
                    if (!this.containsKeyPair(pointerKey)) {
                        ret = null;
                        return ret;
                    }
                    String nowSizeRet = this.keyMapObjGet(sizeKey);
                    if (nowSizeRet == null) {
                        throw new BatchException("List size not found error");
                    }
                    String[] nowSizeRetSplit = nowSizeRet.split("!");
                    ret = nowSizeRetSplit[0];
                }
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("listLen - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "listLen - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeKeyPair(String key, String transactionCode) throws BatchException {
        String ret = null;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(key.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    Object object;
                    ret = this.keyMapObjGet(key);
                    if (this.moveAdjustmentDataMap != null) {
                        object = this.moveAdjustmentSync;
                        synchronized (object) {
                            if (this.moveAdjustmentDataMap != null) {
                                this.moveAdjustmentDataMap.put(key, "");
                            }
                        }
                    }
                    if (ret == null) {
                        return null;
                    }
                    this.keyMapObjRemove(key);
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            if (this.workFileFlushTiming) {
                                this.bw.write(new StringBuilder(160).append("-").append(workFileSeq).append(key).append(workFileSeq).append(" ").append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                SystemUtil.diskAccessSync(this.bw);
                                this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                            } else {
                                this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("-").append(workFileSeq).append(key).append(workFileSeq).append(" ").append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                            }
                        }
                    }
                    if (this.diffDataPoolingFlg) {
                        object = this.diffSync;
                        synchronized (object) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("-" + workFileSeq + key);
                            }
                        }
                    }
                }
                this.writeMapFileFlg = true;
            }
            catch (BatchException be) {
                throw be;
            }
            catch (Exception e) {
                logger.error("removeKeyPair - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "removeKeyPair - Error[" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTagPair(String tag, String key, String transactionCode) throws BatchException {
        if (!this.blocking) {
            try {
                String keyStrs = null;
                int counter = 0;
                boolean appendFlg = true;
                String tagCnv = null;
                Object lastTagCnv = null;
                int dataPutCounter = 0;
                int dataRegistTarget = -1;
                String dataRegistTargetTagStr = null;
                boolean firsrtRegist = true;
                key = key.split("!")[0] + "!" + "0";
                dataPutCounter = counter = (key.hashCode() << 1 >>> 1) % 300 * 500000;
                Integer n = this.tagSetParallelSyncObjs[(tag.hashCode() << 1 >>> 1) % 300];
                synchronized (n) {
                    while (true) {
                        if (this.containsKeyPair(tagCnv = tagStartStr + tag + "_" + new Integer(counter).toString() + tagEndStr)) {
                            String checkStr;
                            firsrtRegist = false;
                            keyStrs = this.getKeyPair(tagCnv);
                            String[] workStrs = keyStrs.split("!");
                            if ((keyStrs = workStrs[0]).indexOf((checkStr = key.split("!")[0]) + tagKeySep) == 0 || keyStrs.indexOf(tagKeySep + checkStr + tagKeySep) != -1) {
                                appendFlg = false;
                            } else if (keyStrs.indexOf(checkStr) != -1) {
                                String[] tagKeysList = keyStrs.split(tagKeySep);
                                for (int tagKeysListIdx = 0; tagKeysListIdx < tagKeysList.length; ++tagKeysListIdx) {
                                    if (!tagKeysList[tagKeysListIdx].equals(checkStr)) continue;
                                    appendFlg = false;
                                    break;
                                }
                            } else if (dataRegistTarget == -1 && keyStrs.getBytes().length + tagKeySep.getBytes().length + key.getBytes().length + 16 < ImdstDefine.tagValueAppendMaxSize) {
                                dataRegistTarget = counter;
                                dataRegistTargetTagStr = keyStrs;
                            }
                            if (!appendFlg) {
                                break;
                            }
                        } else {
                            if (counter > (key.hashCode() << 1 >>> 1) % 300 * 500000) {
                                dataPutCounter = counter - 1;
                                break;
                            }
                            dataPutCounter = counter;
                            break;
                        }
                        ++counter;
                    }
                    if (appendFlg) {
                        if (firsrtRegist) {
                            this.setKeyPair(tagCnv, key, transactionCode);
                        } else if (dataRegistTarget != -1) {
                            tagCnv = tagStartStr + tag + "_" + dataRegistTarget + tagEndStr;
                            dataRegistTargetTagStr = dataRegistTargetTagStr.equals("*") ? key : dataRegistTargetTagStr + tagKeySep + key;
                            this.setKeyPair(tagCnv, dataRegistTargetTagStr, transactionCode);
                        } else if (keyStrs.getBytes().length + tagKeySep.getBytes().length + key.getBytes().length + 16 >= ImdstDefine.tagValueAppendMaxSize) {
                            ++counter;
                            tagCnv = tagStartStr + tag + "_" + (dataPutCounter + 1) + tagEndStr;
                            this.setKeyPair(tagCnv, key, transactionCode);
                        } else {
                            tagCnv = tagStartStr + tag + "_" + dataPutCounter + tagEndStr;
                            keyStrs = keyStrs.equals("*") ? key : keyStrs + tagKeySep + key;
                            this.setKeyPair(tagCnv, keyStrs, transactionCode);
                        }
                    }
                }
            }
            catch (BatchException be) {
                logger.error("setTagPair - InnerError", be);
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("setTagPair - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "setTagPair - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTargetTagInKey(String tag, String key, String transactionCode) throws BatchException {
        boolean ret = false;
        if (!this.blocking) {
            try {
                String keyStrs = null;
                int counter = 0;
                boolean appendFlg = true;
                String tagCnv = null;
                Object lastTagCnv = null;
                boolean dataPutCounter = false;
                boolean firsrtRegist = true;
                String targetKey = key;
                key = key.split("!")[0] + "!" + "0";
                counter = (key.hashCode() << 1 >>> 1) % 300 * 500000;
                Integer n = this.tagSetParallelSyncObjs[(tag.hashCode() << 1 >>> 1) % 300];
                synchronized (n) {
                    while (this.containsKeyPair(tagCnv = tagStartStr + tag + "_" + new Integer(counter).toString() + tagEndStr)) {
                        firsrtRegist = false;
                        keyStrs = this.getKeyPair(tagCnv);
                        String[] workStrs = keyStrs.split("!");
                        if ((keyStrs = workStrs[0]).indexOf(targetKey) != -1) {
                            String[] matchKeys = keyStrs.split(tagKeySep);
                            for (int matchKeysIdx = 0; matchKeysIdx < matchKeys.length; ++matchKeysIdx) {
                                if (!matchKeys[matchKeysIdx].equals(targetKey)) continue;
                                StringBuilder setNewTagKeysBuf = new StringBuilder();
                                String sep = "";
                                for (int matchKeysIdx2 = 0; matchKeysIdx2 < matchKeys.length; ++matchKeysIdx2) {
                                    if (matchKeysIdx2 == matchKeysIdx) continue;
                                    setNewTagKeysBuf.append(sep);
                                    setNewTagKeysBuf.append(matchKeys[matchKeysIdx2]);
                                    sep = tagKeySep;
                                }
                                if (setNewTagKeysBuf.length() > 0) {
                                    setNewTagKeysBuf.append("!");
                                    setNewTagKeysBuf.append("0");
                                } else {
                                    setNewTagKeysBuf.append("*");
                                    setNewTagKeysBuf.append("!");
                                    setNewTagKeysBuf.append("0");
                                }
                                this.setKeyPair(tagCnv, setNewTagKeysBuf.toString(), transactionCode);
                                ret = true;
                                break;
                            }
                            if (ret) break;
                        }
                        ++counter;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("removeTargetTagInKey - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(12, "removeTargetTagInKey - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    public String getTagPair(String tag) {
        String keyStrs = "";
        String[] setTimeSplitWork = null;
        boolean isMatch = false;
        StringBuilder tmpBuf = new StringBuilder(2048);
        String tmpStr = null;
        String tmpSep = "";
        String lastSetTime = "";
        String counterSep = "";
        StringBuilder ret = new StringBuilder();
        if (!this.blocking) {
            int counter = 0;
            for (int idx = 0; idx < 150000000; idx += 500000) {
                keyStrs = null;
                setTimeSplitWork = null;
                isMatch = false;
                tmpBuf = new StringBuilder(2048);
                tmpStr = null;
                tmpSep = "";
                counter = idx;
                while (true) {
                    String tagCnv;
                    if (this.containsKeyPair(tagCnv = tagStartStr + tag + "_" + counter + tagEndStr)) {
                        tmpStr = this.getKeyPair(tagCnv);
                        if (tmpStr != null && !tmpStr.split("!")[0].equals("*")) {
                            isMatch = true;
                            tmpBuf.append(tmpSep);
                            setTimeSplitWork = tmpStr.split("!");
                            if (setTimeSplitWork.length > 1) {
                                lastSetTime = setTimeSplitWork[1];
                            }
                            tmpBuf.append(setTimeSplitWork[0]);
                            tmpSep = tagKeySep;
                        } else if (tmpStr == null || tmpStr.split("!")[0].equals("*")) {
                            if (!isMatch) {
                                keyStrs = null;
                                break;
                            }
                            keyStrs = tmpBuf.toString();
                            break;
                        }
                    } else {
                        if (!isMatch) {
                            keyStrs = null;
                            break;
                        }
                        keyStrs = tmpBuf.toString();
                        break;
                    }
                    ++counter;
                }
                if (keyStrs == null) continue;
                ret.append(counterSep);
                ret.append(keyStrs);
                counterSep = tagKeySep;
            }
        }
        if (ret.toString().equals("")) {
            keyStrs = null;
        } else {
            ret.append("!").append(lastSetTime);
            keyStrs = ret.toString();
        }
        return keyStrs;
    }

    public String getTargetTagIndexList(String tag) {
        String keyIndexList = "";
        String tmpStr = null;
        String tmpSep = "";
        StringBuilder retBuf = new StringBuilder(1024);
        if (!this.blocking) {
            int counter = 0;
            tmpSep = "";
            block0: for (int idx = 0; idx < 150000000; idx += 500000) {
                String tagCnv;
                counter = idx;
                while (this.containsKeyPair(tagCnv = tagStartStr + tag + "_" + counter + tagEndStr)) {
                    tmpStr = this.getKeyPair(tagCnv);
                    if (tmpStr != null && !tmpStr.split("!")[0].equals("*")) {
                        retBuf.append(tmpSep);
                        retBuf.append(counter);
                        tmpSep = tagKeySep;
                        continue block0;
                    }
                    if (tmpStr == null || tmpStr.split("!")[0].equals("*")) continue block0;
                    ++counter;
                }
            }
        }
        if ((keyIndexList = retBuf.toString()) == null || keyIndexList.equals("")) {
            keyIndexList = null;
        }
        return keyIndexList;
    }

    public String getTargetIndexTagPair(String tag, int index) {
        String keyStrs = "";
        String[] setTimeSplitWork = null;
        boolean isMatch = false;
        StringBuilder tmpBuf = new StringBuilder(2048);
        String tmpStr = null;
        String tmpSep = "";
        String lastSetTime = "";
        String counterSep = "";
        StringBuilder ret = new StringBuilder();
        if (!this.blocking) {
            int counter = 0;
            keyStrs = null;
            setTimeSplitWork = null;
            isMatch = false;
            tmpBuf = new StringBuilder(2048);
            tmpStr = null;
            tmpSep = "";
            counter = index;
            while (true) {
                String tagCnv;
                if (this.containsKeyPair(tagCnv = tagStartStr + tag + "_" + counter + tagEndStr)) {
                    tmpStr = this.getKeyPair(tagCnv);
                    if (tmpStr != null && !tmpStr.split("!")[0].equals("*")) {
                        isMatch = true;
                        tmpBuf.append(tmpSep);
                        setTimeSplitWork = tmpStr.split("!");
                        if (setTimeSplitWork.length > 1) {
                            lastSetTime = setTimeSplitWork[1];
                        }
                        tmpBuf.append(setTimeSplitWork[0]);
                        tmpSep = tagKeySep;
                    } else if (tmpStr == null || tmpStr.split("!")[0].equals("*")) {
                        if (!isMatch) {
                            keyStrs = null;
                            break;
                        }
                        keyStrs = tmpBuf.toString();
                        break;
                    }
                } else {
                    if (!isMatch) {
                        keyStrs = null;
                        break;
                    }
                    keyStrs = tmpBuf.toString();
                    break;
                }
                ++counter;
            }
            if (keyStrs != null) {
                ret.append(counterSep);
                ret.append(keyStrs);
                counterSep = tagKeySep;
            }
        }
        keyStrs = ret.toString().equals("") ? null : ret.toString();
        return keyStrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String removeTagRelation(String tag, String transactionCode) throws BatchException {
        String keyStrs = "";
        String[] setTimeSplitWork = null;
        boolean isMatch = false;
        StringBuilder tmpBuf = new StringBuilder(2048);
        String tmpStr = null;
        String tmpSep = "";
        String lastSetTime = "";
        String counterSep = "";
        StringBuilder ret = new StringBuilder();
        try {
            if (!this.blocking) {
                int counter = 0;
                Integer n = this.tagSetParallelSyncObjs[(tag.hashCode() << 1 >>> 1) % 300];
                synchronized (n) {
                    for (int idx = 0; idx < 150000000; idx += 500000) {
                        block10: {
                            String tagCnv;
                            keyStrs = "";
                            setTimeSplitWork = null;
                            isMatch = false;
                            tmpBuf = new StringBuilder(2048);
                            tmpStr = null;
                            tmpSep = "";
                            counter = idx;
                            while (this.containsKeyPair(tagCnv = tagStartStr + tag + "_" + counter + tagEndStr)) {
                                tmpStr = this.removeKeyPair(tagCnv, transactionCode);
                                if (tmpStr != null) {
                                    isMatch = true;
                                    tmpBuf.append(tmpSep);
                                    setTimeSplitWork = tmpStr.split("!");
                                    if (setTimeSplitWork.length > 1) {
                                        lastSetTime = setTimeSplitWork[1];
                                    }
                                    tmpBuf.append(setTimeSplitWork[0]);
                                    tmpSep = tagKeySep;
                                    ++counter;
                                    continue;
                                }
                                keyStrs = !isMatch ? null : tmpBuf.toString();
                                break block10;
                            }
                            keyStrs = !isMatch ? null : tmpBuf.toString();
                        }
                        if (keyStrs == null) continue;
                        ret.append(counterSep);
                        ret.append(keyStrs);
                        counterSep = tagKeySep;
                    }
                }
            }
            if (ret.toString().equals("")) {
                return null;
            }
            ret.append("!").append(lastSetTime);
            return ret.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BatchException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String calcValue(String key, int calcVal, String transactionCode, boolean initCalcValueFlg) throws BatchException {
        String ret = null;
        String data = null;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(key.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    boolean containsKeyRet = this.containsKeyPair(key);
                    if (initCalcValueFlg && !containsKeyRet) {
                        boolean initRet = this.setKeyPairOnlyOnce(key, new String(BASE64EncoderStream.encode((byte[])"0".getBytes())) + "!" + "0", "0");
                        containsKeyRet = initRet ? true : this.containsKeyPair(key);
                    }
                    if (containsKeyRet) {
                        String tmp = this.keyMapObjGet(key);
                        String[] keyNoddes = tmp.split("!");
                        String setDataStr = null;
                        if (tmp != null) {
                            String targetData = keyNoddes[0];
                            if (keyNoddes[0].indexOf(",") != -1) {
                                String[] workSplitData = keyNoddes[0].split(",");
                                targetData = workSplitData[0];
                            }
                            String nowData = new String(BASE64DecoderStream.decode((byte[])targetData.getBytes()));
                            long nowDataLong = 0L;
                            try {
                                nowDataLong = Long.parseLong(nowData);
                                if ((nowDataLong += (long)calcVal) < 0L) {
                                    nowDataLong = 0L;
                                }
                                setDataStr = new Long(nowDataLong).toString();
                            }
                            catch (Exception e) {
                                setDataStr = calcVal > 0 ? new Long(calcVal).toString() : new Long(nowDataLong).toString();
                            }
                            data = keyNoddes.length > 1 ? new String(BASE64EncoderStream.encode((byte[])setDataStr.getBytes())) + "!" + (Long.parseLong(keyNoddes[1]) + 1L) : new String(BASE64EncoderStream.encode((byte[])setDataStr.getBytes())) + "!" + "0";
                        }
                    }
                    if (data != null) {
                        this.keyMapObjPut(key, data);
                        if (!this.workFileMemory) {
                            Object object = this.lockWorkFileSync;
                            synchronized (object) {
                                if (this.workFileFlushTiming) {
                                    this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                } else {
                                    this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                }
                            }
                        }
                        if (this.diffDataPoolingFlg) {
                            Object object = this.diffSync;
                            synchronized (object) {
                                if (this.diffDataPoolingFlg) {
                                    this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + data);
                                }
                            }
                        }
                        this.writeMapFileFlg = true;
                        ret = data.split("!")[0];
                    }
                }
            }
            catch (BatchException be) {
                logger.error("calcValue - InnerError", be);
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("setKeyPair - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "setKeyPair - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendValue(String key, String appendValue, String appendSep, String transactionCode) throws BatchException {
        int ret = -1;
        String data = null;
        if (!this.blocking) {
            try {
                Integer n = this.parallelSyncObjs[(key.hashCode() << 1 >>> 1) % 5000];
                synchronized (n) {
                    boolean containsKeyRet = this.containsKeyPair(key);
                    if (containsKeyRet) {
                        String tmp = this.keyMapObjGet(key);
                        String[] keyNoddes = tmp.split("!");
                        String setDataStr = null;
                        if (tmp != null) {
                            String targetData = keyNoddes[0];
                            if (keyNoddes[0].indexOf(",") != -1) {
                                String[] workSplitData = keyNoddes[0].split(",");
                                targetData = workSplitData[0];
                            }
                            if (targetData.equals("(B)")) {
                                setDataStr = appendValue.equals("(B)") ? appendValue : new String(BASE64DecoderStream.decode((byte[])appendValue.getBytes()));
                            } else {
                                appendSep = appendSep.equals("(B)") ? "" : new String(BASE64DecoderStream.decode((byte[])appendSep.getBytes()));
                                String nowData = new String(BASE64DecoderStream.decode((byte[])targetData.getBytes()));
                                setDataStr = nowData + appendSep + appendValue;
                            }
                            if (ImdstDefine.saveDataMaxSize < setDataStr.getBytes().length) {
                                return 1;
                            }
                            data = keyNoddes.length > 1 ? new String(BASE64EncoderStream.encode((byte[])setDataStr.getBytes())) + "!" + (Long.parseLong(keyNoddes[1]) + 1L) : new String(BASE64EncoderStream.encode((byte[])setDataStr.getBytes())) + "!" + "0";
                        }
                    }
                    if (data != null) {
                        Object object;
                        this.keyMapObjPut(key, data);
                        if (!this.workFileMemory) {
                            object = this.lockWorkFileSync;
                            synchronized (object) {
                                if (this.workFileFlushTiming) {
                                    this.bw.write(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                } else {
                                    this.dataTransactionFileFlushDaemon.addDataTransaction(new StringBuilder(160).append("+").append(workFileSeq).append(key).append(workFileSeq).append(data).append(workFileSeq).append(JavaSystemApi.currentTimeMillis).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                }
                            }
                        }
                        if (this.diffDataPoolingFlg) {
                            object = this.diffSync;
                            synchronized (object) {
                                if (this.diffDataPoolingFlg) {
                                    this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + data);
                                }
                            }
                        }
                        this.writeMapFileFlg = true;
                        ret = 0;
                    }
                }
            }
            catch (BatchException be) {
                logger.error("appendValue - InnerError", be);
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("appendValue - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "appendValue - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
        return ret;
    }

    public boolean containsKeyPair(String key) {
        boolean ret = false;
        if (!this.blocking && key != null && this.keyMapObj != null) {
            ret = this.keyMapObj.containsKey(key);
        }
        return ret;
    }

    public boolean containsTagPair(String tag) {
        boolean ret = false;
        if (!this.blocking) {
            String tagCnv;
            for (int idx = 0; idx < 150000000 && !(ret = this.containsKeyPair(tagCnv = tagStartStr + tag + "_" + idx + tagEndStr)); idx += 500000) {
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String locking(String key, String transactionCode, int lockingTime) throws BatchException {
        block17: {
            if (!this.blocking) {
                try {
                    String saveTransactionStr = null;
                    Object object = this.lockKeyLock;
                    synchronized (object) {
                        if (this.containsKeyPair(key)) {
                            return null;
                        }
                        saveTransactionStr = lockingTime == 0 ? transactionCode + this.lockKeyTimeSep + new Long(Long.MAX_VALUE).toString() : transactionCode + this.lockKeyTimeSep + new Long(JavaSystemApi.currentTimeMillis + (long)(lockingTime * 1000)).toString();
                        this.keyMapObjPut(key, saveTransactionStr);
                    }
                    this.writeMapFileFlg = true;
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            if (this.workFileFlushTiming) {
                                this.bw.write("+" + workFileSeq + key + workFileSeq + saveTransactionStr + workFileSeq + JavaSystemApi.currentTimeMillis + workFileSeq + workFileEndPoint + "\n");
                                SystemUtil.diskAccessSync(this.bw);
                                this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                            } else {
                                this.dataTransactionFileFlushDaemon.addDataTransaction("+" + workFileSeq + key + workFileSeq + saveTransactionStr + workFileSeq + JavaSystemApi.currentTimeMillis + workFileSeq + workFileEndPoint + "\n");
                            }
                        }
                    }
                    if (!this.diffDataPoolingFlg) break block17;
                    object = this.diffSync;
                    synchronized (object) {
                        if (this.diffDataPoolingFlg) {
                            this.diffDataPoolingListForFileBase.add("+" + workFileSeq + key + workFileSeq + saveTransactionStr);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("locking - Error");
                    this.blocking = true;
                    StatusUtil.setStatusAndMessage(1, "locking - Error [" + e.getMessage() + "]");
                    throw new BatchException(e);
                }
            }
        }
        return transactionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeLock(String key, String transactionCode) throws BatchException {
        String ret;
        block18: {
            ret = null;
            if (!this.blocking) {
                try {
                    Object object = this.lockKeyLock;
                    synchronized (object) {
                        if (!this.containsKeyPair(key)) {
                            return transactionCode;
                        }
                        if (!this.keyMapObjGet(key).split(this.lockKeyTimeSep)[0].equals(transactionCode)) {
                            return null;
                        }
                        ret = ((String)this.keyMapObj.remove(key)).split(this.lockKeyTimeSep)[0];
                        this.keyMapObj.setKLastDataChangeTime(JavaSystemApi.currentTimeMillis);
                        this.lastAccess = JavaSystemApi.currentTimeMillis;
                    }
                    this.writeMapFileFlg = true;
                    if (!this.workFileMemory) {
                        object = this.lockWorkFileSync;
                        synchronized (object) {
                            if (this.workFileFlushTiming) {
                                this.bw.write("-" + workFileSeq + key + workFileSeq + " " + workFileSeq + JavaSystemApi.currentTimeMillis + workFileSeq + workFileEndPoint + "\n");
                                SystemUtil.diskAccessSync(this.bw);
                                this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                            } else {
                                this.dataTransactionFileFlushDaemon.addDataTransaction("-" + workFileSeq + key + workFileSeq + " " + workFileSeq + JavaSystemApi.currentTimeMillis + workFileSeq + workFileEndPoint + "\n");
                            }
                        }
                    }
                    if (!this.diffDataPoolingFlg) break block18;
                    object = this.diffSync;
                    synchronized (object) {
                        if (this.diffDataPoolingFlg) {
                            this.diffDataPoolingListForFileBase.add("-" + workFileSeq + key);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("removeLock - Error");
                    this.blocking = true;
                    StatusUtil.setStatusAndMessage(1, "removeLock - Error[" + e.getMessage() + "]");
                    throw new BatchException(e);
                }
            }
        }
        return ret;
    }

    public boolean isLock(String key) {
        return this.containsKeyPair(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockedTransactionCode(String key) {
        Object object = this.lockKeyLock;
        synchronized (object) {
            try {
                if (!this.containsKeyPair(key)) {
                    return null;
                }
                return this.keyMapObjGet(key).split(this.lockKeyTimeSep)[0];
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoLockRelease(long time) throws BatchException {
        Object object = this.setKeyLock;
        synchronized (object) {
            Object object2 = this.lockKeyLock;
            synchronized (object2) {
                try {
                    int idx;
                    Object key = null;
                    Set set = this.keyMapObj.entrySet();
                    Iterator iterator = set.iterator();
                    String[] keyList = new String[this.keyMapObj.size()];
                    for (idx = 0; idx < keyList.length; ++idx) {
                        Map.Entry map = (Map.Entry)iterator.next();
                        keyList[idx] = (String)map.getKey();
                    }
                    for (idx = 0; idx < keyList.length; ++idx) {
                        Object object3;
                        String transactionLine = (String)this.keyMapObj.get(keyList[idx]);
                        String[] codeList = transactionLine.split(this.lockKeyTimeSep);
                        if (Long.parseLong(codeList[1]) >= time) continue;
                        this.keyMapObj.remove(keyList[idx]);
                        this.writeMapFileFlg = true;
                        if (!this.workFileMemory) {
                            object3 = this.lockWorkFileSync;
                            synchronized (object3) {
                                if (this.workFileFlushTiming) {
                                    this.bw.write("-" + workFileSeq + keyList[idx] + workFileSeq + " " + workFileSeq + JavaSystemApi.currentTimeMillis + workFileSeq + workFileEndPoint + "\n");
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                } else {
                                    this.dataTransactionFileFlushDaemon.addDataTransaction("-" + workFileSeq + keyList[idx] + workFileSeq + " " + workFileSeq + JavaSystemApi.currentTimeMillis + workFileSeq + workFileEndPoint + "\n");
                                }
                            }
                        }
                        if (!this.diffDataPoolingFlg) continue;
                        object3 = this.diffSync;
                        synchronized (object3) {
                            if (this.diffDataPoolingFlg) {
                                this.diffDataPoolingListForFileBase.add("-" + workFileSeq + keyList[idx]);
                            }
                            continue;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("autoLockRelease - Error");
                    this.blocking = true;
                    StatusUtil.setStatusAndMessage(1, "autoLockRelease - Error[" + e.getMessage() + "]");
                    throw new BatchException(e);
                }
            }
        }
    }

    private void keyMapObjPut(String key, String val) throws BatchException {
        try {
            if (val.length() < this.putValueMaxSize && key != null && val != null) {
                this.keyMapObj.put(key, val);
                this.keyMapObj.setKLastDataChangeTime(JavaSystemApi.currentTimeMillis);
            }
            this.lastAccess = JavaSystemApi.currentTimeMillis;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
    }

    private void setLastDataChangeTime() {
        this.keyMapObj.setKLastDataChangeTime(JavaSystemApi.currentTimeMillis);
    }

    private void keyMapObjPutNoChange(String key, String val) {
        if (val.length() < this.putValueMaxSize && key != null && val != null) {
            this.keyMapObj.put(key, val);
        }
        this.lastAccess = JavaSystemApi.currentTimeMillis;
    }

    private void keyMapObjPutSetTime(String key, String val, long execTime) {
        if (val.length() < this.putValueMaxSize && key != null && val != null) {
            this.keyMapObj.put(key, val);
            this.keyMapObj.setKLastDataChangeTime(execTime);
        }
        this.lastAccess = JavaSystemApi.currentTimeMillis;
    }

    private String keyMapObjGet(String key) throws BatchException {
        try {
            this.lastAccess = JavaSystemApi.currentTimeMillis;
            if (key != null) {
                return (String)this.keyMapObj.get(key);
            }
            return null;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
    }

    private long keyMapObjDataPointGet(String key) throws BatchException {
        try {
            this.lastAccess = JavaSystemApi.currentTimeMillis;
            if (key != null) {
                return this.keyMapObj.dataPointGet(key);
            }
            return -1L;
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
    }

    private void keyMapObjRemove(String key) throws BatchException {
        try {
            if (key != null) {
                this.keyMapObj.remove(key);
                this.keyMapObj.setKLastDataChangeTime(JavaSystemApi.currentTimeMillis);
                this.lastAccess = JavaSystemApi.currentTimeMillis;
            }
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
    }

    private void keyMapObjRemoveNoChange(String key) {
        if (key != null) {
            this.keyMapObj.remove(key);
            this.lastAccess = JavaSystemApi.currentTimeMillis;
        }
    }

    private void keyMapObjRemoveSetTime(String key, long execTime) {
        if (key != null) {
            this.keyMapObj.remove(key);
            this.keyMapObj.setKLastDataChangeTime(execTime);
            this.lastAccess = JavaSystemApi.currentTimeMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diffDataMode(boolean flg, PrintWriter pw) {
        Object object = this.diffSync;
        synchronized (object) {
            if (flg) {
                this.myDiffModeOperationStatus = 2;
                this.diffDataPoolingListForFileBase = new FileBaseDataList(this.nodeKeyMapFilePath + ".difftmplist");
            } else {
                if (this.diffDataPoolingListForFileBase != null) {
                    this.diffDataPoolingListForFileBase.clear();
                    this.diffDataPoolingListForFileBase = null;
                }
                this.myDiffModeOperationStatus = 1;
            }
            this.diffDataPoolingFlg = flg;
            try {
                pw.println("1");
                pw.flush();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diffDataMode(boolean flg) {
        Object object = this.diffSync;
        synchronized (object) {
            if (flg) {
                this.myDiffModeOperationStatus = 2;
                this.diffDataPoolingListForFileBase = new FileBaseDataList(this.nodeKeyMapFilePath + ".difftmplist");
            } else {
                if (this.diffDataPoolingListForFileBase != null) {
                    this.diffDataPoolingListForFileBase.clear();
                    this.diffDataPoolingListForFileBase = null;
                }
                this.myDiffModeOperationStatus = 1;
            }
            this.diffDataPoolingFlg = flg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diffDataModeOff() {
        Object object = this.diffSync;
        synchronized (object) {
            if (this.diffDataPoolingListForFileBase != null) {
                this.diffDataPoolingListForFileBase.clear();
                this.diffDataPoolingListForFileBase = null;
            }
            this.myDiffModeOperationStatus = 1;
            this.diffDataPoolingFlg = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputKeyData2Stream(PrintWriter pw) throws BatchException {
        if (!this.blocking) {
            try {
                Object object = this.poolKeyLock;
                synchronized (object) {
                    Set entrySet = this.keyMapObj.entrySet();
                    Iterator entryIte = entrySet.iterator();
                    long counter = 0L;
                    boolean sendCounter = false;
                    while (entryIte.hasNext()) {
                        Map.Entry obj = (Map.Entry)entryIte.next();
                        if (obj == null) continue;
                        String key = null;
                        key = (String)obj.getKey();
                        try {
                            String decodeKey = new String(BASE64DecoderStream.decode((byte[])key.getBytes()));
                            if (decodeKey.indexOf("{imdst_") == 0) continue;
                            pw.println(key);
                            pw.flush();
                        }
                        catch (Exception ee) {}
                    }
                    pw.println("-1");
                    pw.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputKeyMapObj2Stream(PrintWriter pw) throws BatchException {
        if (!this.blocking) {
            try {
                Object object = this.poolKeyLock;
                synchronized (object) {
                    this.myOperationStatus = 3;
                    logger.info("outputKeyMapObj2Stream - synchronized - start");
                    String allDataSep = "";
                    StringBuilder allDataBuf = new StringBuilder(8192);
                    Set entrySet = this.keyMapObj.entrySet();
                    int printLineCount = 0;
                    int maxLineCount = new Double((double)JavaSystemApi.getRuntimeFreeMem("") * 0.3 / (double)(ImdstDefine.saveDataMaxSize / 50)).intValue();
                    if (maxLineCount > 100000) {
                        maxLineCount = 100000;
                    }
                    if (ImdstDefine.lowSpecDataNode && maxLineCount > ImdstDefine.lowSpecDataNodeSendDataCount) {
                        maxLineCount = ImdstDefine.lowSpecDataNodeSendDataCount;
                    }
                    if (entrySet.size() > 0) {
                        if (maxLineCount == 0) {
                            maxLineCount = 1;
                        }
                        printLineCount = new Double(entrySet.size() / maxLineCount).intValue();
                        if (entrySet.size() % maxLineCount > 0) {
                            ++printLineCount;
                        }
                    }
                    pw.println(printLineCount);
                    pw.flush();
                    Iterator entryIte = entrySet.iterator();
                    long counter = 0L;
                    int sendCounter = 0;
                    if (this.keyMapObj.memoryMode) {
                        String lastSendStr;
                        while (entryIte.hasNext()) {
                            Map.Entry obj;
                            if (this.outputDataStopSignal) {
                                logger.info("outputKeyMapObj2Stream - Stop Signal");
                                break;
                            }
                            if (counter % 1000L == 0L) {
                                logger.info("outputKeyMapObj2Stream - output count[" + counter + "]");
                            }
                            if ((obj = (Map.Entry)entryIte.next()) == null) continue;
                            String key = null;
                            key = (String)obj.getKey();
                            allDataBuf.append(allDataSep);
                            allDataBuf.append(key);
                            allDataBuf.append(workFileSeq);
                            allDataBuf.append(this.keyMapObjGet(key));
                            allDataSep = ";";
                            if (++counter <= (long)(maxLineCount - 1)) continue;
                            ++sendCounter;
                            pw.println(allDataBuf.toString());
                            pw.flush();
                            allDataBuf = new StringBuilder(8192);
                            if (ImdstDefine.lowSpecDataNode) {
                                Thread.sleep(50L);
                            }
                            counter = 0L;
                            if (sendCounter % 10 != 0) continue;
                            Thread.sleep(3000L);
                        }
                        if (!(lastSendStr = allDataBuf.toString()).equals("")) {
                            pw.println(lastSendStr);
                            pw.flush();
                        }
                        allDataBuf = null;
                        pw.println("-1");
                        pw.flush();
                    } else {
                        ArrayList<Long> keyList = new ArrayList<Long>();
                        HashMap<Long, String> pointToKeyMap = new HashMap<Long, String>();
                        while (entryIte.hasNext()) {
                            int idx;
                            Map.Entry obj;
                            if (this.outputDataStopSignal) {
                                logger.info("outputKeyMapObj2Stream - Stop Signal");
                                break;
                            }
                            if (counter % 1000L == 0L) {
                                logger.info("outputKeyMapObj2Stream - output count[" + counter + "]");
                            }
                            if ((obj = (Map.Entry)entryIte.next()) == null) continue;
                            String key = null;
                            key = (String)obj.getKey();
                            long point = this.keyMapObjDataPointGet(key);
                            if (point != -1L) {
                                pointToKeyMap.put(new Long(point), key);
                                keyList.add(point);
                            }
                            if (++counter <= (long)(maxLineCount - 1)) continue;
                            int keyListSize = keyList.size();
                            long[] keyListInt = new long[keyListSize];
                            for (idx = 0; idx < keyListSize; ++idx) {
                                keyListInt[idx] = (Long)keyList.get(idx);
                            }
                            Arrays.sort(keyListInt);
                            keyList = null;
                            keyList = new ArrayList();
                            for (idx = 0; idx < keyListInt.length; ++idx) {
                                String sendKey = (String)pointToKeyMap.get(new Long(keyListInt[idx]));
                                allDataBuf.append(allDataSep);
                                allDataBuf.append(sendKey);
                                allDataBuf.append(workFileSeq);
                                allDataBuf.append(this.keyMapObjGet(sendKey));
                                allDataSep = ";";
                            }
                            ++sendCounter;
                            pw.println(allDataBuf.toString());
                            pw.flush();
                            if (ImdstDefine.lowSpecDataNode) {
                                Thread.sleep(50L);
                            }
                            allDataBuf = new StringBuilder(8192);
                            counter = 0L;
                            if (sendCounter % 10 == 0) {
                                Thread.sleep(3000L);
                            }
                            pointToKeyMap = new HashMap();
                        }
                        if (keyList.size() > 0) {
                            int idx;
                            int keyListSize = keyList.size();
                            long[] keyListInt = new long[keyListSize];
                            for (idx = 0; idx < keyListInt.length; ++idx) {
                                keyListInt[idx] = (Long)keyList.get(idx);
                            }
                            Arrays.sort(keyListInt);
                            keyList = null;
                            keyList = new ArrayList();
                            for (idx = 0; idx < keyListInt.length; ++idx) {
                                String sendKey = (String)pointToKeyMap.get(new Long(keyListInt[idx]));
                                allDataBuf.append(allDataSep);
                                allDataBuf.append(sendKey);
                                allDataBuf.append(workFileSeq);
                                allDataBuf.append(this.keyMapObjGet(sendKey));
                                allDataSep = ";";
                            }
                            String lastSendStr = allDataBuf.toString();
                            if (!lastSendStr.equals("")) {
                                pw.println(lastSendStr);
                                pw.flush();
                            }
                        }
                        allDataBuf = null;
                        pw.println("-1");
                        pw.flush();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("outputKeyMapObj2Stream - Error =[" + e.getMessage() + "]");
            }
            finally {
                this.myOperationStatus = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputDiffKeyMapObj2Stream(PrintWriter pw, BufferedReader br) throws BatchException {
        if (!this.blocking) {
            try {
                Object object = this.poolKeyLock;
                synchronized (object) {
                    int i;
                    String nextWrite = null;
                    this.myOperationStatus = 3;
                    logger.info("outputDiffKeyMapObj2Stream - synchronized - start");
                    String allDataSep = "";
                    StringBuilder allDataBuf = new StringBuilder(8192);
                    ((FileBaseDataList)this.diffDataPoolingListForFileBase).waitTime = 300;
                    for (i = 0; i < this.diffDataPoolingListForFileBase.size() - 10; ++i) {
                        allDataBuf.append(allDataSep);
                        allDataBuf.append(this.diffDataPoolingListForFileBase.get(i));
                        allDataSep = ";";
                        if (i <= 0 || i % 30 != 0) continue;
                        logger.info("outputDiffKeyMapObj2Stream - Diff Data Normal Send Count[" + i + "]");
                        pw.println(allDataBuf.toString());
                        pw.flush();
                        allDataBuf = null;
                        allDataBuf = new StringBuilder(8192);
                        allDataSep = "";
                        nextWrite = br.readLine();
                        if (nextWrite == null || !nextWrite.equals("-1") && !nextWrite.equals("2")) {
                            throw new Exception("NextWriteMessage= [" + nextWrite + "]");
                        }
                        nextWrite = null;
                    }
                    String lastSendData = allDataBuf.toString();
                    if (!lastSendData.equals("")) {
                        logger.info("outputDiffKeyMapObj2Stream - Diff Data Normal Send2 Count[" + i + "]");
                        pw.println(lastSendData);
                        pw.flush();
                        nextWrite = br.readLine();
                        if (nextWrite == null || !nextWrite.equals("-1") && !nextWrite.equals("2")) {
                            throw new Exception("NextWriteMessage= [" + nextWrite + "]");
                        }
                        nextWrite = null;
                    }
                    Object object2 = this.diffSync;
                    synchronized (object2) {
                        allDataBuf = null;
                        allDataBuf = new StringBuilder(8192);
                        allDataSep = "";
                        while (i < this.diffDataPoolingListForFileBase.size()) {
                            allDataBuf.append(allDataSep);
                            allDataBuf.append(this.diffDataPoolingListForFileBase.get(i));
                            allDataSep = ";";
                            if (i > 0 && i % 20 == 0) {
                                logger.info("outputDiffKeyMapObj2Stream - Diff Data Last Send Count[" + i + "]");
                                pw.println(allDataBuf.toString());
                                pw.flush();
                                allDataBuf = null;
                                allDataBuf = new StringBuilder(8192);
                                allDataSep = "";
                                nextWrite = br.readLine();
                                if (nextWrite == null || !nextWrite.equals("-1") && !nextWrite.equals("2")) {
                                    throw new Exception("Erro Target Read End Message= [" + nextWrite + "]");
                                }
                                nextWrite = null;
                            }
                            ++i;
                        }
                        lastSendData = allDataBuf.toString();
                        if (!lastSendData.equals("")) {
                            pw.println(lastSendData);
                            pw.flush();
                            nextWrite = br.readLine();
                            if (nextWrite == null || !nextWrite.equals("-1") && !nextWrite.equals("2")) {
                                throw new Exception("Erro Target Read End Message= [" + nextWrite + "]");
                            }
                            nextWrite = null;
                        }
                        pw.println("-1");
                        pw.flush();
                        allDataBuf = null;
                        String outputRet = br.readLine();
                        if (outputRet == null || !outputRet.equals("1")) {
                            throw new Exception("outputDiffKeyMapObj2Stream - Error Ret=[" + outputRet + "]");
                        }
                        pw.println("1");
                        pw.flush();
                        this.diffDataMode(false);
                    }
                }
                logger.info("outputDiffKeyMapObj2Stream - synchronized - end");
            }
            catch (Exception e) {
                logger.error("outputDiffKeyMapObj2Stream - Error [" + e.getMessage() + "]", e);
                this.diffDataMode(false);
            }
            finally {
                this.myOperationStatus = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputKeyMapObj2Stream(BufferedReader br, PrintWriter pw, int dataLineCount) throws BatchException {
        if (!this.blocking) {
            try {
                this.myOperationStatus = 2;
                int i = 0;
                String[] oneDatas = null;
                boolean setDataExec = false;
                logger.info("inputKeyMapObj2Stream - synchronized - start");
                Object object = this.poolKeyLock;
                synchronized (object) {
                    Object object2 = this.lockWorkFileSync;
                    synchronized (object2) {
                        File workKeyMapObjFile = new File(this.workKeyFilePath);
                        if (workKeyMapObjFile.exists()) {
                            if (this.bw != null) {
                                this.bw.flush();
                                this.bw.close();
                            }
                            workKeyMapObjFile.delete();
                        }
                        this.keyMapObj.clear();
                        if (this.dataMemory) {
                            if (this.keyMapObj != null) {
                                this.keyMapObj.close();
                            }
                        } else {
                            this.keyMapObj.deleteMapDataFile();
                        }
                        this.keyMapObj = null;
                        JavaSystemApi.manualGc();
                        Thread.sleep(3000L);
                        this.keyMapObj = !this.allDataForFile ? new KeyManagerValueMap(this.mapSize, this.dataMemory, this.virtualStorageDirs, true, null, this.diskCacheFile) : new KeyManagerValueMap(this.keyFileDirs, this.mapSize, true, this.diskCacheFile);
                        if (!this.dataMemory) {
                            this.keyMapObj.initNoMemoryModeSetting(this.diskModeRestoreFile);
                        }
                        FileOutputStream newFos = new FileOutputStream(new File(this.workKeyFilePath));
                        this.bw = new CustomBufferedWriter(new OutputStreamWriter((OutputStream)newFos, workMapFileEnc), 196608, newFos);
                        this.tLogWriteCount = new AtomicInteger(0);
                        if (!this.workFileMemory && !this.workFileFlushTiming) {
                            this.dataTransactionFileFlushDaemon.close();
                            this.dataTransactionFileFlushDaemon.tBw = this.bw;
                            this.dataTransactionFileFlushDaemon.tFilePath = this.workKeyFilePath;
                        }
                        long inputStartTime = JavaSystemApi.currentTimeMillis;
                        long counter = 0L;
                        for (int idx = 0; idx < Integer.MAX_VALUE; ++idx) {
                            String allDataStr = br.readLine();
                            if (allDataStr == null || allDataStr.trim().equals("-1")) {
                                logger.info("inputKeyMapObj2Stream ReadLine End");
                                break;
                            }
                            String[] allDataLines = allDataStr.split(";");
                            allDataStr = null;
                            for (i = 0; i < allDataLines.length; ++i) {
                                if (++counter % 500L == 0L) {
                                    logger.info("inputKeyMapObj2Stream Input Count[" + counter + "]");
                                }
                                if (allDataLines[i].trim().equals("")) continue;
                                oneDatas = allDataLines[i].split(workFileSeq);
                                if (oneDatas.length == 2) {
                                    setDataExec = true;
                                    this.keyMapObjPutNoChange(oneDatas[0], oneDatas[1]);
                                    if (this.workFileMemory) continue;
                                    this.bw.write("+" + workFileSeq + oneDatas[0] + workFileSeq + oneDatas[1] + workFileSeq + inputStartTime + workFileSeq + workFileEndPoint + "\n");
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                    continue;
                                }
                                if (oneDatas.length != 3) continue;
                                setDataExec = true;
                                this.keyMapObjPutNoChange(oneDatas[0], oneDatas[1] + workFileSeq + oneDatas[2]);
                                if (this.workFileMemory) continue;
                                this.bw.write("+" + workFileSeq + oneDatas[0] + workFileSeq + oneDatas[1] + workFileSeq + oneDatas[2] + workFileSeq + inputStartTime + workFileSeq + workFileEndPoint + "\n");
                                this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                            }
                            allDataLines = null;
                        }
                        if (setDataExec) {
                            this.setLastDataChangeTime();
                        }
                        pw.println("1");
                        pw.flush();
                    }
                }
                logger.info("inputKeyMapObj2Stream - synchronized - end");
            }
            catch (Exception e) {
                try {
                    pw.println("-1");
                    pw.flush();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                logger.error("inputKeyMapObj2Stream - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "inputKeyMapObj2Stream - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputDiffKeyMapObj2Stream(BufferedReader br, PrintWriter pw) throws BatchException {
        if (!this.blocking) {
            try {
                int i = 0;
                String[] oneDatas = null;
                logger.info("inputDiffKeyMapObj2Stream - synchronized - start");
                Object object = this.poolKeyLock;
                synchronized (object) {
                    Object object2 = this.lockWorkFileSync;
                    synchronized (object2) {
                        long writeCurrentTime = this.lastAccess;
                        int counter = 0;
                        String allDataStr = null;
                        while ((allDataStr = br.readLine()) != null && !allDataStr.trim().equals("-1")) {
                            if (allDataStr != null && !allDataStr.trim().equals("")) {
                                String[] allDataLines = allDataStr.split(";");
                                allDataStr = null;
                                for (i = 0; i < allDataLines.length; ++i) {
                                    if (allDataLines[i].trim().equals("")) continue;
                                    oneDatas = allDataLines[i].split(workFileSeq);
                                    if (allDataLines.length == i + 1) {
                                        if (oneDatas[0].equals("+")) {
                                            if (oneDatas.length == 3) {
                                                this.keyMapObjPut(oneDatas[1], oneDatas[2]);
                                            } else if (oneDatas.length == 4) {
                                                this.keyMapObjPut(oneDatas[1], oneDatas[2] + workFileSeq + oneDatas[3]);
                                            }
                                        } else if (oneDatas[0].equals("-")) {
                                            this.keyMapObjRemove(oneDatas[1]);
                                        }
                                    } else if (oneDatas[0].equals("+")) {
                                        if (oneDatas.length == 3) {
                                            this.keyMapObjPutNoChange(oneDatas[1], oneDatas[2]);
                                        } else if (oneDatas.length == 4) {
                                            this.keyMapObjPutNoChange(oneDatas[1], oneDatas[2] + workFileSeq + oneDatas[3]);
                                        }
                                    } else if (oneDatas[0].equals("-")) {
                                        this.keyMapObjRemoveNoChange(oneDatas[1]);
                                    }
                                    if (this.workFileMemory) continue;
                                    ++counter;
                                    String writeValueStr = " ";
                                    String dataType = "+";
                                    if (oneDatas[0].equals("-")) {
                                        dataType = "-";
                                    } else if (oneDatas.length == 3) {
                                        writeValueStr = oneDatas[2];
                                    } else if (oneDatas.length == 4) {
                                        writeValueStr = oneDatas[2] + workFileSeq + oneDatas[3];
                                    }
                                    this.bw.write(new StringBuilder(512).append(dataType).append(workFileSeq).append(oneDatas[1]).append(workFileSeq).append(writeValueStr).append(workFileSeq).append(writeCurrentTime).append(workFileSeq).append(workFileEndPoint).append("\n").toString());
                                    if (counter % 100 != 0) continue;
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                }
                                if (!this.workFileMemory) {
                                    SystemUtil.diskAccessSync(this.bw);
                                    this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                                }
                                allDataLines = null;
                            }
                            pw.println("2");
                            pw.flush();
                        }
                        if (!this.workFileMemory) {
                            SystemUtil.diskAccessSync(this.bw);
                            this.checkTransactionLogWriterLimit(this.tLogWriteCount.incrementAndGet());
                        }
                        pw.println("1");
                        pw.flush();
                    }
                }
                logger.info("inputDiffKeyMapObj2Stream - synchronized - end");
                this.myOperationStatus = 1;
                if (ImdstDefine.recoverRequired) {
                    ImdstDefine.recoverRequired = false;
                }
            }
            catch (Exception e) {
                this.myOperationStatus = 2;
                logger.error("inputDiffKeyMapObj2Stream - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "inputDiffKeyMapObj2Stream - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
    }

    public void outputNoMatchKeyMapKey2Stream(PrintWriter pw, int matchNo, String rulesStr) throws BatchException {
        if (!this.blocking) {
            try {
                String[] rules = null;
                int[] rulesInt = null;
                rules = rulesStr.split(",");
                rulesInt = new int[rules.length];
                for (int i = 0; i < rules.length; ++i) {
                    rulesInt[i] = Integer.parseInt(rules[i]);
                }
                String allDataSep = "";
                StringBuilder allDataBuf = new StringBuilder(8192);
                Set entrySet = this.keyMapObj.entrySet();
                int printLineCount = 0;
                int maxLineCount = new Double((double)JavaSystemApi.getRuntimeFreeMem("") * 0.1 / (((double)ImdstDefine.saveKeyMaxSize * 1.38 + (double)ImdstDefine.saveDataMaxSize * 1.38) / 50.0)).intValue();
                if (maxLineCount > 50000) {
                    maxLineCount = 50000;
                }
                if (ImdstDefine.lowSpecDataNode && maxLineCount > ImdstDefine.lowSpecDataNodeSendDataCount) {
                    maxLineCount = ImdstDefine.lowSpecDataNodeSendDataCount;
                }
                if (entrySet.size() > 0) {
                    if (maxLineCount == 0) {
                        maxLineCount = 1;
                    }
                    printLineCount = new Double(entrySet.size() / maxLineCount).intValue();
                    if (entrySet.size() % maxLineCount > 0) {
                        ++printLineCount;
                    }
                }
                Iterator entryIte = entrySet.iterator();
                int counter = 0;
                while (entryIte.hasNext()) {
                    Map.Entry obj = (Map.Entry)entryIte.next();
                    if (obj == null) continue;
                    String key = null;
                    String sendTagKey = null;
                    boolean sendFlg = true;
                    boolean tagFlg = false;
                    key = (String)obj.getKey();
                    if (key.indexOf(tagStartStr) == 0) {
                        tagFlg = true;
                        int startIdx = 15;
                        int endIdx = key.lastIndexOf(tagEndStr);
                        String checkKey = key.substring(startIdx, endIdx);
                        sendTagKey = key.substring(startIdx, endIdx);
                        int lastIdx = checkKey.lastIndexOf("_");
                        for (int idx = 0; idx < rulesInt.length; ++idx) {
                            if (!DataDispatcher.isRuleMatchKey(checkKey.substring(0, lastIdx), rulesInt[idx], matchNo)) continue;
                            sendFlg = false;
                            break;
                        }
                    } else {
                        for (int idx = 0; idx < rulesInt.length; ++idx) {
                            if (!DataDispatcher.isRuleMatchKey(key, rulesInt[idx], matchNo)) continue;
                            sendFlg = false;
                            break;
                        }
                    }
                    if (sendFlg) {
                        SystemUtil.debugLine("outputNoMatchKeyMapKey2Stream - MoveTargetKey[" + key + "]");
                        String data = this.keyMapObjGet(key);
                        if (data != null) {
                            if (tagFlg) {
                                String[] tagDatas = data.split(tagKeySep);
                                for (int idx = 0; idx < tagDatas.length; ++idx) {
                                    allDataBuf.append(allDataSep);
                                    allDataBuf.append("2");
                                    allDataBuf.append(workFileSeq);
                                    allDataBuf.append(sendTagKey);
                                    allDataBuf.append(workFileSeq);
                                    allDataBuf.append(tagDatas[idx]);
                                    allDataBuf.append("!");
                                    allDataBuf.append("0");
                                    allDataSep = ";";
                                    ++counter;
                                }
                            } else {
                                allDataBuf.append(allDataSep);
                                allDataBuf.append("1");
                                allDataBuf.append(workFileSeq);
                                allDataBuf.append(key);
                                allDataBuf.append(workFileSeq);
                                allDataBuf.append(data);
                                allDataSep = ";";
                            }
                        }
                    }
                    if (++counter <= maxLineCount - 1) continue;
                    pw.println(allDataBuf.toString());
                    allDataBuf = new StringBuilder(8192);
                    counter = 0;
                    allDataSep = "";
                }
                pw.println(allDataBuf.toString());
                pw.println("-1");
                pw.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("outputNoMatchKeyMapKey2Stream - Error =[" + e.getMessage() + "]");
            }
        }
    }

    public void outputConsistentHashMoveData2Stream(PrintWriter pw, String targetRangStr) throws BatchException {
        if (!this.blocking) {
            try {
                String allDataSep = "";
                StringBuilder allDataBuf = new StringBuilder(8192);
                int counter = 0;
                int[][] rangs = this.convertRangeData(targetRangStr);
                Set entrySet = this.keyMapObj.entrySet();
                int printLineCount = 0;
                int maxLineCount = new Double((double)JavaSystemApi.getRuntimeFreeMem("") * 0.1 / (((double)ImdstDefine.saveKeyMaxSize * 1.38 + (double)ImdstDefine.saveDataMaxSize * 1.38) / 50.0)).intValue();
                if (maxLineCount > 50000) {
                    maxLineCount = 50000;
                }
                if (ImdstDefine.lowSpecDataNode && maxLineCount > ImdstDefine.lowSpecDataNodeSendDataCount) {
                    maxLineCount = ImdstDefine.lowSpecDataNodeSendDataCount;
                }
                if (entrySet.size() > 0) {
                    if (maxLineCount == 0) {
                        maxLineCount = 1;
                    }
                    printLineCount = new Double(entrySet.size() / maxLineCount).intValue();
                    if (entrySet.size() % maxLineCount > 0) {
                        ++printLineCount;
                    }
                }
                Iterator entryIte = entrySet.iterator();
                while (entryIte.hasNext()) {
                    if (this.outputDataStopSignal) {
                        logger.info("outputConsistentHashMoveData2Stream - Stop Signal");
                        break;
                    }
                    Map.Entry obj = (Map.Entry)entryIte.next();
                    if (obj == null) continue;
                    String key = null;
                    String sendTagKey = null;
                    boolean sendFlg = false;
                    boolean tagFlg = false;
                    key = (String)obj.getKey();
                    if (key.indexOf(tagStartStr) == 0) {
                        tagFlg = true;
                        int startIdx = 15;
                        int endIdx = key.lastIndexOf(tagEndStr);
                        String checkKey = key.substring(startIdx, endIdx);
                        sendTagKey = key.substring(startIdx, endIdx);
                        int lastIdx = checkKey.lastIndexOf("_");
                        sendFlg = DataDispatcher.isRangeData(checkKey.substring(0, lastIdx), rangs);
                    } else {
                        sendFlg = key.indexOf("{imdst_list") == 0 ? false : DataDispatcher.isRangeData(key, rangs);
                    }
                    if (sendFlg) {
                        SystemUtil.debugLine("outputConsistentHashMoveData2Stream - MoveTargetKey[" + key + "]");
                        String data = this.keyMapObjGet(key);
                        if (data != null) {
                            if (tagFlg) {
                                String[] tagDatas = data.split(tagKeySep);
                                for (int idx = 0; idx < tagDatas.length; ++idx) {
                                    if (tagDatas[idx].indexOf("!") == -1) {
                                        tagDatas[idx] = tagDatas[idx] + "!0";
                                    }
                                    allDataBuf.append(allDataSep);
                                    allDataBuf.append("2");
                                    allDataBuf.append(workFileSeq);
                                    allDataBuf.append(sendTagKey);
                                    allDataBuf.append(workFileSeq);
                                    allDataBuf.append(tagDatas[idx]);
                                    allDataSep = ";";
                                    ++counter;
                                }
                            } else {
                                allDataBuf.append(allDataSep);
                                allDataBuf.append("1");
                                allDataBuf.append(workFileSeq);
                                allDataBuf.append(key);
                                allDataBuf.append(workFileSeq);
                                allDataBuf.append(data);
                                allDataSep = ";";
                            }
                        }
                    }
                    if (++counter <= maxLineCount - 1) continue;
                    pw.println(allDataBuf.toString());
                    pw.flush();
                    if (ImdstDefine.lowSpecDataNode) {
                        Thread.sleep(50L);
                    }
                    allDataBuf = new StringBuilder(8192);
                    counter = 0;
                    allDataSep = "";
                }
                pw.println(allDataBuf.toString());
                pw.println("-1");
                pw.flush();
            }
            catch (Exception e) {
                logger.error("outputConsistentHashMoveData2Stream - Error =[" + e.getMessage() + "]");
            }
        }
    }

    public void inputNoMatchKeyMapKey2Stream(PrintWriter pw, BufferedReader br) throws BatchException {
        this.inputConsistentHashMoveData2Stream(pw, br);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputConsistentHashMoveData2Stream(PrintWriter pw, BufferedReader br) throws BatchException {
        if (!this.blocking) {
            try {
                this.moveAdjustmentDataMap = new ConcurrentHashMap(1024, 1000.0f, 512);
                int i = 0;
                String[] oneDatas = null;
                String dataStr = null;
                while (true) {
                    logger.info("inputConsistentHashMoveData2Stream - synchronized - start");
                    Object object = this.poolKeyLock;
                    synchronized (object) {
                        dataStr = br.readLine();
                        if (dataStr == null || dataStr.equals("-1")) {
                            break;
                        }
                        String[] dataLines = dataStr.split(";");
                        for (i = 0; i < dataLines.length; ++i) {
                            if (dataLines[i].trim().equals("")) continue;
                            oneDatas = dataLines[i].split(workFileSeq);
                            if (oneDatas[0].equals("1")) {
                                if (oneDatas.length > 3) {
                                    oneDatas[2] = oneDatas[2] + "," + oneDatas[3];
                                }
                                this.setKeyPairOnlyOnce(oneDatas[1], oneDatas[2], "0", true);
                                continue;
                            }
                            if (!oneDatas[0].equals("2")) continue;
                            int lastIdx = oneDatas[1].lastIndexOf("_");
                            oneDatas[1] = oneDatas[1].substring(0, lastIdx);
                            this.setTagPair(oneDatas[1], oneDatas[2], "0");
                        }
                        pw.println("next");
                        pw.flush();
                    }
                    logger.info("inputConsistentHashMoveData2Stream - synchronized - end");
                }
                pw.println("end");
                pw.flush();
            }
            catch (SocketException se) {
                logger.error("", se);
            }
            catch (Exception e) {
                if (pw != null) {
                    try {
                        pw.println("error");
                        pw.flush();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
                logger.error("inputConsistentHashMoveData2Stream - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "inputConsistentHashMoveData2Stream - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
            finally {
                Object se = this.moveAdjustmentSync;
                synchronized (se) {
                    Set entrySet = this.moveAdjustmentDataMap.entrySet();
                    for (Map.Entry obj : entrySet) {
                        if (obj == null) continue;
                        String key = null;
                        key = (String)obj.getKey();
                        this.keyMapObjRemove(key);
                    }
                    this.moveAdjustmentDataMap = null;
                }
            }
        }
    }

    public void removeConsistentHashMoveData2Stream(PrintWriter pw, String targetRangStr) throws BatchException {
        if (!this.blocking) {
            try {
                int[][] rangs = this.convertRangeData(targetRangStr);
                Set entrySet = this.keyMapObj.entrySet();
                for (Map.Entry obj : entrySet) {
                    if (obj == null) continue;
                    String key = null;
                    key = (String)obj.getKey();
                    if (key.indexOf(tagStartStr) == 0) {
                        int lastIdx;
                        int startIdx = 15;
                        int endIdx = key.lastIndexOf(tagEndStr);
                        String checkKey = key.substring(startIdx, endIdx);
                        if (!DataDispatcher.isRangeData(checkKey.substring(0, lastIdx = checkKey.lastIndexOf("_")), rangs)) continue;
                        this.removeKeyPair(key, "0");
                        continue;
                    }
                    if (!DataDispatcher.isRangeData(key, rangs)) continue;
                    this.removeKeyPair(key, "0");
                }
                pw.println("-1");
                pw.flush();
            }
            catch (Exception e) {
                if (pw != null) {
                    try {
                        pw.println("error");
                        pw.flush();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
                logger.error("removeConsistentHashMoveData2Stream - Error =[" + e.getMessage() + "]");
            }
        }
    }

    public void removeModMoveData2Stream(PrintWriter pw, BufferedReader br) throws BatchException {
        if (!this.blocking) {
            try {
                boolean i = false;
                String[] oneDatas = null;
                String dataStr = null;
                while (true) {
                    logger.info("removeModMoveData2Stream - synchronized - start");
                    dataStr = br.readLine();
                    if (dataStr != null && !dataStr.equals("-1")) {
                        oneDatas = dataStr.split(workFileSeq);
                        if (oneDatas[0].equals("1")) {
                            this.removeKeyPair(oneDatas[1], "0");
                        } else if (oneDatas[0].equals("2")) {
                            this.removeKeyPair(tagStartStr + oneDatas[1] + tagEndStr, "0");
                        }
                        pw.println("next");
                        pw.flush();
                        logger.info("inputConsistentHashMoveData2Stream - synchronized - end");
                        continue;
                    }
                    break;
                }
            }
            catch (SocketException se) {
                logger.error("", se);
            }
            catch (Exception e) {
                if (pw != null) {
                    try {
                        pw.println("error");
                        pw.flush();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
                logger.error("inputConsistentHashMoveData2Stream - Error");
                this.blocking = true;
                StatusUtil.setStatusAndMessage(1, "inputConsistentHashMoveData2Stream - Error [" + e.getMessage() + "]");
                throw new BatchException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTransactionLogWriterLimit(int nowCount) {
        if (nowCount > ImdstDefine.maxTransactionLogBufferUseCount) {
            try {
                this.bw.flush();
                this.bw.close();
                this.bw = null;
            }
            catch (Exception e) {
                this.bw = null;
            }
            finally {
                try {
                    FileOutputStream newFos = new FileOutputStream(new File(this.workKeyFilePath), true);
                    this.bw = new CustomBufferedWriter(new OutputStreamWriter((OutputStream)newFos, workMapFileEnc), 196608, newFos);
                    this.tLogWriteCount = new AtomicInteger(0);
                }
                catch (Exception e) {
                    this.bw = null;
                }
            }
        }
    }

    private int[][] convertRangeData(String rangsStr) {
        String[] targetRangs = rangsStr.split("_");
        int[][] rangs = new int[targetRangs.length][2];
        for (int ii = 0; ii < targetRangs.length; ++ii) {
            String[] workRangs = targetRangs[ii].split("-");
            rangs[ii][0] = Integer.parseInt(workRangs[0]);
            rangs[ii][1] = Integer.parseInt(workRangs[1]);
        }
        return rangs;
    }

    public long getLastDataChangeTime() {
        return this.keyMapObj.getKLastDataChangeTime();
    }

    public int getSaveDataCount() {
        return this.keyMapObj.size();
    }

    public long getSaveDataSize(String uniqueKey) {
        return this.keyMapObj.getDataUseSize(uniqueKey);
    }

    public String[] getAllSaveDataSize() {
        return this.keyMapObj.getAllDataUseSize();
    }

    public boolean checkError() {
        return this.blocking;
    }

    private static boolean isExpireData(String valStr) {
        String[] metaColumns;
        String[] valStrSplit;
        String[] checkValueSplit = null;
        if (valStr != null && valStr.length() <= 1000) {
            valStrSplit = valStr.split("!");
            valStr = valStrSplit[0];
            checkValueSplit = valStr.split(",");
        } else if (valStr != null && valStr.length() >= 1001) {
            if (valStr.indexOf(",", valStr.length() - 100) != -1) {
                valStrSplit = valStr.split("!");
                valStr = valStrSplit[0];
                checkValueSplit = valStr.split(",");
            }
        } else {
            return false;
        }
        return checkValueSplit != null && checkValueSplit.length > 1 && !SystemUtil.expireCheck((metaColumns = checkValueSplit[1].split("-"))[1], 1L);
    }

    public void dump() {
        try {
            System.out.println("-------------------------------------- Dump Start ------------------------------------");
            System.out.println("ALL Data Count = [" + this.getSaveDataCount() + "]");
            System.out.println("======================================================================================");
            Set entrySet = this.keyMapObj.entrySet();
            for (Map.Entry obj : entrySet) {
                if (obj == null) continue;
                String key = null;
                key = (String)obj.getKey();
                if (key.indexOf(tagStartStr) == 0) {
                    String tag = key;
                    int startIdx = 15;
                    int endIdx = key.lastIndexOf(tagEndStr);
                    key = key.substring(startIdx, endIdx);
                    int lastIdx = key.lastIndexOf("_");
                    key = key.substring(0, lastIdx);
                    System.out.println("Tag=[" + new String(BASE64DecoderStream.decode((byte[])key.getBytes())) + "], Value=[" + this.keyMapObjGet(tag) + "]");
                    continue;
                }
                System.out.println("Key=[" + new String(BASE64DecoderStream.decode((byte[])key.getBytes())) + "], Value=[" + this.keyMapObjGet(key) + "]");
            }
            System.out.println("-------------------------------------- Dump End --------------------------------------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int keyObjectExport(String filePath) {
        if (this.keyObjBkupMode || filePath != null) {
            Object object = this.keyObjectExportSync;
            synchronized (object) {
                try {
                    File storeFile = null;
                    storeFile = filePath != null ? new File(filePath) : new File(this.keyObjBkupFilePath);
                    this.keyMapObj.fileStoreMapObject(storeFile);
                    return 1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -9;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataExport(PrintWriter pw, BufferedReader br, Socket soc) {
        try {
            int checkTime = 1;
            long waitTime = 0L;
            long networkCheckCount = 1000L;
            long count = 0L;
            int maxOutPutCount = 5;
            try {
                soc.setSoTimeout(1000);
                String confStr = br.readLine();
                if (confStr != null && !confStr.trim().equals("")) {
                    String[] confStrList = confStr.split(",");
                    checkTime = Integer.parseInt(confStrList[0]);
                    waitTime = Long.parseLong(confStrList[1]);
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            Set entrySet = this.keyMapObj.entrySet();
            Iterator entryIte = entrySet.iterator();
            while (entryIte.hasNext()) {
                ++count;
                Map.Entry obj = (Map.Entry)entryIte.next();
                if (obj == null) continue;
                String key = null;
                key = (String)obj.getKey();
                String value = this.keyMapObjGet(key);
                pw.println("+" + workFileSeq + key + workFileSeq + value + workFileSeq + JavaSystemApi.currentTimeMillis + workFileSeq + workFileEndPoint);
                if (count % (long)maxOutPutCount == 0L) {
                    pw.flush();
                }
                if (count % networkCheckCount == 0L) {
                    try {
                        soc.setSoTimeout(checkTime);
                        br.read();
                        br.reset();
                    }
                    catch (SocketTimeoutException se) {
                        // empty catch block
                    }
                }
                if (waitTime == 0L) continue;
                Thread.sleep(waitTime);
            }
            pw.flush();
        }
        catch (Exception e) {
        }
        finally {
            try {
                pw.println("-1");
                pw.flush();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void testSearch(String val) {
        try {
            Set entrySet = this.keyMapObj.entrySet();
            Iterator entryIte = entrySet.iterator();
            ArrayList<String> retList = new ArrayList<String>();
            while (entryIte.hasNext()) {
                String[] valwork;
                String decodeVal;
                String value;
                String key;
                Map.Entry obj = (Map.Entry)entryIte.next();
                if (obj == null || (key = (String)obj.getKey()) == null || key.indexOf("imdst_tag#9641") != -1 || (value = this.keyMapObjGet(key)) == null || (decodeVal = new String(BASE64DecoderStream.decode((byte[])(valwork = value.split("!"))[0].getBytes()))).indexOf(val) == -1) continue;
                retList.add(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

