/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.lang.ref.SoftReference;
import java.util.Set;
import okuyama.imdst.util.ValueCacheMap;

public class SoftRefCacheMap
extends Thread {
    private ValueCacheMap innerCacheMap = null;
    private volatile boolean cleanerExec = true;

    public SoftRefCacheMap() {
        this(1024);
    }

    public SoftRefCacheMap(int maxCacheCapacity) {
        this.innerCacheMap = new ValueCacheMap(maxCacheCapacity);
    }

    public Object put(Object key, Object value) {
        SoftReference oldRef = (SoftReference)this.innerCacheMap.put(key, new SoftReference<Object>(value));
        if (oldRef != null) {
            oldRef.clear();
        }
        return null;
    }

    public Object get(Object key) {
        Object value = null;
        SoftReference refValue = null;
        refValue = (SoftReference)this.innerCacheMap.get(key);
        if (refValue == null) {
            return null;
        }
        Object t = refValue.get();
        value = t;
        if (t == null) {
            this.innerCacheMap.remove(key);
        }
        return value;
    }

    public Object remove(Object key) {
        return this.innerCacheMap.remove(key);
    }

    public boolean containsKey(Object key) {
        Object value = null;
        SoftReference refValue = null;
        refValue = (SoftReference)this.innerCacheMap.get(key);
        if (refValue == null) {
            return false;
        }
        Object t = refValue.get();
        value = t;
        if (t == null) {
            this.innerCacheMap.remove(key);
        }
        return value != null;
    }

    public void end() {
        this.cleanerExec = false;
        this.innerCacheMap.clear();
    }

    @Override
    public void run() {
        boolean exec = true;
        while (exec) {
            try {
                int idx = 0;
                if (this.innerCacheMap == null) continue;
                Set keySet = this.innerCacheMap.keySet();
                for (Object key : keySet) {
                    SoftReference refValue = (SoftReference)this.innerCacheMap.get(key);
                    if (refValue.get() == null) {
                        this.innerCacheMap.remove(key);
                    }
                    if (!this.cleanerExec) {
                        exec = false;
                        break;
                    }
                    if (++idx % 50 != 0) continue;
                    Thread.sleep(50L);
                }
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

