/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import okuyama.imdst.util.CoreMapKey;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.StatusUtil;
import okuyama.imdst.util.io.CustomBufferedWriter;

public class SystemUtil {
    private static Object compressSync = new Object();
    private static ConcurrentLinkedQueue valueCompresserPool = null;
    private static ConcurrentLinkedQueue valueDecompresserPool = null;
    private static Object[] diskAccessSync = null;
    private static int[] diskAccessSyncCount = null;
    public static PrintWriter netDebugPrinter = null;
    private static Map checkCharacterMap = new HashMap(64);
    public static int bindMasterNodeServerPortNo = 8888;

    public static String fillCharacter(String data, int fixSize) {
        return SystemUtil.fillCharacter(data, fixSize, 38);
    }

    public static String fillCharacter(String data, int fixSize, int fillByte) {
        StringBuilder writeBuf = new StringBuilder(data);
        int valueSize = data.length();
        byte[] appendDatas = new byte[fixSize - valueSize];
        for (int i = 0; i < appendDatas.length; ++i) {
            appendDatas[i] = new Integer(fillByte).byteValue();
        }
        writeBuf.append(new String(appendDatas));
        return writeBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int diskAccessSync(RandomAccessFile fileAccessor, byte[] buf) throws Exception {
        int ret = 0;
        int syncIdx = 0;
        if (ImdstDefine.parallelDiskAccess != 1) {
            syncIdx = (fileAccessor.hashCode() << 1 >>> 1) % ImdstDefine.parallelDiskAccess;
        }
        Object object = diskAccessSync[syncIdx];
        synchronized (object) {
            ret = fileAccessor.read(buf);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int diskAccessSync(RandomAccessFile fileAccessor, byte[] buf, int start, int len) throws Exception {
        int ret = 0;
        int syncIdx = 0;
        if (ImdstDefine.parallelDiskAccess != 1) {
            syncIdx = (fileAccessor.hashCode() << 1 >>> 1) % ImdstDefine.parallelDiskAccess;
        }
        Object object = diskAccessSync[syncIdx];
        synchronized (object) {
            ret = fileAccessor.read(buf, start, len);
        }
        return ret;
    }

    public static int diskAccessSync(Object fileAccessor) throws Exception {
        return SystemUtil.diskAccessSync(fileAccessor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int diskAccessSync(Object fileAccessor, boolean auto) throws Exception {
        block20: {
            Object object;
            int type = 0;
            int syncIdx = 0;
            if (ImdstDefine.parallelDiskAccess != 1) {
                syncIdx = (fileAccessor.hashCode() << 1 >>> 1) % ImdstDefine.parallelDiskAccess;
            }
            boolean checkEnd = false;
            if (fileAccessor instanceof CustomBufferedWriter) {
                type = 2;
                checkEnd = true;
            }
            if (!checkEnd && fileAccessor instanceof BufferedWriter) {
                type = 1;
                checkEnd = true;
            }
            if (type == 1) {
                if (!auto) {
                    ((BufferedWriter)fileAccessor).flush();
                    return 0;
                }
                object = diskAccessSync[syncIdx];
                synchronized (object) {
                    ((BufferedWriter)fileAccessor).flush();
                }
            }
            if (type != 2) break block20;
            object = diskAccessSync[syncIdx];
            synchronized (object) {
                CustomBufferedWriter customBufferedWriter = (CustomBufferedWriter)fileAccessor;
                customBufferedWriter.flush();
                if (ImdstDefine.transactionLogFsyncType > 0) {
                    int n = syncIdx;
                    diskAccessSyncCount[n] = diskAccessSyncCount[n] + 1;
                    FileDescriptor fd = null;
                    switch (ImdstDefine.transactionLogFsyncType) {
                        case 4: {
                            fd = ((CustomBufferedWriter)fileAccessor).getFD();
                            fd.sync();
                            break;
                        }
                        case 3: {
                            if (diskAccessSyncCount[syncIdx] <= 5) break;
                            fd = ((CustomBufferedWriter)fileAccessor).getFD();
                            fd.sync();
                            SystemUtil.diskAccessSyncCount[syncIdx] = 0;
                            break;
                        }
                        case 2: {
                            if (diskAccessSyncCount[syncIdx] <= 25) break;
                            fd = ((CustomBufferedWriter)fileAccessor).getFD();
                            fd.sync();
                            SystemUtil.diskAccessSyncCount[syncIdx] = 0;
                            break;
                        }
                        case 1: {
                            if (diskAccessSyncCount[syncIdx] <= 50) break;
                            fd = ((CustomBufferedWriter)fileAccessor).getFD();
                            fd.sync();
                            SystemUtil.diskAccessSyncCount[syncIdx] = 0;
                        }
                    }
                }
            }
        }
        return 0;
    }

    public static boolean expireCheck(String expirTimeStr) {
        boolean ret = true;
        try {
            long expireTime;
            if (!expirTimeStr.trim().equals("0") && (expireTime = Long.parseLong(expirTimeStr)) <= JavaSystemApi.currentTimeMillis) {
                ret = false;
            }
        }
        catch (NumberFormatException e) {
            ret = false;
        }
        return ret;
    }

    public static boolean expireCheck(String expirTimeStr, long overTime) {
        boolean ret = true;
        try {
            long expireTime;
            if (!expirTimeStr.trim().equals("0") && (expireTime = Long.parseLong(expirTimeStr)) + overTime <= JavaSystemApi.currentTimeMillis) {
                ret = false;
            }
        }
        catch (NumberFormatException e) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initValueCompress() {
        if (valueCompresserPool != null) {
            return;
        }
        Object object = compressSync;
        synchronized (object) {
            if (valueCompresserPool == null) {
                valueCompresserPool = new ConcurrentLinkedQueue();
                valueDecompresserPool = new ConcurrentLinkedQueue();
                for (int i = 0; i < ImdstDefine.valueCompresserPoolSize; ++i) {
                    Deflater compresser = new Deflater();
                    compresser.setLevel(ImdstDefine.valueCompresserLevel);
                    valueCompresserPool.add(compresser);
                    Inflater decompresser = new Inflater();
                    valueDecompresserPool.add(decompresser);
                }
            }
        }
    }

    public static byte[] valueCompress(byte[] src) {
        if (!ImdstDefine.saveValueCompress) {
            return src;
        }
        return SystemUtil.dataCompress(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] dataCompress(byte[] src) {
        if (valueCompresserPool == null) {
            SystemUtil.initValueCompress();
        }
        byte[] ret = null;
        Deflater compresser = (Deflater)valueCompresserPool.poll();
        if (compresser == null) {
            compresser = new Deflater();
            compresser.setLevel(ImdstDefine.valueCompresserLevel);
        }
        try {
            ret = SystemUtil.compress(src, compresser, ImdstDefine.valueCompresserCompressSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            compresser = null;
        }
        finally {
            if (compresser != null) {
                compresser.reset();
                valueCompresserPool.add(compresser);
            }
        }
        return ret;
    }

    public static byte[] valueDecompress(byte[] src) {
        if (!ImdstDefine.saveValueCompress) {
            return src;
        }
        return SystemUtil.dataDecompress(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] dataDecompress(byte[] src) {
        Inflater decompresser;
        if (valueCompresserPool == null) {
            SystemUtil.initValueCompress();
        }
        if ((decompresser = (Inflater)valueDecompresserPool.poll()) == null) {
            decompresser = new Inflater();
        }
        byte[] ret = null;
        try {
            ret = SystemUtil.decompress(src, decompresser, ImdstDefine.valueCompresserCompressSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            decompresser = null;
        }
        finally {
            if (decompresser != null) {
                decompresser.reset();
                valueDecompresserPool.add(decompresser);
            }
        }
        return ret;
    }

    private static byte[] compress(byte[] src, Deflater compresser, int compressCycleSize) throws Exception {
        ByteArrayOutputStream compos = new ByteArrayOutputStream();
        compresser.setInput(src);
        compresser.finish();
        byte[] buf = new byte[compressCycleSize];
        int count = 0;
        while (!compresser.finished()) {
            count = compresser.deflate(buf);
            compos.write(buf, 0, count);
        }
        return compos.toByteArray();
    }

    private static byte[] decompress(byte[] src, Inflater decompresser, int compressCycleSize) throws Exception {
        ByteArrayOutputStream decompos = new ByteArrayOutputStream();
        decompresser.setInput(src);
        byte[] buf = new byte[compressCycleSize];
        int count = 0;
        while (!decompresser.finished()) {
            count = decompresser.inflate(buf);
            decompos.write(buf, 0, count);
        }
        return decompos.toByteArray();
    }

    public static boolean checkNoIndexCharacter(String checkStr) {
        if (checkStr.length() > 1) {
            int checkCount = 0;
            int matchCount = 0;
            for (int i = 0; i < checkStr.length(); ++i) {
                String str = checkStr.substring(i, i + 1);
                ++checkCount;
                if (str.indexOf(" ") <= -1 && str.indexOf("\u3002") <= -1 && str.indexOf("\u3001") <= -1 && str.indexOf("\u3000") <= -1 && str.indexOf("\u300c") <= -1 && str.indexOf("\u300d") <= -1 && str.indexOf(",") <= -1 && str.indexOf(".") <= -1 && str.indexOf("(") <= -1 && str.indexOf(")") <= -1 && str.indexOf("[") <= -1 && str.indexOf("]") <= -1 && str.indexOf("\uff08") <= -1 && str.indexOf("\uff09") <= -1 && str.indexOf("{") <= -1 && str.indexOf("}") <= -1 && str.indexOf("\uff5b") <= -1 && str.indexOf("\uff5d") <= -1 && str.indexOf("/") <= -1) continue;
                ++matchCount;
            }
            if (checkCount == matchCount) {
                return true;
            }
        } else if (checkCharacterMap.containsKey(checkStr)) {
            return true;
        }
        return false;
    }

    public static void debugLine(String outputStr) {
        if (StatusUtil.getDebugOption()) {
            StringBuilder strBuf = new StringBuilder(100);
            strBuf.append(new Date().toString());
            strBuf.append(" DebugLine \"");
            strBuf.append(outputStr);
            strBuf.append("\"");
            if (netDebugPrinter == null) {
                System.out.println(strBuf.toString());
            } else {
                try {
                    netDebugPrinter.println(strBuf.toString());
                    netDebugPrinter.flush();
                }
                catch (Exception e) {
                    StatusUtil.setDebugOption(false);
                    netDebugPrinter = null;
                }
            }
            Object var1_1 = null;
        }
    }

    public static byte[] defaultSerializeMap(Map data) {
        return SystemUtil.normalObjectSerialize(data);
    }

    private static byte[] jsonSerializeMap(Map data) {
        return null;
    }

    public static byte[] normalObjectSerialize(Object data) {
        ByteArrayOutputStream bao = null;
        ObjectOutputStream oo = null;
        try {
            bao = new ByteArrayOutputStream(1000);
            oo = new ObjectOutputStream(bao);
            oo.writeObject(data);
            oo.flush();
            oo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bao.toByteArray();
    }

    public static byte[] byteListStoreSerialize(Object data) {
        ByteArrayOutputStream bao = null;
        Object oo = null;
        try {
            bao = new ByteArrayOutputStream(17000);
            for (Map.Entry entry : ((Map)data).entrySet()) {
                byte[] keyByte = ((CoreMapKey)entry.getKey()).getDatas();
                byte[] valueByte = (byte[])entry.getValue();
                int keyLen = keyByte.length;
                int valLen = valueByte.length;
                byte[] keyLenBytes = new Integer(keyLen).toString().getBytes();
                byte[] saveKeyLenInfo = new byte[]{48, 48, 48, 48, 48, 48};
                int idx = 0;
                for (int i = 6 - keyLenBytes.length; i < 6; ++i) {
                    saveKeyLenInfo[i] = keyLenBytes[idx];
                    ++idx;
                }
                byte[] valLenBytes = new Integer(valLen).toString().getBytes();
                byte[] saveValLenInfo = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48};
                idx = 0;
                for (int i = 9 - valLenBytes.length; i < 9; ++i) {
                    saveValLenInfo[i] = valLenBytes[idx];
                    ++idx;
                }
                bao.write(saveKeyLenInfo);
                bao.write(saveValLenInfo);
                bao.write(keyByte);
                bao.write(valueByte);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bao.toByteArray();
    }

    public static Map defaultDeserializeMap(byte[] data) {
        return (Map)SystemUtil.normalObjectDeserialize(data);
    }

    private static Map jsonDeserializeMap(byte[] data) {
        return null;
    }

    public static Object normalObjectDeserialize(byte[] data) {
        Object retData = null;
        ByteArrayInputStream bio = null;
        ObjectInputStream ois = null;
        try {
            bio = new ByteArrayInputStream(data);
            ois = new ObjectInputStream(bio);
            retData = ois.readObject();
            ois.close();
            bio.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return retData;
    }

    public static Map byteListStoreDeserialize(byte[] data) {
        HashMap<CoreMapKey, byte[]> retData = new HashMap<CoreMapKey, byte[]>();
        Object bio = null;
        Object ois = null;
        try {
            int keyInfoStartIdx = 0;
            int valInfoStartIdx = 6;
            int keyDataInfoStartIdx = 15;
            int valDataInfoStartIdx = 0;
            while (keyInfoStartIdx < data.length) {
                byte[] keyLenInfo = new byte[6];
                byte[] valLenInfo = new byte[9];
                System.arraycopy(data, keyInfoStartIdx, keyLenInfo, 0, 6);
                System.arraycopy(data, valInfoStartIdx, valLenInfo, 0, 9);
                int keyLen = Integer.parseInt(new String(keyLenInfo));
                int valLen = Integer.parseInt(new String(valLenInfo));
                byte[] keyData = new byte[keyLen];
                byte[] valData = new byte[valLen];
                System.arraycopy(data, keyDataInfoStartIdx, keyData, 0, keyLen);
                valDataInfoStartIdx = keyDataInfoStartIdx + keyLen;
                System.arraycopy(data, valDataInfoStartIdx, valData, 0, valLen);
                retData.put(new CoreMapKey(keyData), valData);
                keyInfoStartIdx = valDataInfoStartIdx + valLen;
                valInfoStartIdx = keyInfoStartIdx + 6;
                keyDataInfoStartIdx = valInfoStartIdx + 9;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return retData;
    }

    public static String getHostName() {
        try {
            InetAddress inet = InetAddress.getLocalHost();
            return inet.getHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getBindMasterNodePortNo() {
        return bindMasterNodeServerPortNo;
    }

    public static String[] fastSplit(String target, int sepPoint) {
        if (target == null || target.length() < 1) {
            return new String[1];
        }
        String[] ret = new String[]{target.substring(0, sepPoint), target.substring(sepPoint + 1)};
        return ret;
    }

    public static String[] fastSplit(String target, String sep, int sepCount) {
        if (target == null || target.length() < 1) {
            return target.split(sep);
        }
        String[] tmpRet = new String[sepCount + 1];
        int offset = 0;
        int startOffset = 0;
        int idx = 0;
        while ((offset = target.indexOf(sep, offset)) != -1) {
            tmpRet[idx] = target.substring(startOffset, offset);
            startOffset = ++offset;
            if (++idx != sepCount) continue;
        }
        tmpRet[idx] = target.substring(startOffset, target.length());
        return tmpRet;
    }

    public static String[] fastSplit(String target, String sep) {
        if (target == null || target.length() < 1) {
            return target.split(sep);
        }
        String[] tmpRet = new String[10];
        int offset = 0;
        int startOffset = 0;
        int idx = 0;
        while ((offset = target.indexOf(sep, offset)) != -1) {
            tmpRet[idx] = target.substring(startOffset, offset);
            ++idx;
            startOffset = ++offset;
        }
        tmpRet[idx] = target.substring(startOffset, target.length());
        String[] ret = new String[idx + 1];
        for (int i = 0; i < idx + 1; ++i) {
            ret[i] = tmpRet[i];
        }
        return ret;
    }

    static {
        diskAccessSync = new Object[ImdstDefine.parallelDiskAccess];
        diskAccessSyncCount = new int[ImdstDefine.parallelDiskAccess];
        for (int i = 0; i < ImdstDefine.parallelDiskAccess; ++i) {
            SystemUtil.diskAccessSync[i] = new Object();
            SystemUtil.diskAccessSyncCount[i] = 0;
        }
        checkCharacterMap.put("a", null);
        checkCharacterMap.put("b", null);
        checkCharacterMap.put("c", null);
        checkCharacterMap.put("d", null);
        checkCharacterMap.put("e", null);
        checkCharacterMap.put("f", null);
        checkCharacterMap.put("g", null);
        checkCharacterMap.put("h", null);
        checkCharacterMap.put("i", null);
        checkCharacterMap.put("j", null);
        checkCharacterMap.put("k", null);
        checkCharacterMap.put("l", null);
        checkCharacterMap.put("m", null);
        checkCharacterMap.put("n", null);
        checkCharacterMap.put("o", null);
        checkCharacterMap.put("p", null);
        checkCharacterMap.put("q", null);
        checkCharacterMap.put("r", null);
        checkCharacterMap.put("s", null);
        checkCharacterMap.put("t", null);
        checkCharacterMap.put("u", null);
        checkCharacterMap.put("v", null);
        checkCharacterMap.put("w", null);
        checkCharacterMap.put("x", null);
        checkCharacterMap.put("y", null);
        checkCharacterMap.put("z", null);
        checkCharacterMap.put("A", null);
        checkCharacterMap.put("B", null);
        checkCharacterMap.put("C", null);
        checkCharacterMap.put("D", null);
        checkCharacterMap.put("E", null);
        checkCharacterMap.put("F", null);
        checkCharacterMap.put("G", null);
        checkCharacterMap.put("H", null);
        checkCharacterMap.put("I", null);
        checkCharacterMap.put("J", null);
        checkCharacterMap.put("K", null);
        checkCharacterMap.put("L", null);
        checkCharacterMap.put("M", null);
        checkCharacterMap.put("N", null);
        checkCharacterMap.put("O", null);
        checkCharacterMap.put("P", null);
        checkCharacterMap.put("Q", null);
        checkCharacterMap.put("R", null);
        checkCharacterMap.put("S", null);
        checkCharacterMap.put("T", null);
        checkCharacterMap.put("U", null);
        checkCharacterMap.put("V", null);
        checkCharacterMap.put("W", null);
        checkCharacterMap.put("X", null);
        checkCharacterMap.put("Y", null);
        checkCharacterMap.put("Z", null);
        checkCharacterMap.put("1", null);
        checkCharacterMap.put("2", null);
        checkCharacterMap.put("3", null);
        checkCharacterMap.put("4", null);
        checkCharacterMap.put("5", null);
        checkCharacterMap.put("6", null);
        checkCharacterMap.put("7", null);
        checkCharacterMap.put("8", null);
        checkCharacterMap.put("9", null);
        checkCharacterMap.put("0", null);
        checkCharacterMap.put("!", null);
        checkCharacterMap.put("#", null);
        checkCharacterMap.put("$", null);
        checkCharacterMap.put("%", null);
        checkCharacterMap.put("&", null);
        checkCharacterMap.put("'", null);
        checkCharacterMap.put("(", null);
        checkCharacterMap.put(")", null);
        checkCharacterMap.put("-", null);
        checkCharacterMap.put("=", null);
        checkCharacterMap.put("^", null);
        checkCharacterMap.put("~", null);
        checkCharacterMap.put("\\", null);
        checkCharacterMap.put("|", null);
        checkCharacterMap.put("@", null);
        checkCharacterMap.put("`", null);
        checkCharacterMap.put("[", null);
        checkCharacterMap.put("{", null);
        checkCharacterMap.put(";", null);
        checkCharacterMap.put("+", null);
        checkCharacterMap.put(":", null);
        checkCharacterMap.put("*", null);
        checkCharacterMap.put("]", null);
        checkCharacterMap.put("}", null);
        checkCharacterMap.put("/", null);
        checkCharacterMap.put("?", null);
        checkCharacterMap.put("_", null);
        checkCharacterMap.put(",", null);
        checkCharacterMap.put("<", null);
        checkCharacterMap.put(".", null);
        checkCharacterMap.put(">", null);
        checkCharacterMap.put(" ", null);
        checkCharacterMap.put("\u3000", null);
        checkCharacterMap.put("\u3042", null);
        checkCharacterMap.put("\u3044", null);
        checkCharacterMap.put("\u3046", null);
        checkCharacterMap.put("\u3048", null);
        checkCharacterMap.put("\u304a", null);
        checkCharacterMap.put("\u304b", null);
        checkCharacterMap.put("\u304d", null);
        checkCharacterMap.put("\u304f", null);
        checkCharacterMap.put("\u3051", null);
        checkCharacterMap.put("\u3053", null);
        checkCharacterMap.put("\u3055", null);
        checkCharacterMap.put("\u3057", null);
        checkCharacterMap.put("\u3059", null);
        checkCharacterMap.put("\u305b", null);
        checkCharacterMap.put("\u305d", null);
        checkCharacterMap.put("\u305f", null);
        checkCharacterMap.put("\u3061", null);
        checkCharacterMap.put("\u3064", null);
        checkCharacterMap.put("\u3066", null);
        checkCharacterMap.put("\u3068", null);
        checkCharacterMap.put("\u306a", null);
        checkCharacterMap.put("\u306b", null);
        checkCharacterMap.put("\u306c", null);
        checkCharacterMap.put("\u306d", null);
        checkCharacterMap.put("\u306e", null);
        checkCharacterMap.put("\u306f", null);
        checkCharacterMap.put("\u3072", null);
        checkCharacterMap.put("\u3075", null);
        checkCharacterMap.put("\u3078", null);
        checkCharacterMap.put("\u307b", null);
        checkCharacterMap.put("\u307e", null);
        checkCharacterMap.put("\u307f", null);
        checkCharacterMap.put("\u3080", null);
        checkCharacterMap.put("\u3081", null);
        checkCharacterMap.put("\u3082", null);
        checkCharacterMap.put("\u3084", null);
        checkCharacterMap.put("\u3086", null);
        checkCharacterMap.put("\u3088", null);
        checkCharacterMap.put("\u308f", null);
        checkCharacterMap.put("\u3092", null);
        checkCharacterMap.put("\u3093", null);
        checkCharacterMap.put("\uff01", null);
        checkCharacterMap.put("\u201d", null);
        checkCharacterMap.put("\uff03", null);
        checkCharacterMap.put("\uff04", null);
        checkCharacterMap.put("\uff05", null);
        checkCharacterMap.put("\uff06", null);
        checkCharacterMap.put("\u2019", null);
        checkCharacterMap.put("\uff08", null);
        checkCharacterMap.put("\uff09", null);
        checkCharacterMap.put("\uff1d", null);
        checkCharacterMap.put("\uff5e", null);
        checkCharacterMap.put("\uff5c", null);
        checkCharacterMap.put("\uff11", null);
        checkCharacterMap.put("\uff12", null);
        checkCharacterMap.put("\uff13", null);
        checkCharacterMap.put("\uff14", null);
        checkCharacterMap.put("\uff15", null);
        checkCharacterMap.put("\uff16", null);
        checkCharacterMap.put("\uff17", null);
        checkCharacterMap.put("\uff18", null);
        checkCharacterMap.put("\uff19", null);
        checkCharacterMap.put("\uff10", null);
        checkCharacterMap.put("\uff0d", null);
        checkCharacterMap.put("\uff3e", null);
        checkCharacterMap.put("\uffe5", null);
        checkCharacterMap.put("\uff51", null);
        checkCharacterMap.put("\uff57", null);
        checkCharacterMap.put("\uff45", null);
        checkCharacterMap.put("\uff52", null);
        checkCharacterMap.put("\uff54", null);
        checkCharacterMap.put("\uff59", null);
        checkCharacterMap.put("\uff55", null);
        checkCharacterMap.put("\uff49", null);
        checkCharacterMap.put("\uff4f", null);
        checkCharacterMap.put("\uff50", null);
        checkCharacterMap.put("\uff20", null);
        checkCharacterMap.put("\uff3b", null);
        checkCharacterMap.put("\uff3d", null);
        checkCharacterMap.put("\uff1a", null);
        checkCharacterMap.put("\uff1b", null);
        checkCharacterMap.put("\uff4c", null);
        checkCharacterMap.put("\uff4b", null);
        checkCharacterMap.put("\uff4a", null);
        checkCharacterMap.put("\uff48", null);
        checkCharacterMap.put("\uff47", null);
        checkCharacterMap.put("\uff46", null);
        checkCharacterMap.put("\uff44", null);
        checkCharacterMap.put("\uff53", null);
        checkCharacterMap.put("\uff41", null);
        checkCharacterMap.put("\uff5a", null);
        checkCharacterMap.put("\uff58", null);
        checkCharacterMap.put("\uff43", null);
        checkCharacterMap.put("\uff56", null);
        checkCharacterMap.put("\uff42", null);
        checkCharacterMap.put("\uff4e", null);
        checkCharacterMap.put("\uff4d", null);
        checkCharacterMap.put("\uff0c", null);
        checkCharacterMap.put("\uff0e", null);
        checkCharacterMap.put("\uff0f", null);
        checkCharacterMap.put("\uffe5", null);
        checkCharacterMap.put("\uff31", null);
        checkCharacterMap.put("\uff37", null);
        checkCharacterMap.put("\uff25", null);
        checkCharacterMap.put("\uff32", null);
        checkCharacterMap.put("\uff34", null);
        checkCharacterMap.put("\uff39", null);
        checkCharacterMap.put("\uff35", null);
        checkCharacterMap.put("\uff29", null);
        checkCharacterMap.put("\uff2f", null);
        checkCharacterMap.put("\uff30", null);
        checkCharacterMap.put("\u2018", null);
        checkCharacterMap.put("\uff5b", null);
        checkCharacterMap.put("\uff5d", null);
        checkCharacterMap.put("\uff0a", null);
        checkCharacterMap.put("\uff0b", null);
        checkCharacterMap.put("\uff2c", null);
        checkCharacterMap.put("\uff2b", null);
        checkCharacterMap.put("\uff2a", null);
        checkCharacterMap.put("\uff28", null);
        checkCharacterMap.put("\uff27", null);
        checkCharacterMap.put("\uff26", null);
        checkCharacterMap.put("\uff24", null);
        checkCharacterMap.put("\uff33", null);
        checkCharacterMap.put("\uff21", null);
        checkCharacterMap.put("\uff3a", null);
        checkCharacterMap.put("\uff38", null);
        checkCharacterMap.put("\uff23", null);
        checkCharacterMap.put("\uff36", null);
        checkCharacterMap.put("\uff22", null);
        checkCharacterMap.put("\uff2e", null);
        checkCharacterMap.put("\uff2d", null);
        checkCharacterMap.put("\uff1c", null);
        checkCharacterMap.put("\uff1e", null);
        checkCharacterMap.put("\uff1f", null);
        checkCharacterMap.put("\uff3f", null);
        checkCharacterMap.put("\r", null);
        checkCharacterMap.put("\n", null);
    }
}

