/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import okuyama.imdst.util.DiskBaseCacheMap;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.io.AbstractDataRandomAccess;

public class HighSpeedDiskCacheRandomAccess
extends AbstractDataRandomAccess {
    protected Map dataPointMap = null;
    protected DiskCacheManager diskCacheManager = null;
    protected int maxCacheSize = ImdstDefine.maxDiskCacheSize;
    private String cacheFilePath = null;
    private long nowSeekPoint = 0L;
    private long cacheHitCount = 0L;

    public HighSpeedDiskCacheRandomAccess(File target, String type, String cacheFilePath) throws FileNotFoundException {
        super(target, type);
        File cacheFile = null;
        this.cacheFilePath = cacheFilePath;
        if (this.cacheFilePath != null && !this.cacheFilePath.trim().equals("")) {
            cacheFile = new File(cacheFilePath);
            this.diskCacheManager = new DiskCacheManager(this.maxCacheSize, cacheFile);
            this.diskCacheManager.start();
            System.out.println(" DiskCache Use - CacheFile=[" + cacheFilePath + "] Number of max cache data=" + this.maxCacheSize);
        } else {
            this.diskCacheManager = new DiskCacheManager();
        }
    }

    @Override
    public void setDataPointMap(Map dataPointMap) {
        this.dataPointMap = dataPointMap;
    }

    @Override
    public void requestSeekPoint(long seekPoint, int start, int size) {
    }

    @Override
    public void seek(long seekPoint) throws IOException {
        super.seek(seekPoint);
        this.nowSeekPoint = seekPoint;
    }

    @Override
    public void write(byte[] data, int start, int size) throws IOException {
        super.write(data, start, size);
        this.diskCacheManager.removeCache(this.nowSeekPoint);
    }

    @Override
    public int seekAndRead(long seekPoint, byte[] data, int start, int size, Object key) throws IOException {
        int ret = -1;
        try {
            byte[] cacheData = null;
            cacheData = this.diskCacheManager.getCacheData(seekPoint);
            if (cacheData == null) {
                super.seek(seekPoint);
                ret = super.read(data, start, size);
                cacheData = new byte[data.length];
                ret = data.length;
                System.arraycopy(data, 0, cacheData, 0, data.length);
                this.diskCacheManager.addCacheData(seekPoint, cacheData);
            } else {
                System.arraycopy(cacheData, 0, data, 0, cacheData.length);
                ret = cacheData.length;
            }
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.diskCacheManager.endManged();
    }

    class DiskCacheManager
    extends Thread {
        private boolean runFlg = false;
        private ArrayBlockingQueue writeQueue = new ArrayBlockingQueue(20000);
        private ConcurrentHashMap fixWriteDataMap = new ConcurrentHashMap(20000);
        private DiskBaseCacheMap diskBaseCacheMap = null;
        private Object sync = new Object();
        private Object removeSync = new Object();
        private long lastAccessTime = 0L;
        private boolean noCache = false;

        public DiskCacheManager() {
            this.noCache = true;
        }

        public DiskCacheManager(int maxCacheSize, File dataFile) throws FileNotFoundException {
            this.diskBaseCacheMap = new DiskBaseCacheMap(maxCacheSize, dataFile);
            this.runFlg = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean sleepFlg = false;
            long checkCount = 0L;
            try {
                while (this.runFlg) {
                    if (++checkCount > 50L) {
                        this.diskBaseCacheMap.existsCacheFile();
                        checkCount = 0L;
                    }
                    if (this.diskBaseCacheMap.errorFlg) {
                        System.out.println("Cache File Error " + new Date().toString());
                        this.noCache = true;
                        Thread.sleep(10000L);
                        this.diskBaseCacheMap.clear();
                        if (this.diskBaseCacheMap.errorFlg) continue;
                    }
                    this.noCache = false;
                    if (sleepFlg) {
                        Thread.sleep(1000L);
                    }
                    sleepFlg = false;
                    for (int skipIdx = 0; skipIdx < 3 && System.nanoTime() - this.lastAccessTime <= 10000000L; ++skipIdx) {
                        Thread.sleep(10L);
                    }
                    Object skipIdx = this.sync;
                    synchronized (skipIdx) {
                        Long cacheSeekPoint = (Long)this.writeQueue.poll();
                        if (cacheSeekPoint != null) {
                            byte[] cacheData = (byte[])this.fixWriteDataMap.remove(cacheSeekPoint);
                            if (cacheData == null) {
                                Thread.sleep(10L);
                                cacheData = (byte[])this.fixWriteDataMap.remove(cacheSeekPoint);
                            }
                            if (cacheData != null) {
                                this.diskBaseCacheMap.put(cacheSeekPoint, cacheData);
                            }
                        } else {
                            sleepFlg = true;
                        }
                    }
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                this.diskBaseCacheMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCacheData(long seekPoint, byte[] cacheData) {
            if (this.noCache) {
                return;
            }
            this.lastAccessTime = System.nanoTime();
            Object object = this.removeSync;
            synchronized (object) {
                Long seekPointLong = new Long(seekPoint);
                if (this.writeQueue.offer(seekPointLong)) {
                    this.fixWriteDataMap.put(seekPointLong, cacheData);
                }
            }
        }

        public byte[] getCacheData(long seekPoint) {
            if (this.noCache) {
                return null;
            }
            this.lastAccessTime = System.nanoTime();
            return (byte[])this.diskBaseCacheMap.get(new Long(seekPoint));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCache(long seekPoint) {
            if (this.noCache) {
                return;
            }
            this.lastAccessTime = System.nanoTime();
            Object object = this.removeSync;
            synchronized (object) {
                Object object2 = this.sync;
                synchronized (object2) {
                    this.diskBaseCacheMap.remove(new Long(seekPoint));
                    this.fixWriteDataMap.remove(seekPoint);
                }
            }
        }

        public void endManged() {
            this.runFlg = false;
        }
    }
}

