/*
 * Decompiled with CFR 0.152.
 */
package test.helper;

import okuyama.base.job.AbstractHelper;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.client.OkuyamaQueueClient;

public class QueueClientPutTestHelper
extends AbstractHelper {
    private static ILogger logger = LoggerFactory.createLogger(QueueClientPutTestHelper.class);

    @Override
    public void initHelper(String initValue) {
    }

    @Override
    public String executeHelper(String optionParam) throws BatchException {
        logger.debug("QueueClientPutTestHelper - executeHelper - start");
        String ret = SUCCESS;
        boolean counter = false;
        Object[] parameters = super.getParameters();
        OkuyamaQueueClient queueClient = (OkuyamaQueueClient)parameters[0];
        String queueName = (String)parameters[1];
        int dataCount = (Integer)parameters[2];
        String prefix = (String)parameters[3];
        try {
            System.out.println("Queue Put Test Start QueueName [" + queueName + "] UniqueName[" + prefix + "]");
            long start = System.nanoTime();
            for (int i = 0; i < dataCount; ++i) {
                String data = prefix + "_" + i;
                if (queueClient.put(queueName, data)) {
                    super.setHelperShareParam(data, "");
                    continue;
                }
                System.out.println("Queue Put Error --------------------------------------- Data[" + data + "]");
            }
            queueClient.close();
            long end = System.nanoTime();
            System.out.println("Queue Put Time=" + (end - start) / 1000L / 1000L + " milli");
        }
        catch (Exception e) {
            logger.error("QueueClientPutTestHelper - executeHelper - Error", e);
            throw new BatchException(e);
        }
        logger.debug("QueueClientPutTestHelper - executeHelper - end");
        return ret;
    }

    @Override
    public void endHelper() {
    }
}

