/*
 * Decompiled with CFR 0.152.
 */
package test.job;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import okuyama.base.job.AbstractJob;
import okuyama.base.job.IJob;
import okuyama.base.lang.BatchException;
import okuyama.imdst.client.OkuyamaClient;

public class DataNodeRebootTestJob
extends AbstractJob
implements IJob {
    private int execCount = 5;
    private String testScriptPath = "C:";

    @Override
    public void initJob(String initValue) {
        if (initValue != null && !initValue.equals("")) {
            this.execCount = Integer.parseInt(initValue);
        }
    }

    @Override
    public String executeJob(String optionParam) throws BatchException {
        String ret = SUCCESS;
        Object stopCmd1 = null;
        Object stopCmd2 = null;
        Object startCmd1 = null;
        Object startCmd2 = null;
        long nodeRebootWaitTime = 300000L;
        try {
            if (optionParam != null && !optionParam.equals("")) {
                this.testScriptPath = optionParam;
            }
            Thread.sleep(10000L);
            String recoverTimeStr = super.getPropertiesValue("RebootTime");
            if (recoverTimeStr != null && !recoverTimeStr.trim().equals("")) {
                nodeRebootWaitTime = Long.parseLong(recoverTimeStr);
            }
            for (int t = 0; t < this.execCount; ++t) {
                String[] keyList = new String[]{"p" + t, "p_x" + t, "p_y" + t, "p_z" + t};
                this.execRestart(keyList, nodeRebootWaitTime);
            }
        }
        catch (Exception e) {
            throw new BatchException(e);
        }
        return ret;
    }

    private void execRestart(String[] keyPrefixList, long nodeRebootWaitTime) throws Exception {
        System.out.println("execStop - Start");
        String result = null;
        String osName = super.getPropertiesValue("OSName");
        String[] stop = new String[1];
        String[] start = new String[1];
        if (osName == null || osName.equals("") || osName.trim().equals("windows")) {
            stop[0] = this.testScriptPath + "\\execTestStopDataNode.bat";
            start[0] = this.testScriptPath + "\\execTestDataNode.bat";
        } else {
            stop[0] = this.testScriptPath + "/execTestStopDataNode.sh";
            start[0] = this.testScriptPath + "/execTestDataNode.sh";
        }
        String killCmd = "kill -9 ";
        if (osName == null || osName.equals("") || osName.trim().equals("windows")) {
            killCmd = "taskkill /F /PID ";
        }
        String stopCmd = "";
        String startCmd = "";
        OkuyamaClient client = new OkuyamaClient();
        client.connect("127.0.0.1", 8888);
        for (int idx = 0; idx < keyPrefixList.length; ++idx) {
            for (int i = 0; i < 1000; ++i) {
                if (client.setValue("RebootTestKey_" + keyPrefixList[idx] + "_" + i, "RebootTestValue_" + keyPrefixList[idx] + "_" + i)) continue;
                System.out.println("Reboot test set error Key=RebootTestKey_" + keyPrefixList[idx] + "_" + i);
            }
        }
        int exec = 0;
        stopCmd = stop[exec];
        startCmd = start[exec];
        System.out.println(stopCmd);
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(stopCmd);
        InputStream is = p.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((result = br.readLine()) != null) {
            System.out.println(result);
            if ((result = result.trim()).equals("")) continue;
            try {
                int pid = Integer.parseInt(result);
                killCmd = killCmd + pid;
            }
            catch (Exception ee) {}
        }
        rt = Runtime.getRuntime();
        System.out.println(killCmd);
        p = rt.exec(killCmd);
        Thread.sleep(10000L);
        rt = Runtime.getRuntime();
        System.out.println(startCmd);
        p = rt.exec(startCmd);
        Thread.sleep(nodeRebootWaitTime);
        for (int idx = 0; idx < keyPrefixList.length; ++idx) {
            for (int i = 0; i < 1000; ++i) {
                String[] getRet = client.getValue("RebootTestKey_" + keyPrefixList[idx] + "_" + i);
                if (!getRet[0].equals("true")) {
                    System.out.println(new Date().toString() + " Reboot test get error type=" + getRet[0] + " Key=" + "RebootTestKey_" + keyPrefixList[idx] + "_" + i);
                    continue;
                }
                if (getRet[1].equals("RebootTestValue_" + keyPrefixList[idx] + "_" + i)) continue;
                System.out.println(new Date().toString() + " Reboot test get error type=" + getRet[0] + " Key=" + "RebootTestKey_" + keyPrefixList[idx] + "_" + i + " Value=" + getRet[1]);
            }
        }
        System.out.println("execStop - End");
    }
}

