/*
 * Decompiled with CFR 0.152.
 */
package test.job;

import okuyama.base.job.AbstractJob;
import okuyama.base.job.IJob;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.util.FileBaseDataMap;

public class TestJob
extends AbstractJob
implements IJob {
    private int checkCycle = 5000;
    private static String[] dirs = new String[]{"./keymapfile/1.dir/", "./keymapfile/2.dir/"};
    private static FileBaseDataMap fileBaseDataMap = new FileBaseDataMap(dirs, 25600, 0.2, 0x100000);
    private static ILogger logger = LoggerFactory.createLogger(TestJob.class);

    @Override
    public void initJob(String initValue) {
        logger.debug("TestJob - initJob - start");
        logger.debug("TestJob - initJob - end");
    }

    @Override
    public String executeJob(String optionParam) throws BatchException {
        logger.debug("TestJob - executeJob - start");
        String ret = SUCCESS;
        try {
            long start = System.nanoTime();
            for (int i = 0; i < 50; ++i) {
                fileBaseDataMap.put(optionParam + "key" + i, optionParam + "value" + i);
            }
            long end = System.nanoTime();
            System.out.println((end - start) / 1024L / 1024L);
            long start2 = System.nanoTime();
            for (int i = 0; i < 50; ++i) {
                fileBaseDataMap.get(optionParam + "key" + i);
            }
            long end2 = System.nanoTime();
            System.out.println("2=" + (end - start) / 1024L / 1024L);
        }
        catch (Exception e) {
            logger.error("TestJob - executeJob - Error", e);
            throw new BatchException(e);
        }
        logger.debug("TestJob - executeJob - end");
        return ret;
    }
}

