/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FileUtil {
    private static final Log LOG = LogFactory.getLog(FileUtil.class);

    public static Path[] stat2Paths(FileStatus[] stats) {
        if (stats == null) {
            return null;
        }
        Path[] ret = new Path[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            ret[i] = stats[i].getPath();
        }
        return ret;
    }

    public static Path[] stat2Paths(FileStatus[] stats, Path path) {
        if (stats == null) {
            return new Path[]{path};
        }
        return FileUtil.stat2Paths(stats);
    }

    public static boolean fullyDelete(File dir) throws IOException {
        if (!FileUtil.fullyDeleteContents(dir)) {
            return false;
        }
        return dir.delete();
    }

    public static boolean fullyDeleteContents(File dir) throws IOException {
        boolean deletionSucceeded = true;
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isFile()) {
                    if (contents[i].delete()) continue;
                    deletionSucceeded = false;
                    continue;
                }
                boolean b = false;
                b = contents[i].delete();
                if (b || FileUtil.fullyDelete(contents[i])) continue;
                deletionSucceeded = false;
            }
        }
        return deletionSucceeded;
    }

    @Deprecated
    public static void fullyDelete(FileSystem fs, Path dir) throws IOException {
        fs.delete(dir, true);
    }

    private static void checkDependencies(FileSystem srcFS, Path src, FileSystem dstFS, Path dst) throws IOException {
        if (srcFS == dstFS) {
            String srcq = src.makeQualified(srcFS).toString() + "/";
            String dstq = dst.makeQualified(dstFS).toString() + "/";
            if (dstq.startsWith(srcq)) {
                if (srcq.length() == dstq.length()) {
                    throw new IOException("Cannot copy " + src + " to itself.");
                }
                throw new IOException("Cannot copy " + src + " to its subdirectory " + dst);
            }
        }
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, Configuration conf) throws IOException {
        return FileUtil.copy(srcFS, src, dstFS, dst, deleteSource, true, conf);
    }

    public static boolean copy(FileSystem srcFS, Path[] srcs, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        boolean gotException = false;
        boolean returnVal = true;
        StringBuilder exceptions = new StringBuilder();
        if (srcs.length == 1) {
            return FileUtil.copy(srcFS, srcs[0], dstFS, dst, deleteSource, overwrite, conf);
        }
        if (!dstFS.exists(dst)) {
            throw new IOException("`" + dst + "': specified destination directory " + "doest not exist");
        }
        FileStatus sdst = dstFS.getFileStatus(dst);
        if (!sdst.isDirectory()) {
            throw new IOException("copying multiple files, but last argument `" + dst + "' is not a directory");
        }
        for (Path src : srcs) {
            try {
                if (FileUtil.copy(srcFS, src, dstFS, dst, deleteSource, overwrite, conf)) continue;
                returnVal = false;
            }
            catch (IOException e) {
                gotException = true;
                exceptions.append(e.getMessage());
                exceptions.append("\n");
            }
        }
        if (gotException) {
            throw new IOException(exceptions.toString());
        }
        return returnVal;
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        FileStatus fileStatus = srcFS.getFileStatus(src);
        return FileUtil.copy(srcFS, fileStatus, dstFS, dst, deleteSource, overwrite, conf);
    }

    private static boolean copy(FileSystem srcFS, FileStatus srcStatus, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        Path src = srcStatus.getPath();
        dst = FileUtil.checkDest(src.getName(), dstFS, dst, overwrite);
        if (srcStatus.isDirectory()) {
            FileUtil.checkDependencies(srcFS, src, dstFS, dst);
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            FileStatus[] contents = srcFS.listStatus(src);
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(srcFS, contents[i], dstFS, new Path(dst, contents[i].getPath().getName()), deleteSource, overwrite, conf);
            }
        } else {
            FSDataInputStream in = null;
            FSDataOutputStream out = null;
            try {
                in = srcFS.open(src);
                out = dstFS.create(dst, overwrite);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, conf, true);
            }
            catch (IOException e) {
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                throw e;
            }
        }
        if (deleteSource) {
            return srcFS.delete(src, true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyMerge(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstFile, boolean deleteSource, Configuration conf, String addString) throws IOException {
        dstFile = FileUtil.checkDest(srcDir.getName(), dstFS, dstFile, false);
        if (srcFS.getFileStatus(srcDir).isDirectory()) {
            return false;
        }
        FSDataOutputStream out = dstFS.create(dstFile);
        try {
            FileStatus[] contents = srcFS.listStatus(srcDir);
            for (int i = 0; i < contents.length; ++i) {
                if (!contents[i].isFile()) continue;
                FSDataInputStream in = srcFS.open(contents[i].getPath());
                try {
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, conf, false);
                    if (addString == null) continue;
                    ((OutputStream)out).write(addString.getBytes("UTF-8"));
                    continue;
                }
                finally {
                    ((InputStream)in).close();
                }
            }
        }
        finally {
            ((OutputStream)out).close();
        }
        if (deleteSource) {
            return srcFS.delete(srcDir, true);
        }
        return true;
    }

    public static boolean copy(File src, FileSystem dstFS, Path dst, boolean deleteSource, Configuration conf) throws IOException {
        dst = FileUtil.checkDest(src.getName(), dstFS, dst, false);
        if (src.isDirectory()) {
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            File[] contents = src.listFiles();
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(contents[i], dstFS, new Path(dst, contents[i].getName()), deleteSource, conf);
            }
        } else if (src.isFile()) {
            FileInputStream in = null;
            FSDataOutputStream out = null;
            try {
                in = new FileInputStream(src);
                out = dstFS.create(dst);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, conf);
            }
            catch (IOException e) {
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                throw e;
            }
        } else {
            throw new IOException(src.toString() + ": No such file or directory");
        }
        if (deleteSource) {
            return FileUtil.fullyDelete(src);
        }
        return true;
    }

    public static boolean copy(FileSystem srcFS, Path src, File dst, boolean deleteSource, Configuration conf) throws IOException {
        FileStatus filestatus = srcFS.getFileStatus(src);
        return FileUtil.copy(srcFS, filestatus, dst, deleteSource, conf);
    }

    private static boolean copy(FileSystem srcFS, FileStatus srcStatus, File dst, boolean deleteSource, Configuration conf) throws IOException {
        Path src = srcStatus.getPath();
        if (srcStatus.isDirectory()) {
            if (!dst.mkdirs()) {
                return false;
            }
            FileStatus[] contents = srcFS.listStatus(src);
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(srcFS, contents[i], new File(dst, contents[i].getPath().getName()), deleteSource, conf);
            }
        } else {
            FSDataInputStream in = srcFS.open(src);
            IOUtils.copyBytes((InputStream)in, (OutputStream)new FileOutputStream(dst), conf);
        }
        if (deleteSource) {
            return srcFS.delete(src, true);
        }
        return true;
    }

    private static Path checkDest(String srcName, FileSystem dstFS, Path dst, boolean overwrite) throws IOException {
        if (dstFS.exists(dst)) {
            FileStatus sdst = dstFS.getFileStatus(dst);
            if (sdst.isDirectory()) {
                if (null == srcName) {
                    throw new IOException("Target " + dst + " is a directory");
                }
                return FileUtil.checkDest(null, dstFS, new Path(dst, srcName), overwrite);
            }
            if (!overwrite) {
                throw new IOException("Target " + dst + " already exists");
            }
        }
        return dst;
    }

    public static String makeShellPath(String filename) throws IOException {
        if (Path.WINDOWS) {
            return new CygPathCommand(filename).getResult();
        }
        return filename;
    }

    public static String makeShellPath(File file) throws IOException {
        return FileUtil.makeShellPath(file, false);
    }

    public static String makeShellPath(File file, boolean makeCanonicalPath) throws IOException {
        if (makeCanonicalPath) {
            return FileUtil.makeShellPath(file.getCanonicalPath());
        }
        return FileUtil.makeShellPath(file.toString());
    }

    public static long getDU(File dir) {
        long size = 0L;
        if (!dir.exists()) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return dir.length();
        }
        size = dir.length();
        File[] allFiles = dir.listFiles();
        for (int i = 0; i < allFiles.length; ++i) {
            size += FileUtil.getDU(allFiles[i]);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(File inFile, File unzipDir) throws IOException {
        ZipFile zipFile = new ZipFile(inFile);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                InputStream in = zipFile.getInputStream(entry);
                try {
                    File file = new File(unzipDir, entry.getName());
                    if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                        throw new IOException("Mkdirs failed to create " + file.getParentFile().toString());
                    }
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        int i;
                        byte[] buffer = new byte[8192];
                        while ((i = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, i);
                        }
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            zipFile.close();
        }
    }

    public static void unTar(File inFile, File untarDir) throws IOException {
        if (!untarDir.mkdirs() && !untarDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + untarDir);
        }
        StringBuilder untarCommand = new StringBuilder();
        boolean gzipped = inFile.toString().endsWith("gz");
        if (gzipped) {
            untarCommand.append(" gzip -dc '");
            untarCommand.append(FileUtil.makeShellPath(inFile));
            untarCommand.append("' | (");
        }
        untarCommand.append("cd '");
        untarCommand.append(FileUtil.makeShellPath(untarDir));
        untarCommand.append("' ; ");
        untarCommand.append("tar -xf ");
        if (gzipped) {
            untarCommand.append(" -)");
        } else {
            untarCommand.append(FileUtil.makeShellPath(inFile));
        }
        String[] shellCmd = new String[]{"bash", "-c", untarCommand.toString()};
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(shellCmd);
        shexec.execute();
        int exitcode = shexec.getExitCode();
        if (exitcode != 0) {
            throw new IOException("Error untarring file " + inFile + ". Tar process exited with exit code " + exitcode);
        }
    }

    private static IOException createIOException(File f, String message, String error, int exitvalue, Exception cause) {
        String s = "Failed to get link count on file " + f + ": message=" + message + "; error=" + error + "; exit value=" + exitvalue;
        return cause == null ? new IOException(s) : new IOException(s, cause);
    }

    public static int symLink(String target, String linkname) throws IOException {
        String cmd = "ln -s " + target + " " + linkname;
        Process p = Runtime.getRuntime().exec(cmd, null);
        int returnVal = -1;
        try {
            returnVal = p.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return returnVal;
    }

    public static int chmod(String filename, String perm) throws IOException, InterruptedException {
        return FileUtil.chmod(filename, perm, false);
    }

    public static int chmod(String filename, String perm, boolean recursive) throws IOException, InterruptedException {
        Shell.ShellCommandExecutor shExec;
        block3: {
            StringBuilder cmdBuf = new StringBuilder();
            cmdBuf.append("chmod ");
            if (recursive) {
                cmdBuf.append("-R ");
            }
            cmdBuf.append(perm).append(" ");
            cmdBuf.append(filename);
            String[] shellCmd = new String[]{"bash", "-c", cmdBuf.toString()};
            shExec = new Shell.ShellCommandExecutor(shellCmd);
            try {
                shExec.execute();
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)("Error while changing permission : " + filename + " Exception: " + StringUtils.stringifyException(e)));
            }
        }
        return shExec.getExitCode();
    }

    public static final File createLocalTempFile(File basefile, String prefix, boolean isDeleteOnExit) throws IOException {
        File tmp = File.createTempFile(prefix + basefile.getName(), "", basefile.getParentFile());
        if (isDeleteOnExit) {
            tmp.deleteOnExit();
        }
        return tmp;
    }

    public static void replaceFile(File src, File target) throws IOException {
        if (!src.renameTo(target)) {
            int retries = 5;
            while (target.exists() && !target.delete() && retries-- >= 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("replaceFile interrupted.");
                }
            }
            if (!src.renameTo(target)) {
                throw new IOException("Unable to rename " + src + " to " + target);
            }
        }
    }

    public static class HardLink {
        private static String[] hardLinkCommand;
        private static String[] getLinkCountCommand;
        private static OSType osType;

        private static OSType getOSType() {
            String osName = System.getProperty("os.name");
            if (osName.indexOf("Windows") >= 0 && (osName.indexOf("XP") >= 0 || osName.indexOf("2003") >= 0 || osName.indexOf("Vista") >= 0)) {
                return OSType.OS_TYPE_WINXP;
            }
            if (osName.indexOf("SunOS") >= 0) {
                return OSType.OS_TYPE_SOLARIS;
            }
            if (osName.indexOf("Mac") >= 0) {
                return OSType.OS_TYPE_MAC;
            }
            return OSType.OS_TYPE_UNIX;
        }

        public static void createHardLink(File target, File linkName) throws IOException {
            int len = hardLinkCommand.length;
            if (osType == OSType.OS_TYPE_WINXP) {
                HardLink.hardLinkCommand[len - 1] = target.getCanonicalPath();
                HardLink.hardLinkCommand[len - 2] = linkName.getCanonicalPath();
            } else {
                HardLink.hardLinkCommand[len - 2] = FileUtil.makeShellPath(target, true);
                HardLink.hardLinkCommand[len - 1] = FileUtil.makeShellPath(linkName, true);
            }
            Process process = Runtime.getRuntime().exec(hardLinkCommand);
            try {
                if (process.waitFor() != 0) {
                    String inpMsg;
                    String errMsg = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
                    if (errMsg == null) {
                        errMsg = "";
                    }
                    if ((inpMsg = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine()) == null) {
                        inpMsg = "";
                    }
                    throw new IOException(errMsg + inpMsg);
                }
            }
            catch (InterruptedException e) {
                throw new IOException(StringUtils.stringifyException(e));
            }
            finally {
                process.destroy();
            }
        }

        public static int getLinkCount(File fileName) throws IOException {
            if (!fileName.exists()) {
                throw new FileNotFoundException(fileName + " not found.");
            }
            int len = getLinkCountCommand.length;
            String[] cmd = new String[len + 1];
            for (int i = 0; i < len; ++i) {
                cmd[i] = getLinkCountCommand[i];
            }
            cmd[len] = fileName.toString();
            String inpMsg = null;
            String errMsg = null;
            int exitValue = -1;
            BufferedReader in = null;
            BufferedReader err = null;
            Process process = Runtime.getRuntime().exec(cmd);
            try {
                exitValue = process.waitFor();
                in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                inpMsg = in.readLine();
                err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                errMsg = err.readLine();
                if (inpMsg == null || exitValue != 0) {
                    throw FileUtil.createIOException(fileName, inpMsg, errMsg, exitValue, null);
                }
                if (HardLink.getOSType() == OSType.OS_TYPE_SOLARIS) {
                    String[] result = inpMsg.split("\\s+");
                    int n = Integer.parseInt(result[1]);
                    return n;
                }
                int result = Integer.parseInt(inpMsg);
                return result;
            }
            catch (NumberFormatException e) {
                throw FileUtil.createIOException(fileName, inpMsg, errMsg, exitValue, e);
            }
            catch (InterruptedException e) {
                throw FileUtil.createIOException(fileName, inpMsg, errMsg, exitValue, e);
            }
            finally {
                process.destroy();
                if (in != null) {
                    in.close();
                }
                if (err != null) {
                    err.close();
                }
            }
        }

        static {
            osType = HardLink.getOSType();
            switch (osType) {
                case OS_TYPE_WINXP: {
                    hardLinkCommand = new String[]{"fsutil", "hardlink", "create", null, null};
                    getLinkCountCommand = new String[]{"stat", "-c%h"};
                    break;
                }
                case OS_TYPE_SOLARIS: {
                    hardLinkCommand = new String[]{"ln", null, null};
                    getLinkCountCommand = new String[]{"ls", "-l"};
                    break;
                }
                case OS_TYPE_MAC: {
                    hardLinkCommand = new String[]{"ln", null, null};
                    getLinkCountCommand = new String[]{"stat", "-f%l"};
                    break;
                }
                default: {
                    hardLinkCommand = new String[]{"ln", null, null};
                    getLinkCountCommand = new String[]{"stat", "-c%h"};
                }
            }
        }

        static enum OSType {
            OS_TYPE_UNIX,
            OS_TYPE_WINXP,
            OS_TYPE_SOLARIS,
            OS_TYPE_MAC;

        }
    }

    private static class CygPathCommand
    extends Shell {
        String[] command;
        String result;

        CygPathCommand(String path) throws IOException {
            this.command = new String[]{"cygpath", "-u", path};
            this.run();
        }

        String getResult() throws IOException {
            return this.result;
        }

        @Override
        protected String[] getExecString() {
            return this.command;
        }

        @Override
        protected void parseExecResult(BufferedReader lines) throws IOException {
            String line = lines.readLine();
            if (line == null) {
                throw new IOException("Can't convert '" + this.command[2] + " to a cygwin path");
            }
            this.result = line;
        }
    }
}

