/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.reflect.ReflectRequestor;
import org.apache.avro.reflect.ReflectResponder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;

class AvroRpcEngine
implements RpcEngine {
    private static final Log LOG = LogFactory.getLog(RPC.class);
    private static int VERSION = 0;
    private static final RpcEngine ENGINE = new WritableRpcEngine();

    AvroRpcEngine() {
    }

    @Override
    public Object getProxy(Class protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, addr, ticket, conf, factory));
    }

    @Override
    public void stopProxy(Object proxy) {
        try {
            ((Invoker)Proxy.getInvocationHandler(proxy)).close();
        }
        catch (IOException e) {
            LOG.warn((Object)("Error while stopping " + proxy), (Throwable)e);
        }
    }

    @Override
    public Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, UserGroupInformation ticket, Configuration conf) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RPC.Server getServer(Class iface, Object impl, String bindAddress, int port, int numHandlers, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager) throws IOException {
        return ENGINE.getServer(TunnelProtocol.class, new TunnelResponder(iface, impl), bindAddress, port, numHandlers, verbose, conf, secretManager);
    }

    private static class TunnelResponder
    extends ReflectResponder
    implements TunnelProtocol {
        public TunnelResponder(Class iface, Object impl) {
            super(iface, impl);
        }

        @Override
        public long getProtocolVersion(String protocol, long version) throws IOException {
            return VERSION;
        }

        @Override
        public BufferListWritable call(BufferListWritable request) throws IOException {
            return new BufferListWritable(this.respond(request.buffers));
        }
    }

    private static class Invoker
    implements InvocationHandler,
    Closeable {
        private final ClientTransceiver tx;
        private final ReflectRequestor requestor;

        public Invoker(Class<?> protocol, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
            this.tx = new ClientTransceiver(addr, ticket, conf, factory);
            this.requestor = new ReflectRequestor(protocol, (Transceiver)this.tx);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.requestor.invoke(proxy, method, args);
        }

        @Override
        public void close() throws IOException {
            this.tx.close();
        }
    }

    private static class ClientTransceiver
    extends Transceiver {
        private TunnelProtocol tunnel;
        private InetSocketAddress remote;

        public ClientTransceiver(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
            this.tunnel = (TunnelProtocol)ENGINE.getProxy(TunnelProtocol.class, VERSION, addr, ticket, conf, factory);
            this.remote = addr;
        }

        public String getRemoteName() {
            return this.remote.toString();
        }

        public List<ByteBuffer> transceive(List<ByteBuffer> request) throws IOException {
            return this.tunnel.call(new BufferListWritable(request)).buffers;
        }

        public List<ByteBuffer> readBuffers() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void writeBuffers(List<ByteBuffer> buffers) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void close() throws IOException {
            ENGINE.stopProxy(this.tunnel);
        }
    }

    private static class BufferListWritable
    implements Writable {
        private List<ByteBuffer> buffers;

        public BufferListWritable() {
        }

        public BufferListWritable(List<ByteBuffer> buffers) {
            this.buffers = buffers;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            int size = in.readInt();
            this.buffers = new ArrayList<ByteBuffer>(size);
            for (int i = 0; i < size; ++i) {
                int length = in.readInt();
                ByteBuffer buffer = ByteBuffer.allocate(length);
                in.readFully(buffer.array(), 0, length);
                this.buffers.add(buffer);
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.buffers.size());
            for (ByteBuffer buffer : this.buffers) {
                out.writeInt(buffer.remaining());
                out.write(buffer.array(), buffer.position(), buffer.remaining());
            }
        }
    }

    private static interface TunnelProtocol
    extends VersionedProtocol {
        public BufferListWritable call(BufferListWritable var1) throws IOException;
    }
}

