/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import okuyama.imdst.util.ImdstDefine;

public class CustomReader {
    private InputStream is = null;
    private BufferedInputStream bis = null;
    private ByteArrayOutputStream bos = null;
    private byte[] b = new byte[1];

    public CustomReader(InputStream is) {
        this.is = is;
        if (!ImdstDefine.bigDataTransfer) {
            this.bos = new ByteArrayOutputStream(8192);
            this.bis = new BufferedInputStream(this.is, 8192);
        } else {
            this.bos = new ByteArrayOutputStream(0x100000);
            this.bis = new BufferedInputStream(this.is, 262144);
        }
    }

    private String readLine4Big() throws Exception {
        byte[] b = new byte[262144];
        boolean i = false;
        int readLen = 0;
        while ((readLen = this.bis.read(b, 0, 262144)) != -1) {
            if (readLen == 1) {
                if (b[0] == 10) break;
                if (b[0] == 13) continue;
                this.bos.write(b, 0, readLen);
                continue;
            }
            if (b[readLen - 2] != 13 && b[readLen - 1] != 10) {
                this.bos.write(b, 0, readLen);
                continue;
            }
            if (b[readLen - 1] != 10) continue;
            if (b[readLen - 2] == 13) {
                this.bos.write(b, 0, readLen - 2);
                break;
            }
            this.bos.write(b, 0, readLen - 1);
            break;
        }
        String ret = this.bos.toString();
        this.bos.reset();
        return ret;
    }

    private String readLine4Small() throws Exception {
        this.b[0] = 0;
        boolean i = false;
        while (this.bis.read(this.b, 0, 1) != -1) {
            if (this.b[0] != 13 && this.b[0] != 10) {
                this.bos.write(this.b, 0, 1);
                continue;
            }
            if (this.b[0] != 10) continue;
        }
        String ret = this.bos.toString();
        this.bos.reset();
        return ret;
    }

    public String readLine() throws Exception {
        if (ImdstDefine.bigDataTransfer) {
            return this.readLine4Big();
        }
        return this.readLine4Small();
    }

    public boolean ready() throws Exception {
        return this.bis.available() > 0;
    }

    public int read(byte[] buf) throws Exception {
        for (int i = 0; i < buf.length; ++i) {
            this.bis.read(buf, i, 1);
        }
        return buf.length;
    }

    public void mark(int point) throws Exception {
        this.bis.mark(point);
    }

    public int read() throws Exception {
        return this.bis.read();
    }

    public void reset() throws Exception {
        this.bis.reset();
    }

    public void close() {
        try {
            if (this.bis != null) {
                this.bis.close();
                this.bis = null;
            }
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

