/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.JavaSystemApi;
import okuyama.imdst.util.io.NodeDnsUtil;

public class KeyNodeConnector {
    private String nodeName = null;
    private int nodePort = -1;
    private String nodeFullName = null;
    private Socket socket = null;
    private PrintWriter pw = null;
    private BufferedReader br = null;
    private Long connectTime = null;
    private int useCount = 0;
    private boolean poolConnect = false;
    private boolean retryConnectMode = true;
    private boolean retry = false;
    private static boolean recoverMode = false;
    private static String recoverTarget = "";

    public KeyNodeConnector(String nodeName, int nodePort, String nodeFullName) throws Exception {
        this.nodeName = nodeName;
        this.nodePort = nodePort;
        this.nodeFullName = nodeFullName;
    }

    public static void setRecoverMode(boolean mode, String target) {
        recoverMode = mode;
        recoverTarget = mode ? target : "";
    }

    public void connect() throws Exception {
        this.connect(ImdstDefine.nodeConnectionOpenTimeout);
    }

    public void connect(int connectOpenTime) throws Exception {
        InetSocketAddress inetAddr = null;
        inetAddr = new InetSocketAddress(NodeDnsUtil.getNameToReal(this.nodeName), this.nodePort);
        this.socket = new Socket();
        this.socket.setTcpNoDelay(ImdstDefine.tcpNoDelay);
        if (ImdstDefine.tcpReceiveBufferSize != 0) {
            this.socket.setReceiveBufferSize(ImdstDefine.tcpReceiveBufferSize);
        }
        if (ImdstDefine.tcpSendBufferSize != 0) {
            this.socket.setSendBufferSize(ImdstDefine.tcpSendBufferSize);
        }
        this.socket.connect(inetAddr, connectOpenTime);
        this.connectTime = new Long(JavaSystemApi.currentTimeMillis);
        if (recoverMode && recoverTarget.equals(this.nodeFullName)) {
            this.socket.setSoTimeout(300000);
        } else {
            this.socket.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
        }
        this.pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8")));
        this.br = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
    }

    public String readLine() throws Exception {
        return this.readLine(null, false);
    }

    public String readLineWithReady() throws Exception {
        return this.readLine(null, true);
    }

    public String readLine(String retryStr) throws Exception {
        if (ImdstDefine.compulsionRetryConnectMode) {
            this.retry = false;
        }
        return this.readLine(retryStr, false);
    }

    public String readLineWithReady(String retryStr) throws Exception {
        if (ImdstDefine.compulsionRetryConnectMode) {
            this.retry = false;
        }
        return this.readLine(retryStr, true);
    }

    private String readLine(String retryStr, boolean isReady) throws Exception {
        String ret = null;
        try {
            ++this.useCount;
            if (isReady && !this.br.ready()) {
                Thread.sleep(500L);
            }
            if (recoverMode && recoverTarget.equals(this.nodeFullName)) {
                this.socket.setSoTimeout(300000);
            }
            if ((ret = this.br.readLine()) == null) {
                throw new IOException("readLine Ret = null");
            }
            this.retry = false;
        }
        catch (Exception e) {
            this.useCount = Integer.MAX_VALUE;
            if (this.retryConnectMode && !this.retry) {
                this.retry = true;
                if (this.socket != null && !this.socket.isClosed()) {
                    this.br.close();
                    this.br = null;
                    this.pw.close();
                    this.pw = null;
                    this.socket.close();
                    this.socket = null;
                }
                try {
                    Thread.sleep(100L);
                    this.connect();
                }
                catch (SocketTimeoutException ste) {
                    Thread.sleep(5000L);
                    this.connect();
                }
                if (retryStr != null) {
                    this.socket.setSoTimeout(ImdstDefine.nodeConnectionTimeout * 5);
                    this.pw.println(retryStr);
                    this.pw.flush();
                    ret = this.br.readLine();
                    if (ret == null) {
                        this.close();
                        this.connect();
                        this.socket.setSoTimeout(ImdstDefine.nodeConnectionTimeout * 5);
                        this.pw.println(retryStr);
                        this.pw.flush();
                        ret = this.br.readLine();
                    }
                }
                this.socket.setSoTimeout(ImdstDefine.nodeConnectionTimeout);
                this.retry = false;
            }
            throw e;
        }
        return ret;
    }

    public void print(String str) throws Exception {
        this.pw.print(str);
        this.retry = false;
    }

    public void println(String str) throws Exception {
        try {
            if (str.length() < 50000) {
                this.pw.println(str);
                this.retry = false;
            } else if (str.indexOf("1,") == 0) {
                this.pw.println("1001," + str.length());
                this.pw.println(str.length());
                this.pw.flush();
                this.pw.print(str);
                this.retry = false;
            } else {
                this.pw.println(str);
                this.retry = false;
            }
        }
        catch (Exception e) {
            if (this.retryConnectMode && !this.retry) {
                this.retry = true;
                try {
                    if (this.socket != null && !this.socket.isClosed()) {
                        this.socket.close();
                    }
                    this.connect();
                    this.println(str);
                }
                catch (Exception ee) {
                    throw e;
                }
            }
            throw e;
        }
    }

    public void flush() throws Exception {
        this.pw.flush();
        this.retry = false;
    }

    public void setSoTimeout(int time) throws Exception {
        if (this.socket != null) {
            this.socket.setSoTimeout(time);
        }
    }

    public Long getConnetTime() {
        return this.connectTime;
    }

    public void setPoolConnectStatus(boolean status) {
        this.poolConnect = status;
    }

    public boolean getPoolConnectStatus() {
        return this.poolConnect;
    }

    public void initRetryFlg() {
        this.retry = false;
    }

    public void setRetryConnectMode(boolean mode) {
        this.retryConnectMode = mode;
    }

    public String getNodeFullName() {
        return this.nodeFullName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getNodePort() {
        return this.nodePort;
    }

    public void close() {
        try {
            if (this.pw != null) {
                this.pw.println("(&imdst9999&)");
                this.pw.flush();
                this.pw.close();
                this.pw = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.br != null) {
                this.br.close();
                this.pw = null;
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getUseCount() {
        return this.useCount;
    }

    public String connectorDump() {
        StringBuilder dump = new StringBuilder(1024);
        dump.append(this.nodeName);
        dump.append(" / ");
        dump.append(this.nodePort);
        dump.append(" / ");
        dump.append(this.nodeFullName);
        dump.append(" / ");
        dump.append(this.socket);
        dump.append(" / ");
        dump.append(this.pw);
        dump.append(" / ");
        dump.append(this.br);
        dump.append(" / ");
        dump.append(this.connectTime);
        dump.append(" / ");
        dump.append(this.poolConnect);
        dump.append(" / ");
        dump.append(this.retryConnectMode);
        dump.append(" / ");
        dump.append(this.retry);
        dump.append(" / ");
        return dump.toString();
    }
}

