/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.serializemap;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import okuyama.imdst.util.CoreMapKey;
import okuyama.imdst.util.serializemap.ByteDataSerializeCustomHashMap;
import okuyama.imdst.util.serializemap.ISerializer;

public class ByteDataSerializer
implements Cloneable,
Serializable,
ISerializer {
    private String serializeMapName = null;
    private boolean valueDisk = false;

    public ByteDataSerializer() {
    }

    public ByteDataSerializer(String mode) {
        if (mode.trim().toLowerCase().equals("disk")) {
            this.valueDisk = true;
        }
    }

    @Override
    public void setInstanceCreateMapName(String mapName) {
        this.serializeMapName = mapName;
    }

    @Override
    public byte[] serialize(Map serializeTarget, Class mapKeyClazz, Class mapValueClazz, Object key, int uniqueNo) {
        byte[] retData = null;
        if (this.valueDisk) {
            if (serializeTarget instanceof ByteDataSerializeCustomHashMap) {
                retData = ((ByteDataSerializeCustomHashMap)serializeTarget).byteData;
            } else if (serializeTarget instanceof HashMap) {
                String val = (String)serializeTarget.get(key);
                String keyVal = key + ";" + val;
                byte[] newData = new byte[4096];
                byte[] keyValByte = keyVal.getBytes();
                for (int idx = 0; idx < keyValByte.length; ++idx) {
                    newData[idx] = keyValByte[idx];
                }
                retData = newData;
            }
        } else if (serializeTarget instanceof ByteDataSerializeCustomHashMap) {
            retData = ((ByteDataSerializeCustomHashMap)serializeTarget).byteData;
        } else if (serializeTarget instanceof HashMap) {
            byte[] val = (byte[])serializeTarget.get(key);
            String keyVal = key + ";" + new String(val);
            byte[] newData = new byte[4096];
            byte[] keyValByte = keyVal.getBytes();
            for (int idx = 0; idx < keyValByte.length; ++idx) {
                newData[idx] = keyValByte[idx];
            }
            retData = newData;
        }
        return retData;
    }

    @Override
    public Map deSerialize(byte[] deserializeTarget, Object key, int uniqueNo) {
        if (this.valueDisk) {
            String dataStr = null;
            String[] keyVal = null;
            dataStr = new String(deserializeTarget);
            dataStr = dataStr.trim();
            ByteDataSerializeCustomHashMap customHashMap = new ByteDataSerializeCustomHashMap(deserializeTarget);
            if (!dataStr.equals("")) {
                keyVal = dataStr.split(",");
                for (int idx = 0; idx < keyVal.length; ++idx) {
                    String[] singleData = keyVal[idx].split(";");
                    customHashMap.originalPut(new CoreMapKey(singleData[0]), new String(singleData[1]));
                }
            }
            return customHashMap;
        }
        String dataStr = null;
        String[] keyVal = null;
        dataStr = new String(deserializeTarget);
        dataStr = dataStr.trim();
        ByteDataSerializeCustomHashMap customHashMap = new ByteDataSerializeCustomHashMap(deserializeTarget);
        if (!dataStr.equals("")) {
            keyVal = dataStr.split(",");
            for (int idx = 0; idx < keyVal.length; ++idx) {
                String[] singleData = keyVal[idx].split(";");
                customHashMap.originalPut(new CoreMapKey(singleData[0]), singleData[1].getBytes());
            }
        }
        return customHashMap;
    }

    @Override
    public void clearParentMap() {
    }
}

