/*
 * Decompiled with CFR 0.152.
 */
package test.job;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import okuyama.base.job.AbstractJob;
import okuyama.base.job.IJob;
import okuyama.base.lang.BatchException;
import okuyama.base.util.ILogger;
import okuyama.base.util.LoggerFactory;
import okuyama.imdst.client.OkuyamaClient;
import okuyama.imdst.client.OkuyamaResultSet;

public class MethodPatterTestJob
extends AbstractJob
implements IJob {
    private String masterNodeName = "127.0.0.1";
    private int masterNodePort = 8888;
    private int nowCount = 0;
    private ILogger logger = LoggerFactory.createLogger(MethodPatterTestJob.class);
    private String bigCharacter = "";

    @Override
    public void initJob(String initValue) {
        if (initValue != null && !initValue.equals("")) {
            String[] master = initValue.split(":");
            this.masterNodeName = master[0];
            this.masterNodePort = Integer.parseInt(master[1]);
        }
    }

    @Override
    public String executeJob(String optionParam) throws BatchException {
        String ret = SUCCESS;
        String[] execMethods = null;
        int count = 5000;
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>();
        try {
            execMethods = optionParam.split(",");
            int port = this.masterNodePort;
            OkuyamaClient okuyamaClient = null;
            String startStr = super.getPropertiesValue(super.getJobName() + "start");
            String listNamePrefix = super.getPropertiesValue(super.getJobName() + "list");
            int start = Integer.parseInt(startStr);
            count += start;
            for (int cy = 0; cy < 1; ++cy) {
                for (int t = 0; t < Integer.parseInt(execMethods[0]); ++t) {
                    int i;
                    StringBuilder strBuf = new StringBuilder(60000);
                    Random rnd = new Random();
                    for (i = 0; i < 300; ++i) {
                        strBuf.append(rnd.nextInt(1999999999));
                    }
                    this.bigCharacter = strBuf.toString();
                    this.nowCount = t;
                    System.out.println("Test Count =[" + t + "]");
                    for (i = 1; i < execMethods.length; ++i) {
                        if (execMethods[i].equals("set")) {
                            retMap.put("set", this.execSet(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("get")) {
                            retMap.put("get", this.execGet(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("settag")) {
                            retMap.put("settag", this.execTagSet(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("gettag")) {
                            retMap.put("gettag", this.execTagGet(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("remove")) {
                            retMap.put("remove", this.execRemove(okuyamaClient, start, 500));
                        }
                        if (execMethods[i].equals("script")) {
                            retMap.put("script", this.execScript(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("add")) {
                            retMap.put("add", this.execAdd(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("gets-cas")) {
                            retMap.put("cas", this.execGetsCas(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("incr")) {
                            retMap.put("incr", this.execIncr(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("decr")) {
                            retMap.put("decr", this.execDecr(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("tagremove")) {
                            retMap.put("tagremove", this.execTagRemove(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("index")) {
                            retMap.put("createindex", this.execIndex(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("setexpireandget")) {
                            retMap.put("setexpireandget", this.execSetExpireAndGet(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("getmultitagvalues")) {
                            retMap.put("getmultitagvalues", this.execGetMultiTagValues(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("objectsetget")) {
                            retMap.put("objectsetget", this.execObjectSetGet(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("getmultitagkeys")) {
                            retMap.put("getmultitagkeys", this.execGetMultiTagKeys(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("gettagkeysresult")) {
                            retMap.put("gettagkeysresult", this.execGetTagKeysResult(okuyamaClient, start, count));
                        }
                        if (execMethods[i].equals("getmultitagkeysresult")) {
                            retMap.put("getmultitagkeysresult", this.execMultiGetTagKeysResult(okuyamaClient, start, count));
                        }
                        if (!execMethods[i].equals("list")) continue;
                        retMap.put("list", this.execList(okuyamaClient, start, listNamePrefix));
                    }
                    System.out.println("ErrorMap=" + retMap.toString());
                    System.out.println("---------------------------------------------");
                    okuyamaClient = new OkuyamaClient();
                    okuyamaClient.connect(this.masterNodeName, port);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(new Date());
            System.out.println(retMap);
            throw new BatchException(e);
        }
        return ret;
    }

    private boolean execSet(OkuyamaClient client, int start, int count) throws Exception {
        int i;
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execSet - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        for (i = start; i < count; ++i) {
            if (!okuyamaClient.setValue(this.nowCount + "datasavekey_" + new Integer(i).toString(), this.nowCount + "testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + new Integer(i).toString())) {
                System.out.println("Set - Error=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + ", " + this.nowCount + "testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + new Integer(i).toString());
                errorFlg = true;
            }
            if (i % 10000 != 0) continue;
            System.out.println(i);
        }
        for (i = start; i < start + 500; ++i) {
            if (!okuyamaClient.setValue(this.nowCount + "datasavekey_bigdata_" + new Integer(i).toString(), this.nowCount + "savetestbigdata_" + new Integer(i).toString() + "_" + this.bigCharacter + "_" + new Integer(i).toString())) {
                System.out.println("Set - Error=[" + this.nowCount + "datasavekey_bigdata_" + new Integer(i).toString());
                errorFlg = true;
            }
            if (i % 10000 != 0) continue;
            System.out.println(i);
        }
        long endTime = new Date().getTime();
        System.out.println("Set Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execSet - End");
        return errorFlg;
    }

    private boolean execGet(OkuyamaClient client, int start, int count) throws Exception {
        int i;
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execGet - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] ret = null;
        long startTime = new Date().getTime();
        for (i = start; i < count; ++i) {
            ret = okuyamaClient.getValue(this.nowCount + "datasavekey_" + new Integer(i).toString());
            if (ret[0].equals("true")) {
                if (ret[1].equals(this.nowCount + "testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + new Integer(i).toString())) continue;
                System.out.println("\u30c7\u30fc\u30bf\u304c\u5408\u3063\u3066\u3044\u306a\u3044 key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]  value=[" + ret[1] + "]");
                errorFlg = true;
                continue;
            }
            if (ret[0].equals("false")) {
                System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]");
                this.logger.error("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]");
                errorFlg = true;
                continue;
            }
            if (!ret[0].equals("error")) continue;
            System.out.println("Error key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        for (i = start; i < start + 500; ++i) {
            ret = okuyamaClient.getValue(this.nowCount + "datasavekey_bigdata_" + new Integer(i).toString());
            if (ret[0].equals("true")) {
                if (ret[1].equals(this.nowCount + "savetestbigdata_" + new Integer(i).toString() + "_" + this.bigCharacter + "_" + new Integer(i).toString())) continue;
                System.out.println("\u30c7\u30fc\u30bf\u304c\u5408\u3063\u3066\u3044\u306a\u3044 key=[" + this.nowCount + "savetestbigdata_" + new Integer(i).toString() + "]  value=[" + ret[1] + "]");
                errorFlg = true;
                continue;
            }
            if (ret[0].equals("false")) {
                System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + this.nowCount + "datasavekey_bigdata_" + new Integer(i).toString() + "]");
                this.logger.error("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + this.nowCount + "datasavekey_bigdata" + new Integer(i).toString() + "]");
                errorFlg = true;
                continue;
            }
            if (!ret[0].equals("error")) continue;
            System.out.println("Error key=[" + this.nowCount + "datasavekey_bigdata_" + new Integer(i).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        String[] keys = new String[102];
        int idx = 0;
        HashMap<String, String> checkResultMap = new HashMap<String, String>(50);
        for (int i2 = start; i2 < start + 50; ++i2) {
            keys[idx] = this.nowCount + "datasavekey_" + new Integer(i2).toString();
            checkResultMap.put(keys[idx], this.nowCount + "testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + new Integer(i2).toString());
            keys[idx + 1] = this.nowCount + "datasavekey_bigdata_" + new Integer(i2).toString();
            checkResultMap.put(keys[idx + 1], this.nowCount + "savetestbigdata_" + new Integer(i2).toString() + "_" + this.bigCharacter + "_" + new Integer(i2).toString());
            idx += 2;
        }
        Map multiGetRet = okuyamaClient.getMultiValue(keys);
        if (!((Object)checkResultMap).equals(multiGetRet)) {
            System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 MultiGet=[" + multiGetRet + "]");
            this.logger.error("\u30c7\u30fc\u30bf\u306a\u3057 MultiGet=[" + multiGetRet + "]");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Get Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execGet - End");
        return errorFlg;
    }

    private boolean execTagSet(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execTagSet - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] tag1 = new String[]{start + "_" + this.nowCount + "_tag1"};
        String[] tag2 = new String[]{start + "_" + this.nowCount + "_tag1", start + "_" + this.nowCount + "_tag2"};
        String[] tag3 = new String[]{start + "_" + this.nowCount + "_tag1", start + "_" + this.nowCount + "_tag2", start + "_" + this.nowCount + "_tag3"};
        String[] tag4 = new String[]{start + "_" + this.nowCount + "_tag4"};
        String[] setTag = null;
        int counter = 0;
        long startTime = new Date().getTime();
        for (int i = start; i < count; ++i) {
            if (counter == 0) {
                setTag = tag1;
                ++counter;
            } else if (counter == 1) {
                setTag = tag2;
                ++counter;
            } else if (counter == 2) {
                setTag = tag3;
                ++counter;
            } else if (counter == 3) {
                setTag = tag4;
                counter = 0;
            }
            if (okuyamaClient.setValue(this.nowCount + "tagsampledatakey_" + new Integer(i).toString(), setTag, this.nowCount + "tagsamplesavedata_" + new Integer(i).toString())) continue;
            System.out.println("Tag Set - Error=[" + this.nowCount + "tagsampledatakey_" + new Integer(i).toString() + ", " + this.nowCount + "tagsamplesavedata_" + new Integer(i).toString());
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Tag Set Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execTagSet - End");
        return errorFlg;
    }

    private boolean execTagGet(OkuyamaClient client, int start, int count) throws Exception {
        int idx;
        int ii;
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execTagGet - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] tag1 = new String[]{start + "_" + this.nowCount + "_tag1"};
        String[] tag2 = new String[]{start + "_" + this.nowCount + "_tag1", start + "_" + this.nowCount + "_tag2"};
        String[] tag3 = new String[]{start + "_" + this.nowCount + "_tag1", start + "_" + this.nowCount + "_tag2", start + "_" + this.nowCount + "_tag3"};
        String[] tag4 = new String[]{start + "_" + this.nowCount + "_tag4"};
        Object setTag = null;
        ArrayList<String> tag1RetList = new ArrayList<String>();
        ArrayList<String> tag2RetList = new ArrayList<String>();
        ArrayList<String> tag3RetList = new ArrayList<String>();
        ArrayList<String> tag4RetList = new ArrayList<String>();
        int counter = 0;
        for (int i = start; i < count; ++i) {
            if (counter == 0) {
                tag1RetList.add(this.nowCount + "tagsampledatakey_" + new Integer(i).toString());
                ++counter;
                continue;
            }
            if (counter == 1) {
                tag1RetList.add(this.nowCount + "tagsampledatakey_" + new Integer(i).toString());
                tag2RetList.add(this.nowCount + "tagsampledatakey_" + new Integer(i).toString());
                ++counter;
                continue;
            }
            if (counter == 2) {
                tag1RetList.add(this.nowCount + "tagsampledatakey_" + new Integer(i).toString());
                tag2RetList.add(this.nowCount + "tagsampledatakey_" + new Integer(i).toString());
                tag3RetList.add(this.nowCount + "tagsampledatakey_" + new Integer(i).toString());
                ++counter;
                continue;
            }
            if (counter != 3) continue;
            tag4RetList.add(this.nowCount + "tagsampledatakey_" + new Integer(i).toString());
            counter = 0;
        }
        HashMap<String, String> getResult1 = new HashMap<String, String>();
        HashMap<String, String> getResult2 = new HashMap<String, String>();
        HashMap<String, String> getResult3 = new HashMap<String, String>();
        HashMap<String, String> getResult4 = new HashMap<String, String>();
        String[] keys = null;
        long startTime = new Date().getTime();
        Object[] ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag1");
        if (ret[0].equals("true")) {
            keys = (String[])ret[1];
            for (ii = 0; ii < keys.length; ++ii) {
                getResult1.put(keys[ii], "*");
            }
        } else if (ret[0].equals("false")) {
            System.out.println(start + "tag1=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println(start + "tag1=Error[" + ret[1] + "]");
            errorFlg = true;
        }
        ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag2");
        if (ret[0].equals("true")) {
            keys = (String[])ret[1];
            for (ii = 0; ii < keys.length; ++ii) {
                getResult2.put(keys[ii], "*");
            }
        } else if (ret[0].equals("false")) {
            System.out.println(start + "_tag2=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println(start + "tag2=Error[" + ret[1] + "]");
            errorFlg = true;
        }
        ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag3");
        if (ret[0].equals("true")) {
            keys = (String[])ret[1];
            for (ii = 0; ii < keys.length; ++ii) {
                getResult3.put(keys[ii], "*");
            }
        } else if (ret[0].equals("false")) {
            System.out.println(start + "_tag3=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println(start + "tag3=Error[" + ret[1] + "]");
            errorFlg = true;
        }
        ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag4");
        if (ret[0].equals("true")) {
            keys = (String[])ret[1];
            for (ii = 0; ii < keys.length; ++ii) {
                getResult4.put(keys[ii], "*");
            }
        } else if (ret[0].equals("false")) {
            System.out.println(start + "_tag4=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println(start + "tag4=Error[" + ret[1] + "]");
            errorFlg = true;
        }
        for (idx = 0; idx < tag1RetList.size(); ++idx) {
            if (getResult1.containsKey((String)tag1RetList.get(idx))) continue;
            System.out.println(start + "_tag1=\u8a72\u5f53\u30c7\u30fc\u30bf\u306a\u3057 Key=[" + (String)tag1RetList.get(idx) + "]");
            errorFlg = true;
        }
        for (idx = 0; idx < tag2RetList.size(); ++idx) {
            if (getResult2.containsKey((String)tag2RetList.get(idx))) continue;
            System.out.println(start + "_tag2=\u8a72\u5f53\u30c7\u30fc\u30bf\u306a\u3057 Key=[" + (String)tag2RetList.get(idx) + "]");
            errorFlg = true;
        }
        for (idx = 0; idx < tag3RetList.size(); ++idx) {
            if (getResult3.containsKey((String)tag3RetList.get(idx))) continue;
            System.out.println(start + "_tag3=\u8a72\u5f53\u30c7\u30fc\u30bf\u306a\u3057 Key=[" + (String)tag3RetList.get(idx) + "]");
            errorFlg = true;
        }
        for (idx = 0; idx < tag4RetList.size(); ++idx) {
            if (getResult4.containsKey((String)tag4RetList.get(idx))) continue;
            System.out.println(start + "_tag4=\u8a72\u5f53\u30c7\u30fc\u30bf\u306a\u3057 Key=[" + (String)tag4RetList.get(idx) + "]");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Tag Get Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execTagGet - End");
        return errorFlg;
    }

    private boolean execRemove(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execRemove - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] ret = null;
        long startTime = new Date().getTime();
        for (int i = start; i < count; ++i) {
            ret = okuyamaClient.removeValue(this.nowCount + "datasavekey_" + new Integer(i).toString());
            if (ret[0].equals("true")) {
                if (ret[1].equals(this.nowCount + "testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + new Integer(i).toString())) continue;
                System.out.println("\u30c7\u30fc\u30bf\u304c\u5408\u3063\u3066\u3044\u306a\u3044 key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]  value=[" + ret[1] + "]");
                errorFlg = true;
                continue;
            }
            if (ret[0].equals("false")) {
                System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]");
                errorFlg = true;
                continue;
            }
            if (!ret[0].equals("error")) continue;
            System.out.println("Error key=[" + this.nowCount + "datasavekey_" + new Integer(i).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Remove Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execRemove - End");
        return errorFlg;
    }

    private boolean execScript(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execScript - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        String[] ret = okuyamaClient.getValueScript(this.nowCount + "datasavekey_" + (start + 600), "var dataValue; var retValue = dataValue.replace('data', 'dummy'); var execRet = '1';");
        if (ret[0].equals("true")) {
            if (!ret[1].equals(this.nowCount + "savedummyvaluestr_" + (start + 600))) {
                System.out.println("\u30c7\u30fc\u30bf\u304c\u5408\u3063\u3066\u3044\u306a\u3044" + ret[1]);
                errorFlg = true;
            }
        } else if (ret[0].equals("false")) {
            System.out.println("\u30c7\u30fc\u30bf\u306a\u3057 key=[" + this.nowCount + "datasavekey_" + (start + 600));
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println("Error key=[" + this.nowCount + "datasavekey_" + (start + 600));
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("GetScript Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execScript - End");
        return errorFlg;
    }

    private boolean execAdd(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execAdd - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        String[] retParam = okuyamaClient.setNewValue(this.nowCount + "Key_ABCDE" + start, this.nowCount + "AAAAAAAAABBBBBBBBBBBBCCCCCCCCCC" + start);
        if (retParam[0].equals("false")) {
            System.out.println("Key=[" + this.nowCount + "Key_ABCDE] Error=[" + retParam[1] + "]");
            errorFlg = true;
        }
        HashMap<String, String> newObjMap = new HashMap<String, String>();
        newObjMap.put(this.nowCount + "Key_ABCDE_obj_" + start, this.nowCount + "AAAAAAAAABBBBBBBBBBBBCCCCCCCCCC" + start);
        String[] setNewObjRet = okuyamaClient.setNewObjectValue(this.nowCount + "Key_ABCDE_obj_" + start, newObjMap);
        if (!setNewObjRet[0].equals("true")) {
            System.out.println("Key=[" + this.nowCount + "Key_ABCDE_obj_" + start + "] Error =[" + setNewObjRet[1] + "]");
            errorFlg = true;
        } else {
            Map retMap;
            Object[] getNewObjRet = okuyamaClient.getObjectValue(this.nowCount + "Key_ABCDE_obj_" + start);
            if (getNewObjRet[0].equals("true") && !((Object)(retMap = (Map)getNewObjRet[1])).equals(newObjMap)) {
                System.out.println("Key=[" + this.nowCount + "Key_ABCDE_obj_" + start + "] Get - Error");
                errorFlg = true;
            }
        }
        long endTime = new Date().getTime();
        System.out.println("New Value Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execAdd - End");
        return errorFlg;
    }

    private boolean execGetsCas(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execCas - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        int casCount = 0;
        for (int i = start; i < count; ++i) {
            if (!okuyamaClient.setValue(casCount + "_castest_datasavekey", "castest_testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + casCount + "_" + new Integer(i).toString())) {
                System.out.println("Set - Error=[" + casCount + "_castest_datasavekey] Value[" + this.nowCount + "castest_testdata1234567891011121314151617181920212223242526272829_savedatavaluestr_" + casCount + "_" + new Integer(i).toString() + "]");
                errorFlg = true;
            }
            ++casCount;
        }
        Random rndIdx = new Random();
        int casSuccessCount = 0;
        int casErrorCount = 0;
        for (int casIdx = 0; casIdx < 6000; ++casIdx) {
            int rndSet = rndIdx.nextInt(casCount);
            String[] getsRet = okuyamaClient.getValueVersionCheck(rndSet + "_castest_datasavekey");
            String[] retParam = okuyamaClient.setValueVersionCheck(rndSet + "_castest_datasavekey", "updated-" + rndSet, getsRet[2]);
            if (retParam[0].equals("true")) {
                ++casSuccessCount;
                continue;
            }
            ++casErrorCount;
        }
        long endTime = new Date().getTime();
        System.out.println("Cas Method= " + (endTime - startTime) + " milli second Suucess=" + casSuccessCount + "  Error=" + casErrorCount);
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execCas - End");
        return errorFlg;
    }

    private boolean execIncr(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execIncr - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        Object[] ret = okuyamaClient.incrValue("calcKeyIncr_" + this.nowCount, 1L);
        if (ret[0].equals("true")) {
            System.out.println("execIncr - error - 1");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.incrValue("calcKeyIncr_" + this.nowCount, 20L, true))[0].equals("false")) {
            System.out.println("execIncr - error - 2");
            errorFlg = true;
        }
        long startTime = new Date().getTime();
        String[] work = okuyamaClient.setNewValue("calcKeyIncr", "0");
        for (int i = start; i < count; ++i) {
            Object[] calcRet = okuyamaClient.incrValue("calcKeyIncr", 1L);
            if (!calcRet[0].equals("false")) continue;
            errorFlg = true;
            System.out.println(calcRet[0]);
            System.out.println(calcRet[1]);
        }
        long endTime = new Date().getTime();
        String[] nowVal = okuyamaClient.getValue("calcKeyIncr");
        System.out.println("IncrValue Method= " + (endTime - startTime) + " milli second Value=[" + nowVal[1] + "]");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execAdd - End");
        return errorFlg;
    }

    private boolean execDecr(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execDecr - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        Object[] ret = okuyamaClient.decrValue("calcKeyDecr_" + this.nowCount, 1L);
        if (ret[0].equals("true")) {
            System.out.println("execDecr - error - 1");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.decrValue("calcKeyDecr_" + this.nowCount, 20L, true))[0].equals("false")) {
            System.out.println("execDecr - error - 2");
            errorFlg = true;
        }
        long startTime = new Date().getTime();
        String[] work = okuyamaClient.setNewValue("calcKeyDecr", "1000000");
        for (int i = start; i < count; ++i) {
            Object[] calcRet = okuyamaClient.decrValue("calcKeyDecr", 1L);
            if (!calcRet[0].equals("false")) continue;
            errorFlg = true;
            System.out.println(calcRet[0]);
            System.out.println(calcRet[1]);
        }
        long endTime = new Date().getTime();
        String[] nowVal = okuyamaClient.getValue("calcKeyDecr");
        System.out.println("DecrValue Method= " + (endTime - startTime) + " milli second Value=[" + nowVal[1] + "]");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execDecr - End");
        return errorFlg;
    }

    private boolean execTagRemove(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execTagRemove - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] tag1 = new String[]{start + "_" + this.nowCount + "_tag1"};
        String[] tag2 = new String[]{start + "_" + this.nowCount + "_tag1", start + "_" + this.nowCount + "_tag2"};
        String[] tag3 = new String[]{start + "_" + this.nowCount + "_tag1", start + "_" + this.nowCount + "_tag2", start + "_" + this.nowCount + "_tag3"};
        String[] tag4 = new String[]{start + "_" + this.nowCount + "_tag4"};
        String[] setTag = null;
        int counter = 0;
        long startTime = new Date().getTime();
        for (int i = start; i < count; ++i) {
            if (counter == 0) {
                setTag = tag1;
                if (!okuyamaClient.removeTagFromKey(this.nowCount + "tagsampledatakey_" + new Integer(i).toString(), setTag[0])) {
                    System.out.println("TagRemove - Error=[" + this.nowCount + "tagsampledatakey_" + new Integer(i).toString() + ", TagRemove[" + setTag[0]);
                    errorFlg = true;
                }
                ++counter;
                continue;
            }
            if (counter == 1) {
                setTag = tag2;
                if (!okuyamaClient.removeTagFromKey(this.nowCount + "tagsampledatakey_" + new Integer(i).toString(), setTag[0])) {
                    System.out.println("TagRemove - Error=[" + this.nowCount + "tagsampledatakey_" + new Integer(i).toString() + ", TagRemove[" + setTag[0]);
                    errorFlg = true;
                }
                if (!okuyamaClient.removeTagFromKey(this.nowCount + "tagsampledatakey_" + new Integer(i).toString(), setTag[1])) {
                    System.out.println("TagRemove - Error=[" + this.nowCount + "tagsampledatakey_" + new Integer(i).toString() + ", TagRemove[" + setTag[1]);
                    errorFlg = true;
                }
                ++counter;
                continue;
            }
            if (counter == 2) {
                setTag = tag3;
                if (!okuyamaClient.removeTagFromKey(this.nowCount + "tagsampledatakey_" + new Integer(i).toString(), setTag[0])) {
                    System.out.println("TagRemove - Error=[" + this.nowCount + "tagsampledatakey_" + new Integer(i).toString() + ", TagRemove[" + setTag[0]);
                    errorFlg = true;
                }
                if (!okuyamaClient.removeTagFromKey(this.nowCount + "tagsampledatakey_" + new Integer(i).toString(), setTag[1])) {
                    System.out.println("TagRemove - Error=[" + this.nowCount + "tagsampledatakey_" + new Integer(i).toString() + ", TagRemove[" + setTag[1]);
                    errorFlg = true;
                }
                if (!okuyamaClient.removeTagFromKey(this.nowCount + "tagsampledatakey_" + new Integer(i).toString(), setTag[2])) {
                    System.out.println("TagRemove - Error=[" + this.nowCount + "tagsampledatakey_" + new Integer(i).toString() + ", TagRemove[" + setTag[2]);
                    errorFlg = true;
                }
                ++counter;
                continue;
            }
            if (counter != 3) continue;
            setTag = tag4;
            if (!okuyamaClient.removeTagFromKey(this.nowCount + "tagsampledatakey_" + new Integer(i).toString(), setTag[0])) {
                System.out.println("TagRemove - Error=[" + this.nowCount + "tagsampledatakey_" + new Integer(i).toString() + ", TagRemove[" + setTag[0]);
                errorFlg = true;
            }
            counter = 0;
        }
        Object[] ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag1");
        if (ret[0].equals("true")) {
            System.out.println("TagRemoveDataExsist[" + start + "_" + this.nowCount + "_tag1]");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag2"))[0].equals("true")) {
            System.out.println("TagRemoveDataExsist[" + start + "_" + this.nowCount + "_tag2]");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag3"))[0].equals("true")) {
            System.out.println("TagRemoveDataExsist[" + start + "_" + this.nowCount + "_tag3]");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.getTagKeys(start + "_" + this.nowCount + "_tag4"))[0].equals("true")) {
            System.out.println("TagRemoveDataExsist[" + start + "_" + this.nowCount + "_tag4]");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Tag Remove Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execTagRemove - End");
        return errorFlg;
    }

    private boolean execIndex(OkuyamaClient client, int start, int count) throws Exception {
        String val;
        int i2;
        Map multiGetRet;
        String[] keys;
        int i;
        String[] dByteChars5;
        String[] dByteChars4;
        String[] dByteChars3;
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        String[] sChars = null;
        Object[] searchRet = null;
        System.out.println("execIndex - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        okuyamaClient.setValueAndCreateIndex(this.nowCount + "test123", "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053");
        String[] dByteChars = new String[]{"\u3046\u3048", "\u304b\u304d"};
        Object[] dByteRet = okuyamaClient.searchValue(dByteChars, "1");
        if (((String)dByteRet[0]).equals("true")) {
            String[] retkeys = (String[])dByteRet[1];
            boolean matchFlg = false;
            for (int i3 = 0; i3 < retkeys.length; ++i3) {
                if (!retkeys[i3].equals(this.nowCount + "test123")) continue;
                matchFlg = true;
            }
            if (!matchFlg) {
                System.out.println("Double Byte Search Test 1 - Error");
                errorFlg = true;
            }
        }
        okuyamaClient.setValueAndCreateIndex(this.nowCount + "test456", "\u6f22\u5b57\u3067\u3059\u3002\u3053\u308c\u304b\u3089\u96e3\u3057\u3044\u8a66\u9a13\u3092\u884c\u3044\u307e\u3059");
        String[] dByteChars2 = new String[]{"\u5b57", "\u3044"};
        dByteRet = okuyamaClient.searchValue(dByteChars2, "1");
        if (((String)dByteRet[0]).equals("true")) {
            String[] retkeys = (String[])dByteRet[1];
            boolean matchFlg = false;
            for (int i4 = 0; i4 < retkeys.length; ++i4) {
                if (!retkeys[i4].equals(this.nowCount + "test456")) continue;
                matchFlg = true;
            }
            if (!matchFlg) {
                System.out.println("Double Byte Search Test 2 - Error");
                errorFlg = true;
            }
        }
        if (!((String)(dByteRet = okuyamaClient.searchValue(dByteChars3 = new String[]{"\u5b57", "\u590f"}, "1"))[0]).equals("false")) {
            System.out.println("Double Byte Search Test 3 - Error");
            System.out.println(((String[])dByteRet[1])[0]);
            errorFlg = true;
        }
        if (!((String)(dByteRet = okuyamaClient.searchValue(dByteChars4 = new String[]{"\u3053\u308c\u304b\u3089\u96e3", "\u8a66\u9a13\u3092\u884c\u3044"}, "1"))[0]).equals("true")) {
            System.out.println("Double Byte Search Test 4 - Error");
            errorFlg = true;
        }
        if (!((String)(dByteRet = okuyamaClient.searchValue(dByteChars5 = new String[]{"\u3053\u308c\u304b\u3089\u7c21\u5358", "\u8a66\u9a13\u3092\u884c\u3044"}, "1"))[0]).equals("false")) {
            System.out.println("Double Byte Search Te\u00dfst 5 - Error");
            errorFlg = true;
        }
        int normalSetCount = 0;
        for (int i5 = start; i5 < count; ++i5) {
            if (!okuyamaClient.setValueAndCreateIndex(this.nowCount + "createindexKey_" + new Integer(i5).toString(), i5 + "abc" + this.nowCount + "createindexvalue_" + new Integer(i5).toString())) {
                System.out.println("setValueAndCreateIndex - Error=[" + this.nowCount + "createindexKey_" + new Integer(i5).toString() + "]");
                errorFlg = true;
            }
            ++normalSetCount;
            if (i5 % 10000 == 0) {
                System.out.println(i5);
            }
            if (i5 - start > 100) break;
        }
        int prefixSetCount = 0;
        String prefix = "Pre" + this.nowCount + "fix";
        for (i = start; i < count; ++i) {
            if (!okuyamaClient.setValueAndCreateIndex(this.nowCount + "createindexPrefixKey_" + new Integer(i).toString(), i + "abc" + this.nowCount + "createindexvalue_" + new Integer(i).toString(), prefix)) {
                System.out.println("setValueAndCreateIndex(Prefix) - Error=[" + this.nowCount + "createindexPrefixKey_" + new Integer(i).toString() + "]");
                errorFlg = true;
            }
            ++prefixSetCount;
            if (i % 10000 == 0) {
                System.out.println(i);
            }
            if (i - start > 100) break;
        }
        for (i = start; i < count; ++i) {
            sChars = new String[]{i + "abc" + this.nowCount + "create"};
            searchRet = okuyamaClient.searchValue(sChars, "1");
            if (!searchRet[0].equals("true")) {
                System.out.println("searchValue - 1-1 - Error=[" + sChars[0] + "]");
                errorFlg = true;
            } else if (((String[])searchRet[1]).length != 1) {
                keys = (String[])searchRet[1];
                multiGetRet = okuyamaClient.getMultiValue(keys);
                for (i2 = 0; i2 < keys.length; ++i2) {
                    val = (String)multiGetRet.get(keys[i2]);
                    if (val.indexOf(sChars[0]) != -1) continue;
                    System.out.println("searchValue - 1-2 - Error=[" + sChars[0] + "] Not Value[" + val + "]");
                    errorFlg = true;
                }
            } else if (!((String[])searchRet[1])[0].equals(this.nowCount + "createindexKey_" + new Integer(i).toString())) {
                System.out.println("searchValue - 1-3 - Error=[" + sChars[0] + "]");
                errorFlg = true;
            }
            if (i - start > 100) break;
        }
        sChars = new String[]{"abc" + this.nowCount + "create"};
        searchRet = okuyamaClient.searchValue(sChars, "1");
        if (!searchRet[0].equals("true")) {
            System.out.println("searchValue- 2-1 - Error=[" + sChars[0] + "]");
            errorFlg = true;
        } else if (((String[])searchRet[1]).length != normalSetCount) {
            System.out.println("searchValue - 2-2 - rror=[" + sChars[0] + "] Length=[" + ((String[])searchRet[1]).length + "] TrueCount=[" + normalSetCount + "]");
            errorFlg = true;
        }
        for (i = start; i < count; ++i) {
            sChars = new String[]{i + "abc" + this.nowCount + "create"};
            searchRet = okuyamaClient.searchValue(sChars, "1", prefix);
            if (!searchRet[0].equals("true")) {
                System.out.println("searchValue(Prefix) - 1-1 - Error=[" + sChars[0] + "]");
                errorFlg = true;
            } else if (((String[])searchRet[1]).length != 1) {
                keys = (String[])searchRet[1];
                multiGetRet = okuyamaClient.getMultiValue(keys);
                for (i2 = 0; i2 < keys.length; ++i2) {
                    val = (String)multiGetRet.get(keys[i2]);
                    if (val.indexOf(sChars[0]) != -1) continue;
                    System.out.println("searchValue(Prefix) - 1-2 - Error=[" + sChars[0] + "] Not Value[" + val + "]");
                    errorFlg = true;
                }
            } else if (!((String[])searchRet[1])[0].equals(this.nowCount + "createindexPrefixKey_" + new Integer(i).toString())) {
                System.out.println("searchValue(Prefix) - 1-3 - Error=[" + sChars[0] + "]");
                errorFlg = true;
            }
            if (i - start > 100) break;
        }
        sChars = new String[]{"abc" + this.nowCount + "create"};
        searchRet = okuyamaClient.searchValue(sChars, "1", prefix);
        if (!searchRet[0].equals("true")) {
            System.out.println("searchValue(Prefix)- 2-1 - Error=[" + sChars[0] + "]");
            errorFlg = true;
        } else if (((String[])searchRet[1]).length != prefixSetCount) {
            System.out.println("searchValue(Prefix) - 2-2 - Error=[" + sChars[0] + "] Length=[" + ((String[])searchRet[1]).length + "] TrueCount=[" + prefixSetCount + "]");
            errorFlg = true;
        }
        for (i = start; i < count; ++i) {
            if (!okuyamaClient.removeSearchIndex(this.nowCount + "createindexKey_" + new Integer(i).toString())) {
                System.out.println("removeValue- 3-1 - Error=[" + this.nowCount + "createindexKey_" + new Integer(i).toString() + "]");
                errorFlg = true;
            }
            if (i - start > 100) break;
        }
        sChars = new String[]{"abc" + this.nowCount + "create"};
        searchRet = okuyamaClient.searchValue(sChars, "1");
        if (!searchRet[0].equals("false")) {
            System.out.println("removeValue- 4-1 - Error=[" + sChars[0] + "]");
            errorFlg = true;
        }
        for (i = start; i < count; ++i) {
            if (!okuyamaClient.removeSearchIndex(this.nowCount + "createindexPrefixKey_" + new Integer(i).toString(), prefix)) {
                System.out.println("removeValue(Prefix)- 3-1 - Error=[" + this.nowCount + "createindexPrefixKey_" + new Integer(i).toString() + "]");
                errorFlg = true;
            }
            if (i - start > 100) break;
        }
        sChars = new String[]{"abc" + this.nowCount + "create"};
        searchRet = okuyamaClient.searchValue(sChars, "1", prefix);
        if (!searchRet[0].equals("false")) {
            System.out.println("removeValue(Prefix) - 4-1 - Error=[" + sChars[0] + "]");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("CreateIndex & searchValue & removeIndex Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execIndex - End");
        return errorFlg;
    }

    private boolean execSetExpireAndGet(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execSetExpireAndGet - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        if (!okuyamaClient.setValue(this.nowCount + "expiredatasavekey_" + new Integer(start).toString(), this.nowCount + "setexpiretestdata123456789_" + new Integer(start).toString(), new Integer(10))) {
            System.out.println("SetExpireAndGet - Set Error=[" + this.nowCount + "expiredatasavekey_" + new Integer(start).toString() + ", " + this.nowCount + "setexpiretestdata123456789_" + new Integer(start).toString());
            errorFlg = true;
        }
        if (!okuyamaClient.setValue(this.nowCount + "expiredatasavekey_" + new Integer(start + 1).toString(), this.nowCount + "setexpiretestdata123456789_" + new Integer(start + 1).toString(), new Integer(3))) {
            System.out.println("SetExpireAndGet - Set Error=[" + this.nowCount + "expiredatasavekey_" + new Integer(start + 1).toString() + ", " + this.nowCount + "setexpiretestdata123456789_" + new Integer(start + 1).toString());
            errorFlg = true;
        }
        if (!okuyamaClient.setValue(this.nowCount + "expiredatasavekey_" + new Integer(start + 2).toString(), this.nowCount + "setexpiretestdata123456789_" + new Integer(start + 2).toString(), new Integer(8))) {
            System.out.println("SetExpireAndGet - Set Error=[" + this.nowCount + "expiredatasavekey_" + new Integer(start + 2).toString() + ", " + this.nowCount + "setexpiretestdata123456789_" + new Integer(start + 2).toString());
            errorFlg = true;
        }
        Thread.sleep(5000L);
        String[] ret = okuyamaClient.getValue(this.nowCount + "expiredatasavekey_" + new Integer(start).toString());
        if (!ret[0].equals("true")) {
            if (ret[0].equals("false")) {
                this.logger.error("\u30c7\u30fc\u30bf\u306a\u3057 - 1 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start).toString() + "]");
                errorFlg = true;
            } else if (ret[0].equals("error")) {
                System.out.println("Error - 1 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start).toString() + "]" + ret[1]);
                errorFlg = true;
            }
        }
        if ((ret = okuyamaClient.getValue(this.nowCount + "expiredatasavekey_" + new Integer(start + 1).toString()))[0].equals("true")) {
            this.logger.error("\u30c7\u30fc\u30bf\u3042\u308a - 2 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start + 1).toString() + "]");
            errorFlg = true;
        } else if (!ret[0].equals("false") && ret[0].equals("error")) {
            System.out.println("Error - 2 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        ret = okuyamaClient.getValueAndUpdateExpireTime(this.nowCount + "expiredatasavekey_" + new Integer(start + 2).toString());
        if (!ret[0].equals("true")) {
            if (ret[0].equals("false")) {
                this.logger.error("\u30c7\u30fc\u30bf\u306a\u3057 - 3 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start + 2).toString() + "]");
                errorFlg = true;
            } else if (ret[0].equals("error")) {
                System.out.println("Error - 3 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start + 2).toString() + "]" + ret[1]);
                errorFlg = true;
            }
        }
        Thread.sleep(5500L);
        ret = okuyamaClient.getValue(this.nowCount + "expiredatasavekey_" + new Integer(start).toString());
        if (ret[0].equals("true")) {
            this.logger.error("\u30c7\u30fc\u30bf\u3042\u308a - 1 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start).toString() + "]");
            errorFlg = true;
        } else if (!ret[0].equals("false") && ret[0].equals("error")) {
            System.out.println("Error - 1 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        ret = okuyamaClient.getValue(this.nowCount + "expiredatasavekey_" + new Integer(start + 1).toString());
        if (ret[0].equals("true")) {
            this.logger.error("\u30c7\u30fc\u30bf\u3042\u308a - 2 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start + 1).toString() + "]");
            errorFlg = true;
        } else if (!ret[0].equals("false") && ret[0].equals("error")) {
            System.out.println("Error - 2 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        ret = okuyamaClient.getValueAndUpdateExpireTime(this.nowCount + "expiredatasavekey_" + new Integer(start + 2).toString());
        if (!ret[0].equals("true")) {
            if (ret[0].equals("false")) {
                this.logger.error("\u30c7\u30fc\u30bf\u306a\u3057 - 3 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start + 2).toString() + "]");
                errorFlg = true;
            } else if (ret[0].equals("error")) {
                System.out.println("Error - 3 Key=[" + this.nowCount + "expiredatasavekey_" + new Integer(start + 2).toString() + "]" + ret[1]);
                errorFlg = true;
            }
        }
        long endTime = new Date().getTime();
        System.out.println("SetExpireAndGet Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execSetExpireAndGet - End");
        return errorFlg;
    }

    private boolean execGetMultiTagValues(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execGetMultiTagValues - Start");
        long startTime = new Date().getTime();
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] tag1 = new String[]{start + "_" + this.nowCount + "_tag1_m"};
        String[] tag2 = new String[]{start + "_" + this.nowCount + "_tag1_m", start + "_" + this.nowCount + "_tag2_m"};
        String[] tag3 = new String[]{start + "_" + this.nowCount + "_tag1_m", start + "_" + this.nowCount + "_tag2_m", start + "_" + this.nowCount + "_tag3_m"};
        String[] tag4 = new String[]{start + "_" + this.nowCount + "_tag4_m"};
        String[] tag5 = new String[]{start + "_" + this.nowCount + "_tag4_m", start + "_" + this.nowCount + "_tag1_m"};
        Object setTag = null;
        ArrayList tag1RetList = new ArrayList();
        ArrayList tag2RetList = new ArrayList();
        ArrayList tag3RetList = new ArrayList();
        ArrayList tag4RetList = new ArrayList();
        int counter = 0;
        for (int i = 0; i < 100; ++i) {
            if (counter == 0) {
                okuyamaClient.setValue(this.nowCount + "tagsampledatakey_m_" + new Integer(i).toString() + "]", tag1, "tagsampledatakey_m_" + new Integer(i).toString() + "]");
                ++counter;
                continue;
            }
            if (counter == 1) {
                okuyamaClient.setValue(this.nowCount + "tagsampledatakey_m_" + new Integer(i).toString() + "]", tag2, "tagsampledatakey_m_" + new Integer(i).toString() + "]");
                ++counter;
                continue;
            }
            if (counter == 2) {
                okuyamaClient.setValue(this.nowCount + "tagsampledatakey_m_" + new Integer(i).toString() + "]", tag3, "tagsampledatakey_m_" + new Integer(i).toString() + "]");
                ++counter;
                continue;
            }
            okuyamaClient.setValue(this.nowCount + "tagsampledatakey_m_" + new Integer(i).toString() + "]", tag4, "tagsampledatakey_m_" + new Integer(i).toString() + "]");
            counter = 0;
        }
        Map ret = null;
        ret = okuyamaClient.getMultiTagValues(tag1, true);
        if (ret.size() != 75) {
            System.out.println(start + "_" + this.nowCount + "_tag1_m - Error");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.getMultiTagValues(tag2, true)).size() != 50) {
            System.out.println(start + "_" + this.nowCount + "_tag1_m, AND _tag2_m  - Error");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.getMultiTagValues(tag3, true)).size() != 25) {
            System.out.println(start + "_" + this.nowCount + "_tag1_m, AND _tag2_m, AND _tag3_m  - Error");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.getMultiTagValues(tag5, false)).size() != 100) {
            System.out.println(start + "_" + this.nowCount + "_tag1_m, OR _tag4_m - Error");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Tag Multi Get Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execGetMultiTagValues - End");
        return errorFlg;
    }

    private boolean execGetMultiTagKeys(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execGetMultiTagKeys - Start");
        long startTime = new Date().getTime();
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] tag1 = new String[]{start + "_" + this.nowCount + "_tag1_mk"};
        String[] tag2 = new String[]{start + "_" + this.nowCount + "_tag1_mk", start + "_" + this.nowCount + "_tag2_mk"};
        String[] tag3 = new String[]{start + "_" + this.nowCount + "_tag1_mk", start + "_" + this.nowCount + "_tag2_mk", start + "_" + this.nowCount + "_tag3_mk"};
        String[] tag4 = new String[]{start + "_" + this.nowCount + "_tag4_mk"};
        String[] tag5 = new String[]{start + "_" + this.nowCount + "_tag4_mk", start + "_" + this.nowCount + "_tag1_mk"};
        Object setTag = null;
        ArrayList tag1RetList = new ArrayList();
        ArrayList tag2RetList = new ArrayList();
        ArrayList tag3RetList = new ArrayList();
        ArrayList tag4RetList = new ArrayList();
        int counter = 0;
        for (int i = 0; i < 100; ++i) {
            if (counter == 0) {
                okuyamaClient.setValue(this.nowCount + "tagsampledatakey_mk_" + new Integer(i).toString() + "]", tag1, "tagsampledatakey_mk_" + new Integer(i).toString() + "]");
                ++counter;
                continue;
            }
            if (counter == 1) {
                okuyamaClient.setValue(this.nowCount + "tagsampledatakey_mk_" + new Integer(i).toString() + "]", tag2, "tagsampledatakey_mk_" + new Integer(i).toString() + "]");
                ++counter;
                continue;
            }
            if (counter == 2) {
                okuyamaClient.setValue(this.nowCount + "tagsampledatakey_mk_" + new Integer(i).toString() + "]", tag3, "tagsampledatakey_mk_" + new Integer(i).toString() + "]");
                ++counter;
                continue;
            }
            okuyamaClient.setValue(this.nowCount + "tagsampledatakey_mk_" + new Integer(i).toString() + "]", tag4, "tagsampledatakey_mk_" + new Integer(i).toString() + "]");
            counter = 0;
        }
        String[] ret = null;
        ret = okuyamaClient.getMultiTagKeys(tag1, true);
        if (ret.length != 75) {
            System.out.println(start + "_" + this.nowCount + "_tag1_mk - Error");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.getMultiTagKeys(tag2, true)).length != 50) {
            System.out.println(start + "_" + this.nowCount + "_tag1_mk, AND _tag2_mk  - Error");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.getMultiTagKeys(tag3, true)).length != 25) {
            System.out.println(start + "_" + this.nowCount + "_tag1_mk, AND _tag2_mk, AND _tag3_mk  - Error");
            errorFlg = true;
        }
        if ((ret = okuyamaClient.getMultiTagKeys(tag5, false)).length != 100) {
            System.out.println(start + "_" + this.nowCount + "_tag1_mk, OR _tag4_mk - Error");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Tag Multi Get Keys Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execGetMultiTagKeys - End");
        return errorFlg;
    }

    private boolean execObjectSetGet(OkuyamaClient client, int start, int count) throws Exception {
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execObjectSetGet - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        if (!okuyamaClient.setObjectValue(this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString(), this.nowCount + "setexpiretestdata123456789_" + new Integer(start).toString(), new Integer(10))) {
            System.out.println("SetExpireAndGet - Set Error=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString() + ", " + this.nowCount + "setexpiretestdata123456789_" + new Integer(start).toString());
            errorFlg = true;
        }
        if (!okuyamaClient.setObjectValue(this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 1).toString(), this.nowCount + "setexpiretestdata123456789_" + new Integer(start + 1).toString(), new Integer(3))) {
            System.out.println("SetExpireAndGet - Set Error=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 1).toString() + ", " + this.nowCount + "setexpiretestdata123456789_" + new Integer(start + 1).toString());
            errorFlg = true;
        }
        if (!okuyamaClient.setObjectValue(this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 2).toString(), this.nowCount + "setexpiretestdata123456789_" + new Integer(start + 2).toString(), new Integer(8))) {
            System.out.println("SetExpireAndGet - Set Error=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 2).toString() + ", " + this.nowCount + "setexpiretestdata123456789_" + new Integer(start + 2).toString());
            errorFlg = true;
        }
        Thread.sleep(5000L);
        Object[] ret = okuyamaClient.getObjectValue(this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString());
        if (ret[0].equals("true")) {
            if (!((String)ret[1]).equals(this.nowCount + "setexpiretestdata123456789_" + new Integer(start).toString())) {
                this.logger.error("\u30c7\u30fc\u30bf\u9593\u9055\u3044 - 1 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString() + "]");
                errorFlg = true;
            }
        } else if (ret[0].equals("false")) {
            this.logger.error("\u30c7\u30fc\u30bf\u306a\u3057 - 1 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString() + "]");
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println("Error - 1 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        if ((ret = okuyamaClient.getObjectValue(this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 1).toString()))[0].equals("true")) {
            this.logger.error("\u30c7\u30fc\u30bf\u3042\u308a - 2 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 1).toString() + "]");
            errorFlg = true;
        } else if (!ret[0].equals("false") && ret[0].equals("error")) {
            System.out.println("Error - 2 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        ret = okuyamaClient.getObjectValueAndUpdateExpireTime(this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 2).toString());
        if (ret[0].equals("true")) {
            if (!((String)ret[1]).equals(this.nowCount + "setexpiretestdata123456789_" + new Integer(start + 2).toString())) {
                this.logger.error("\u30c7\u30fc\u30bf\u9593\u9055\u3044 - 3 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 2).toString() + "]");
                errorFlg = true;
            }
        } else if (ret[0].equals("false")) {
            this.logger.error("\u30c7\u30fc\u30bf\u306a\u3057 - 3 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 2).toString() + "]");
            errorFlg = true;
        } else if (ret[0].equals("error")) {
            System.out.println("Error - 3 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 2).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        Thread.sleep(5500L);
        ret = okuyamaClient.getValue(this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString());
        if (ret[0].equals("true")) {
            this.logger.error("\u30c7\u30fc\u30bf\u3042\u308a - 1 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString() + "]");
            errorFlg = true;
        } else if (!ret[0].equals("false") && ret[0].equals("error")) {
            System.out.println("Error - 1 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        ret = okuyamaClient.getValue(this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 1).toString());
        if (ret[0].equals("true")) {
            this.logger.error("\u30c7\u30fc\u30bf\u3042\u308a - 2 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 1).toString() + "]");
            errorFlg = true;
        } else if (!ret[0].equals("false") && ret[0].equals("error")) {
            System.out.println("Error - 2 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start).toString() + "]" + ret[1]);
            errorFlg = true;
        }
        ret = okuyamaClient.getObjectValueAndUpdateExpireTime(this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 2).toString());
        if (!ret[0].equals("true")) {
            if (ret[0].equals("false")) {
                this.logger.error("\u30c7\u30fc\u30bf\u306a\u3057 - 3 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 2).toString() + "]");
                errorFlg = true;
            } else if (ret[0].equals("error")) {
                System.out.println("Error - 3 Key=[" + this.nowCount + "expireobjectdatasavekey_" + new Integer(start + 2).toString() + "]" + ret[1]);
                errorFlg = true;
            }
        }
        long endTime = new Date().getTime();
        System.out.println("SetObjectExpireAndObjectGet Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execObjectSetGet - End");
        return errorFlg;
    }

    private boolean execGetTagKeysResult(OkuyamaClient client, int start, int count) throws Exception {
        int idx;
        OkuyamaClient okuyamaClient = null;
        OkuyamaResultSet okuyamaResultSet = null;
        boolean errorFlg = false;
        System.out.println("execGetTagKeysResult - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] tag1 = new String[]{start + "_" + this.nowCount + "_tag1_reslut"};
        String[] tag2 = new String[]{start + "_" + this.nowCount + "_tag1_reslut", start + "_" + this.nowCount + "_tag2_reslut"};
        String[] tag3 = new String[]{start + "_" + this.nowCount + "_tag1_reslut", start + "_" + this.nowCount + "_tag2_reslut", start + "_" + this.nowCount + "_tag3_reslut"};
        String[] tag4 = new String[]{start + "_" + this.nowCount + "_tag4_reslut"};
        String[] setTag = null;
        int counter = 0;
        for (int i = start; i < count; ++i) {
            if (counter == 0) {
                setTag = tag1;
                ++counter;
            } else if (counter == 1) {
                setTag = tag2;
                ++counter;
            } else if (counter == 2) {
                setTag = tag3;
                ++counter;
            } else if (counter == 3) {
                setTag = tag4;
                counter = 0;
            }
            if (okuyamaClient.setValue(this.nowCount + "tagsampledatakey_reslut_" + new Integer(i).toString(), setTag, this.nowCount + "tagsamplesavedata_reslut_" + new Integer(i).toString())) continue;
            System.out.println("Tag GetResult Set - Error=[" + this.nowCount + "tagsampledatakey_reslut_" + new Integer(i).toString() + ", " + this.nowCount + "tagsamplesavedata_reslut_" + new Integer(i).toString());
            errorFlg = true;
        }
        ArrayList<String> tag1RetList = new ArrayList<String>();
        ArrayList<String> tag2RetList = new ArrayList<String>();
        ArrayList<String> tag3RetList = new ArrayList<String>();
        ArrayList<String> tag4RetList = new ArrayList<String>();
        counter = 0;
        for (int i = start; i < count; ++i) {
            if (counter == 0) {
                tag1RetList.add(this.nowCount + "tagsampledatakey_reslut_" + new Integer(i).toString());
                ++counter;
                continue;
            }
            if (counter == 1) {
                tag1RetList.add(this.nowCount + "tagsampledatakey_reslut_" + new Integer(i).toString());
                tag2RetList.add(this.nowCount + "tagsampledatakey_reslut_" + new Integer(i).toString());
                ++counter;
                continue;
            }
            if (counter == 2) {
                tag1RetList.add(this.nowCount + "tagsampledatakey_reslut_" + new Integer(i).toString());
                tag2RetList.add(this.nowCount + "tagsampledatakey_reslut_" + new Integer(i).toString());
                tag3RetList.add(this.nowCount + "tagsampledatakey_reslut_" + new Integer(i).toString());
                ++counter;
                continue;
            }
            if (counter != 3) continue;
            tag4RetList.add(this.nowCount + "tagsampledatakey_reslut_" + new Integer(i).toString());
            counter = 0;
        }
        HashMap<Object, Object> getResult1 = new HashMap<Object, Object>();
        HashMap<Object, Object> getResult2 = new HashMap<Object, Object>();
        HashMap<Object, Object> getResult3 = new HashMap<Object, Object>();
        HashMap<Object, Object> getResult4 = new HashMap<Object, Object>();
        Object keys = null;
        long startTime = new Date().getTime();
        okuyamaResultSet = okuyamaClient.getTagKeysResult(start + "_" + this.nowCount + "_tag1_reslut");
        if (okuyamaResultSet != null) {
            while (okuyamaResultSet.next()) {
                getResult1.put(okuyamaResultSet.getKey(), okuyamaResultSet.getValue());
            }
            okuyamaResultSet.close();
        } else {
            System.out.println(start + "tag1_reslut=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        }
        okuyamaResultSet = okuyamaClient.getTagKeysResult(start + "_" + this.nowCount + "_tag2_reslut");
        if (okuyamaResultSet != null) {
            while (okuyamaResultSet.next()) {
                getResult2.put(okuyamaResultSet.getKey(), okuyamaResultSet.getValue());
            }
            okuyamaResultSet.close();
        } else {
            System.out.println(start + "tag2_reslut=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        }
        okuyamaResultSet = okuyamaClient.getTagKeysResult(start + "_" + this.nowCount + "_tag3_reslut");
        if (okuyamaResultSet != null) {
            while (okuyamaResultSet.next()) {
                getResult3.put(okuyamaResultSet.getKey(), okuyamaResultSet.getValue());
            }
            okuyamaResultSet.close();
        } else {
            System.out.println(start + "tag3_reslut=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        }
        okuyamaResultSet = okuyamaClient.getTagKeysResult(start + "_" + this.nowCount + "_tag4_reslut");
        if (okuyamaResultSet != null) {
            while (okuyamaResultSet.next()) {
                getResult4.put(okuyamaResultSet.getKey(), okuyamaResultSet.getValue());
            }
            okuyamaResultSet.close();
        } else {
            System.out.println(start + "tag4_reslut=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        }
        okuyamaResultSet = okuyamaClient.getTagKeysResult(start + "_" + this.nowCount + "_tag5_reslut");
        if (okuyamaResultSet != null) {
            while (okuyamaResultSet.next()) {
                System.out.println(start + "tag5_reslut=\u30c7\u30fc\u30bf\u3042\u308a");
                errorFlg = true;
            }
            okuyamaResultSet.close();
        } else {
            System.out.println(start + "tag5_reslut=OkuyamaResultSet\u53d6\u5f97\u3067\u304d\u305a");
            errorFlg = true;
        }
        for (idx = 0; idx < tag1RetList.size(); ++idx) {
            if (getResult1.containsKey((String)tag1RetList.get(idx))) continue;
            System.out.println(start + "_tag1_result=\u8a72\u5f53\u30c7\u30fc\u30bf\u306a\u3057 Key=[" + (String)tag1RetList.get(idx) + "]");
            errorFlg = true;
        }
        for (idx = 0; idx < tag2RetList.size(); ++idx) {
            if (getResult2.containsKey((String)tag2RetList.get(idx))) continue;
            System.out.println(start + "_tag2_result=\u8a72\u5f53\u30c7\u30fc\u30bf\u306a\u3057 Key=[" + (String)tag2RetList.get(idx) + "]");
            errorFlg = true;
        }
        for (idx = 0; idx < tag3RetList.size(); ++idx) {
            if (getResult3.containsKey((String)tag3RetList.get(idx))) continue;
            System.out.println(start + "_tag3_result=\u8a72\u5f53\u30c7\u30fc\u30bf\u306a\u3057 Key=[" + (String)tag3RetList.get(idx) + "]");
            errorFlg = true;
        }
        for (idx = 0; idx < tag4RetList.size(); ++idx) {
            if (getResult4.containsKey((String)tag4RetList.get(idx))) continue;
            System.out.println(start + "_tag4_result=\u8a72\u5f53\u30c7\u30fc\u30bf\u306a\u3057 Key=[" + (String)tag4RetList.get(idx) + "]");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Tag Get Result Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execGetTagKeysResult - End");
        return errorFlg;
    }

    private boolean execMultiGetTagKeysResult(OkuyamaClient client, int start, int count) throws Exception {
        int idx;
        String[] andTestTag3;
        String[] orTestTag2;
        OkuyamaClient okuyamaClient = null;
        OkuyamaResultSet okuyamaResultSet = null;
        boolean errorFlg = false;
        System.out.println("execMultiGetTagKeysResult - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        String[] tag1 = new String[]{start + "_" + this.nowCount + "_tag1_m_reslut"};
        String[] tag2 = new String[]{start + "_" + this.nowCount + "_tag1_m_reslut", start + "_" + this.nowCount + "_tag2_m_reslut"};
        String[] tag3 = new String[]{start + "_" + this.nowCount + "_tag1_m_reslut", start + "_" + this.nowCount + "_tag2_m_reslut", start + "_" + this.nowCount + "_tag3_m_reslut"};
        String[] tag4 = new String[]{start + "_" + this.nowCount + "_tag4_m_reslut"};
        String[] setTag = null;
        int counter = 0;
        for (int i = start; i < count; ++i) {
            if (counter == 0) {
                setTag = tag1;
                ++counter;
            } else if (counter == 1) {
                setTag = tag2;
                ++counter;
            } else if (counter == 2) {
                setTag = tag3;
                ++counter;
            } else if (counter == 3) {
                setTag = tag4;
                counter = 0;
            }
            if (okuyamaClient.setValue(this.nowCount + "tagsampledatakey_m_reslut_" + new Integer(i).toString(), setTag, this.nowCount + "tagsamplesavedata_m_reslut_" + new Integer(i).toString())) continue;
            System.out.println("Tag GetResult Set - Error=[" + this.nowCount + "tagsampledatakey_m_reslut_" + new Integer(i).toString() + ", " + this.nowCount + "tagsamplesavedata_m_reslut_" + new Integer(i).toString());
            errorFlg = true;
        }
        ArrayList<String> tag1RetList = new ArrayList<String>();
        ArrayList<String> tag2RetList = new ArrayList<String>();
        counter = 0;
        for (int i = start; i < count; ++i) {
            if (counter == 0) {
                tag2RetList.add(this.nowCount + "tagsampledatakey_m_reslut_" + new Integer(i).toString());
                ++counter;
                continue;
            }
            if (counter == 1) {
                tag1RetList.add(this.nowCount + "tagsampledatakey_m_reslut_" + new Integer(i).toString());
                tag2RetList.add(this.nowCount + "tagsampledatakey_m_reslut_" + new Integer(i).toString());
                ++counter;
                continue;
            }
            if (counter == 2) {
                tag1RetList.add(this.nowCount + "tagsampledatakey_m_reslut_" + new Integer(i).toString());
                tag2RetList.add(this.nowCount + "tagsampledatakey_m_reslut_" + new Integer(i).toString());
                ++counter;
                continue;
            }
            if (counter != 3) continue;
            tag2RetList.add(this.nowCount + "tagsampledatakey_m_reslut_" + new Integer(i).toString());
            counter = 0;
        }
        HashMap<Object, Object> getResult1 = new HashMap<Object, Object>();
        HashMap<Object, Object> getResult2 = new HashMap<Object, Object>();
        HashMap getResult3 = new HashMap();
        HashMap getResult4 = new HashMap();
        Object keys = null;
        long startTime = new Date().getTime();
        String[] andTestTag1 = new String[]{start + "_" + this.nowCount + "_tag1_m_reslut", start + "_" + this.nowCount + "_tag2_m_reslut"};
        okuyamaResultSet = okuyamaClient.getMultiTagKeysResult(andTestTag1);
        if (okuyamaResultSet != null) {
            while (okuyamaResultSet.next()) {
                getResult1.put(okuyamaResultSet.getKey(), okuyamaResultSet.getValue());
            }
            okuyamaResultSet.close();
            if (getResult1.size() != tag1RetList.size()) {
                System.out.println(start + "tag1&tag2_reslut=\u30c7\u30fc\u30bf\u6570\u7570\u5e38");
                errorFlg = true;
            }
        } else {
            System.out.println(start + "tag1&tag2_reslut=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        }
        if ((okuyamaResultSet = okuyamaClient.getMultiTagKeysResult(orTestTag2 = new String[]{start + "_" + this.nowCount + "_tag1_m_reslut", start + "_" + this.nowCount + "_tag2_m_reslut", start + "_" + this.nowCount + "_tag4_m_reslut"}, false)) != null) {
            while (okuyamaResultSet.next()) {
                getResult2.put(okuyamaResultSet.getKey(), okuyamaResultSet.getValue());
            }
            okuyamaResultSet.close();
            if (getResult2.size() != tag2RetList.size()) {
                System.out.println(start + "tag1&tag2&tag4_reslut=\u30c7\u30fc\u30bf\u6570\u7570\u5e38");
                errorFlg = true;
            }
        } else {
            System.out.println(start + "tag1&tag2&tag4_reslut=\u30c7\u30fc\u30bf\u306a\u3057");
            errorFlg = true;
        }
        if ((okuyamaResultSet = okuyamaClient.getMultiTagKeysResult(andTestTag3 = new String[]{start + "_" + this.nowCount + "_tag2_m_reslut", start + "_" + this.nowCount + "_tag3_m_reslut", start + "_" + this.nowCount + "_tag4_m_reslut"}, true)) != null) {
            while (okuyamaResultSet.next()) {
                errorFlg = true;
                System.out.println(start + "tag2_tag3_tag4_reslut=\u30c7\u30fc\u30bf\u3042\u308a");
                System.out.println(okuyamaResultSet.getKey());
            }
            okuyamaResultSet.close();
        }
        for (idx = 0; idx < tag1RetList.size(); ++idx) {
            if (getResult1.containsKey((String)tag1RetList.get(idx))) continue;
            System.out.println(start + "AND_1=\u8a72\u5f53\u30c7\u30fc\u30bf\u306a\u3057 Key=[" + (String)tag1RetList.get(idx) + "]");
            errorFlg = true;
        }
        for (idx = 0; idx < tag2RetList.size(); ++idx) {
            if (getResult2.containsKey((String)tag2RetList.get(idx))) continue;
            System.out.println(start + "Or_1=\u8a72\u5f53\u30c7\u30fc\u30bf\u306a\u3057 Key=[" + (String)tag2RetList.get(idx) + "]");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("Tag Get Result Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execMultiGetTagKeysResult - End");
        return errorFlg;
    }

    private boolean execList(OkuyamaClient client, int start, String listNamePrefix) throws Exception {
        String[] retTmp;
        long idx;
        int idx2;
        String[] retTmp2;
        long idx3;
        String[] retTmp3;
        String[] retTmp4;
        OkuyamaClient okuyamaClient = null;
        boolean errorFlg = false;
        System.out.println("execList - Start");
        if (client != null) {
            okuyamaClient = client;
        } else {
            int port = this.masterNodePort;
            okuyamaClient = new OkuyamaClient();
            okuyamaClient.connect(this.masterNodeName, port);
        }
        long startTime = new Date().getTime();
        Random rnd = new Random();
        String listName = listNamePrefix + "list" + System.nanoTime();
        String[] ret = okuyamaClient.createListStruct(listName);
        if (!ret[0].equals("true")) {
            System.out.println("List create error1 =" + listName);
            errorFlg = true;
        }
        if (!(ret = okuyamaClient.createListStruct(listName))[0].equals("false")) {
            System.out.println("List create error2 =" + listName);
            errorFlg = true;
        }
        for (int idx4 = 0; idx4 < 5000; ++idx4) {
            retTmp4 = okuyamaClient.listLPush(listName, "Llistdata." + idx4);
            if (retTmp4[0].equals("true")) continue;
            System.out.println("List create error3 =" + listName);
            System.out.println(retTmp4[1]);
            errorFlg = true;
        }
        for (long idx5 = 0L; idx5 < 5000L; ++idx5) {
            retTmp3 = okuyamaClient.listIndex(listName, idx5);
            if (!retTmp3[0].equals("true")) {
                System.out.println("List create error4 =" + listName);
                System.out.println(retTmp3[1]);
                errorFlg = true;
                continue;
            }
            if (retTmp3[1].equals("Llistdata." + (4999L - idx5))) continue;
            System.out.println("List create error4-1 =" + listName);
            System.out.println(retTmp3[1]);
            errorFlg = true;
        }
        for (int idx6 = 0; idx6 < 5000; ++idx6) {
            retTmp4 = okuyamaClient.listRPush(listName, "Rlistdata." + idx6);
            if (retTmp4[0].equals("true")) continue;
            System.out.println("List create error5 =" + listName);
            System.out.println(retTmp4[1]);
            errorFlg = true;
        }
        for (long idx7 = 0L; idx7 < 5000L; ++idx7) {
            retTmp3 = okuyamaClient.listIndex(listName, idx7);
            if (!retTmp3[0].equals("true")) {
                System.out.println("List create error6 =" + listName);
                System.out.println(retTmp3[1]);
                errorFlg = true;
                continue;
            }
            if (retTmp3[1].equals("Llistdata." + (4999L - idx7))) continue;
            System.out.println("List create error6-1 =" + listName);
            System.out.println(retTmp3[1]);
            errorFlg = true;
        }
        int idxTest2 = 0;
        for (idx3 = 5000L; idx3 < 10000L; ++idx3) {
            retTmp2 = okuyamaClient.listIndex(listName, idx3);
            if (!retTmp2[0].equals("true")) {
                System.out.println("List create error7 =" + listName);
                System.out.println(retTmp2[1]);
                errorFlg = true;
            } else if (!retTmp2[1].equals("Rlistdata." + idxTest2)) {
                System.out.println("List create error7-1 =" + listName);
                System.out.println(retTmp2[1]);
                errorFlg = true;
            }
            ++idxTest2;
        }
        for (idx3 = 0L; idx3 < 5000L; ++idx3) {
            retTmp2 = okuyamaClient.listLPop(listName);
            if (!retTmp2[0].equals("true")) {
                System.out.println("List error8 =" + listName);
                System.out.println(retTmp2[1]);
                errorFlg = true;
                continue;
            }
            if (retTmp2[1].equals("Llistdata." + (4999L - idx3))) continue;
            System.out.println("List  error8-1 =" + listName);
            System.out.println(retTmp2[1]);
            errorFlg = true;
        }
        idxTest2 = 0;
        for (idx3 = 5000L; idx3 < 10000L; ++idx3) {
            retTmp2 = okuyamaClient.listLPop(listName);
            if (!retTmp2[0].equals("true")) {
                System.out.println("List create error9 =" + listName);
                System.out.println(retTmp2[1]);
                errorFlg = true;
            } else if (!retTmp2[1].equals("Rlistdata." + idxTest2)) {
                System.out.println("List create error9-1 =" + listName);
                System.out.println(retTmp2[1]);
                errorFlg = true;
            }
            ++idxTest2;
        }
        String[] nullRetTmp = okuyamaClient.listLPop(listName);
        if (!nullRetTmp[0].equals("false")) {
            System.out.println("List create error10 =" + listName);
            System.out.println(nullRetTmp[1]);
            errorFlg = true;
        }
        for (idx2 = 0; idx2 < 5000; ++idx2) {
            retTmp2 = okuyamaClient.listLPush(listName, "Llistdata." + idx2);
            if (retTmp2[0].equals("true")) continue;
            System.out.println("List create error3 =" + listName);
            System.out.println(retTmp2[1]);
            errorFlg = true;
        }
        for (idx2 = 0; idx2 < 5000; ++idx2) {
            retTmp2 = okuyamaClient.listRPush(listName, "Rlistdata." + idx2);
            if (retTmp2[0].equals("true")) continue;
            System.out.println("List create error5 =" + listName);
            System.out.println(retTmp2[1]);
            errorFlg = true;
        }
        idxTest2 = 9999;
        for (idx = 5000L; idx < 10000L; ++idx) {
            retTmp = okuyamaClient.listRPop(listName);
            if (!retTmp[0].equals("true")) {
                System.out.println("List create error11 =" + listName);
                System.out.println(retTmp[1]);
                errorFlg = true;
                continue;
            }
            if (retTmp[1].equals("Rlistdata." + ((long)idxTest2 - idx))) continue;
            System.out.println("List create error11-1 =" + listName);
            System.out.println(retTmp[1]);
            errorFlg = true;
        }
        for (idx = 4999L; idx > -1L; --idx) {
            retTmp = okuyamaClient.listRPop(listName);
            if (!retTmp[0].equals("true")) {
                System.out.println("List error12 =" + listName);
                System.out.println(retTmp[1]);
                errorFlg = true;
                continue;
            }
            if (retTmp[1].equals("Llistdata." + (4999L - idx))) continue;
            System.out.println("List  error12-1 =" + listName);
            System.out.println("RealData=[" + retTmp[1] + "]!=" + " TestPattern[Llistdata." + (4999L - idx) + "]");
            errorFlg = true;
        }
        long endTime = new Date().getTime();
        System.out.println("List Method= " + (endTime - startTime) + " milli second");
        if (client == null) {
            okuyamaClient.close();
        }
        System.out.println("execList - End");
        return errorFlg;
    }
}

