/*
 * Decompiled with CFR 0.152.
 */
package fuse;

import fuse.Filesystem3;
import fuse.FuseException;
import fuse.FuseFS;
import fuse.FuseFSDirFiller;
import fuse.FuseGetattrSetter;
import fuse.FuseOpenSetter;
import fuse.FuseSizeSetter;
import fuse.FuseStatfsSetter;
import fuse.XattrLister;
import fuse.XattrSupport;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Date;
import org.apache.commons.logging.Log;

public class Filesystem3ToFuseFSAdapter
implements FuseFS {
    private Filesystem3 fs3;
    private XattrSupport xattrSupport;
    private Charset cs;
    private Log log;

    public Filesystem3ToFuseFSAdapter(Filesystem3 fs3, Log log) {
        this(fs3, System.getProperty("file.encoding", "UTF-8"), log);
    }

    public Filesystem3ToFuseFSAdapter(Filesystem3 fs3, String encoding, Log log) {
        this(fs3, Charset.forName(encoding), log);
    }

    public Filesystem3ToFuseFSAdapter(Filesystem3 fs3, Charset cs, Log log) {
        this.fs3 = fs3;
        if (fs3 instanceof XattrSupport) {
            this.xattrSupport = (XattrSupport)((Object)fs3);
        }
        this.cs = cs;
        this.log = log;
    }

    public int getattr(ByteBuffer path, FuseGetattrSetter getattrSetter) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getattr: path=" + pathStr));
        }
        try {
            return this.handleErrno(this.fs3.getattr(pathStr, getattrSetter), getattrSetter);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int readlink(ByteBuffer path, ByteBuffer link) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("readlink: path=" + pathStr));
        }
        CharBuffer linkCb = CharBuffer.allocate(link.capacity());
        try {
            int errno = this.fs3.readlink(pathStr, linkCb);
            if (errno == 0) {
                linkCb.flip();
                CharsetEncoder enc = this.cs.newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPLACE);
                CoderResult result = enc.encode(linkCb, link, true);
                if (result.isOverflow()) {
                    throw new FuseException("Buffer owerflow while encoding result").initErrno(36);
                }
            }
            return this.handleErrno(errno, linkCb.rewind());
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int getdir(ByteBuffer path, FuseFSDirFiller dirFiller) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getdir: path=" + pathStr));
        }
        try {
            dirFiller.setCharset(this.cs);
            return this.handleErrno(this.fs3.getdir(pathStr, dirFiller), dirFiller);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int mknod(ByteBuffer path, int mode, int rdev) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("mknod: path=" + pathStr + ", mode=" + Integer.toOctalString(mode) + "(OCT), rdev=" + rdev));
        }
        try {
            return this.handleErrno(this.fs3.mknod(pathStr, mode, rdev));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int mkdir(ByteBuffer path, int mode) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("mkdir: path=" + pathStr + ", mode=" + Integer.toOctalString(mode) + "(OCT)"));
        }
        try {
            return this.handleErrno(this.fs3.mkdir(pathStr, mode));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int unlink(ByteBuffer path) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("unlink: path=" + pathStr));
        }
        try {
            return this.handleErrno(this.fs3.unlink(pathStr));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int rmdir(ByteBuffer path) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("rmdir: path=" + pathStr));
        }
        try {
            return this.handleErrno(this.fs3.rmdir(pathStr));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int symlink(ByteBuffer from, ByteBuffer to) {
        String fromStr = this.cs.decode(from).toString();
        String toStr = this.cs.decode(to).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("symlink: from=" + fromStr + " to=" + toStr));
        }
        try {
            return this.handleErrno(this.fs3.symlink(fromStr, toStr));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int rename(ByteBuffer from, ByteBuffer to) {
        String fromStr = this.cs.decode(from).toString();
        String toStr = this.cs.decode(to).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("rename: from=" + fromStr + " to=" + toStr));
        }
        try {
            return this.handleErrno(this.fs3.rename(fromStr, toStr));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int link(ByteBuffer from, ByteBuffer to) {
        String fromStr = this.cs.decode(from).toString();
        String toStr = this.cs.decode(to).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("link: from=" + fromStr + " to=" + toStr));
        }
        try {
            return this.handleErrno(this.fs3.link(fromStr, toStr));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int chmod(ByteBuffer path, int mode) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("chmod: path=" + pathStr + ", mode=" + Integer.toOctalString(mode) + "(OCT)"));
        }
        try {
            return this.handleErrno(this.fs3.chmod(pathStr, mode));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int chown(ByteBuffer path, int uid, int gid) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("chown: path=" + pathStr + ", uid=" + uid + ", gid=" + gid));
        }
        try {
            return this.handleErrno(this.fs3.chown(pathStr, uid, gid));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int truncate(ByteBuffer path, long size) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("truncate: path=" + pathStr + ", size=" + size));
        }
        try {
            return this.handleErrno(this.fs3.truncate(pathStr, size));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int utime(ByteBuffer path, int atime, int mtime) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("utime: path=" + pathStr + ", atime=" + atime + " (" + new Date((long)atime * 1000L) + "), mtime=" + mtime + " (" + new Date((long)mtime * 1000L) + ")"));
        }
        try {
            return this.handleErrno(this.fs3.utime(pathStr, atime, mtime));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int statfs(FuseStatfsSetter statfsSetter) {
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)"statfs");
        }
        try {
            return this.handleErrno(this.fs3.statfs(statfsSetter), statfsSetter);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int open(ByteBuffer path, int flags, FuseOpenSetter openSetter) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("open: path=" + pathStr + ", flags=" + flags));
        }
        try {
            return this.handleErrno(this.fs3.open(pathStr, flags, openSetter), openSetter);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int read(ByteBuffer path, Object fh, ByteBuffer buf, long offset) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("read: path=" + pathStr + ", fh=" + fh + ", offset=" + offset));
        }
        try {
            return this.handleErrno(this.fs3.read(pathStr, fh, buf, offset), buf);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int write(ByteBuffer path, Object fh, boolean isWritepage, ByteBuffer buf, long offset) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("write: path=" + pathStr + ", fh=" + fh + ", isWritepage=" + isWritepage + ", offset=" + offset));
        }
        try {
            return this.handleErrno(this.fs3.write(pathStr, fh, isWritepage, buf, offset), buf);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int flush(ByteBuffer path, Object fh) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("flush: path=" + pathStr + ", fh=" + fh));
        }
        try {
            return this.handleErrno(this.fs3.flush(pathStr, fh));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int release(ByteBuffer path, Object fh, int flags) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("release: path=" + pathStr + ", fh=" + fh + ", flags=" + flags));
        }
        try {
            return this.handleErrno(this.fs3.release(pathStr, fh, flags));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int fsync(ByteBuffer path, Object fh, boolean isDatasync) {
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("fsync: path=" + pathStr + ", fh=" + fh + ", isDatasync=" + isDatasync));
        }
        try {
            return this.handleErrno(this.fs3.fsync(this.cs.decode(path).toString(), fh, isDatasync));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int getxattrsize(ByteBuffer path, ByteBuffer name, FuseSizeSetter sizeSetter) {
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String pathStr = this.cs.decode(path).toString();
        String nameStr = this.cs.decode(name).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getxattrsize: path=" + pathStr + ", name=" + nameStr));
        }
        try {
            return this.handleErrno(this.xattrSupport.getxattrsize(pathStr, nameStr, sizeSetter), sizeSetter);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int getxattr(ByteBuffer path, ByteBuffer name, ByteBuffer value) {
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String pathStr = this.cs.decode(path).toString();
        String nameStr = this.cs.decode(name).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getxattr: path=" + pathStr + ", name=" + nameStr));
        }
        try {
            return this.handleErrno(this.xattrSupport.getxattr(pathStr, nameStr, value), value);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int listxattrsize(ByteBuffer path, FuseSizeSetter sizeSetter) {
        int errno;
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("listxattrsize: path=" + pathStr));
        }
        XattrSizeLister lister = new XattrSizeLister();
        try {
            errno = this.xattrSupport.listxattr(pathStr, lister);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
        sizeSetter.setSize(lister.size);
        return this.handleErrno(errno, sizeSetter);
    }

    public int listxattr(ByteBuffer path, ByteBuffer list) {
        int errno;
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String pathStr = this.cs.decode(path).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("listxattr: path=" + pathStr));
        }
        XattrValueLister lister = new XattrValueLister(list);
        try {
            errno = this.xattrSupport.listxattr(pathStr, lister);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
        if (lister.boe != null) {
            return this.handleException(lister.boe);
        }
        return this.handleErrno(errno, lister);
    }

    public int setxattr(ByteBuffer path, ByteBuffer name, ByteBuffer value, int flags) {
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String pathStr = this.cs.decode(path).toString();
        String nameStr = this.cs.decode(name).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("setxattr: path=" + pathStr + ", name=" + nameStr + ", value=" + value + ", flags=" + flags));
        }
        try {
            return this.handleErrno(this.xattrSupport.setxattr(pathStr, nameStr, value, flags));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    public int removexattr(ByteBuffer path, ByteBuffer name) {
        if (this.xattrSupport == null) {
            return this.handleErrno(524);
        }
        String pathStr = this.cs.decode(path).toString();
        String nameStr = this.cs.decode(name).toString();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("removexattr: path= " + pathStr + ", name=" + nameStr));
        }
        try {
            return this.handleErrno(this.xattrSupport.removexattr(pathStr, nameStr));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    private int handleErrno(int errno) {
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)(errno == 0 ? "  returning with success" : "  returning errno: " + errno));
        }
        return errno;
    }

    private int handleErrno(int errno, Object v1) {
        if (errno != 0) {
            return this.handleErrno(errno);
        }
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("  returning: " + v1));
        }
        return errno;
    }

    private int handleErrno(int errno, Object v1, Object v2) {
        if (errno != 0) {
            return this.handleErrno(errno);
        }
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("  returning: " + v1 + ", " + v2));
        }
        return errno;
    }

    private int handleException(Exception e) {
        int errno;
        if (e instanceof FuseException) {
            errno = this.handleErrno(((FuseException)e).getErrno());
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)e);
            }
        } else if (e instanceof BufferOverflowException) {
            errno = this.handleErrno(34);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)e);
            }
        } else {
            errno = this.handleErrno(14);
            if (this.log != null) {
                this.log.error((Object)e);
            }
        }
        return errno;
    }

    private class XattrValueLister
    implements XattrLister {
        CharsetEncoder enc;
        ByteBuffer list;
        BufferOverflowException boe;

        XattrValueLister(ByteBuffer list) {
            this.enc = Filesystem3ToFuseFSAdapter.this.cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.list = list;
        }

        public void add(String xattrName) {
            if (this.boe == null) {
                try {
                    this.enc.encode(CharBuffer.wrap(xattrName), this.list, true);
                    this.list.put((byte)0);
                }
                catch (BufferOverflowException e) {
                    this.boe = e;
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean first = true;
            for (int i = 0; i < this.list.position(); ++i) {
                int offset = i;
                int length = 0;
                while (offset + length < this.list.position() && this.list.get(offset + length) != 0) {
                    ++length;
                }
                byte[] nameBytes = new byte[length];
                for (int j = 0; j < length; ++j) {
                    nameBytes[j] = this.list.get(offset + j);
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append('\"').append(Filesystem3ToFuseFSAdapter.this.cs.decode(ByteBuffer.wrap(nameBytes))).append('\"');
                i = offset + length;
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private class XattrSizeLister
    implements XattrLister {
        CharsetEncoder enc;
        int size;

        private XattrSizeLister() {
            this.enc = Filesystem3ToFuseFSAdapter.this.cs.newEncoder();
            this.size = 0;
        }

        public void add(String xattrName) {
            this.size += (int)((float)xattrName.length() * this.enc.averageBytesPerChar()) + 1;
        }
    }
}

