/*
 * Decompiled with CFR 0.152.
 */
package fuse.logging;

import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class FuseLog
implements Log {
    public static PrintStream trace = System.err;
    public static PrintStream debug = System.err;
    public static PrintStream info = System.err;
    public static PrintStream warn = System.err;
    public static PrintStream error = System.err;
    public static PrintStream fatal = System.err;
    public static final String LEVEL_PREFIX = "fuse.logging.level";
    private static final int LEVEL_TRACE = 0;
    private static final int LEVEL_DEBUG = 1;
    private static final int LEVEL_INFO = 2;
    private static final int LEVEL_WARN = 3;
    private static final int LEVEL_ERROR = 4;
    private static final int LEVEL_FATAL = 5;
    private static final String[] levelNames = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private static final String formatPattern = "%1$tH:%1$tM:%1$tS.%1$tL %2$8s %3$5s [%4$s]: %5$s%n";
    private static final Levels levels = new Levels();
    private String name;

    public static void setOut(PrintStream out) {
        error = fatal = out;
        warn = fatal;
        info = fatal;
        debug = fatal;
        trace = fatal;
    }

    public FuseLog(String name) {
        this.name = name;
    }

    public boolean isDebugEnabled() {
        return levels.isDebugEnabled(this.name);
    }

    public boolean isErrorEnabled() {
        return levels.isErrorEnabled(this.name);
    }

    public boolean isFatalEnabled() {
        return levels.isFatalEnabled(this.name);
    }

    public boolean isInfoEnabled() {
        return levels.isInfoEnabled(this.name);
    }

    public boolean isTraceEnabled() {
        return levels.isTraceEnabled(this.name);
    }

    public boolean isWarnEnabled() {
        return levels.isWarnEnabled(this.name);
    }

    public void trace(Object object) {
        this._log(0, trace, object, null);
    }

    public void trace(Object object, Throwable throwable) {
        this._log(0, trace, object, throwable);
    }

    public void debug(Object object) {
        this._log(1, debug, object, null);
    }

    public void debug(Object object, Throwable throwable) {
        this._log(1, debug, object, throwable);
    }

    public void info(Object object) {
        this._log(2, info, object, null);
    }

    public void info(Object object, Throwable throwable) {
        this._log(2, info, object, throwable);
    }

    public void warn(Object object) {
        this._log(3, warn, object, null);
    }

    public void warn(Object object, Throwable throwable) {
        this._log(3, warn, object, throwable);
    }

    public void error(Object object) {
        this._log(4, error, object, null);
    }

    public void error(Object object, Throwable throwable) {
        this._log(4, error, object, throwable);
    }

    public void fatal(Object object) {
        this._log(5, fatal, object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this._log(5, fatal, object, throwable);
    }

    private void _log(int levelValue, PrintStream stream, Object object, Throwable throwable) {
        if (levelValue >= FuseLog.levels.getLevelValue(this.name)) {
            if (object instanceof Throwable && throwable == null) {
                throwable = (Throwable)object;
            }
            String msg = object.toString();
            stream.printf(formatPattern, new Date(), Thread.currentThread().getName(), levelNames[levelValue], this.name, msg);
            if (throwable != null) {
                throwable.printStackTrace(stream);
            }
        }
    }

    private static class Levels {
        private Map name2levelMap = new HashMap();

        Levels() {
            Properties props = System.getProperties();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                if (!propName.startsWith(FuseLog.LEVEL_PREFIX)) continue;
                String levelKey = propName.length() == FuseLog.LEVEL_PREFIX.length() ? "" : propName.substring(FuseLog.LEVEL_PREFIX.length() + 1);
                String levelName = props.getProperty(propName);
                int levelValue = -1;
                for (int i = 0; i < levelNames.length; ++i) {
                    if (!levelNames[i].equals(levelName)) continue;
                    levelValue = i;
                    break;
                }
                if (levelValue < 0) {
                    throw new IllegalArgumentException("Invalid logging level specified for System property: " + propName + ": " + levelName);
                }
                this.name2levelMap.put(levelKey, new Integer(levelValue));
            }
        }

        boolean isDebugEnabled(String name) {
            return this.getLevelValue(name) <= 1;
        }

        boolean isErrorEnabled(String name) {
            return this.getLevelValue(name) <= 4;
        }

        boolean isFatalEnabled(String name) {
            return this.getLevelValue(name) <= 5;
        }

        boolean isInfoEnabled(String name) {
            return this.getLevelValue(name) <= 2;
        }

        boolean isTraceEnabled(String name) {
            return this.getLevelValue(name) <= 0;
        }

        boolean isWarnEnabled(String name) {
            return this.getLevelValue(name) <= 3;
        }

        public String toString(String name) {
            return levelNames[this.getLevelValue(name)];
        }

        private int getLevelValue(String name) {
            while (true) {
                Integer levelValue;
                if ((levelValue = (Integer)this.name2levelMap.get(name)) != null) {
                    return levelValue;
                }
                if (name.length() == 0) break;
                int lastDot = name.lastIndexOf(46);
                if (lastDot >= 0) {
                    name = name.substring(0, lastDot);
                    continue;
                }
                name = "";
            }
            return 2;
        }
    }
}

