/*
 * Decompiled with CFR 0.152.
 */
package fuse.okuyamafs;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AccessFsClientMap {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private static Map accessFhMap = new ConcurrentHashMap(10000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessFh(String file, Object value) {
        this.w.lock();
        try {
            LinkedHashMap<Object, String> accessFh = null;
            accessFh = (LinkedHashMap<Object, String>)accessFhMap.get(file);
            if (accessFh == null) {
                accessFh = new LinkedHashMap<Object, String>();
            }
            accessFh.put(value, file);
            accessFhMap.put(file, accessFh);
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String file) {
        this.r.lock();
        try {
            boolean bl = accessFhMap.containsKey(file);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAccessFh(String file) {
        this.r.lock();
        try {
            Map accessFh = (Map)accessFhMap.get(file);
            if (accessFh == null) {
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] fhList = new Object[accessFh.size()];
            int idx = 0;
            Set entrySet = accessFh.entrySet();
            for (Map.Entry obj : entrySet) {
                fhList[idx] = obj.getKey();
                ++idx;
            }
            Object[] objectArray = fhList;
            return objectArray;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessFh(String file, Object value) {
        this.w.lock();
        try {
            Map accessFh = (Map)accessFhMap.get(file);
            if (accessFh != null) {
                accessFh.remove(value);
                if (accessFh.size() > 0) {
                    accessFhMap.put(file, accessFh);
                } else {
                    accessFhMap.remove(file);
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.w.lock();
        try {
            accessFhMap.clear();
        }
        finally {
            this.w.unlock();
        }
    }
}

