/*
 * Decompiled with CFR 0.152.
 */
package fuse.okuyamafs;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUCacheMap
extends LinkedHashMap {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private int maxCacheSize = 8192;

    public LRUCacheMap() {
        super(1024, 0.75f, true);
    }

    public LRUCacheMap(int maxCacheCapacity) {
        super(maxCacheCapacity, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        this.w.lock();
        try {
            Object object = super.put(key, value);
            return object;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.r.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        this.r.lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        this.w.lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.w.unlock();
        }
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return this.maxCacheSize < super.size();
    }
}

