/*
 * Decompiled with CFR 0.152.
 */
package fuse.okuyamafs;

import fuse.Filesystem3;
import fuse.FuseDirFiller;
import fuse.FuseException;
import fuse.FuseGetattrSetter;
import fuse.FuseOpenSetter;
import fuse.FuseSizeSetter;
import fuse.FuseStatfs;
import fuse.FuseStatfsSetter;
import fuse.XattrLister;
import fuse.XattrSupport;
import fuse.okuyamafs.GroupingKeyMap;
import fuse.okuyamafs.OkuyamaClientWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OkuyamaFilesystem
implements Filesystem3,
XattrSupport {
    private static final Log log = LogFactory.getLog(OkuyamaFilesystem.class);
    public static volatile int blockSizeAssist = 50;
    public static volatile int blockSize = 5632;
    public static volatile int writeBufferSize = 0x500400;
    public static final int maxSingleModeCacheSize = 200000;
    public static int storageType = -1;
    private FuseStatfs statfs;
    private String masterNodeStr = null;
    OkuyamaClientWrapper client = null;
    private Map openStatusMap = new Hashtable();
    private Map appendWriteDataBuf = new HashMap(10);
    private GroupingKeyMap writeBufFpMap = new GroupingKeyMap();
    private Object[] parallelDataAccessSync = new Object[100];
    public static volatile boolean jvmShutdownStatus = false;
    public static List allChildThreadList = null;
    public long startTimeAAA = 0L;

    public OkuyamaFilesystem(String okuyamaMasterNode, boolean singleMode) throws IOException {
        log.info((Object)"okuyama file system init start...");
        int files = 0;
        int dirs = 0;
        boolean blocks = false;
        this.masterNodeStr = this.masterNodeStr;
        this.statfs = new FuseStatfs();
        this.statfs.blocks = Integer.MAX_VALUE;
        this.statfs.blockSize = blockSize;
        this.statfs.blocksFree = Integer.MAX_VALUE;
        this.statfs.files = files + dirs;
        this.statfs.filesFree = Integer.MAX_VALUE;
        this.statfs.namelen = 2048;
        try {
            for (int idx = 0; idx < 100; ++idx) {
                this.parallelDataAccessSync[idx] = new Object();
            }
            this.client = new OkuyamaClientWrapper(singleMode);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        log.info((Object)"okuyama file system init end...");
    }

    public int chmod(String path, int mode) throws FuseException {
        log.info((Object)("chmod " + path + " " + mode));
        String[] pathInfo = null;
        StringBuilder newPathInfo = new StringBuilder();
        try {
            String pathInfoStr = this.client.getPathDetail(path.trim());
            if (pathInfoStr == null || pathInfoStr.trim().equals("")) {
                return 2;
            }
            pathInfo = pathInfoStr.split("\t");
            pathInfo[7] = new Integer(new Integer(pathInfo[7]) & 0xF000 | mode & 0xFFF).toString();
            String sep = "";
            for (int i = 0; i < pathInfo.length; ++i) {
                newPathInfo.append(sep);
                newPathInfo.append(pathInfo[i]);
                sep = "\t";
            }
            this.client.setPathDetail(path.trim(), newPathInfo.toString());
        }
        catch (FuseException fe) {
            throw fe;
        }
        catch (Exception e) {
            new FuseException((Throwable)e).initErrno(13);
        }
        return 0;
    }

    public int chown(String path, int uid, int gid) throws FuseException {
        log.info((Object)("chown " + path + " " + uid + " " + gid));
        try {
            String pathInfoStr = this.client.getPathDetail(path.trim());
            if (pathInfoStr == null) {
                return 2;
            }
            String[] pathInfo = pathInfoStr.split("\t");
            pathInfo[2] = new Integer(uid).toString();
            pathInfo[3] = new Integer(gid).toString();
            StringBuilder strBuf = new StringBuilder(100);
            String sep = "";
            for (int i = 0; i < pathInfo.length; ++i) {
                strBuf.append(sep);
                strBuf.append(pathInfo[i]);
                sep = "\t";
            }
            this.client.setPathDetail(path.trim(), strBuf.toString());
        }
        catch (FuseException fe) {
            throw fe;
        }
        catch (Exception e) {
            new FuseException((Throwable)e).initErrno(13);
        }
        return 0;
    }

    public int getattr(String path, FuseGetattrSetter getattrSetter) throws FuseException {
        log.info((Object)("getattr " + path));
        String[] pathInfo = null;
        try {
            String[] setInfo = new String[11];
            if (path.trim().equals("/")) {
                setInfo[1] = new Integer(16895).toString();
                pathInfo = new String[9];
                pathInfo[1] = "0";
                pathInfo[2] = "0";
                pathInfo[3] = "0";
                pathInfo[4] = "0";
                pathInfo[5] = "0";
                pathInfo[6] = "0";
                pathInfo[8] = "0";
            } else {
                String pathInfoStr = this.client.getPathDetail(path.trim());
                if (pathInfoStr == null || pathInfoStr.trim().equals("")) {
                    return 2;
                }
                pathInfo = pathInfoStr.split("\t");
                if (pathInfo[0].equals("file")) {
                    setInfo[1] = new Integer(0x8000 | new Integer(pathInfo[7])).toString();
                } else if (pathInfo[0].equals("dir")) {
                    setInfo[1] = new Integer(0x4000 | new Integer(pathInfo[7])).toString();
                } else {
                    this.client.removePathDetail(path.trim());
                    return 2;
                }
            }
            setInfo[0] = new Integer(path.hashCode()).toString();
            setInfo[2] = pathInfo[1];
            setInfo[3] = pathInfo[2];
            setInfo[4] = pathInfo[3];
            setInfo[5] = pathInfo[8];
            setInfo[6] = pathInfo[4];
            long blockCnt = Long.parseLong(setInfo[6]) / 512L;
            if (Long.parseLong(setInfo[6]) % 512L > 0L) {
                ++blockCnt;
            }
            setInfo[8] = pathInfo[5];
            setInfo[9] = pathInfo[5];
            setInfo[10] = pathInfo[5];
            getattrSetter.set(new Long(setInfo[0]).longValue(), new Integer(setInfo[1]).intValue(), new Integer(setInfo[2]).intValue(), new Integer(setInfo[3]).intValue(), new Integer(setInfo[4]).intValue(), new Integer(setInfo[5]).intValue(), new Long(setInfo[6]).longValue(), blockCnt, new Integer(setInfo[8]).intValue(), new Integer(setInfo[9]).intValue(), new Integer(setInfo[10]).intValue());
        }
        catch (FuseException fe) {
            fe.printStackTrace();
            throw fe;
        }
        catch (Exception e) {
            e.printStackTrace();
            new FuseException((Throwable)e).initErrno(13);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getdir(String path, FuseDirFiller dirFiller) throws FuseException {
        log.info((Object)("getdir " + path));
        try {
            Map dirChildMap = this.client.getDirChild(path.trim());
            if (dirChildMap == null) {
                return 20;
            }
            int i = 0;
            Set entrySet = dirChildMap.entrySet();
            for (Map.Entry obj : entrySet) {
                String name = (String)obj.getKey();
                Map metaInfo = this.client.getDataMetaInfo(name);
                boolean deleteFlg = true;
                if (metaInfo.size() > 1 && metaInfo.get("pathdetail") != null && metaInfo.get("attribute") != null) {
                    deleteFlg = false;
                    String[] nameCnv = name.split("/");
                    try {
                        String pathInfoStrCheck = (String)metaInfo.get("pathdetail");
                        if (((String)obj.getValue()).equals("dir")) {
                            dirFiller.add(nameCnv[nameCnv.length - 1], 0L, 16384);
                        } else {
                            dirFiller.add(nameCnv[nameCnv.length - 1], 0L, 32768);
                        }
                        ++i;
                    }
                    catch (Exception ee) {
                        deleteFlg = true;
                    }
                }
                if (!deleteFlg) continue;
                Object object = this.parallelDataAccessSync[(name.hashCode() << 1 >>> 1) % 100];
                synchronized (object) {
                    try {
                        this.client.removePathDetail(name);
                        this.client.removeAttribute(name);
                        String pathInfoStr = (String)metaInfo.get("pathdetail");
                        if (pathInfoStr != null) {
                            String[] pathInfo = pathInfoStr.split("\t");
                            this.client.deleteValue(name, pathInfo[pathInfo.length - 2]);
                        }
                        this.client.removeDir(name);
                    }
                    catch (Exception innerE) {
                        // empty catch block
                    }
                    log.fatal((Object)("broken file remove filename=[" + name + "]"));
                }
            }
            return 0;
        }
        catch (FuseException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FuseException((Throwable)e);
        }
    }

    public int link(String from, String to) throws FuseException {
        log.info((Object)("link " + from + " " + to));
        return 13;
    }

    public int mkdir(String path, int mode) throws FuseException {
        log.info((Object)("mkdir " + path + " " + mode));
        try {
            if (!this.client.addDir(path.trim())) {
                return 17;
            }
            if (!this.client.setDirAttribute(path.trim(), "dir")) {
                return 17;
            }
            String pathType = "dir";
            String pathInfoStr = "";
            pathInfoStr = pathInfoStr + pathType;
            pathInfoStr = pathInfoStr + "\t" + "1";
            pathInfoStr = pathInfoStr + "\t" + "0";
            pathInfoStr = pathInfoStr + "\t" + "0";
            pathInfoStr = pathInfoStr + "\t" + "0";
            pathInfoStr = pathInfoStr + "\t" + System.currentTimeMillis() / 1000L;
            pathInfoStr = pathInfoStr + "\t" + "0";
            pathInfoStr = pathInfoStr + "\t" + mode;
            pathInfoStr = pathInfoStr + "\t" + "0";
            pathInfoStr = pathInfoStr + "\t" + System.nanoTime();
            if (!this.client.addPathDetail(path.trim(), pathInfoStr)) {
                return 17;
            }
        }
        catch (FuseException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FuseException((Throwable)e);
        }
        return 0;
    }

    public int mknod(String path, int mode, int rdev) throws FuseException {
        log.info((Object)("mknod " + path + " " + mode + " " + rdev));
        String modeStr = Integer.toOctalString(mode);
        String pathType = "";
        String fileBlockIdx = null;
        if (modeStr.indexOf("100") == 0) {
            pathType = "file";
            fileBlockIdx = "-1";
        } else if (modeStr.indexOf("40") == 0) {
            pathType = "dir";
        } else {
            return 22;
        }
        String pathInfoStr = "";
        pathInfoStr = pathInfoStr + pathType;
        pathInfoStr = pathInfoStr + "\t" + "1";
        pathInfoStr = pathInfoStr + "\t" + "0";
        pathInfoStr = pathInfoStr + "\t" + "0";
        pathInfoStr = pathInfoStr + "\t" + "0";
        pathInfoStr = pathInfoStr + "\t" + System.currentTimeMillis() / 1000L;
        pathInfoStr = pathInfoStr + "\t" + "0";
        pathInfoStr = pathInfoStr + "\t" + mode;
        pathInfoStr = pathInfoStr + "\t" + rdev;
        pathInfoStr = pathInfoStr + "\t" + System.nanoTime();
        if (fileBlockIdx != null) {
            pathInfoStr = pathInfoStr + "\t" + fileBlockIdx;
        }
        try {
            if (!this.client.addPathDetail(path.trim(), pathInfoStr)) {
                return 17;
            }
            if (!this.client.setDirAttribute(path.trim(), pathType)) {
                return 17;
            }
        }
        catch (FuseException fe) {
            throw fe;
        }
        catch (Exception e) {
            new FuseException((Throwable)e);
        }
        return 0;
    }

    public int open(String path, int flags, FuseOpenSetter openSetter) throws FuseException {
        log.info((Object)("open " + path + " " + flags));
        long fileDp = System.nanoTime();
        try {
            String pathInfoStr = this.client.getPathDetail(path.trim());
            if (pathInfoStr == null || pathInfoStr.trim().equals("")) {
                return 2;
            }
            HashMap<String, Object> openDt = new HashMap<String, Object>();
            openDt.put("filedp", fileDp);
            openDt.put("pathInfoStr", pathInfoStr);
            this.openStatusMap.put(path.trim(), openDt);
            openSetter.setFh(openDt);
        }
        catch (FuseException fe) {
            throw fe;
        }
        catch (Exception e) {
            e.printStackTrace();
            new FuseException((Throwable)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rename(String from, String to) throws FuseException {
        log.info((Object)("rename " + from + " " + to));
        String[] pathInfo = null;
        StringBuilder newPathInfo = new StringBuilder();
        try {
            Object object = this.parallelDataAccessSync[(from.hashCode() << 1 >>> 1) % 100];
            synchronized (object) {
                String pathInfoStr;
                List bufferedDataFhList = this.writeBufFpMap.removeGroupingData(from);
                if (bufferedDataFhList != null) {
                    for (int idx = 0; idx < bufferedDataFhList.size(); ++idx) {
                        Object bFh = bufferedDataFhList.get(idx);
                        this.fixNoCommitData(bFh);
                    }
                }
                if ((pathInfoStr = this.client.getPathDetail(from.trim())) == null || pathInfoStr.trim().equals("")) {
                    return 2;
                }
                pathInfo = pathInfoStr.split("\t");
                if (!this.client.addPathDetail(to.trim(), pathInfoStr)) {
                    return 17;
                }
                if (!this.client.setDirAttribute(to.trim(), pathInfo[0])) {
                    return 17;
                }
                if (!this.client.removePathDetail(from.trim())) {
                    return 5;
                }
                if (!this.client.removeAttribute(from.trim())) {
                    return 5;
                }
            }
        }
        catch (FuseException fe) {
            throw fe;
        }
        catch (Exception e) {
            new FuseException((Throwable)e).initErrno(13);
        }
        return 0;
    }

    public int rmdir(String path) throws FuseException {
        log.info((Object)("rmdir " + path));
        try {
            String pathInfoStr = this.client.getPathDetail(path.trim());
            if (pathInfoStr == null) {
                return 20;
            }
            Map dirChildMap = this.client.getDirChild(path.trim());
            if (dirChildMap != null && dirChildMap.size() > 0) {
                return 39;
            }
            if (!this.client.removePathDetail(path.trim())) {
                return 16;
            }
            if (!this.client.removeDir(path.trim())) {
                return 16;
            }
        }
        catch (Exception e) {
            new FuseException((Throwable)e).initErrno(13);
        }
        return 0;
    }

    public int statfs(FuseStatfsSetter statfsSetter) throws FuseException {
        log.info((Object)("statfs " + statfsSetter));
        statfsSetter.set(blockSize, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, 2000);
        return 0;
    }

    public int symlink(String from, String to) throws FuseException {
        log.info((Object)("symlink " + from + " " + to));
        return 13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int truncate(String path, long size) throws FuseException {
        log.info((Object)("truncate " + path + " " + size));
        try {
            Object object = this.parallelDataAccessSync[(path.hashCode() << 1 >>> 1) % 100];
            synchronized (object) {
                String pathInfoStr;
                List bufferedDataFhList = this.writeBufFpMap.removeGroupingData(path);
                if (bufferedDataFhList != null) {
                    for (int idx = 0; idx < bufferedDataFhList.size(); ++idx) {
                        Object bFh = bufferedDataFhList.get(idx);
                        this.fixNoCommitData(bFh);
                    }
                }
                if ((pathInfoStr = this.client.getPathDetail(path.trim())) == null) {
                    return 2;
                }
                String[] pathInfo = pathInfoStr.split("\t");
                if (new Long(pathInfo[4].trim()) > size) {
                    this.client.removeValue(path.trim(), size, Long.parseLong(pathInfo[4]) - size, pathInfo[pathInfo.length - 2]);
                } else {
                    this.client.appendingNullData(path.trim(), size, pathInfo[pathInfo.length - 2]);
                }
                pathInfo[4] = new Long(size).toString();
                pathInfo[5] = new Long(System.currentTimeMillis() / 1000L).toString();
                int assistBlockSize = 0;
                if (size % (long)blockSize > 0L) {
                    assistBlockSize = 1;
                }
                pathInfo[6] = new Long(size / (long)blockSize + (long)assistBlockSize).toString();
                StringBuilder strBuf = new StringBuilder(64);
                strBuf.append(pathInfo[0]).append("\t").append(pathInfo[1]).append("\t").append(pathInfo[2]).append("\t").append(pathInfo[3]).append("\t").append(pathInfo[4]).append("\t").append(pathInfo[5]).append("\t").append(pathInfo[6]).append("\t").append(pathInfo[7]).append("\t").append(pathInfo[8]).append("\t").append(pathInfo[9]).append("\t").append("-1");
                if (!this.client.setPathDetail(path.trim(), strBuf.toString())) {
                    return 5;
                }
            }
        }
        catch (FuseException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FuseException((Throwable)e).initErrno(13);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unlink(String path) throws FuseException {
        log.info((Object)("unlink " + path));
        try {
            Object object = this.parallelDataAccessSync[(path.hashCode() << 1 >>> 1) % 100];
            synchronized (object) {
                String[] pathInfo;
                String pathInfoStr;
                List bufferedDataFhList = this.writeBufFpMap.removeGroupingData(path);
                if (bufferedDataFhList != null) {
                    for (int idx = 0; idx < bufferedDataFhList.size(); ++idx) {
                        Object bFh = bufferedDataFhList.get(idx);
                        this.fixNoCommitData(bFh);
                    }
                }
                Map metaInfo = this.client.getDataMetaInfo(path);
                boolean deleteFlg = true;
                if (metaInfo.size() > 1 && metaInfo.get("pathdetail") != null && metaInfo.get("attribute") != null) {
                    deleteFlg = false;
                    pathInfoStr = this.client.getPathDetail(path.trim());
                    if (pathInfoStr == null) {
                        return 2;
                    }
                    pathInfo = pathInfoStr.split("\t");
                    if (!this.client.removePathDetail(path.trim())) {
                        return 5;
                    }
                    if (!this.client.removeAttribute(path.trim())) {
                        return 5;
                    }
                    this.client.deleteValue(path.trim(), pathInfo[pathInfo.length - 2]);
                }
                if (deleteFlg) {
                    try {
                        this.client.removePathDetail(path);
                        this.client.removeAttribute(path);
                        pathInfoStr = (String)metaInfo.get("pathdetail");
                        if (pathInfoStr != null) {
                            pathInfo = pathInfoStr.split("\t");
                            this.client.deleteValue(path, pathInfo[pathInfo.length - 2]);
                        }
                    }
                    catch (Exception innerE) {
                        // empty catch block
                    }
                    log.fatal((Object)("broken file remove filename=[" + path + "]"));
                }
            }
        }
        catch (Exception e) {
            throw new FuseException((Throwable)e).initErrno(5);
        }
        return 0;
    }

    public int utime(String path, int atime, int mtime) throws FuseException {
        log.info((Object)("utime " + path + " " + atime + " " + mtime));
        return 0;
    }

    public int readlink(String path, CharBuffer link) throws FuseException {
        log.info((Object)("readlink " + path));
        link.append(path);
        return 0;
    }

    public int write_bk(String path, Object fh, boolean isWritepage, ByteBuffer buf, long offset) throws FuseException {
        byte[] tmpBuf = new byte[buf.limit()];
        buf.get(tmpBuf);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int write(String path, Object fh, boolean isWritepage, ByteBuffer buf, long offset) throws FuseException {
        if (this.startTimeAAA == 0L) {
            this.startTimeAAA = System.nanoTime();
        }
        if (storageType == 1) {
            int n = this.realWrite(path, fh, isWritepage, buf, offset);
            return n;
        }
        if (fh == null) {
            int n = 52;
            return n;
        }
        Object object = this.parallelDataAccessSync[(path.hashCode() << 1 >>> 1) % 100];
        synchronized (object) {
            try {
                if (this.appendWriteDataBuf.containsKey(fh)) {
                    Map appendData = (Map)this.appendWriteDataBuf.get(fh);
                    ByteArrayOutputStream bBuf = (ByteArrayOutputStream)appendData.get("buf");
                    long bOffset = (Long)appendData.get("offset");
                    if (bOffset + (long)bBuf.size() == offset) {
                        byte[] tmpBuf = new byte[buf.limit()];
                        buf.get(tmpBuf);
                        bBuf.write(tmpBuf);
                        if (bBuf.size() >= writeBufferSize) {
                            int ret;
                            this.appendWriteDataBuf.remove(fh);
                            String bPath = (String)appendData.get("path");
                            Object bFh = appendData.get("fh");
                            boolean bIsWritepage = (Boolean)appendData.get("isWritepage");
                            int n = ret = this.realWrite(bPath, bFh, bIsWritepage, bBuf, bOffset);
                            return n;
                        }
                        int bPath = 0;
                        return bPath;
                    }
                    this.appendWriteDataBuf.remove(fh);
                    String bPath = (String)appendData.get("path");
                    Object bFh = appendData.get("fh");
                    boolean bIsWritepage = (Boolean)appendData.get("isWritepage");
                    int realWriteRet = this.realWrite(bPath, bFh, bIsWritepage, bBuf, bOffset);
                    if (realWriteRet == 0) {
                        int retI;
                        int n = retI = this.realWrite(path, fh, isWritepage, buf, offset);
                        return n;
                    }
                    int n = realWriteRet;
                    return n;
                }
                HashMap<String, Object> appendData = new HashMap<String, Object>();
                appendData.put("path", path);
                appendData.put("fh", fh);
                appendData.put("isWritepage", isWritepage);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(0xA02000);
                byte[] tmpByte = new byte[buf.limit()];
                buf.get(tmpByte);
                baos.write(tmpByte);
                appendData.put("buf", baos);
                appendData.put("offset", offset);
                this.appendWriteDataBuf.put(fh, appendData);
                this.writeBufFpMap.addGroupingData(path, fh);
                int n = 0;
                return n;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Exception e) {
                    throw new FuseException((Throwable)e);
                }
            }
        }
    }

    public int realWrite(String path, Object fh, boolean isWritepage, ByteBuffer buf, long offset) throws FuseException {
        byte[] writeData = new byte[buf.limit()];
        buf.get(writeData);
        return this.realWrite(path, fh, isWritepage, writeData, offset);
    }

    public int realWrite(String path, Object fh, boolean isWritepage, ByteArrayOutputStream buf, long offset) throws FuseException {
        byte[] data = buf.toByteArray();
        return this.realWrite(path, fh, isWritepage, data, offset);
    }

    public int realWrite(String path, Object fh, boolean isWritepage, byte[] writeData, long offset) throws FuseException {
        if (fh == null) {
            return 52;
        }
        try {
            String pathTrimStr = path.trim();
            String pathInfoStr = this.client.getPathDetail(pathTrimStr);
            if (pathInfoStr == null) {
                return 2;
            }
            String[] pathInfo = pathInfoStr.split("\t");
            long writeLastBlockIdx = -1L;
            if (writeData == null || writeData.length < 1) {
                log.error((Object)("write data nothing = realWrite  path:" + path + " offset:" + offset + " isWritepage:" + isWritepage + " buf.limit:" + writeData.length));
            } else {
                int idx = writeData.length;
                writeLastBlockIdx = this.client.writeValue(pathTrimStr, offset, writeData, writeData.length, pathInfo[pathInfo.length - 2], new Long(pathInfo[10]));
            }
            if (Long.parseLong(pathInfo[4]) < 1L) {
                pathInfo[4] = new Long(writeData.length).toString();
            } else if (Long.parseLong(pathInfo[4]) < new Long(offset + new Long(writeData.length))) {
                pathInfo[4] = new Long(offset + new Long(writeData.length)).toString();
            }
            pathInfo[5] = new Long(System.currentTimeMillis() / 1000L).toString();
            int assistBlockSize = 0;
            if ((Long.parseLong(pathInfo[4]) + (long)writeData.length) % (long)blockSize > 0L) {
                assistBlockSize = 1;
            }
            pathInfo[6] = new Long((Long.parseLong(pathInfo[4]) + (long)writeData.length) / (long)blockSize + (long)assistBlockSize).toString();
            StringBuilder strBuf = new StringBuilder(64);
            strBuf.append(pathInfo[0]).append("\t").append(pathInfo[1]).append("\t").append(pathInfo[2]).append("\t").append(pathInfo[3]).append("\t").append(pathInfo[4]).append("\t").append(pathInfo[5]).append("\t").append(pathInfo[6]).append("\t").append(pathInfo[7]).append("\t").append(pathInfo[8]).append("\t").append(pathInfo[9]).append("\t");
            if (new Long(pathInfo[10]) < writeLastBlockIdx) {
                strBuf.append(writeLastBlockIdx);
            } else {
                strBuf.append(pathInfo[10]);
            }
            this.client.setPathDetail(pathTrimStr, strBuf.toString());
        }
        catch (FuseException fe) {
            throw fe;
        }
        catch (Exception e) {
            new FuseException((Throwable)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(String path, Object fh, ByteBuffer buf, long offset) throws FuseException {
        log.info((Object)("read:" + path + " offset:" + offset + " buf.limit:" + buf.limit()));
        if (fh == null) {
            return 52;
        }
        try {
            String trimToPath = path.trim();
            Object object = this.parallelDataAccessSync[(path.hashCode() << 1 >>> 1) % 100];
            synchronized (object) {
                List bufferedDataFhList = this.writeBufFpMap.removeGroupingData(path);
                if (bufferedDataFhList != null) {
                    for (int idx = 0; idx < bufferedDataFhList.size(); ++idx) {
                        Object bFh = bufferedDataFhList.get(idx);
                        this.fixNoCommitData(bFh);
                    }
                }
                String pathInfoStr = this.client.getPathDetail(trimToPath);
                String[] pathInfo = pathInfoStr.split("\t");
                int readLen = this.client.readValue(trimToPath, offset, buf.limit(), pathInfo[pathInfo.length - 2], buf);
                if (readLen == -1 || readLen < 1) {
                    log.info((Object)("read data nothing read=read:" + path + " offset:" + offset + " buf.limit:" + buf.limit()));
                }
            }
        }
        catch (FuseException fe) {
            throw fe;
        }
        catch (Exception e) {
            new FuseException((Throwable)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int release(String path, Object fh, int flags) throws FuseException {
        log.info((Object)("release " + path + " " + fh + " " + flags));
        Object object = this.parallelDataAccessSync[(path.hashCode() << 1 >>> 1) % 100];
        synchronized (object) {
            List bufferedDataFhList = this.writeBufFpMap.removeGroupingData(path);
            if (bufferedDataFhList != null) {
                for (int idx = 0; idx < bufferedDataFhList.size(); ++idx) {
                    Object bFh = bufferedDataFhList.get(idx);
                    this.fixNoCommitData(bFh);
                }
            }
            this.openStatusMap.remove(path.trim());
            this.fixNoCommitData(fh);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(String path, Object fh) throws FuseException {
        Object object = this.parallelDataAccessSync[(path.hashCode() << 1 >>> 1) % 100];
        synchronized (object) {
            log.info((Object)("flush " + path + " " + fh));
            List bufferedDataFhList = this.writeBufFpMap.removeGroupingData(path);
            if (bufferedDataFhList != null) {
                for (int idx = 0; idx < bufferedDataFhList.size(); ++idx) {
                    Object bFh = bufferedDataFhList.get(idx);
                    this.fixNoCommitData(bFh);
                }
            }
            this.fixNoCommitData(fh);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fsync(String path, Object fh, boolean isDatasync) throws FuseException {
        Object object = this.parallelDataAccessSync[(path.hashCode() << 1 >>> 1) % 100];
        synchronized (object) {
            log.info((Object)("fsync " + path + " " + fh + " " + isDatasync));
            List bufferedDataFhList = this.writeBufFpMap.removeGroupingData(path);
            if (bufferedDataFhList != null) {
                for (int idx = 0; idx < bufferedDataFhList.size(); ++idx) {
                    Object bFh = bufferedDataFhList.get(idx);
                    this.fixNoCommitData(bFh);
                }
            }
            this.fixNoCommitData(fh);
        }
        return 0;
    }

    private int fixNoCommitData(Object fh) throws FuseException {
        if (this.appendWriteDataBuf.containsKey(fh)) {
            Map appendData = (Map)this.appendWriteDataBuf.remove(fh);
            String bPath = (String)appendData.get("path");
            Object bFh = appendData.get("fh");
            boolean bIsWritepage = (Boolean)appendData.get("isWritepage");
            ByteArrayOutputStream bBuf = (ByteArrayOutputStream)appendData.get("buf");
            long bOffset = (Long)appendData.get("offset");
            int realWriteRet = this.realWrite(bPath, bFh, bIsWritepage, bBuf, bOffset);
            return realWriteRet;
        }
        return 0;
    }

    public int getxattr(String path, String name, ByteBuffer dst) throws FuseException, BufferOverflowException {
        return 0;
    }

    public int getxattrsize(String path, String name, FuseSizeSetter sizeSetter) throws FuseException {
        return 0;
    }

    public int listxattr(String path, XattrLister lister) throws FuseException {
        return 0;
    }

    public int removexattr(String path, String name) throws FuseException {
        return 0;
    }

    public int setxattr(String path, String name, ByteBuffer value, int flags) throws FuseException {
        return 0;
    }
}

