/*
 * Decompiled with CFR 0.152.
 */
package fuse.okuyamafs;

import fuse.Filesystem3;
import fuse.FuseMount;
import fuse.okuyamafs.CoreMapFactory;
import fuse.okuyamafs.FilesystemCheckDaemon;
import fuse.okuyamafs.JVMShutdownSequence;
import fuse.okuyamafs.OkuyamaFilesystem;
import okuyama.imdst.util.ImdstDefine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OkuyamaFuse {
    private static final Log log = LogFactory.getLog(OkuyamaFuse.class);
    private static boolean stripingDataBlock = false;

    public static void main(String[] args) {
        String[] fuseArgs = new String[args.length - 1];
        System.arraycopy(args, 0, fuseArgs, 0, fuseArgs.length);
        ImdstDefine.valueCompresserLevel = 9;
        try {
            String okuyamaStr = args[args.length - 1];
            if (okuyamaStr.indexOf("#") != -1) {
                stripingDataBlock = true;
                okuyamaStr = okuyamaStr.substring(0, okuyamaStr.length() - 1);
            }
            String[] masterNodeInfos = null;
            masterNodeInfos = okuyamaStr.indexOf(",") != -1 ? okuyamaStr.split(",") : (okuyamaStr + "," + okuyamaStr).split(",");
            String[] optionParams = new String[]{"2", "true"};
            String fsystemMode = optionParams[0].trim();
            boolean singleFlg = new Boolean(optionParams[1].trim());
            OkuyamaFilesystem.storageType = new Integer(fsystemMode);
            if (OkuyamaFilesystem.storageType == 1) {
                // empty if block
            }
            CoreMapFactory.init(new Integer(fsystemMode.trim()), masterNodeInfos, stripingDataBlock);
            FilesystemCheckDaemon loopDaemon = new FilesystemCheckDaemon(1, (Object)fuseArgs[fuseArgs.length - 1]);
            loopDaemon.start();
            if (OkuyamaFilesystem.storageType == 2) {
                FilesystemCheckDaemon bufferCheckDaemon = new FilesystemCheckDaemon(2, null);
                bufferCheckDaemon.start();
            }
            Runtime.getRuntime().addShutdownHook(new JVMShutdownSequence());
            FuseMount.mount((String[])fuseArgs, (Filesystem3)new OkuyamaFilesystem(fsystemMode, singleFlg), (Log)log);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

