/*
 * Decompiled with CFR 0.152.
 */
package fuse.okuyamafs;

import fuse.okuyamafs.BufferedOkuyamaClient;
import fuse.okuyamafs.OkuyamaFilesystem;
import fuse.okuyamafs.OkuyamaFsMapUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import okuyama.imdst.client.OkuyamaClient;
import okuyama.imdst.client.OkuyamaClientFactory;

class ResponseCheckDaemon
extends Thread {
    private ArrayBlockingQueue requestBox = new ArrayBlockingQueue(1);
    private ArrayBlockingQueue responseBox = new ArrayBlockingQueue(1);
    private OkuyamaClientFactory factory = null;
    private OkuyamaClient client = null;
    private boolean endFlg = false;

    public ResponseCheckDaemon(OkuyamaClientFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                String key = null;
                do {
                    key = (String)this.requestBox.poll(1000L, TimeUnit.MILLISECONDS);
                } while (!OkuyamaFilesystem.jvmShutdownStatus && key == null);
                if (OkuyamaFilesystem.jvmShutdownStatus) break;
                if (this.endFlg) {
                    if (this.client == null) break;
                    this.client.close();
                    this.client = null;
                    break;
                }
                this.client = new BufferedOkuyamaClient(this.factory.getClient(300000));
                Object[] responseSet = this.client.readByteValue(key);
                if (responseSet[0].equals("true")) {
                    Object[] retObj = new Object[]{key, OkuyamaFsMapUtil.dataDecompress((byte[])responseSet[1])};
                    this.responseBox.put(retObj);
                    continue;
                }
                this.responseBox.put(new Object[0]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (this.client != null) {
                        this.client.close();
                        this.client = null;
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                if (this.endFlg) {
                    return;
                }
                try {
                    this.responseBox.put(new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
            finally {
                try {
                    if (this.client == null) continue;
                    this.client.close();
                    this.client = null;
                }
                catch (Exception ee) {}
                continue;
            }
            break;
        }
    }

    public void putRequest(String key) throws Exception {
        this.requestBox.put(key);
    }

    public Object[] takeResponse() {
        try {
            return (Object[])this.responseBox.take();
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return new Object[0];
        }
    }

    public void endRequest() throws Exception {
        this.endFlg = true;
        this.requestBox.put("");
    }
}

