/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapreduce.util.ProcessTree;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.Private
public class DefaultTaskController
extends TaskController {
    private static final Log LOG = LogFactory.getLog(DefaultTaskController.class);

    @Override
    void launchTaskJVM(TaskController.TaskControllerContext context) throws IOException {
        Shell.ShellCommandExecutor shexec;
        this.initializeTask(context);
        JvmManager.JvmEnv env = context.env;
        List<String> wrappedCommand = TaskLog.captureOutAndError(env.setup, env.vargs, env.stdout, env.stderr, env.logSize, true);
        context.shExec = shexec = new Shell.ShellCommandExecutor(wrappedCommand.toArray(new String[0]), env.workDir, env.env);
        shexec.execute();
    }

    @Override
    void initializeTask(TaskController.TaskControllerContext context) {
    }

    @Override
    void initializeJob(TaskController.JobInitializationContext context) {
    }

    @Override
    void terminateTask(TaskController.TaskControllerContext context) {
        Shell.ShellCommandExecutor shexec = context.shExec;
        if (shexec != null) {
            Process process = shexec.getProcess();
            if (Shell.WINDOWS) {
                if (process != null) {
                    process.destroy();
                }
            } else {
                String pid = context.pid;
                if (pid != null) {
                    if (ProcessTree.isSetsidAvailable) {
                        ProcessTree.terminateProcessGroup(pid);
                    } else {
                        ProcessTree.terminateProcess(pid);
                    }
                }
            }
        }
    }

    @Override
    void killTask(TaskController.TaskControllerContext context) {
        Shell.ShellCommandExecutor shexec = context.shExec;
        if (shexec != null) {
            if (Shell.WINDOWS) {
                return;
            }
            String pid = context.pid;
            if (pid != null) {
                if (ProcessTree.isSetsidAvailable) {
                    ProcessTree.killProcessGroup(pid);
                } else {
                    ProcessTree.killProcess(pid);
                }
            }
        }
    }

    @Override
    void dumpTaskStack(TaskController.TaskControllerContext context) {
        Shell.ShellCommandExecutor shexec = context.shExec;
        if (shexec != null) {
            if (Shell.WINDOWS) {
                return;
            }
            String pid = context.pid;
            if (pid != null) {
                if (ProcessTree.isSetsidAvailable) {
                    ProcessTree.sigQuitProcessGroup(pid);
                } else {
                    ProcessTree.sigQuitProcess(pid);
                }
            }
        }
    }

    @Override
    public void initializeDistributedCacheFile(TaskController.DistributedCacheFileContext context) throws IOException {
        Path localizedUniqueDir = context.getLocalizedUniqueDir();
        try {
            LOG.info((Object)("Doing chmod on localdir :" + localizedUniqueDir));
            FileUtil.chmod((String)localizedUniqueDir.toString(), (String)"+x", (boolean)true);
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)("Exception in doing chmod on" + localizedUniqueDir), (Throwable)ie);
            throw new IOException(ie);
        }
    }

    @Override
    public void initializeUser(TaskController.InitializationContext context) {
    }

    @Override
    void runDebugScript(TaskController.DebugScriptContext context) throws IOException {
        List<String> wrappedCommand = TaskLog.captureDebugOut(context.args, context.stdout);
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(wrappedCommand.toArray(new String[0]), context.workDir);
        shexec.execute();
        int exitCode = shexec.getExitCode();
        if (exitCode != 0) {
            throw new IOException("Task debug script exit with nonzero status of " + exitCode + ".");
        }
    }

    @Override
    void enableTaskForCleanup(CleanupQueue.PathDeletionContext context) throws IOException {
        this.enablePathForCleanup(context);
    }

    @Override
    void enableJobForCleanup(CleanupQueue.PathDeletionContext context) throws IOException {
        this.enablePathForCleanup(context);
    }

    private void enablePathForCleanup(CleanupQueue.PathDeletionContext context) throws IOException {
        try {
            FileUtil.chmod((String)context.fullPath, (String)"u+rwx", (boolean)true);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Interrupted while setting permissions for " + context.fullPath + " for deletion."));
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Unable to change permissions of " + context.fullPath));
        }
    }
}

