/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.jobhistory.JobHistory;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;

class JSPUtil {
    static final String PRIVATE_ACTIONS_KEY = "webinterface.private.actions";
    private static final Map<String, JobHistoryParser.JobInfo> jobHistoryCache = new LinkedHashMap<String, JobHistoryParser.JobInfo>();
    private static final Log LOG = LogFactory.getLog(JSPUtil.class);

    JSPUtil() {
    }

    public static JobWithViewAccessCheck checkAccessAndGetJob(JobTracker jt, JobID jobid, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final JobInProgress job = jt.getJob(jobid);
        JobWithViewAccessCheck myJob = new JobWithViewAccessCheck(job);
        String user = request.getRemoteUser();
        if (user != null && job != null && jt.isJobLevelAuthorizationEnabled()) {
            final UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
            try {
                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, ServletException {
                        job.checkAccess(ugi, JobACL.VIEW_JOB);
                        return null;
                    }
                });
            }
            catch (AccessControlException e) {
                String errMsg = "User " + ugi.getShortUserName() + " failed to view " + jobid + "!<br><br>" + e.getMessage() + "<hr><a href=\"jobtracker.jsp\">Go back to JobTracker</a><br>";
                JSPUtil.setErrorAndForward(errMsg, request, response);
                myJob.setViewAccess(false);
            }
            catch (InterruptedException e) {
                String errMsg = " Interrupted while trying to access " + jobid + "<hr><a href=\"jobtracker.jsp\">Go back to JobTracker</a><br>";
                JSPUtil.setErrorAndForward(errMsg, request, response);
                myJob.setViewAccess(false);
            }
        }
        return myJob;
    }

    public static void setErrorAndForward(String errMsg, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("error.msg", (Object)errMsg);
        RequestDispatcher dispatcher = request.getRequestDispatcher("/job_authorization_error.jsp");
        response.setStatus(401);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public static boolean processButtons(HttpServletRequest request, HttpServletResponse response, final JobTracker tracker) throws IOException, InterruptedException, ServletException {
        String[] jobs;
        String user = request.getRemoteUser();
        if (JSPUtil.privateActionsAllowed(tracker.conf) && request.getParameter("killJobs") != null && (jobs = request.getParameterValues("jobCheckBox")) != null) {
            boolean notAuthorized = false;
            String errMsg = "User " + user + " failed to kill the following job(s)!<br><br>";
            for (String job : jobs) {
                final JobID jobId = JobID.forName(job);
                if (user != null) {
                    UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
                    try {
                        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws IOException {
                                tracker.killJob(jobId);
                                return null;
                            }
                        });
                    }
                    catch (AccessControlException e) {
                        errMsg = errMsg.concat("<br>" + e.getMessage());
                        notAuthorized = true;
                    }
                    continue;
                }
                tracker.killJob(jobId);
            }
            if (notAuthorized) {
                errMsg = errMsg.concat("<br><hr><a href=\"jobtracker.jsp\">Go back to JobTracker</a><br>");
                JSPUtil.setErrorAndForward(errMsg, request, response);
                return false;
            }
        }
        if (JSPUtil.privateActionsAllowed(tracker.conf) && request.getParameter("changeJobPriority") != null && (jobs = request.getParameterValues("jobCheckBox")) != null) {
            final JobPriority jobPri = JobPriority.valueOf(request.getParameter("setJobPriority"));
            boolean notAuthorized = false;
            String errMsg = "User " + user + " failed to set priority for the following job(s)!<br><br>";
            for (String job : jobs) {
                final JobID jobId = JobID.forName(job);
                if (user != null) {
                    UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
                    try {
                        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws IOException {
                                tracker.setJobPriority(jobId, jobPri);
                                return null;
                            }
                        });
                    }
                    catch (AccessControlException e) {
                        errMsg = errMsg.concat("<br>" + e.getMessage());
                        notAuthorized = true;
                    }
                    continue;
                }
                tracker.setJobPriority(jobId, jobPri);
            }
            if (notAuthorized) {
                errMsg = errMsg.concat("<br><hr><a href=\"jobtracker.jsp\">Go back to JobTracker</a><br>");
                JSPUtil.setErrorAndForward(errMsg, request, response);
                return false;
            }
        }
        return true;
    }

    public static String generateJobTable(String label, Collection<JobInProgress> jobs, int refresh, int rowId, JobConf conf) throws IOException {
        boolean isModifiable = label.equals("Running") && JSPUtil.privateActionsAllowed(conf);
        StringBuilder sb = new StringBuilder();
        sb.append("<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\">\n");
        if (jobs.size() > 0) {
            if (isModifiable) {
                sb.append("<form action=\"/jobtracker.jsp\" onsubmit=\"return confirmAction();\" method=\"POST\">");
                sb.append("<tr>");
                sb.append("<td><input type=\"Button\" onclick=\"selectAll()\" value=\"Select All\" id=\"checkEm\"></td>");
                sb.append("<td>");
                sb.append("<input type=\"submit\" name=\"killJobs\" value=\"Kill Selected Jobs\">");
                sb.append("</td");
                sb.append("<td><nobr>");
                sb.append("<select name=\"setJobPriority\">");
                for (JobPriority prio : JobPriority.values()) {
                    sb.append("<option" + (JobPriority.NORMAL == prio ? " selected=\"selected\">" : ">") + (Object)((Object)prio) + "</option>");
                }
                sb.append("</select>");
                sb.append("<input type=\"submit\" name=\"changeJobPriority\" value=\"Change\">");
                sb.append("</nobr></td>");
                sb.append("<td colspan=\"10\">&nbsp;</td>");
                sb.append("</tr>");
                sb.append("<td>&nbsp;</td>");
            } else {
                sb.append("<tr>");
            }
            sb.append("<td><b>Jobid</b></td><td><b>Priority</b></td><td><b>User</b></td>");
            sb.append("<td><b>Name</b></td>");
            sb.append("<td><b>Map % Complete</b></td>");
            sb.append("<td><b>Map Total</b></td>");
            sb.append("<td><b>Maps Completed</b></td>");
            sb.append("<td><b>Reduce % Complete</b></td>");
            sb.append("<td><b>Reduce Total</b></td>");
            sb.append("<td><b>Reduces Completed</b></td>");
            sb.append("<td><b>Job Scheduling Information</b></td>");
            sb.append("</tr>\n");
            for (JobInProgress job : jobs) {
                JobProfile profile = job.getProfile();
                JobStatus status = job.getStatus();
                JobID jobid = profile.getJobID();
                int desiredMaps = job.desiredMaps();
                int desiredReduces = job.desiredReduces();
                int completedMaps = job.finishedMaps();
                int completedReduces = job.finishedReduces();
                String name = HtmlQuoting.quoteHtmlChars((String)profile.getJobName());
                String jobpri = job.getPriority().toString();
                String schedulingInfo = HtmlQuoting.quoteHtmlChars((String)job.getStatus().getSchedulingInfo());
                if (isModifiable) {
                    sb.append("<tr><td><input TYPE=\"checkbox\" onclick=\"checkButtonVerbage()\" name=\"jobCheckBox\" value=" + jobid + "></td>");
                } else {
                    sb.append("<tr>");
                }
                sb.append("<td id=\"job_" + rowId + "\"><a href=\"jobdetails.jsp?jobid=" + jobid + "&refresh=" + refresh + "\">" + jobid + "</a></td>" + "<td id=\"priority_" + rowId + "\">" + jobpri + "</td>" + "<td id=\"user_" + rowId + "\">" + HtmlQuoting.quoteHtmlChars((String)profile.getUser()) + "</td>" + "<td id=\"name_" + rowId + "\">" + ("".equals(name) ? "&nbsp;" : name) + "</td>" + "<td>" + StringUtils.formatPercent((double)status.mapProgress(), (int)2) + ServletUtil.percentageGraph((float)(status.mapProgress() * 100.0f), (int)80) + "</td><td>" + desiredMaps + "</td><td>" + completedMaps + "</td><td>" + StringUtils.formatPercent((double)status.reduceProgress(), (int)2) + ServletUtil.percentageGraph((float)(status.reduceProgress() * 100.0f), (int)80) + "</td><td>" + desiredReduces + "</td><td> " + completedReduces + "</td><td>" + schedulingInfo + "</td></tr>\n");
                ++rowId;
            }
            if (isModifiable) {
                sb.append("</form>\n");
            }
        } else {
            sb.append("<tr><td align=\"center\" colspan=\"8\"><i>none</i></td></tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    public static String generateRetiredJobTable(JobTracker tracker, int rowId) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\">\n");
        Iterator<JobStatus> iterator = tracker.retireJobs.getAll().descendingIterator();
        if (!iterator.hasNext()) {
            sb.append("<tr><td align=\"center\" colspan=\"8\"><i>none</i></td></tr>\n");
        } else {
            sb.append("<tr>");
            sb.append("<td><b>Jobid</b></td>");
            sb.append("<td><b>Priority</b></td>");
            sb.append("<td><b>User</b></td>");
            sb.append("<td><b>Name</b></td>");
            sb.append("<td><b>State</b></td>");
            sb.append("<td><b>Start Time</b></td>");
            sb.append("<td><b>Finish Time</b></td>");
            sb.append("<td><b>Map % Complete</b></td>");
            sb.append("<td><b>Reduce % Complete</b></td>");
            sb.append("<td><b>Job Scheduling Information</b></td>");
            sb.append("</tr>\n");
            for (int i = 0; i < 100 && iterator.hasNext(); ++i) {
                JobStatus status = iterator.next();
                sb.append("<tr>");
                sb.append("<td id=\"job_" + rowId + "\">" + "<a href=\"jobdetailshistory.jsp?logFile=" + URLEncoder.encode(status.getHistoryFile().toString(), "UTF-8") + "\">" + status.getJobId() + "</a></td>" + "<td id=\"priority_" + rowId + "\">" + status.getJobPriority().toString() + "</td>" + "<td id=\"user_" + rowId + "\">" + HtmlQuoting.quoteHtmlChars((String)status.getUsername()) + "</td>" + "<td id=\"name_" + rowId + "\">" + HtmlQuoting.quoteHtmlChars((String)status.getJobName()) + "</td>" + "<td>" + JobStatus.getJobRunState(status.getRunState()) + "</td>" + "<td>" + new Date(status.getStartTime()) + "</td>" + "<td>" + new Date(status.getFinishTime()) + "</td>" + "<td>" + StringUtils.formatPercent((double)status.mapProgress(), (int)2) + ServletUtil.percentageGraph((float)(status.mapProgress() * 100.0f), (int)80) + "</td>" + "<td>" + StringUtils.formatPercent((double)status.reduceProgress(), (int)2) + ServletUtil.percentageGraph((float)(status.reduceProgress() * 100.0f), (int)80) + "</td>" + "<td>" + HtmlQuoting.quoteHtmlChars((String)status.getSchedulingInfo()) + "</td>" + "</tr>\n");
                ++rowId;
            }
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    public static void generateRetiredJobXml(JspWriter out, JobTracker tracker, int rowId) throws IOException {
        Iterator<JobStatus> iterator = tracker.retireJobs.getAll().descendingIterator();
        for (int i = 0; i < 100 && iterator.hasNext(); ++i) {
            JobStatus status = iterator.next();
            StringBuilder sb = new StringBuilder();
            sb.append("<retired_job rowid=\"" + rowId + "\" jobid=\"" + status.getJobId() + "\">");
            sb.append("<jobid>" + status.getJobId() + "</jobid>");
            sb.append("<history_url>jobdetailshistory.jsp?logFile=" + URLEncoder.encode(status.getHistoryFile().toString(), "UTF-8") + "</history_url>");
            sb.append("<priority>" + status.getJobPriority().toString() + "</priority>");
            sb.append("<user>" + status.getUsername() + "</user>");
            sb.append("<name>" + status.getJobName() + "</name>");
            sb.append("<run_state>" + JobStatus.getJobRunState(status.getRunState()) + "</run_state>");
            sb.append("<start_time>" + new Date(status.getStartTime()) + "</start_time>");
            sb.append("<finish_time>" + new Date(status.getFinishTime()) + "</finish_time>");
            sb.append("<map_complete>" + StringUtils.formatPercent((double)status.mapProgress(), (int)2) + "</map_complete>");
            sb.append("<reduce_complete>" + StringUtils.formatPercent((double)status.reduceProgress(), (int)2) + "</reduce_complete>");
            sb.append("<scheduling_info>" + status.getSchedulingInfo() + "</scheduling_info>");
            sb.append("</retired_job>\n");
            out.write(sb.toString());
            ++rowId;
        }
    }

    static boolean privateActionsAllowed(JobConf conf) {
        return conf.getBoolean(PRIVATE_ACTIONS_KEY, false);
    }

    static Path getJobConfFilePath(Path logFile) {
        Path logDir = logFile.getParent();
        org.apache.hadoop.mapreduce.JobID jobId = JobHistory.getJobIDFromHistoryFilePath(logFile);
        return JobHistory.getConfFile(logDir, jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JobHistoryParser.JobInfo getJobInfo(Path logFile, FileSystem fs, JobTracker jobTracker) throws IOException {
        String jobid = JobHistory.getJobIDFromHistoryFilePath(logFile).toString();
        JobHistoryParser.JobInfo jobInfo = null;
        Map<String, JobHistoryParser.JobInfo> map = jobHistoryCache;
        synchronized (map) {
            jobInfo = jobHistoryCache.remove(jobid);
            if (jobInfo == null) {
                JobHistoryParser parser = new JobHistoryParser(fs, logFile);
                jobInfo = parser.parse();
                LOG.info((Object)("Loading Job History file " + jobid + ".   Cache size is " + jobHistoryCache.size()));
            }
            jobHistoryCache.put(jobid, jobInfo);
            int CACHE_SIZE = jobTracker.conf.getInt("mapreduce.jobtracker.jobhistory.lru.cache.size", 5);
            if (jobHistoryCache.size() > CACHE_SIZE) {
                Iterator<Map.Entry<String, JobHistoryParser.JobInfo>> it = jobHistoryCache.entrySet().iterator();
                String removeJobId = it.next().getKey();
                it.remove();
                LOG.info((Object)("Job History file removed form cache " + removeJobId));
            }
        }
        jobTracker.getJobACLsManager().checkAccess(JobID.forName(jobid), UserGroupInformation.getCurrentUser(), JobACL.VIEW_JOB, jobInfo.getUsername(), jobInfo.getJobACLs().get((Object)JobACL.VIEW_JOB));
        return jobInfo;
    }

    static JobHistoryParser.JobInfo checkAccessAndGetJobInfo(HttpServletRequest request, HttpServletResponse response, final JobTracker jobTracker, final FileSystem fs, final Path logFile) throws IOException, InterruptedException, ServletException {
        String jobid = JobHistory.getJobIDFromHistoryFilePath(logFile).toString();
        String user = request.getRemoteUser();
        JobHistoryParser.JobInfo job = null;
        if (user != null) {
            try {
                UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
                job = (JobHistoryParser.JobInfo)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JobHistoryParser.JobInfo>(){

                    @Override
                    public JobHistoryParser.JobInfo run() throws IOException {
                        JobHistoryParser.JobInfo jobInfo = JSPUtil.getJobInfo(logFile, fs, jobTracker);
                        return jobInfo;
                    }
                });
            }
            catch (AccessControlException e) {
                String errMsg = String.format("User %s failed to view %s!<br><br>%s<hr><a href=\"jobhistory.jsp\">Go back to JobHistory</a><br><a href=\"jobtracker.jsp\">Go back to JobTracker</a>", user, jobid, e.getMessage());
                JSPUtil.setErrorAndForward(errMsg, request, response);
                return null;
            }
        } else {
            job = JSPUtil.getJobInfo(logFile, fs, jobTracker);
        }
        return job;
    }

    static void printJobACLs(JobTracker tracker, Map<JobACL, AccessControlList> jobAcls, JspWriter out) throws IOException {
        if (tracker.isJobLevelAuthorizationEnabled()) {
            out.print("<b>Job-ACLs:</b><br>");
            for (JobACL aclName : JobACL.values()) {
                String aclConfigName = aclName.getAclName();
                AccessControlList aclConfigured = jobAcls.get((Object)aclName);
                if (aclConfigured == null) continue;
                String aclStr = aclConfigured.toString();
                out.print("&nbsp;&nbsp;&nbsp;&nbsp;" + aclConfigName + ": " + HtmlQuoting.quoteHtmlChars((String)aclStr) + "<br>");
            }
        }
    }

    static class JobWithViewAccessCheck {
        private JobInProgress job = null;
        private boolean isViewAllowed = true;

        JobWithViewAccessCheck(JobInProgress job) {
            this.job = job;
        }

        JobInProgress getJob() {
            return this.job;
        }

        boolean isViewJobAllowed() {
            return this.isViewAllowed;
        }

        void setViewAccess(boolean isViewAllowed) {
            this.isViewAllowed = isViewAllowed;
        }
    }
}

