/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.tools.CLI;
import org.apache.hadoop.mapreduce.util.ConfigUtil;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class JobClient
extends CLI {
    private TaskStatusFilter taskOutputFilter = TaskStatusFilter.FAILED;
    Cluster cluster;

    public JobClient() {
    }

    public JobClient(JobConf conf) throws IOException {
        this.init(conf);
    }

    public JobClient(Configuration conf) throws IOException {
        this.init(new JobConf(conf));
    }

    public void init(JobConf conf) throws IOException {
        this.setConf(conf);
        this.cluster = new Cluster(conf);
    }

    public JobClient(InetSocketAddress jobTrackAddr, Configuration conf) throws IOException {
        this.cluster = new Cluster(jobTrackAddr, conf);
    }

    public synchronized void close() throws IOException {
        this.cluster.close();
    }

    public synchronized FileSystem getFs() throws IOException {
        try {
            return this.cluster.getFileSystem();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public Cluster getClusterHandle() {
        return this.cluster;
    }

    public RunningJob submitJob(String jobFile) throws FileNotFoundException, InvalidJobConfException, IOException {
        JobConf job = new JobConf(jobFile);
        return this.submitJob(job);
    }

    public RunningJob submitJob(JobConf conf) throws FileNotFoundException, IOException {
        try {
            conf.setBooleanIfUnset("mapred.mapper.new-api", false);
            conf.setBooleanIfUnset("mapred.reducer.new-api", false);
            Job job = Job.getInstance(this.cluster, conf);
            job.submit();
            return new NetworkedJob(job);
        }
        catch (InterruptedException ie) {
            throw new IOException("interrupted", ie);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("class not found", cnfe);
        }
    }

    public RunningJob getJob(JobID jobid) throws IOException {
        try {
            org.apache.hadoop.mapred.JobStatus status;
            Job job = this.cluster.getJob(jobid);
            if (job != null && (status = org.apache.hadoop.mapred.JobStatus.downgrade(job.getStatus())) != null) {
                return new NetworkedJob(status);
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        return null;
    }

    @Deprecated
    public RunningJob getJob(String jobid) throws IOException {
        return this.getJob(JobID.forName(jobid));
    }

    public TaskReport[] getMapTaskReports(JobID jobId) throws IOException {
        try {
            return TaskReport.downgradeArray(this.cluster.getJob(jobId).getTaskReports(TaskType.MAP));
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @Deprecated
    public TaskReport[] getMapTaskReports(String jobId) throws IOException {
        return this.getMapTaskReports(JobID.forName(jobId));
    }

    public TaskReport[] getReduceTaskReports(JobID jobId) throws IOException {
        try {
            return TaskReport.downgradeArray(this.cluster.getJob(jobId).getTaskReports(TaskType.REDUCE));
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public TaskReport[] getCleanupTaskReports(JobID jobId) throws IOException {
        try {
            return TaskReport.downgradeArray(this.cluster.getJob(jobId).getTaskReports(TaskType.JOB_CLEANUP));
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public TaskReport[] getSetupTaskReports(JobID jobId) throws IOException {
        try {
            return TaskReport.downgradeArray(this.cluster.getJob(jobId).getTaskReports(TaskType.JOB_SETUP));
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @Deprecated
    public TaskReport[] getReduceTaskReports(String jobId) throws IOException {
        return this.getReduceTaskReports(JobID.forName(jobId));
    }

    public void displayTasks(JobID jobId, String type, String state) throws IOException {
        try {
            super.displayTasks(this.cluster.getJob(jobId), type, state);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public ClusterStatus getClusterStatus() throws IOException {
        try {
            ClusterMetrics metrics = this.cluster.getClusterStatus();
            return new ClusterStatus(metrics.getTaskTrackerCount(), metrics.getBlackListedTaskTrackerCount(), this.cluster.getTaskTrackerExpiryInterval(), metrics.getOccupiedMapSlots(), metrics.getOccupiedReduceSlots(), metrics.getMapSlotCapacity(), metrics.getReduceSlotCapacity(), JobTracker.State.valueOf(this.cluster.getJobTrackerState().name()), metrics.getDecommissionedTaskTrackerCount());
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    private Collection<String> arrayToStringList(TaskTrackerInfo[] objs) {
        ArrayList<String> list = new ArrayList<String>();
        for (TaskTrackerInfo info : objs) {
            list.add(info.getTaskTrackerName());
        }
        return list;
    }

    private Collection<ClusterStatus.BlackListInfo> arrayToBlackListInfo(TaskTrackerInfo[] objs) {
        ArrayList<ClusterStatus.BlackListInfo> list = new ArrayList<ClusterStatus.BlackListInfo>();
        for (TaskTrackerInfo info : objs) {
            ClusterStatus.BlackListInfo binfo = new ClusterStatus.BlackListInfo();
            binfo.setTrackerName(info.getTaskTrackerName());
            binfo.setReasonForBlackListing(info.getReasonForBlacklist());
            binfo.setBlackListReport(info.getBlacklistReport());
            list.add(binfo);
        }
        return list;
    }

    public ClusterStatus getClusterStatus(boolean detailed) throws IOException {
        try {
            ClusterMetrics metrics = this.cluster.getClusterStatus();
            return new ClusterStatus(this.arrayToStringList(this.cluster.getActiveTaskTrackers()), this.arrayToBlackListInfo(this.cluster.getBlackListedTaskTrackers()), this.cluster.getTaskTrackerExpiryInterval(), metrics.getOccupiedMapSlots(), metrics.getOccupiedReduceSlots(), metrics.getMapSlotCapacity(), metrics.getReduceSlotCapacity(), JobTracker.State.valueOf(this.cluster.getJobTrackerState().name()));
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public org.apache.hadoop.mapred.JobStatus[] jobsToComplete() throws IOException {
        ArrayList<org.apache.hadoop.mapred.JobStatus> stats = new ArrayList<org.apache.hadoop.mapred.JobStatus>();
        for (org.apache.hadoop.mapred.JobStatus stat : this.getAllJobs()) {
            if (stat.isJobComplete()) continue;
            stats.add(stat);
        }
        return stats.toArray(new org.apache.hadoop.mapred.JobStatus[0]);
    }

    public org.apache.hadoop.mapred.JobStatus[] getAllJobs() throws IOException {
        try {
            Job[] jobs = this.cluster.getAllJobs();
            org.apache.hadoop.mapred.JobStatus[] stats = new org.apache.hadoop.mapred.JobStatus[jobs.length];
            for (int i = 0; i < jobs.length; ++i) {
                stats[i] = org.apache.hadoop.mapred.JobStatus.downgrade(jobs[i].getStatus());
            }
            return stats;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public static RunningJob runJob(JobConf job) throws IOException {
        JobClient jc = new JobClient(job);
        RunningJob rj = jc.submitJob(job);
        try {
            if (!jc.monitorAndPrintJob(job, rj)) {
                throw new IOException("Job failed!");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return rj;
    }

    public boolean monitorAndPrintJob(JobConf conf, RunningJob job) throws IOException, InterruptedException {
        return ((NetworkedJob)job).monitorAndPrintJob();
    }

    static String getTaskLogURL(TaskAttemptID taskId, String baseUrl) {
        return baseUrl + "/tasklog?plaintext=true&attemptid=" + taskId;
    }

    static Configuration getConfiguration(String jobTrackerSpec) {
        Configuration conf = new Configuration();
        if (jobTrackerSpec != null) {
            if (jobTrackerSpec.indexOf(":") >= 0) {
                conf.set("mapred.job.tracker", jobTrackerSpec);
            } else {
                String classpathFile = "hadoop-" + jobTrackerSpec + ".xml";
                URL validate = conf.getResource(classpathFile);
                if (validate == null) {
                    throw new RuntimeException(classpathFile + " not found on CLASSPATH");
                }
                conf.addResource(classpathFile);
            }
        }
        return conf;
    }

    @Deprecated
    public void setTaskOutputFilter(TaskStatusFilter newValue) {
        this.taskOutputFilter = newValue;
    }

    public static TaskStatusFilter getTaskOutputFilter(JobConf job) {
        return TaskStatusFilter.valueOf(job.get("jobclient.output.filter", "FAILED"));
    }

    public static void setTaskOutputFilter(JobConf job, TaskStatusFilter newValue) {
        job.set("jobclient.output.filter", newValue.toString());
    }

    @Deprecated
    public TaskStatusFilter getTaskOutputFilter() {
        return this.taskOutputFilter;
    }

    @Override
    protected long getCounter(Counters cntrs, String counterGroupName, String counterName) throws IOException {
        org.apache.hadoop.mapred.Counters counters = org.apache.hadoop.mapred.Counters.downgrade(cntrs);
        return counters.findCounter(counterGroupName, counterName).getValue();
    }

    void displayJobList(org.apache.hadoop.mapred.JobStatus[] jobs) {
        System.out.printf("JobId\tState\tStartTime\tUserName\tPriority\tSchedulingInfo\n", new Object[0]);
        for (org.apache.hadoop.mapred.JobStatus job : jobs) {
            System.out.printf("%s\t%d\t%d\t%s\t%s\t%s\n", job.getJobID(), job.getRunState(), job.getStartTime(), job.getUsername(), job.getJobPriority().name(), job.getSchedulingInfo());
        }
    }

    public int getDefaultMaps() throws IOException {
        try {
            return this.cluster.getClusterStatus().getMapSlotCapacity();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public int getDefaultReduces() throws IOException {
        try {
            return this.cluster.getClusterStatus().getReduceSlotCapacity();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public Path getSystemDir() {
        try {
            return this.cluster.getSystemDir();
        }
        catch (IOException ioe) {
            return null;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    private JobQueueInfo[] getJobQueueInfoArray(QueueInfo[] queues) throws IOException {
        JobQueueInfo[] ret = new JobQueueInfo[queues.length];
        for (int i = 0; i < queues.length; ++i) {
            ret[i] = new JobQueueInfo(queues[i]);
        }
        return ret;
    }

    public JobQueueInfo[] getRootQueues() throws IOException {
        try {
            return this.getJobQueueInfoArray(this.cluster.getRootQueues());
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public JobQueueInfo[] getChildQueues(String queueName) throws IOException {
        try {
            return this.getJobQueueInfoArray(this.cluster.getChildQueues(queueName));
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public JobQueueInfo[] getQueues() throws IOException {
        try {
            return this.getJobQueueInfoArray(this.cluster.getQueues());
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public org.apache.hadoop.mapred.JobStatus[] getJobsFromQueue(String queueName) throws IOException {
        try {
            QueueInfo queue = this.cluster.getQueue(queueName);
            if (queue == null) {
                return null;
            }
            JobStatus[] stats = queue.getJobStatuses();
            org.apache.hadoop.mapred.JobStatus[] ret = new org.apache.hadoop.mapred.JobStatus[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                ret[i] = org.apache.hadoop.mapred.JobStatus.downgrade(stats[i]);
            }
            return ret;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public JobQueueInfo getQueueInfo(String queueName) throws IOException {
        try {
            QueueInfo queueInfo = this.cluster.getQueue(queueName);
            if (queueInfo != null) {
                return new JobQueueInfo(queueInfo);
            }
            return null;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        try {
            org.apache.hadoop.mapreduce.QueueAclsInfo[] acls = this.cluster.getQueueAclsForCurrentUser();
            QueueAclsInfo[] ret = new QueueAclsInfo[acls.length];
            for (int i = 0; i < acls.length; ++i) {
                ret[i] = QueueAclsInfo.downgrade(acls[i]);
            }
            return ret;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return this.cluster.getDelegationToken(renewer);
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException, InterruptedException {
        return this.cluster.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException, InterruptedException {
        this.cluster.cancelDelegationToken(token);
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Tool)new JobClient(), (String[])argv);
        System.exit(res);
    }

    static {
        ConfigUtil.loadResources();
    }

    class NetworkedJob
    implements RunningJob {
        Job job;

        public NetworkedJob(org.apache.hadoop.mapred.JobStatus status) throws IOException {
            this.job = Job.getInstance(JobClient.this.cluster, status, new JobConf(status.getJobFile()));
        }

        public NetworkedJob(Job job) throws IOException {
            this.job = job;
        }

        @Override
        public Configuration getConfiguration() {
            return this.job.getConfiguration();
        }

        @Override
        public JobID getID() {
            return JobID.downgrade(this.job.getJobID());
        }

        @Override
        @Deprecated
        public String getJobID() {
            return this.getID().toString();
        }

        @Override
        public String getJobName() {
            return this.job.getJobName();
        }

        @Override
        public String getJobFile() {
            return this.job.getJobFile();
        }

        @Override
        public String getTrackingURL() {
            return this.job.getTrackingURL();
        }

        @Override
        public float mapProgress() throws IOException {
            try {
                return this.job.mapProgress();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public float reduceProgress() throws IOException {
            try {
                return this.job.reduceProgress();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public float cleanupProgress() throws IOException {
            try {
                return this.job.cleanupProgress();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public float setupProgress() throws IOException {
            try {
                return this.job.setupProgress();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public synchronized boolean isComplete() throws IOException {
            try {
                return this.job.isComplete();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public synchronized boolean isSuccessful() throws IOException {
            try {
                return this.job.isSuccessful();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public void waitForCompletion() throws IOException {
            try {
                this.job.waitForCompletion(false);
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
            catch (ClassNotFoundException ce) {
                throw new IOException(ce);
            }
        }

        @Override
        public synchronized int getJobState() throws IOException {
            try {
                return this.job.getJobState().getValue();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public synchronized void killJob() throws IOException {
            try {
                this.job.killJob();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public synchronized void setJobPriority(String priority) throws IOException {
            try {
                this.job.setPriority(JobPriority.valueOf(priority));
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public synchronized void killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
            try {
                if (shouldFail) {
                    this.job.failTask(taskId);
                } else {
                    this.job.killTask(taskId);
                }
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        @Deprecated
        public synchronized void killTask(String taskId, boolean shouldFail) throws IOException {
            this.killTask(TaskAttemptID.forName(taskId), shouldFail);
        }

        @Override
        public synchronized TaskCompletionEvent[] getTaskCompletionEvents(int startFrom) throws IOException {
            try {
                org.apache.hadoop.mapreduce.TaskCompletionEvent[] acls = this.job.getTaskCompletionEvents(startFrom, 10);
                TaskCompletionEvent[] ret = new TaskCompletionEvent[acls.length];
                for (int i = 0; i < acls.length; ++i) {
                    ret[i] = TaskCompletionEvent.downgrade(acls[i]);
                }
                return ret;
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        public String toString() {
            return this.job.toString();
        }

        @Override
        public org.apache.hadoop.mapred.Counters getCounters() throws IOException {
            try {
                return org.apache.hadoop.mapred.Counters.downgrade(this.job.getCounters());
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public String[] getTaskDiagnostics(TaskAttemptID id) throws IOException {
            try {
                return this.job.getTaskDiagnostics(id);
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public String getHistoryUrl() throws IOException {
            try {
                return this.job.getHistoryUrl();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        @Override
        public boolean isRetired() throws IOException {
            try {
                return this.job.isRetired();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }

        boolean monitorAndPrintJob() throws IOException, InterruptedException {
            return this.job.monitorAndPrintJob();
        }
    }

    public static enum TaskStatusFilter {
        NONE,
        KILLED,
        FAILED,
        SUCCEEDED,
        ALL;

    }
}

