/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;

class JobTrackerMetricsInst
extends JobTrackerInstrumentation
implements Updater {
    private final MetricsRecord metricsRecord;
    private int numMapTasksLaunched = 0;
    private int numMapTasksCompleted = 0;
    private int numMapTasksFailed = 0;
    private int numReduceTasksLaunched = 0;
    private int numReduceTasksCompleted = 0;
    private int numReduceTasksFailed = 0;
    private int numJobsSubmitted = 0;
    private int numJobsCompleted = 0;
    private int numWaitingMaps = 0;
    private int numWaitingReduces = 0;
    private volatile int numMapSlots = 0;
    private volatile int numReduceSlots = 0;
    private int numBlackListedMapSlots = 0;
    private int numBlackListedReduceSlots = 0;
    private int numReservedMapSlots = 0;
    private int numReservedReduceSlots = 0;
    private int numOccupiedMapSlots = 0;
    private int numOccupiedReduceSlots = 0;
    private int numJobsFailed = 0;
    private int numJobsKilled = 0;
    private int numJobsPreparing = 0;
    private int numJobsRunning = 0;
    private int numRunningMaps = 0;
    private int numRunningReduces = 0;
    private int numMapTasksKilled = 0;
    private int numReduceTasksKilled = 0;
    private int numTrackers = 0;
    private int numTrackersBlackListed = 0;
    private int numTrackersDecommissioned = 0;

    public JobTrackerMetricsInst(JobTracker tracker, JobConf conf) {
        super(tracker, conf);
        String sessionId = conf.getSessionId();
        JvmMetrics.init((String)"JobTracker", (String)sessionId);
        MetricsContext context = MetricsUtil.getContext((String)"mapred");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"jobtracker");
        this.metricsRecord.setTag("sessionId", sessionId);
        context.registerUpdater((Updater)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        JobTrackerMetricsInst jobTrackerMetricsInst = this;
        synchronized (jobTrackerMetricsInst) {
            this.metricsRecord.setMetric("map_slots", this.numMapSlots);
            this.metricsRecord.setMetric("reduce_slots", this.numReduceSlots);
            this.metricsRecord.incrMetric("blacklisted_maps", this.numBlackListedMapSlots);
            this.metricsRecord.incrMetric("blacklisted_reduces", this.numBlackListedReduceSlots);
            this.metricsRecord.incrMetric("maps_launched", this.numMapTasksLaunched);
            this.metricsRecord.incrMetric("maps_completed", this.numMapTasksCompleted);
            this.metricsRecord.incrMetric("maps_failed", this.numMapTasksFailed);
            this.metricsRecord.incrMetric("reduces_launched", this.numReduceTasksLaunched);
            this.metricsRecord.incrMetric("reduces_completed", this.numReduceTasksCompleted);
            this.metricsRecord.incrMetric("reduces_failed", this.numReduceTasksFailed);
            this.metricsRecord.incrMetric("jobs_submitted", this.numJobsSubmitted);
            this.metricsRecord.incrMetric("jobs_completed", this.numJobsCompleted);
            this.metricsRecord.incrMetric("waiting_maps", this.numWaitingMaps);
            this.metricsRecord.incrMetric("waiting_reduces", this.numWaitingReduces);
            this.metricsRecord.incrMetric("reserved_map_slots", this.numReservedMapSlots);
            this.metricsRecord.incrMetric("reserved_reduce_slots", this.numReservedReduceSlots);
            this.metricsRecord.incrMetric("occupied_map_slots", this.numOccupiedMapSlots);
            this.metricsRecord.incrMetric("occupied_reduce_slots", this.numOccupiedReduceSlots);
            this.metricsRecord.incrMetric("jobs_failed", this.numJobsFailed);
            this.metricsRecord.incrMetric("jobs_killed", this.numJobsKilled);
            this.metricsRecord.incrMetric("jobs_preparing", this.numJobsPreparing);
            this.metricsRecord.incrMetric("jobs_running", this.numJobsRunning);
            this.metricsRecord.incrMetric("running_maps", this.numRunningMaps);
            this.metricsRecord.incrMetric("running_reduces", this.numRunningReduces);
            this.metricsRecord.incrMetric("maps_killed", this.numMapTasksKilled);
            this.metricsRecord.incrMetric("reduces_killed", this.numReduceTasksKilled);
            this.metricsRecord.incrMetric("trackers", this.numTrackers);
            this.metricsRecord.incrMetric("trackers_blacklisted", this.numTrackersBlackListed);
            this.metricsRecord.setMetric("trackers_decommissioned", this.numTrackersDecommissioned);
            this.numMapTasksLaunched = 0;
            this.numMapTasksCompleted = 0;
            this.numMapTasksFailed = 0;
            this.numReduceTasksLaunched = 0;
            this.numReduceTasksCompleted = 0;
            this.numReduceTasksFailed = 0;
            this.numJobsSubmitted = 0;
            this.numJobsCompleted = 0;
            this.numWaitingMaps = 0;
            this.numWaitingReduces = 0;
            this.numBlackListedMapSlots = 0;
            this.numBlackListedReduceSlots = 0;
            this.numReservedMapSlots = 0;
            this.numReservedReduceSlots = 0;
            this.numOccupiedMapSlots = 0;
            this.numOccupiedReduceSlots = 0;
            this.numJobsFailed = 0;
            this.numJobsKilled = 0;
            this.numJobsPreparing = 0;
            this.numJobsRunning = 0;
            this.numRunningMaps = 0;
            this.numRunningReduces = 0;
            this.numMapTasksKilled = 0;
            this.numReduceTasksKilled = 0;
            this.numTrackers = 0;
            this.numTrackersBlackListed = 0;
        }
        this.metricsRecord.update();
    }

    @Override
    public synchronized void launchMap(TaskAttemptID taskAttemptID) {
        ++this.numMapTasksLaunched;
        this.decWaitingMaps(taskAttemptID.getJobID(), 1);
    }

    @Override
    public synchronized void completeMap(TaskAttemptID taskAttemptID) {
        ++this.numMapTasksCompleted;
    }

    @Override
    public synchronized void failedMap(TaskAttemptID taskAttemptID) {
        ++this.numMapTasksFailed;
        this.addWaitingMaps(taskAttemptID.getJobID(), 1);
    }

    @Override
    public synchronized void launchReduce(TaskAttemptID taskAttemptID) {
        ++this.numReduceTasksLaunched;
        this.decWaitingReduces(taskAttemptID.getJobID(), 1);
    }

    @Override
    public synchronized void completeReduce(TaskAttemptID taskAttemptID) {
        ++this.numReduceTasksCompleted;
    }

    @Override
    public synchronized void failedReduce(TaskAttemptID taskAttemptID) {
        ++this.numReduceTasksFailed;
        this.addWaitingReduces(taskAttemptID.getJobID(), 1);
    }

    @Override
    public synchronized void submitJob(JobConf conf, JobID id) {
        ++this.numJobsSubmitted;
    }

    @Override
    public synchronized void completeJob(JobConf conf, JobID id) {
        ++this.numJobsCompleted;
    }

    @Override
    public synchronized void addWaitingMaps(JobID id, int task) {
        this.numWaitingMaps += task;
    }

    @Override
    public synchronized void decWaitingMaps(JobID id, int task) {
        this.numWaitingMaps -= task;
    }

    @Override
    public synchronized void addWaitingReduces(JobID id, int task) {
        this.numWaitingReduces += task;
    }

    @Override
    public synchronized void decWaitingReduces(JobID id, int task) {
        this.numWaitingReduces -= task;
    }

    @Override
    public synchronized void setMapSlots(int slots) {
        this.numMapSlots = slots;
    }

    @Override
    public synchronized void setReduceSlots(int slots) {
        this.numReduceSlots = slots;
    }

    @Override
    public synchronized void addBlackListedMapSlots(int slots) {
        this.numBlackListedMapSlots += slots;
    }

    @Override
    public synchronized void decBlackListedMapSlots(int slots) {
        this.numBlackListedMapSlots -= slots;
    }

    @Override
    public synchronized void addBlackListedReduceSlots(int slots) {
        this.numBlackListedReduceSlots += slots;
    }

    @Override
    public synchronized void decBlackListedReduceSlots(int slots) {
        this.numBlackListedReduceSlots -= slots;
    }

    @Override
    public synchronized void addReservedMapSlots(int slots) {
        this.numReservedMapSlots += slots;
    }

    @Override
    public synchronized void decReservedMapSlots(int slots) {
        this.numReservedMapSlots -= slots;
    }

    @Override
    public synchronized void addReservedReduceSlots(int slots) {
        this.numReservedReduceSlots += slots;
    }

    @Override
    public synchronized void decReservedReduceSlots(int slots) {
        this.numReservedReduceSlots -= slots;
    }

    @Override
    public synchronized void addOccupiedMapSlots(int slots) {
        this.numOccupiedMapSlots += slots;
    }

    @Override
    public synchronized void decOccupiedMapSlots(int slots) {
        this.numOccupiedMapSlots -= slots;
    }

    @Override
    public synchronized void addOccupiedReduceSlots(int slots) {
        this.numOccupiedReduceSlots += slots;
    }

    @Override
    public synchronized void decOccupiedReduceSlots(int slots) {
        this.numOccupiedReduceSlots -= slots;
    }

    @Override
    public synchronized void failedJob(JobConf conf, JobID id) {
        ++this.numJobsFailed;
    }

    @Override
    public synchronized void killedJob(JobConf conf, JobID id) {
        ++this.numJobsKilled;
    }

    @Override
    public synchronized void addPrepJob(JobConf conf, JobID id) {
        ++this.numJobsPreparing;
    }

    @Override
    public synchronized void decPrepJob(JobConf conf, JobID id) {
        --this.numJobsPreparing;
    }

    @Override
    public synchronized void addRunningJob(JobConf conf, JobID id) {
        ++this.numJobsRunning;
    }

    @Override
    public synchronized void decRunningJob(JobConf conf, JobID id) {
        --this.numJobsRunning;
    }

    @Override
    public synchronized void addRunningMaps(int task) {
        this.numRunningMaps += task;
    }

    @Override
    public synchronized void decRunningMaps(int task) {
        this.numRunningMaps -= task;
    }

    @Override
    public synchronized void addRunningReduces(int task) {
        this.numRunningReduces += task;
    }

    @Override
    public synchronized void decRunningReduces(int task) {
        this.numRunningReduces -= task;
    }

    @Override
    public synchronized void killedMap(TaskAttemptID taskAttemptID) {
        ++this.numMapTasksKilled;
    }

    @Override
    public synchronized void killedReduce(TaskAttemptID taskAttemptID) {
        ++this.numReduceTasksKilled;
    }

    @Override
    public synchronized void addTrackers(int trackers) {
        this.numTrackers += trackers;
    }

    @Override
    public synchronized void decTrackers(int trackers) {
        this.numTrackers -= trackers;
    }

    @Override
    public synchronized void addBlackListedTrackers(int trackers) {
        this.numTrackersBlackListed += trackers;
    }

    @Override
    public synchronized void decBlackListedTrackers(int trackers) {
        this.numTrackersBlackListed -= trackers;
    }

    @Override
    public synchronized void setDecommissionedTrackers(int trackers) {
        this.numTrackersDecommissioned = trackers;
    }
}

