/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.log4j.Level;

class ReduceTaskRunner
extends TaskRunner {
    public ReduceTaskRunner(TaskTracker.TaskInProgress task, TaskTracker tracker, JobConf conf) throws IOException {
        super(task, tracker, conf);
    }

    @Override
    public boolean prepare() throws IOException {
        if (!super.prepare()) {
            return false;
        }
        this.mapOutputFile.removeAll();
        return true;
    }

    @Override
    public void close() throws IOException {
        LOG.info((Object)(this.getTask() + " done; removing files."));
        this.getTask().getProgress().setStatus("closed");
        this.mapOutputFile.removeAll();
    }

    @Override
    public String getChildJavaOpts(JobConf jobConf, String defaultValue) {
        return jobConf.get("mapreduce.reduce.java.opts", super.getChildJavaOpts(jobConf, "-Xmx200m"));
    }

    @Override
    public int getChildUlimit(JobConf jobConf) {
        return jobConf.getInt("mapreduce.reduce.ulimit", super.getChildUlimit(jobConf));
    }

    @Override
    public String getChildEnv(JobConf jobConf) {
        return jobConf.get("mapreduce.reduce.env", super.getChildEnv(jobConf));
    }

    @Override
    public Level getLogLevel(JobConf jobConf) {
        return Level.toLevel((String)jobConf.get("mapreduce.reduce.log.level", JobConf.DEFAULT_LOG_LEVEL.toString()));
    }
}

