﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;

namespace OLEPOS {
	public class OPos {
		#region OPOS定数の定義 --------------------------------------------
		// Common
		public const string ESC = "\x1b";
		public const string EscUnderLine = ESC + "|1uC";
		// OPOS.H
		public const int OPOS_SUCCESS = 0;
		public const int OPOS_E_CLOSED = 101;
		public const int OPOS_E_CLAIMED = 102;
		public const int OPOS_E_NOTCLAIMED = 103;
		public const int OPOS_E_NOSERVICE = 104;
		public const int OPOS_E_DISABLED = 105;
		public const int OPOS_E_ILLEGAL = 106;
		public const int OPOS_E_NOHARDWARE = 107;
		public const int OPOS_E_OFFLINE = 108;
		public const int OPOS_E_NOEXIST = 109;
		public const int OPOS_E_EXISTS = 110;
		public const int OPOS_E_FAILURE = 111;
		public const int OPOS_E_TIMEOUT = 112;
		public const int OPOS_E_BUSY = 113;
		public const int OPOS_E_EXTENDED = 114;
		public const int OPOSERR = 100; // Base for ResultCode errors.
		public const int OPOSERREXT = 200; // Base for ResultCodeExtendedErrors.
		public const int OPOS_OR_ALREADYOPEN = 301;
		public const int OPOS_OR_REGBADNAME = 302;
		public const int OPOS_OR_REGPROGID = 303;
		public const int OPOS_OR_CREATE = 304;
		public const int OPOS_OR_BADIF = 305;
		public const int OPOS_OR_FAILEDOPEN = 306;
		public const int OPOS_OR_BADVERSION = 307;
		public const int OPOS_ORS_NOPORT = 401;
		public const int OPOS_ORS_NOTSUPPORTED = 402;
		public const int OPOS_ORS_CONFIG = 403;
		public const int OPOS_ORS_SPECIFIC = 450;
		public const int OPOS_BC_NONE = 0;
		public const int OPOS_BC_NIBBLE = 1;
		public const int OPOS_BC_DECIMAL = 2;
		public const int OPOS_CH_INTERNAL = 1;
		public const int OPOS_CH_EXTERNAL = 2;
		public const int OPOS_CH_INTERACTIVE = 3;
		public const int OPOS_PR_NONE = 0;
		public const int OPOS_PR_STANDARD = 1;
		public const int OPOS_PR_ADVANCED = 2;
		public const int OPOS_PN_DISABLED = 0;
		public const int OPOS_PN_ENABLED = 1;
		public const int OPOS_PS_UNKNOWN = 2000;
		public const int OPOS_PS_ONLINE = 2001;
		public const int OPOS_PS_OFF = 2002;
		public const int OPOS_PS_OFFLINE = 2003;
		public const int OPOS_PS_OFF_OFFLINE = 2004;
		public const int OPOS_CFV_FIRMWARE_OLDER = 1;
		public const int OPOS_CFV_FIRMWARE_SAME = 2;
		public const int OPOS_CFV_FIRMWARE_NEWER = 3;
		public const int OPOS_CFV_FIRMWARE_DIFFERENT = 4;
		public const int OPOS_CFV_FIRMWARE_UNKNOWN = 5;
		public const int OPOS_EL_OUTPUT = 1;
		public const int OPOS_EL_INPUT = 2;
		public const int OPOS_EL_INPUT_DATA = 3;
		public const int OPOS_ER_RETRY = 11;
		public const int OPOS_ER_CLEAR = 12;
		public const int OPOS_ER_CONTINUEINPUT = 13;
		public const int OPOS_SUE_POWER_ONLINE = 2001; // (added in 1.3)
		public const int OPOS_SUE_POWER_OFF = 2002; // (added in 1.3)
		public const int OPOS_SUE_POWER_OFFLINE = 2003; // (added in 1.3)
		public const int OPOS_SUE_POWER_OFF_OFFLINE = 2004; // (added in 1.3)
		public const int OPOS_SUE_UF_PROGRESS = 2100; // (added in 1.9)
		public const int OPOS_SUE_UF_COMPLETE = 2200; // (added in 1.9)
		public const int OPOS_SUE_UF_COMPLETE_DEV_NOT_RESTORED = 2205; // (added in 1.9)
		public const int OPOS_SUE_UF_FAILED_DEV_OK = 2201; // (added in 1.9)
		public const int OPOS_SUE_UF_FAILED_DEV_UNRECOVERABLE = 2202; // (added in 1.9)
		public const int OPOS_SUE_UF_FAILED_DEV_NEEDS_FIRMWARE = 2203; // (added in 1.9)
		public const int OPOS_SUE_UF_FAILED_DEV_UNKNOWN = 2204; // (added in 1.9)
		public const int OPOS_FOREVER = -1; // (added in 1.2)
		// OPOSCASH.H
		public const int CASH_SUE_DRAWERCLOSED = 0;
		public const int CASH_SUE_DRAWEROPEN = 1;
		// OPOSPTR.H
		public const int PTR_S_JOURNAL = 1;
		public const int PTR_S_RECEIPT = 2;
		public const int PTR_S_SLIP = 4;
		public const int PTR_S_JOURNAL_RECEIPT = 0x0003;
		public const int PTR_S_JOURNAL_SLIP = 0x0005;
		public const int PTR_S_RECEIPT_SLIP = 0x0006;
		public const int PTR_TWO_RECEIPT_JOURNAL = 0x8003; // (added in 1.3)
		public const int PTR_TWO_SLIP_JOURNAL = 0x8005; // (added in 1.3)
		public const int PTR_TWO_SLIP_RECEIPT = 0x8006; // (added in 1.3)
		public const int PTR_CCS_ALPHA = 1;
		public const int PTR_CCS_ASCII = 998;
		public const int PTR_CCS_KANA = 10;
		public const int PTR_CCS_KANJI = 11;
		public const int PTR_CCS_UNICODE = 997; // (added in 1.5)
		public const int PTR_CS_UNICODE = 997; // (added in 1.5)
		public const int PTR_CS_ASCII = 998;
		public const int PTR_CS_WINDOWS = 999;
		public const int PTR_CS_ANSI = 999;
		public const int PTR_EL_NONE = 1;
		public const int PTR_EL_RECOVERABLE = 2;
		public const int PTR_EL_FATAL = 3;
		public const int PTR_MM_DOTS = 1;
		public const int PTR_MM_TWIPS = 2;
		public const int PTR_MM_ENGLISH = 3;
		public const int PTR_MM_METRIC = 4;
		public const long PTR_COLOR_PRIMARY = 0x00000001;
		public const long PTR_COLOR_CUSTOM1 = 0x00000002;
		public const long PTR_COLOR_CUSTOM2 = 0x00000004;
		public const long PTR_COLOR_CUSTOM3 = 0x00000008;
		public const long PTR_COLOR_CUSTOM4 = 0x00000010;
		public const long PTR_COLOR_CUSTOM5 = 0x00000020;
		public const long PTR_COLOR_CUSTOM6 = 0x00000040;
		public const long PTR_COLOR_CYAN = 0x00000100;
		public const long PTR_COLOR_MAGENTA = 0x00000200;
		public const long PTR_COLOR_YELLOW = 0x00000400;
		public const long PTR_COLOR_FULL = 0x80000000;
		public const long PTR_CART_UNKNOWN = 0x10000000;
		public const long PTR_CART_OK = 0x00000000;
		public const long PTR_CART_REMOVED = 0x00000001;
		public const long PTR_CART_EMPTY = 0x00000002;
		public const long PTR_CART_NEAREND = 0x00000004;
		public const long PTR_CART_CLEANING = 0x00000008;
		public const long PTR_CN_DISABLED = 0x00000000;
		public const long PTR_CN_ENABLED = 0x00000001;
		public const long PTR_PM_BITMAP = 0x00000001;
		public const long PTR_PM_BARCODE = 0x00000002;
		public const long PTR_PM_BM_ROTATE = 0x00000004;
		public const long PTR_PM_BC_ROTATE = 0x00000008;
		public const long PTR_PM_OPAQUE = 0x00000010;
		public const int PTR_PD_LEFT_TO_RIGHT = 1;
		public const int PTR_PD_BOTTOM_TO_TOP = 2;
		public const int PTR_PD_RIGHT_TO_LEFT = 3;
		public const int PTR_PD_TOP_TO_BOTTOM = 4;
		public const int PTR_CP_FULLCUT = 100;
		public const int PTR_PM_PAGE_MODE = 1;
		public const int PTR_PM_PRINT_SAVE = 2;
		public const int PTR_PM_NORMAL = 3;
		public const int PTR_PM_CANCEL = 4;
		public const int PTR_BC_LEFT = -1;
		public const int PTR_BC_CENTER = -2;
		public const int PTR_BC_RIGHT = -3;
		public const int PTR_BC_TEXT_NONE = -11;
		public const int PTR_BC_TEXT_ABOVE = -12;
		public const int PTR_BC_TEXT_BELOW = -13;
		public const int PTR_BCS_UPCA = 101;  // Digits
		public const int PTR_BCS_UPCE = 102;  // Digits
		public const int PTR_BCS_JAN8 = 103;  // = EAN 8
		public const int PTR_BCS_EAN8 = 103;  // = JAN 8 (added in 1.2)
		public const int PTR_BCS_JAN13 = 104;  // = EAN 13
		public const int PTR_BCS_EAN13 = 104;  // = JAN 13 (added in 1.2)
		public const int PTR_BCS_TF = 105;  // (Discrete 2 of 5) Digits
		public const int PTR_BCS_ITF = 106;  // (Interleaved 2 of 5) Digits
		public const int PTR_BCS_Codabar = 107;  // Digits, -, $, :, /, ., +;
		public const int PTR_BCS_Code39 = 108;  // Alpha, Digits, Space, -, .,
		public const int PTR_BCS_Code93 = 109;  // Same characters as Code 39
		public const int PTR_BCS_Code128 = 110;  // 128 data characters
		public const int PTR_BCS_UPCA_S = 111;  // UPC-A with supplemental
		public const int PTR_BCS_UPCE_S = 112;  // UPC-E with supplemental
		public const int PTR_BCS_UPCD1 = 113;  // UPC-D1
		public const int PTR_BCS_UPCD2 = 114;  // UPC-D2
		public const int PTR_BCS_UPCD3 = 115;  // UPC-D3
		public const int PTR_BCS_UPCD4 = 116;  // UPC-D4
		public const int PTR_BCS_UPCD5 = 117;  // UPC-D5
		public const int PTR_BCS_EAN8_S = 118;  // EAN 8 with supplemental
		public const int PTR_BCS_EAN13_S = 119;  // EAN 13 with supplemental
		public const int PTR_BCS_EAN128 = 120;  // EAN 128
		public const int PTR_BCS_OCRA = 121;  // OCR "A"
		public const int PTR_BCS_OCRB = 122;  // OCR "B"
		public const int PTR_BCS_Code128_Parsed = 123;  // Code 128 with parsing
		public const int PTR_BCS_RSS14 = 131;  // Reduced Space Symbology - 14 digit GTIN
		public const int PTR_BCS_RSS_EXPANDED = 132;  // RSS - 14 digit GTIN plus additional fields
		public const int PTR_BCS_PDF417 = 201;
		public const int PTR_BCS_MAXICODE = 202;
		public const int PTR_BCS_OTHER = 501;
		public const int PTR_BM_ASIS = -11;  // One pixel per printer dot
		public const int PTR_BM_LEFT = -1;
		public const int PTR_BM_CENTER = -2;
		public const int PTR_BM_RIGHT = -3;
		public const int PTR_RP_NORMAL = 0x0001;
		public const int PTR_RP_RIGHT90 = 0x0101;
		public const int PTR_RP_LEFT90 = 0x0102;
		public const int PTR_RP_ROTATE180 = 0x0103;
		public const int PTR_RP_BARCODE = 0x1000; // (added in 1.7)
		public const int PTR_RP_BITMAP = 0x2000; // (added in 1.7)
		public const int PTR_L_TOP = 1;
		public const int PTR_L_BOTTOM = 2;
		public const int PTR_TP_TRANSACTION = 11;
		public const int PTR_TP_NORMAL = 12;
		public const int PTR_MF_TO_TAKEUP = 1;
		public const int PTR_MF_TO_CUTTER = 2;
		public const int PTR_MF_TO_CURRENT_TOF = 4;
		public const int PTR_MF_TO_NEXT_TOF = 8;
		public const int PTR_PS_UNKNOWN = 0;
		public const int PTR_PS_SIDE1 = 1;
		public const int PTR_PS_SIDE2 = 2;
		public const int PTR_PS_OPPOSITE = 3;
		public const int PTR_SUE_COVER_OPEN = 11;
		public const int PTR_SUE_COVER_OK = 12;
		public const int PTR_SUE_JRN_COVER_OPEN = 60;  // (added in 1.8)
		public const int PTR_SUE_JRN_COVER_OK = 61;  // (added in 1.8)
		public const int PTR_SUE_REC_COVER_OPEN = 62;  // (added in 1.8)
		public const int PTR_SUE_REC_COVER_OK = 63;  // (added in 1.8)
		public const int PTR_SUE_SLP_COVER_OPEN = 64;  // (added in 1.8)
		public const int PTR_SUE_SLP_COVER_OK = 65;  // (added in 1.8)
		public const int PTR_SUE_JRN_EMPTY = 21;
		public const int PTR_SUE_JRN_NEAREMPTY = 22;
		public const int PTR_SUE_JRN_PAPEROK = 23;
		public const int PTR_SUE_REC_EMPTY = 24;
		public const int PTR_SUE_REC_NEAREMPTY = 25;
		public const int PTR_SUE_REC_PAPEROK = 26;
		public const int PTR_SUE_SLP_EMPTY = 27;
		public const int PTR_SUE_SLP_NEAREMPTY = 28;
		public const int PTR_SUE_SLP_PAPEROK = 29;
		public const int PTR_SUE_JRN_CARTRIDGE_EMPTY = 41; // (added in 1.5)
		public const int PTR_SUE_JRN_CARTRIDGE_NEAREMPTY = 42; // (added in 1.5)
		public const int PTR_SUE_JRN_HEAD_CLEANING = 43; // (added in 1.5)
		public const int PTR_SUE_JRN_CARTRIDGE_OK = 44; // (added in 1.5)
		public const int PTR_SUE_REC_CARTRIDGE_EMPTY = 45; // (added in 1.5)
		public const int PTR_SUE_REC_CARTRIDGE_NEAREMPTY = 46; // (added in 1.5)
		public const int PTR_SUE_REC_HEAD_CLEANING = 47; // (added in 1.5)
		public const int PTR_SUE_REC_CARTRIDGE_OK = 48; // (added in 1.5)
		public const int PTR_SUE_SLP_CARTRIDGE_EMPTY = 49; // (added in 1.5)
		public const int PTR_SUE_SLP_CARTRIDGE_NEAREMPTY = 50; // (added in 1.5)
		public const int PTR_SUE_SLP_HEAD_CLEANING = 51; // (added in 1.5)
		public const int PTR_SUE_SLP_CARTRIDGE_OK = 52; // (added in 1.5)
		public const int PTR_SUE_IDLE = 1001;
		public const int OPOS_EPTR_COVER_OPEN = 201; // (Several)
		public const int OPOS_EPTR_JRN_EMPTY = 202; // (Several)
		public const int OPOS_EPTR_REC_EMPTY = 203; // (Several)
		public const int OPOS_EPTR_SLP_EMPTY = 204; // (Several)
		public const int OPOS_EPTR_SLP_FORM = 205; // EndRemoval
		public const int OPOS_EPTR_TOOBIG = 206; // PrintBitmap
		public const int OPOS_EPTR_BADFORMAT = 207; // PrintBitmap
		public const int OPOS_EPTR_JRN_CARTRIDGE_REMOVED = 208; // (Several) (added in 1.5)
		public const int OPOS_EPTR_JRN_CARTRIDGE_EMPTY = 209; // (Several) (added in 1.5)
		public const int OPOS_EPTR_JRN_HEAD_CLEANING = 210; // (Several) (added in 1.5)
		public const int OPOS_EPTR_REC_CARTRIDGE_REMOVED = 211; // (Several) (added in 1.5)
		public const int OPOS_EPTR_REC_CARTRIDGE_EMPTY = 212; // (Several) (added in 1.5)
		public const int OPOS_EPTR_REC_HEAD_CLEANING = 213; // (Several) (added in 1.5)
		public const int OPOS_EPTR_SLP_CARTRIDGE_REMOVED = 214; // (Several) (added in 1.5)
		public const int OPOS_EPTR_SLP_CARTRIDGE_EMPTY = 215; // (Several) (added in 1.5)
		public const int OPOS_EPTR_SLP_HEAD_CLEANING = 216; // (Several) (added in 1.5)
		public enum DISP_DT {
			NORMAL = 0,
			BLINK = 1,
			REVERSE = 2,
			BLINK_REVERSE = 3
		}
		#endregion
		/// <summary>
		/// デバイスが有効かどうかをチェックする(関数実行の前に必ずやること！)
		/// </summary>
		/// <param name="lib"></param>
		/// <returns></returns>
		public static bool CheckOpos(OposLib lib) {
			if (lib != null) {
				return (lib.devUse && lib.devEnable && lib.CheckOpos());
			}
			return false;
		}
	}
	/// <summary>
	/// OPOS共通プロパティ、メソッドの定義
	/// </summary>
	public class OposLib:IDisposable {
		#region 共通定義されたOPOS.....
		public OposLib() {
			myType = null;
			myObj = null;
		}
		protected Type myType; // 自分のタイプ
		protected object myObj; // 自分のインスタンス
		private string _devName="";
		public string devName{	// オープンしたときのデバイス名
			get { return _devName; }
			set { _devName = value; }
		}
		/// <summary>
		/// このデバイスを使うかどうか(使う側でセットする)
		/// </summary>
		public bool devUse = false;
		/// <summary>
		/// 有効かどうか(Openしたときなどに自分の中でセットする)
		/// </summary>
		public bool devEnable = false;
		public OposLib(string progID) {
			myType = Type.GetTypeFromProgID(progID);
			if(myType!=null) myObj = Activator.CreateInstance(myType);
		}
		/// <summary>
		/// つかえるかどうか(nullでないか)
		/// </summary>
		/// <returns></returns>
		public bool CheckOpos() {
			return (myType != null && myObj != null);
		}
		/// <summary>
		/// Disposeメソッド
		/// </summary>
		public void Dispose() {
		}
		/// <summary>
		/// ActiveXの情報表示
		/// </summary>
		public void AboutBox() {
			myType.InvokeMember("AboutBox", BindingFlags.InvokeMethod, null, myObj, null);
		}

		/// <summary>
		/// カスタムコントロールを識別する文字列
		/// </summary>
		public string ControlObjectDescription {
			get {
				string str=(string)myType.InvokeMember("ControlObjectDescription",BindingFlags.GetProperty,
					null,myObj,null);
				return str;
			}
		}
		/// <summary>
		/// カスタムコントロールのバージョン番号
		/// </summary>
		public int ControlObjectVersion {
			get {
				int ret = (int)myType.InvokeMember("ControlObjectVersion", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
		}
		/// <summary>
		/// サービスオブジェクトを識別する文字列
		/// </summary>
		public string ServiceObjectDescription {
			get {
				string str = (string)myType.InvokeMember("ServiceObjectDescription", BindingFlags.GetProperty,
					null, myObj, null);
				return str;
			}
		}
		/// <summary>
		/// サービスオブジェクトのバージョン番号
		/// </summary>
		public int ServiceObjectVersion {
			get {
				int ret = (int)myType.InvokeMember("ServiceObjectVersion", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
		}
		/// <summary>
		/// デバイスの名称を表す文字列
		/// </summary>
		public string DeviceName {
			get {
				string str = (string)myType.InvokeMember("DeviceName", BindingFlags.GetProperty,
					null, myObj, null);
				return str;
			}
		}
		/// <summary>
		/// デバイスを識別する詳細な文字列
		/// </summary>
		public string DeviceDescription {
			get {
				string str = (string)myType.InvokeMember("DeviceDescription", BindingFlags.GetProperty,
					null, myObj, null);
				return str;
			}
		}
		/// <summary>
		/// エラーが発生した理由
		/// </summary>
		public int ResultCode {
			get {
				int ret = (int)myType.InvokeMember("ResultCode", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
		}
		/// <summary>
		/// ResultCode がOPOS_E_EXTENDED であった場合に、拡張エラーの識別子が入る
		/// </summary>
		public int ResultCodeExtended {
			get {
				int ret = (int)myType.InvokeMember("ResultCodeExtended", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
		}
		/// <summary>
		/// オープン失敗の詳細な理由 (APG1.5から)
		/// </summary>
		public int OpenResult {
			get {
				int ret = (int)myType.InvokeMember("OpenResult", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
		}
		/// <summary>
		/// Open処理
		/// </summary>
		/// <param name="deviceName"></param>
		/// <returns></returns>
		public int Open(string deviceName) {
			_devName = deviceName;
			int ret = (int)myType.InvokeMember("Open", BindingFlags.InvokeMethod,
				null, myObj, new object[]{deviceName});
			return ret;
		}
		/// <summary>
		/// Open処理
		/// </summary>
		/// <param name="deviceName"></param>
		/// <returns></returns>
		public int OpenTest(string deviceName) {
			_devName = deviceName;
			if (myType == null) MessageBox.Show("myTypeはnull"+" "+_devName);
			else MessageBox.Show("myTypeは" + myType.ToString() + " " + _devName);
			if (myObj == null) MessageBox.Show("myObjはnull");
			else MessageBox.Show("myObjは" + myObj.ToString());
			int ret = (int)myType.InvokeMember("Open", BindingFlags.InvokeMethod,
				null, myObj, new object[] { deviceName });
			return ret;
		}
		/// <summary>
		/// Close処理
		/// </summary>
		/// <returns></returns>
		public int Close() {
			int ret = (int)myType.InvokeMember("Close", BindingFlags.InvokeMethod,
				null, myObj, null);
			return ret;
		}
		/// <summary>
		/// 排他的なアクセス権取得
		/// </summary>
		/// <param name="timeout"></param>
		/// <returns></returns>
		public int ClaimDevice(int timeout) {
			int ret = (int)myType.InvokeMember("ClaimDevice", BindingFlags.InvokeMethod,
				null, myObj, new object[] { timeout });
			return ret;
		}
		/// <summary>
		/// アクセス権の解放
		/// </summary>
		/// <returns></returns>
		public int ReleaseDevice() {
			int ret = (int)myType.InvokeMember("ReleaseDevice", BindingFlags.InvokeMethod,
				null, myObj, null);
			return ret;
		}
		/// <summary>
		/// Claimeされてるかどうか
		/// </summary>
		public bool Claimed {
			get {
				bool ret = (bool)myType.InvokeMember("Claimed", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
			set {
				myType.InvokeMember("Claimed", BindingFlags.SetProperty,
					null, myObj, new object[]{value});
			}
		}
		/// <summary>
		/// Enabledかどうか
		/// </summary>
		public bool DeviceEnabled {
			get {
				bool ret = (bool)myType.InvokeMember("DeviceEnabled", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
			set {
				myType.InvokeMember("DeviceEnabled", BindingFlags.SetProperty,
					null, myObj, new object[] { value });
			}
		}
		/// <summary>
		/// まとめてオープン
		/// </summary>
		/// <param name="deviceName"></param>
		/// <returns></returns>
		public int DeviceStart(string deviceName) {
			int ret=-998;
			try {
				ret = Open(deviceName);
				if (ret == 0) {
					ret = ClaimDevice(1000);
					if (ret == 0) {
						DeviceEnabled = devEnable = true;
					}
				}
			}
			catch (Exception ex) {
				System.Diagnostics.Debug.WriteLine(ex.Message);
				return ret;
			}
			return 0;

		}
		/// <summary>
		/// まとめてクローズ
		/// </summary>
		/// <returns></returns>
		public int DeviceEnd() {
			DeviceEnabled = devEnable = false;
			ReleaseDevice();
			return Close();
		}
		#endregion
	}
	public class StatusUpdateEventArgs : EventArgs {
		public int data;
	}
	/// <summary>
	/// OPOSドロア
	/// </summary>
	public class OposDrawer : OposLib {
		public OposDrawer()
			: base("OPOS.CashDrawer") {
		}
		/// <summary>
		/// ドロアのオープン
		/// </summary>
		/// <returns></returns>
		public int OpenDrawer() {
			if (!devUse || !devEnable) return 0;
			int ret = (int)myType.InvokeMember("OpenDrawer", BindingFlags.InvokeMethod,
				null, myObj, null);
			return ret;
		}
		/// <summary>
		/// ドロアがオープンしてるかどうか
		/// </summary>
		public bool DrawerOpened {
			get {
				if (!devUse || !devEnable) return false;
				bool ret = (bool)myType.InvokeMember("DrawerOpened", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
		}
	}
	/// <summary>
	/// OPOSラインディスプレイ
	/// </summary>
	public class OposDisplay : OposLib {
		public OposDisplay()
			: base("OPOS.LineDisplay") {
		}
		/// <summary>
		/// 表示のクリア
		/// </summary>
		/// <returns></returns>
		public int ClearText() {
			if (!devUse || !devEnable) return 0;
			int ret = (int)myType.InvokeMember("ClearText", BindingFlags.InvokeMethod,
				null, myObj, null);
			return ret;
		}
		/// <summary>
		/// 表示
		/// </summary>
		/// <returns></returns>
		public int DisplayDisp(string disp0,string disp1, OPos.DISP_DT attr) {
			if (!devUse || !devEnable) return 0;
			int ret = ClearText();
			ret = DisplayTextAt(0, 0, disp0, (int)attr);
			ret = DisplayTextAt(1, 0, disp1, (int)attr);
			return ret;
		}
		/// <summary>
		/// 表示
		/// </summary>
		/// <returns></returns>
		public int DisplayTextAt(int Row, int Column, string data, int attr) {
			if (!devUse || !devEnable) return 0;
			int ret = (int)myType.InvokeMember("DisplayTextAt", BindingFlags.InvokeMethod,
				null, myObj, new object[] { Row, Column, data, attr });
			return ret;
		}
		/// <summary>
		/// LineDisplayデバイスの行数
		/// </summary>
		public int DeviceRows {
			get {
				if (!devUse || !devEnable) return 0;
				int ret = (int)myType.InvokeMember("DeviceRows", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
		}
		/// <summary>
		/// LineDisplayデバイスの列数
		/// </summary>
		public int DeviceColmuns {
			get {
				if (!devUse || !devEnable) return 0;
				int ret = (int)myType.InvokeMember("DeviceColmuns", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
		}
		/// <summary>
		/// LineDisplayデバイスのWindow数
		/// </summary>
		public int DeviceWindows {
			get {
				if (!devUse || !devEnable) return 0;
				int ret = (int)myType.InvokeMember("DeviceWindows", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
		}
	}
	/// <summary>
	/// OPOSプリンタ
	/// </summary>
	public class OposPrinter : OposLib {
		public OposPrinter()
			: base("OPOS.POSPrinter") {
		}
		private System.Text.StringBuilder _printBuffer = new System.Text.StringBuilder(1024);
		public string PrintBuffer { // 印刷バッファ
			get { return _printBuffer.ToString(); }
		}
		/// <summary>
		/// RotateSpecialの値
		/// </summary>
		public int RotateSpecial {
			get {
				if (!devUse || !devEnable) return 0;
				int ret = (int)myType.InvokeMember("RotateSpecial", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
			set {
				myType.InvokeMember("RotateSpecial", BindingFlags.SetProperty,
					null, myObj, new object[] { value });
			}
		}
		/// <summary>
		/// プリンタへの印字
		/// </summary>
		/// <param name="station"></param>
		/// <param name="data"></param>
		/// <returns></returns>
		public int PrintNormal(string data) {
			if (!devUse || !devEnable) {
				_printBuffer.Append(data);
				return 0;
			}
			int station = OPos.PTR_S_RECEIPT;
			int ret = (int)myType.InvokeMember("PrintNormal", BindingFlags.InvokeMethod,
				null, myObj, new object[] { station,data });
			return ret;
		}
		/// <summary>
		/// プリンタへの印字
		/// </summary>
		/// <param name="format"></param>
		/// <param name="args"></param>
		/// <returns></returns>
		public int PrintNormal(string format, params object[] args) {
			return PrintNormal(string.Format(format, args));
		}
		/// <summary>
		/// 印字方向
		/// </summary>
		/// <param name="rotation">PTR_RP_NORMAL,PTR_RP_RIGHT90など</param>
		/// <returns></returns>
		public int PrintRotate(int rotation) {
			if (!devUse || !devEnable) return 0;
			int station = OPos.PTR_S_RECEIPT;
			int ret = (int)myType.InvokeMember("RotatePrint", BindingFlags.InvokeMethod,
				null, myObj, new object[] { station,rotation });
			return ret;
		}
		/// <summary>
		/// 、ビットマップの高精細モードと高速モード
		/// </summary>
		public bool RecLetterQuality {
			get {
				if (!devUse || !devEnable) return false;
				bool ret = (bool)myType.InvokeMember("RecLetterQuality", BindingFlags.GetProperty,
					null, myObj, null);
				return ret;
			}
			set {
				myType.InvokeMember("RecLetterQuality", BindingFlags.SetProperty,
					null, myObj, new object[] { value });
			}
		}
		/// <summary>
		/// バーコード印刷
		/// </summary>
		/// <param name="rotation">PTR_RP_NORMAL,PTR_RP_RIGHT90など</param>
		/// <param name="data">495462406082など</param>
		/// <param name="symbology">PTR_BCS_UPCAなど</param>
		/// <param name="height">100など</param>
		/// <param name="width">150など</param>
		/// <param name="alignment">PTR_BC_CENTERなど</param>
		/// <param name="textPosition">PTR_BC_TEXT_BELOWなど</param>
		/// <returns></returns>
		public int PrintBarCode(int rotate, string data, int symbology, int height, int width, int alignment, int textPosition) {
			if (!devUse || !devEnable) {
				_printBuffer.Append("<bar:" + data + ":>\n");
				return 0;
			}
			int station = OPos.PTR_S_RECEIPT;
			RotateSpecial = rotate;
			int ret = (int)myType.InvokeMember("PrintBarCode", BindingFlags.InvokeMethod,
				null, myObj, new object[] { station,data,symbology,height,width,alignment,textPosition });
			return ret;
		}
		/// <summary>
		/// ペーパーカット
		/// </summary>
		/// <param name="feed">Feedあり/なし</param>
		/// <returns></returns>
		public int PrintCutPaper(bool feed) {
			if (!devUse || !devEnable) return 0;
			if (feed) PrintNormal("\n\n\n\n\n");
			int ret = (int)myType.InvokeMember("CutPaper", BindingFlags.InvokeMethod,
				null, myObj, new object[] { 90 });
			return ret;
		}
		/// <summary>
		/// トランザクションモードの指定(指定したほうが速く印字される)
		/// </summary>
		/// <param name="control">PTR_TP_TRANSACTIONで開始、PTR_TP_NORMALで一括印字</param>
		/// <returns></returns>
		public int PrintTransaction(int control,Form owner) {
			if (!devUse || !devEnable) {
				if (control == OPos.PTR_TP_TRANSACTION) _printBuffer = new System.Text.StringBuilder(1024);
				else if(control== OPos.PTR_TP_NORMAL) {
				}
				return 0;
			}
			int station = OPos.PTR_S_RECEIPT;
			int ret = (int)myType.InvokeMember("TransactionPrint", BindingFlags.InvokeMethod,
				null, myObj, new object[] { station,control });
			return ret;
		}
		/// <summary>
		/// Bitmapの印字
		/// </summary>
		/// <returns></returns>
		public int PrintBitmap(string fileName, int width, int alignment) {
			if (!devUse || !devEnable) return 0;
			if (fileName == null || fileName == "") return 0;
			if (!System.IO.File.Exists(fileName)) return 0;
			int station = OPos.PTR_S_RECEIPT;
			System.Drawing.Bitmap bmp = new System.Drawing.Bitmap(fileName);
			if (bmp.Width < width) width = bmp.Width;
			bmp.Dispose();
			int ret = (int)myType.InvokeMember("PrintBitmap", BindingFlags.InvokeMethod,
				null, myObj, new object[] { station, fileName, width, alignment });
			return ret;
		}
	}
}
