﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using OLEPOS;

/*
 * This source code Licence : MIT Licence
 * first written by Sekiya Sato. (Tokyo,Japan)
 
Copyright 2008 Sekiya Sato All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 */
namespace WindowsForms01 {
	public partial class Form1 : Form {
		public Form1() {
			InitializeComponent();
		}
		private void Form1_Load(object sender, EventArgs e) {
		}
		OposDrawer odrawer = null;
		OposDisplay odisplay = null;
		OposPrinter oprinter = null;
		private void button1_Click(object sender, EventArgs e) {
			if(odrawer==null) odrawer = new OposDrawer();
			odrawer.AboutBox();
		}

		private void button2_Click(object sender, EventArgs e) {
			if(odisplay==null) odisplay= new OposDisplay();
			odisplay.AboutBox();
		}

		private void button3_Click(object sender, EventArgs e) {
			if (oprinter == null) oprinter = new OposPrinter();
			oprinter.AboutBox();
		}

		private void button4_Click(object sender, EventArgs e) {
			if (odrawer == null) odrawer = new OposDrawer();
			odrawer.devUse = true;
			odrawer.DeviceStart("unit1"); // いっぺんに初期化
			odrawer.OpenDrawer();
			odrawer.DeviceEnd();
		}

		private void button5_Click(object sender, EventArgs e) {
			if (odisplay == null) odisplay = new OposDisplay();
			odisplay.devUse = true;
			odisplay.DeviceStart("unit2"); // Epson ADKの場合、論理デバイス名
			odisplay.DisplayDisp(textBox1.Text, textBox2.Text, OPos.DISP_DT.NORMAL);
			odisplay.DeviceEnd();
		}

		private void button6_Click(object sender, EventArgs e) {
			if (oprinter == null) oprinter = new OposPrinter();
			oprinter.devUse = true;
			oprinter.DeviceStart("unit1"); // Epson ADKの場合、論理デバイス名
			oprinter.PrintNormal(textBox3.Text+"\n");
			oprinter.PrintCutPaper(true);
			oprinter.DeviceEnd();
		}

		private void button7_Click(object sender, EventArgs e) {
			if (oprinter == null) oprinter = new OposPrinter();
			oprinter.devUse = true;
			oprinter.DeviceStart("unit1"); // Epson ADKの場合、論理デバイス名
			oprinter.PrintBarCode(0,textBox4.Text,OPos.PTR_BCS_EAN13,100,150,OPos.PTR_BC_CENTER,OPos.PTR_BC_TEXT_BELOW);
			oprinter.PrintNormal(" " + OPos.ESC + "|2C【テスト印字】\n");
			oprinter.PrintNormal(OPos.ESC + "|4C" + OPos.ESC + "|bC" + OPos.ESC + "|rvC" + "４ 倍 印 字");
			oprinter.PrintNormal(" " + OPos.EscUnderLine + "サイン欄                 \n");
			oprinter.PrintCutPaper(true);
			oprinter.DeviceEnd();
		}

	}
}
