<?php
///////////////////////////////////////////////////////////////////////////////////////
// opencart1.4.2【日本語版】
// opencart.jp
// remise.php。
// ver 1.0.0 Coding By sae 2010/03/20 seagreenzzz@gmail.com
// GPL ver 3
///////////////////////////////////////////////////////////////////////////////////////
class ControllerPaymentRemise extends Controller{
	//エラーの文言を格納
	private $error = array();

	public function index(){
		//初期にペイクイックのテーブルが存在しない場合には作成する
		$sql = 'SHOW TABLES';

		$result = $this->db->query($sql);

		$check = FALSE;

		foreach($result->rows as $key => $value){
			//SHOW TABLESの場合は、以下のようなカラム名で値が戻る
			if($value['Tables_in_' . DB_DATABASE] == DB_PREFIX . 'remise_payquick'){

				$check = TRUE;

				break;
			}

		}
		//テーブルが存在しない場合は
		if(!$check){
			//テーブル作成のクエリ
			$sql = 'CREATE TABLE `' . DB_PREFIX . 'remise_payquick` (`remise_id` INT(11) NOT NULL AUTO_INCREMENT, `customer_id` INT(11) NOT NULL, `payquick_id` VARCHAR(20) NOT NULL, PRIMARY KEY (`remise_id`)) ENGINE = MyISAM';
			//テーブル作成
			$this->db->query($sql);

		}

		//言語ファイルの読み込み
		$this->load->language('payment/remise');
		//タイトル
		$this->document->title = $this->language->get('heading_title');

		$this->load->model('setting/setting');

		//入力内容が正しい場合
		if( ($this->request->server['REQUEST_METHOD'] == 'POST' ) && ( $this->validate() ) ){
			//モデルの読み込み
			$this->load->model('setting/setting');
			//データベースに入内容を登録
			$this->model_setting_setting->editSetting('remis', $this->request->post );
			//登録が正しくされたことを変数に代入
			$this->session->data['success'] = $this->language->get('text_success');
			//初期のリストページにリダイレクト
			$this->redirect(HTTPS_SERVER . 'index.php?route=extension/payment');

		}//if-end

		//ＨＴＭＬの内容部分のテキスト
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');

		$this->data['text_disabled'] = $this->language->get('text_disabled');

		$this->data['text_virtual'] = $this->language->get('text_virtual');

		$this->data['text_sale'] = $this->language->get('text_sale');

		$this->data['text_result_url'] = $this->language->get('text_result_url');

		//ＨＴＭＬの項目部分
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');

		$this->data['entry_use_price'] = $this->language->get('entry_use_price');

		$this->data['entry_title'] = $this->language->get('entry_title');

		$this->data['entry_store_code'] = $this->language->get('entry_store_code');

		$this->data['entry_host_no'] = $this->language->get('entry_host_no');

		$this->data['entry_product_code'] = $this->language->get('entry_product_code');

		$this->data['entry_payquick'] = $this->language->get('entry_payquick');

		$this->data['entry_url_pc'] = $this->language->get('entry_url_pc');

		$this->data['entry_url_mob'] = $this->language->get('entry_url_mob');

		$this->data['entry_order_status'] = $this->language->get('entry_order_status');

		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');

		$this->data['entry_status'] = $this->language->get('entry_status');

		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		//ボタン
		$this->data['button_save'] = $this->language->get('button_save');

		$this->data['button_cancel'] = $this->language->get('button_cancel');

		//すでに入力した場合の値の保持（ＤＢにある場合はそれを・・・POSTされてある場合は、それを優先）
		if (isset($this->request->post['remise_use_price'])) {
			$this->data['remise_use_price'] = $this->request->post['remise_use_price'];
		} else {
			$this->data['remise_use_price'] = $this->config->get('remise_use_price');
		}

		if (isset($this->request->post['remise_title'])) {
			$this->data['remise_title'] = $this->request->post['remise_title'];
		} else {
			$this->data['remise_title'] = $this->config->get('remise_title');
		}

		if (isset($this->request->post['remise_store_code'])) {
			$this->data['remise_store_code'] = $this->request->post['remise_store_code'];
		} else {
			$this->data['remise_store_code'] = $this->config->get('remise_store_code');
		}

		if (isset($this->request->post['remise_host_no'])) {
			$this->data['remse_host_no'] = $this->request->post['remise_host_no'];
		} else {
			$this->data['remise_host_no'] = $this->config->get('remise_host_no');
		}

		if (isset($this->request->post['remise_product_code'])) {
			$this->data['remise_product_code'] = $this->request->post['remise_product_code'];
		} else {
			$this->data['remise_product_code'] = $this->config->get('remise_product_code');
		}

		if (isset($this->request->post['remise_payquick'])) {
			$this->data['remise_payquick'] = $this->request->post['remise_payquick'];
		} else {
			$this->data['remise_payquick'] = $this->config->get('remise_payquick');
		}

		if (isset($this->request->post['remise_url_pc'])) {
			$this->data['remise_url_pc'] = $this->request->post['remise_url_pc'];
		} else {
			$this->data['remise_url_pc'] = $this->config->get('remise_url_pc');
		}

		if (isset($this->request->post['remise_url_mob'])) {
			$this->data['remise_url_mob'] = $this->request->post['remise_url_mob'];
		} else {
			$this->data['remise_url_mob'] = $this->config->get('remise_url_mob');
		}

		//モデルのロード
		$this->load->model('localisation/order_status');
		//現在登録されているオーダーステータスを取得する
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['remise_order_status_id'])) {
			$this->data['remise_order_status_id'] = $this->request->post['remise_order_status_id'];
		} else {
			$this->data['remise_order_status_id'] = $this->config->get('remise_order_status_id');
		}
		//モデルのロード
		$this->load->model('localisation/geo_zone');
		//ジオゾーンを取得
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['remise_geo_zone'])) {
			$this->data['remise_geo_zone_id'] = $this->request->post['remise_geo_zone_id'];
		} else {
			$this->data['remise_geo_zone_id'] = $this->config->get('remise_geo_zone_id');
		}

		if (isset($this->request->post['remise_status'])) {
			$this->data['remise_status'] = $this->request->post['remise_status'];
		} else {
			$this->data['remise_status'] = $this->config->get('remise_status');
		}

		if (isset($this->request->post['remise_sort_order'])) {
			$this->data['remise_sort_order'] = $this->request->post['remise_sort_order'];
		} else {
			$this->data['remise_sort_order'] = $this->config->get('remise_sort_order');
		}

		//パンくず作成
		$this->document->breadcrumbs = array();
		//ホーム
   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home',
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);
		//支払方法設定
   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=extension/payment',
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);
		//ルミーズＥＣ決済サービスページ
   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=payment/remise',
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

   		//登録の場合のアクションＵＲＬ（ボタンに必要）
		$this->data['action'] = HTTPS_SERVER . 'index.php?route=payment/remise';
		//キャンセルの場合のアクションＵＲＬ
		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=extension/payment';

		//エラーの文言の処理
		if( isset($this->error['warning']) ){
			$this->data['error_warning'] = $this->error['warning'];
		}else{
			$this->data['error_warning'] = '';
		}

		if( isset($this->error['title']) ){
			$this->data['error_title'] = $this->error['title'];
		}else{
			$this->data['error_title'] = '';
		}

		if( isset($this->error['store_code']) ){
			$this->data['error_store_code'] = $this->error['store_code'];
		}else{
			$this->data['error_store_code'] = '';
		}

		if( isset($this->error['host_no']) ){
			$this->data['error_host_no'] = $this->error['host_no'];
		}else{
			$this->data['error_host_no'] = '';
		}

		if( isset($this->error['url_pc']) ){
			$this->data['error_url_pc'] = $this->error['url_pc'];
		}else{
			$this->data['error_url_pc'] = '';
		}

		if( isset($this->error['url_mob']) ){
			$this->data['error_url_mob'] = $this->error['url_mob'];
		}else{
			$this->data['error_url_mob'] = '';
		}

		//画面への出力
		$this->template = 'payment/remise.tpl';

		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));

	}//function-end

//入力値のバリデート
	private function validate(){

		if(!$this->user->hasPermission('modify', 'payment/remise')){
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if(!$this->request->post['remise_title']){
			$this->error['title'] = $this->language->get('error_title');
		}

		if(!$this->request->post['remise_store_code']){
			$this->error['store_code'] = $this->language->get('error_store_code');
		}

		if(!$this->request->post['remise_host_no']){
			$this->error['host_no'] = $this->language->get('error_host_no');
		}

		if(!$this->request->post['remise_url_pc']){
			$this->error['url_pc'] = $this->language->get('error_url_pc');
		}

		if(!$this->request->post['remise_url_mob']){
			$this->error['url_mob'] = $this->language->get('error_url_mob');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}

	}//function-end

}//class-end
?>