<?php
class ControllerStep2 extends Controller {
	private $error = array();

	public function index() {
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->redirect(HTTP_SERVER . 'index.php?route=step_3');
		}

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		$this->data['action'] = HTTP_SERVER . 'index.php?route=step_2';

		$this->data['config_catalog'] = DIR_OPENCART . 'config.php';
		$this->data['config_admin'] = DIR_OPENCART . 'admin/config.php';

		$this->data['cache'] = DIR_SYSTEM . 'cache';
		$this->data['logs'] = DIR_SYSTEM . 'logs';
		$this->data['image'] = DIR_OPENCART . 'image';
		$this->data['image_cache'] = DIR_OPENCART . 'image/cache';
		$this->data['image_data'] = DIR_OPENCART . 'image/data';
		$this->data['download'] = DIR_OPENCART . 'download';
///////////////////////////////////////////////////////////////////////////////////////////
//opencart【日本語版】  ユーザー権限でアパッチが動作していないサーバーに対応
///////////////////////////////////////////////////////////////////////////////////////////
		$this->data['image_cache_data'] = DIR_OPENCART . 'image/cache/data';

		$this->children = array(
			'header',
			'footer'
		);

		$this->template = 'step_2.tpl';

		$this->response->setOutput($this->render(TRUE));
	}

	private function validate() {
		if (phpversion() < '5.0') {
			$this->error['warning'] = '警告:OpenCarではPHP5以上がインストールの条件となります。PHPバージョン5以上がインストールされたサーバーを使用してください!';
		}

		if (!ini_get('file_uploads')) {
			$this->error['warning'] = '警告: PHP.iniでの設定で file_uploads が有効になっていません。有効にしてください!';
		}

		if (ini_get('session.auto_start')) {
			$this->error['warning'] = '警告: PHP.iniでの設定で session.auto_start が有効になっていません。有効にしてください!';
		}

		if (!extension_loaded('mysql')) {
			$this->error['warning'] = '警告: MySQL 拡張機能が使用できません。使用できるサーバーにインストールしてください。通常のレンタルサーバーなどでは普通に使用できます!';
		}

		if (!extension_loaded('gd')) {
			$this->error['warning'] = '警告: GD 拡張機能が使用できません。使用できるサーバーにインストールしてください。通常のレンタルサーバーなどでは普通に使用できます!';
		}

		if (!extension_loaded('zlib')) {
			$this->error['warning'] = '警告: ZLIB 拡張機能が使用できません。使用できるサーバーにインストールしてください。通常のレンタルサーバーなどでは普通に使用できます!';
		}

		if (!is_writable(DIR_OPENCART . 'config.php')) {
			$this->error['warning'] = '警告: config.php ?ディレクトリ（フォルダ）が書き込み可能な状態ではありません。パーミッション（属性）の変更で777にしてください!';
		}

		if (!is_writable(DIR_OPENCART . 'admin/config.php')) {
			$this->error['warning'] = '警告: ディレクトリ（フォルダ）が書き込み可能な状態ではありません。パーミッション（属性）の変更で777にしてください!';
		}

		if (!is_writable(DIR_SYSTEM . 'cache')) {
			$this->error['warning'] = '警告: cache ディレクトリ（フォルダ）が書き込み可能な状態ではありません。パーミッション（属性）の変更で777にしてください!';
		}

		if (!is_writable(DIR_SYSTEM . 'logs')) {
			$this->error['warning'] = '警告: logs ディレクトリ（フォルダ）が書き込み可能な状態ではありません。パーミッション（属性）の変更で777にしてください!';
		}

		if (!is_writable(DIR_OPENCART . 'image')) {
			$this->error['warning'] = '警告: image ディレクトリ（フォルダ）が書き込み可能な状態ではありません。パーミッション（属性）の変更で777にしてください!';
		}

		if (!is_writable(DIR_OPENCART . 'image/cache')) {
			$this->error['warning'] = '警告: image/cache ディレクトリ（フォルダ）が書き込み可能な状態ではありません。パーミッション（属性）の変更で777にしてください!';
		}
		///////////////////////////////////////////////////////////////////////////////////////////
		//opencart【日本語版】  ユーザー権限でアパッチが動作していないサーバーに対応
		///////////////////////////////////////////////////////////////////////////////////////////
		if (!is_writable(DIR_OPENCART . 'image/cache/data')) {
			$this->error['warning'] = '警告: image/cache/data ディレクトリ（フォルダ）が書き込み可能な状態ではありません。パーミッション（属性）の変更で777にしてください!';
		}


		if (!is_writable(DIR_OPENCART . 'image/data')) {
			$this->error['warning'] = '警告: image/data ディレクトリ（フォルダ）が書き込み可能な状態ではありません。パーミッション（属性）の変更で777にしてください!';
		}

		if (!is_writable(DIR_OPENCART . 'download')) {
			$this->error['warning'] = '警告: download ディレクトリ（フォルダ）が書き込み可能な状態ではありません。パーミッション（属性）の変更で777にしてください!';
		}

    	if (!$this->error) {
      		return TRUE;
    	} else {
      		return FALSE;
    	}
	}
}
?>