<?php
///////////////////////////////////////////////////////////////////////////////////////
// opencart1.4.0【日本語版】
// opencart.jp
// sagawa.php
// このファイルは、佐川急便の配送モジュールです(model)。
// ver 1.0.0 Coding By sae seagreenzzz@gmail.com
// GPL ver 3
///////////////////////////////////////////////////////////////////////////////////////
//クラス名はキャメルで書きます。
class ModelShippingSagawa extends Model {

	public function getQuote($address) {
		//このモジュールのlanguageファイルをロードします。
		$this->load->language('shipping/sagawa');

		$error = '';

		//このモジュールの設定をデータベースより読み込みます。settingテーブルです。ステータスが有効ならば
		if ($this->config->get('sagawa_status') && (int)$address['country_id'] == 107 ) {

			$zone = (int)$address['zone_id'];

			$main_price = $this->config->get('sagawa_price');

			switch( $main_price ){

				case 'di':
					//北海道
					$zone_array['ho_p'] = array( '1657' );
					//東北
					$zone_array['to_p'] = array( '1658', '1659', '1660', '1661', '1662', '1663' );
					//関東
					$zone_array['ka_p'] = array( '1664', '1665', '1666', '1667', '1668', '1669', '1670', '1672' );
					//信越
					$zone_array['shi_p'] = array( '1671', '1673' );
					//北陸
					$zone_array['hoku_p'] = array( '1674', '1675', '1676' );
					//東海
					$zone_array['tou_p'] = array( '1677', '1678', '1679', '1680' );
					//近畿
					$zone_array['ki_p'] = array( '1681', '1682', '1683', '1684', '1685', '1686' );
					//中国
					$zone_array['chu_p'] = array( '1687', '1688', '1689', '1690', '1691' );
					//四国
					$zone_array['shiko_p'] = array( '1692', '1693', '1694', '1695' );
					//九州
					$zone_array['kyu_p'] = array( '1696', '1697', '1698', '1699', '1700', '1701', '1702' );
					//沖縄
					$zone_array['oki_p'] = array( '1703' );

					foreach( $zone_array as $key => $val ){

						foreach( $zone_array[$key] as $zone_id ){

							if( $zone_id == $zone ){

								$price_key = $key;

								break;

							}//if-end

						}//foreach-end

					}//foreach-end

					$subtotal = (int)$this->cart->getSubTotal();

					$sagawa_setting = $this->getSetting('sagawa');

					if( $sagawa_setting[ $price_key . '_free'] <= $subtotal){

						$cost = 0;

					}else{

						$cost = $sagawa_setting[$price_key];

					}

					$cost_text = $this->currency->format( $cost );

					$quote_data['sagawa'] = array(
								'id'           => 'sagawa.sagawa',
								'title'        => $this->language->get('text_title'),
								'cost'         => $cost,
								'tax_class_id' => 0,
								'text'         => $cost_text
							);
					break;

				case 'ev':

					$subtotal = (int)$this->cart->getSubTotal();

					if( $this->config->get('sagawa_evenly_free') <= $subtotal){

						$cost = 0;

					}else{

						$cost = (int)$this->config->get('sagawa_evenly');

					}

					$cost_text = $this->currency->format( $cost );

					$quote_data['sagawa'] = array(
								'id'           => 'sagawa.sagawa',
								'title'        => $this->language->get('text_title'),
								'cost'         => $cost,
								'tax_class_id' => 0,
								'text'         => $cost_text
							);
					break;

				case 'pu':

					$cost_quote_array = explode( ',', $this->config->get('sagawa_evenly') );

					$cost_count = count( $cost_quote_array );

					for( $i = 0; $i < $cost_cunt; $i++ ){

						$price_array[] = explode( ':', $cost_quote_array );

					}//for-end

					$price_count = count( $price_array );

					$subtotal = $this->cart->getSubTotal();

					for( $i = 0; $i < $price_count; $i++ ){

						if( $price_array[$i][0] <= $subTotal && $price_array[$i][1] > $subtotal ){

							$cost_quote = $price_array[$i][2];

							break;

						}//if-end

					}//for-end

					$cost = (int)$cost_quote;

					$cost_text = $this->currency->format( $cost );

					$quote_data['sagawa'] = array(
								'id'           => 'sagawa.sagawa',
								'title'        => $this->language->get('text_title'),
								'cost'         => $cost,
								'tax_class_id' => 0,
								'text'         => $cost_text
							);
					break;

			}//switch-end


			$select_time_array = explode( "\n", $this->config->get('sagawa_time') );

			$select_time_str = '<script type="text/javascript">' . "\n"
				 . 'function showInputSagawa(form){

					 if( form.sagawa_stop.selectedIndex == 0 ){

						 $("#stopSagawa").show("fast");

					 }else{

						$("#stopSagawa").hide("fast");

					 }

				   }

	</script>' . "\n";

			$select_time_str .= '&nbsp;&nbsp;配達指定&nbsp;<select style="font-weight:normal" name ="sagawa_stop" onchange="showInputSagawa(this.form)">' . "\n";
			//郵便局留めの場合
			if( $this->config->get('sagawa_stop') ){



				$select_time_str .= '<option value="0">営業所留め</option>' . "\n";

				$post_stop = '<div id="stopSagawa" style="float:right">営業所名を記載してください<input type="text" name="stop" /><br /><a href="http://www.sagawa-exp.co.jp/search/branch_search/" target="_blank" style="text-decoration:underline; color:#FF0000;">営業所を探す</a></div>';

			}else{

				$post_stop = '';

			}

			if( is_array($select_time_array) ){

				foreach( $select_time_array as $value ){

					if( !empty($value) ){

						$select_time_str .= '<option>' . $value . '</option>' . "\n";

					}//if-end

				}//foreach-end

			}//if-end


			$select_time_str .= '</select>' . $post_stop;

			$sagawa_time = trim( $this->config->get('japan_post_time') );


			if( empty($sagawa_time) ) {

				$select_time_str = '';

			}

			if( (int)$address['country_id'] !== 107 ){

					$error = 'ゆうパックは日本国内以外では使用できません。';

			}

				$method_data = array(
						'id'         => 'sagawa',
						'title'      => $this->language->get('text_title') . $select_time_str,
						'quote'      => $quote_data,
						'sort_order' => $this->config->get('sagawa_sort_order'),
						'error'      => $error
					);

			}else{

				$status = FALSE;

				$method_data = array();

				$quote_data = array();

			}

		return $method_data;

	}//function-end

	private  function getSetting($group) {
		$data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "setting WHERE `group` = '" . $this->db->escape($group) . "'");

		foreach ($query->rows as $result) {
			$data[$result['key']] = $result['value'];
		}

		return $data;
	}

}//class-end

?>