<?php
///////////////////////////////////////////////////////////////////////////////////////
// opencart1.4.2【日本語版】
// opencart.jp
// rakuten_easy.php。Controller Admin
// ver 1.0.0 Coding By sae 2010/10/25 seagreenzzz@gmail.com
// GPL ver 3
///////////////////////////////////////////////////////////////////////////////////////
class ControllerPaymentRakutenEasy extends Controller{

	private $error = array();

	public function index(){

		//入力内容が正しい場合
		if( ($this->request->server['REQUEST_METHOD'] == 'POST' ) && ( $this->validate() ) ){
			//モデルの読み込み
			$this->load->model('setting/setting');
			//データベースに入内容を登録
			$this->model_setting_setting->editSetting('rakuten_easy', $this->request->post );
			//登録が正しくされたことを変数に代入
			$this->session->data['success'] = $this->language->get('text_success');
			//初期のリストページにリダイレクト
			$this->redirect(HTTPS_SERVER . 'index.php?route=extension/payment');

		}//if-end

		$this->load->language('payment/rakuten_easy');

		$this->document->title = $this->language->get('heading_title');

		$this->load->model('setting/setting');

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');

		$this->data['text_disabled'] = $this->language->get('text_disabled');

		$this->data['text_all_zones'] = $this->language->get('text_all_zones');

		$this->data['text_send_url'] = $this->language->get('text_send_url');

		$this->data['entry_title'] = $this->language->get('entry_title');

		$this->data['entry_send_url'] = $this->language->get('entry_send_url');

		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['entry_order_status'] = $this->language->get('entry_order_status');

		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');

		$this->data['entry_status'] = $this->language->get('entry_status');

		//ボタン
		$this->data['button_save'] = $this->language->get('button_save');

		$this->data['button_cancel'] = $this->language->get('button_cancel');

//各入力ボックスの初期値などを取得

		//モデルのロード
		$this->load->model('localisation/order_status');
		//現在登録されているオーダーステータスを取得する
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		//モデルのロード
		$this->load->model('localisation/geo_zone');
		//ジオゾーンを取得
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['rakuten_easy_send_url'])) {
			$this->data['rakuten_easy_send_url'] = $this->request->post['rakuten_easy_send_url'];
		} else {
			$this->data['rakuten_easy_send_url'] = $this->config->get('rakuten_easy_send_url');
		}

		if (isset($this->request->post['rakuten_easy_geo_zone'])) {
			$this->data['rakuten_easy_geo_zone_id'] = $this->request->post['rakuten_easy_geo_zone_id'];
		} else {
			$this->data['rakuten_easy_geo_zone_id'] = $this->config->get('rakuten_easy_geo_zone_id');
		}

		if (isset($this->request->post['rakuten_easy_status'])) {
			$this->data['rakuten_easy_status'] = $this->request->post['rakuten_easy_status'];
		} else {
			$this->data['rakuten_easy_status'] = $this->config->get('rakuten_easy_status');
		}

		if (isset($this->request->post['rakuten_easy_sort_order'])) {
			$this->data['rakuten_easy_sort_order'] = $this->request->post['rakuten_easy_sort_order'];
		} else {
			$this->data['rakuten_easy_sort_order'] = $this->config->get('rakuten_easy_sort_order');
		}

		if(isset($this->request->post['rakuten_easy_title'])){
			$this->data['rakuten_easy_title'] = $this->request->post['rakuten_easy_title'];
		}else{
			$this->data['rakuten_easy_title'] = $this->config->get('rakuten_easy_title');
		}

		if(isset($this->request->post['rakuten_easy_id1'])){
			$this->data['rakuten_easy_id1'] = $this->request->post['rakuten_easy_id1'];
		}else{
			$this->data['rakuten_easy_id1'] = $this->config->get('rakuten_easy_id1');
		}

		if(isset($this->request->post['rakuten_easy_id2'])){
			$this->data['rakuten_easy_id2'] = $this->request->post['rakuten_easy_id2'];
		}else{
			$this->data['rakuten_easy_id2'] = $this->config->get('rakuten_easy_id2');
		}

		//パンくず作成
		$this->document->breadcrumbs = array();
		//ホーム
   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home',
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);
		//支払方法設定
   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=extension/payment',
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);
		//楽天かんたん決済ページ
   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=payment/rakuten_easy',
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

   		//登録の場合のアクションＵＲＬ（ボタンに必要）
		$this->data['action'] = HTTPS_SERVER . 'index.php?route=payment/rakuten_easy';
		//キャンセルの場合のアクションＵＲＬ
		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=extension/payment';

		//エラーの文言の処理
		if( isset($this->error['warning']) ){
			$this->data['error_warning'] = $this->error['warning'];
		}else{
			$this->data['error_warning'] = '';
		}

		if( isset($this->error['title']) ){
			$this->data['error_title'] = $this->error['title'];
		}else{
			$this->data['error_title'] = '';
		}

		if( isset($this->error['send_url']) ){
			$this->data['error_send_url'] = $this->error['send_url'];
		}else{
			$this->data['error_send_url'] = '';
		}

		//画面への出力
		$this->template = 'payment/rakuten_easy.tpl';

		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));

	}//function end


	//入力値のバリデート
	private function validate(){

		$this->load->language('payment/rakuten_easy');

		if(!$this->user->hasPermission('modify', 'payment/rakuten_easy')){
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if(!$this->request->post['rakuten_easy_title']){
			$this->error['title'] = $this->language->get('error_title');
		}

		if(!$this->request->post['rakuten_easy_send_url']){
			$this->error['send_url'] = $this->language->get('error_send_url');
		}


		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}

	}//function-end

}
?>